/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class BuyPropositionMessage
extends DOMMessage {
    private String unitId;
    private String settlementId;
    private Goods goods;
    private String goldString;

    public BuyPropositionMessage(Unit unit, Settlement settlement, Goods goods, int gold) {
        super(BuyPropositionMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.goods = goods;
        this.goldString = Integer.toString(gold);
    }

    public BuyPropositionMessage(Game game, Element element) {
        super(BuyPropositionMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.goods = new Goods(game, DOMMessage.getChildElement(element, Goods.getXMLElementTagName()));
        this.goldString = element.getAttribute("gold");
    }

    public int getGold() {
        try {
            return Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        IndianSettlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.hasSpaceLeft()) {
            return DOMMessage.clientError("No space left on unit: " + unit.getId());
        }
        try {
            settlement = unit.getAdjacentIndianSettlementSafely(this.settlementId);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.goods.getLocation() != settlement) {
            return DOMMessage.createError("server.trade.noGoods", "Goods " + this.goods.getId() + " are not in settlement " + this.settlementId);
        }
        return server.getInGameController().buyProposition(serverPlayer, unit, settlement, this.goods, this.getGold());
    }

    @Override
    public Element toXMLElement() {
        Element result = BuyPropositionMessage.createMessage(BuyPropositionMessage.getXMLElementTagName(), "unit", this.unitId, "settlement", this.settlementId, "gold", this.goldString);
        result.appendChild(this.goods.toXMLElement(result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "buyProposition";
    }
}

