/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class BuildColonyMessage
extends DOMMessage {
    private String colonyName;
    private String builderId;

    public BuildColonyMessage(String colonyName, Unit builder) {
        super(BuildColonyMessage.getXMLElementTagName());
        this.colonyName = colonyName;
        this.builderId = builder.getId();
    }

    public BuildColonyMessage(Game game, Element element) {
        super(BuildColonyMessage.getXMLElementTagName());
        this.colonyName = element.getAttribute("name");
        this.builderId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = player.getOurFreeColGameObject(this.builderId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.canBuildColony()) {
            return DOMMessage.clientError("Unit " + this.builderId + " can not build colony.");
        }
        if (this.colonyName == null) {
            return DOMMessage.clientError("Null colony name");
        }
        if (!"".equals(this.colonyName) && game.getSettlement(this.colonyName) != null) {
            return DOMMessage.clientError("Non-unique colony name " + this.colonyName);
        }
        Tile tile = unit.getTile();
        if (!player.canClaimToFoundSettlement(tile)) {
            return DOMMessage.clientError("Can not build colony on tile " + tile + ": " + (Object)((Object)player.canClaimToFoundSettlementReason(tile)));
        }
        return server.getInGameController().buildSettlement(serverPlayer, unit, this.colonyName);
    }

    @Override
    public Element toXMLElement() {
        return BuildColonyMessage.createMessage(BuildColonyMessage.getXMLElementTagName(), "name", this.colonyName, "unit", this.builderId);
    }

    public static String getXMLElementTagName() {
        return "buildColony";
    }
}

