/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.pathfinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.GoalDecider;

public final class GoalDeciders {
    public static GoalDecider getComposedGoalDecider(final boolean all, final GoalDecider ... gds) {
        if (gds.length < 2) {
            throw new IllegalArgumentException("Short GoalDecider list");
        }
        return new GoalDecider(){
            private int winner;
            private PathNode goal;
            {
                this.winner = gds.length;
                this.goal = null;
            }

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                for (int i = 0; i < gds.length && (all || i <= this.winner); ++i) {
                    if (gds[i].hasSubGoals()) {
                        if (all) continue;
                        return true;
                    }
                    if (!all) continue;
                    return false;
                }
                return !all;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                for (int i = 0; i < gds.length && (all || i <= this.winner); ++i) {
                    if (gds[i].check(u, path)) {
                        if (all) continue;
                        this.winner = i;
                        this.goal = path;
                        return true;
                    }
                    if (!all) continue;
                    return false;
                }
                if (all) {
                    this.winner = 0;
                    this.goal = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getOurClosestSettlementGoalDecider() {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private float bestValue = 0.0f;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                float value;
                Location loc = path.getLastNode().getLocation();
                Settlement settlement = loc.getSettlement();
                if (settlement != null && settlement.getOwner().owns(u) && this.bestValue < (value = (settlement.isConnectedPort() ? 2.0f : 1.0f) / (float)(path.getTotalTurns() + 1))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getHighSeasGoalDecider() {
        return new GoalDecider(){
            private PathNode best = null;

            @Override
            public PathNode getGoal() {
                return this.best;
            }

            @Override
            public boolean hasSubGoals() {
                return false;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile tile = path.getTile();
                if (tile != null && tile.isExploredBy(u.getOwner()) && tile.isDirectlyHighSeasConnected() && (tile.getFirstUnit() == null || u.getOwner().owns(tile.getFirstUnit())) && (this.best == null || path.getCost() < this.best.getCost())) {
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getSimpleHighSeasGoalDecider() {
        return new GoalDecider(){
            private PathNode first = null;

            @Override
            public PathNode getGoal() {
                return this.first;
            }

            @Override
            public boolean hasSubGoals() {
                return false;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile tile = path.getTile();
                if (tile != null && tile.isDirectlyHighSeasConnected()) {
                    this.first = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getLocationGoalDecider(final Location target) {
        return new GoalDecider(){
            private PathNode best = null;
            private int bestCost = Integer.MAX_VALUE;

            @Override
            public PathNode getGoal() {
                return this.best;
            }

            @Override
            public boolean hasSubGoals() {
                return false;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                if (Map.isSameLocation(path.getLocation(), target)) {
                    int cost = path.getCost();
                    if (cost < this.bestCost) {
                        this.best = path;
                        this.bestCost = cost;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getAdjacentLocationGoalDecider(Location target) {
        final Tile tile = target.getTile();
        if (tile == null) {
            return null;
        }
        return new GoalDecider(){
            private PathNode best = null;

            @Override
            public PathNode getGoal() {
                return this.best;
            }

            @Override
            public boolean hasSubGoals() {
                return false;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile t = path.getTile();
                if (t != null && t.isAdjacent(tile)) {
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getEnemySettlementGoalDecider(final Collection<Player> enemies) {
        return new GoalDecider(){
            private PathNode best = null;

            @Override
            public PathNode getGoal() {
                return this.best;
            }

            @Override
            public boolean hasSubGoals() {
                return false;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile t = path.getTile();
                if (t == null || !t.isLand()) {
                    return false;
                }
                Settlement s = t.getSettlement();
                if (s == null) {
                    return false;
                }
                if (enemies.contains(s.getOwner())) {
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static GoalDecider getDisembarkGoalDecider(final Tile target) {
        return new GoalDecider(){
            private float bestScore = -1.0f;
            private boolean goalDangerous = true;
            private PathNode goal = null;

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode pathNode) {
                Tile tile = pathNode.getTile();
                if (tile == null || !tile.isLand() || !tile.isEmpty() || tile.hasSettlement()) {
                    return false;
                }
                Player owner = u.getOwner();
                boolean found = false;
                boolean danger = false;
                for (Tile t : pathNode.getTile().getSurroundingTiles(1)) {
                    if (!t.isHighSeasConnected() || t.isLand()) continue;
                    for (Tile t2 : t.getSurroundingTiles(1)) {
                        Settlement settlement = t2.getSettlement();
                        if (settlement == null || owner.owns(settlement) || !settlement.hasAbility("model.ability.bombardShips") || !owner.atWarWith(settlement.getOwner()) && !u.hasAbility("model.ability.piracy")) continue;
                        danger = true;
                        break;
                    }
                    if (this.goalDangerous) {
                        found = true;
                        if (danger) continue;
                        this.goalDangerous = false;
                        this.bestScore = -1.0f;
                        continue;
                    }
                    found = !danger;
                }
                if (found) {
                    float distance = 1.0f + (float)u.getGame().getMap().getDistance(target, tile);
                    float score = tile.getDefenceValue() / distance;
                    if (this.bestScore < score) {
                        this.bestScore = score;
                        this.goal = pathNode;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static GoalDecider getStealthyGoalDecider(final Player enemy) {
        return new GoalDecider(){
            private PathNode goal = null;

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode pathNode) {
                Tile tile = pathNode.getTile();
                if (enemy.canSee(tile)) {
                    return false;
                }
                this.goal = pathNode;
                return true;
            }
        };
    }

    public static GoalDecider getReduceHighSeasCountGoalDecider(final Unit unit) {
        return new GoalDecider(){
            private PathNode goal = null;
            private int score = unit.getTile().getHighSeasCount();

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode pathNode) {
                Tile tile = pathNode.getTile();
                if (tile.getHighSeasCount() < this.score) {
                    Settlement s = tile.getSettlement();
                    if (unit.getOwner().owns(s)) {
                        this.goal = pathNode;
                        this.score = tile.getHighSeasCount();
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static GoalDecider getCornerGoalDecider() {
        return new GoalDecider(){
            private PathNode goal = null;
            private int score = Integer.MAX_VALUE;

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode pathNode) {
                Tile tile = pathNode.getTile();
                if (tile.getHighSeasCount() < this.score && tile.isRiverCorner()) {
                    this.score = tile.getHighSeasCount();
                    this.goal = pathNode;
                    return true;
                }
                return false;
            }
        };
    }

    public static class MultipleAdjacentDecider {
        private final GoalDecider gd;
        private final HashMap<Location, PathNode> results = new HashMap();

        public MultipleAdjacentDecider(final List<Location> locs) {
            this.gd = new GoalDecider(){

                @Override
                public PathNode getGoal() {
                    return null;
                }

                @Override
                public boolean hasSubGoals() {
                    return true;
                }

                @Override
                public boolean check(Unit u, PathNode path) {
                    Tile tile = path.getTile();
                    if (tile == null) {
                        return false;
                    }
                    for (Location loc : locs) {
                        PathNode p;
                        if (!tile.isAdjacent(loc.getTile()) || (p = (PathNode)MultipleAdjacentDecider.this.results.get(loc)) != null && p.getCost() <= path.getCost()) continue;
                        MultipleAdjacentDecider.this.results.put(loc, path);
                    }
                    return false;
                }
            };
        }

        public GoalDecider getGoalDecider() {
            return this.gd;
        }

        public HashMap<Location, PathNode> getResults() {
            return this.results;
        }
    }
}

