/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.Utils;

public class UnitWas
implements Comparable<UnitWas> {
    private static final Logger logger = Logger.getLogger(UnitWas.class.getName());
    private Unit unit;
    private UnitType type;
    private Role role;
    private int roleCount;
    private Location loc;
    private GoodsType work;
    private int workAmount;
    private int movesLeft;
    private Colony colony;

    public UnitWas(Unit unit) {
        this.unit = unit;
        this.type = unit.getType();
        this.role = unit.getRole();
        this.roleCount = unit.getRoleCount();
        this.loc = unit.getLocation();
        this.work = unit.getWorkType();
        this.workAmount = this.getAmount(this.loc, this.work);
        this.movesLeft = unit.getMovesLeft();
        this.colony = unit.getColony();
        if (unit.getGoodsContainer() != null) {
            unit.getGoodsContainer().saveState();
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Location getLocation() {
        return this.loc;
    }

    public GoodsType getWorkType() {
        return this.work;
    }

    public void fireChanges() {
        UnitType newType = null;
        Role newRole = null;
        int newRoleCount = 0;
        Location newLoc = null;
        GoodsType newWork = null;
        int newWorkAmount = 0;
        int newMovesLeft = 0;
        if (!this.unit.isDisposed()) {
            newLoc = this.unit.getLocation();
            if (this.colony != null) {
                newType = this.unit.getType();
                newRole = this.unit.getRole();
                newRoleCount = this.unit.getRoleCount();
                newWork = this.unit.getWorkType();
                newWorkAmount = newWork == null ? 0 : this.getAmount(newLoc, newWork);
            }
            newMovesLeft = this.unit.getMovesLeft();
        }
        FreeColGameObject oldFcgo = (FreeColGameObject)((Object)this.loc);
        FreeColGameObject newFcgo = (FreeColGameObject)((Object)newLoc);
        if (this.loc != newLoc) {
            oldFcgo.firePropertyChange(this.change(oldFcgo), this.unit, null);
            if (newLoc != null) {
                newFcgo.firePropertyChange(this.change(newFcgo), null, this.unit);
            }
        }
        if (this.colony != null) {
            if (this.type != newType && newType != null) {
                String pc = Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString();
                this.colony.firePropertyChange(pc, this.type, newType);
            } else if (this.role != newRole && newRole != null) {
                String pc = "TILE_UNIT_CHANGE";
                this.colony.firePropertyChange(pc, this.role.toString(), newRole.toString());
            }
            if (this.work != newWork) {
                if (this.work != null && oldFcgo != null && this.workAmount != 0) {
                    oldFcgo.firePropertyChange(this.work.getId(), this.workAmount, 0);
                }
                if (newWork != null && newFcgo != null && newWorkAmount != 0) {
                    newFcgo.firePropertyChange(newWork.getId(), 0, newWorkAmount);
                }
            } else if (this.workAmount != newWorkAmount) {
                newFcgo.firePropertyChange(newWork.getId(), this.workAmount, newWorkAmount);
            }
        }
        if (this.role != newRole && newRole != null) {
            this.unit.firePropertyChange("ROLE_CHANGE", this.role, newRole);
        } else if (this.roleCount != newRoleCount && newRoleCount >= 0) {
            this.unit.firePropertyChange("ROLE_CHANGE", this.roleCount, newRoleCount);
        }
        if (this.unit.getGoodsContainer() != null) {
            this.unit.getGoodsContainer().fireChanges();
        }
        if (this.movesLeft != newMovesLeft) {
            this.unit.firePropertyChange("MOVE_CHANGE", this.movesLeft, newMovesLeft);
        }
    }

    private String change(FreeColGameObject fcgo) {
        return fcgo instanceof Tile ? "TILE_UNIT_CHANGE" : (fcgo instanceof Europe ? "unitChange" : (fcgo instanceof ColonyTile ? "UNIT_CHANGE" : (fcgo instanceof Building ? "UNIT_CHANGE" : (fcgo instanceof Unit ? "CARGO_CHANGE" : null))));
    }

    private int getAmount(Location location, GoodsType goodsType) {
        if (goodsType == null) {
            return 0;
        }
        if (location instanceof WorkLocation) {
            ProductionInfo info = ((WorkLocation)location).getProductionInfo();
            return AbstractGoods.getCount(goodsType, info.getProduction());
        }
        return 0;
    }

    @Override
    public int compareTo(UnitWas uw) {
        List<Role> roles = this.unit.getAvailableRoles(null);
        int cmp = ((UnitLocation)uw.loc).getUnitCapacity() - ((UnitLocation)this.loc).getUnitCapacity();
        if (cmp == 0) {
            cmp = roles.indexOf(this.role) - roles.indexOf(uw.role);
        }
        return cmp;
    }

    public boolean equals(Object other) {
        if (other instanceof UnitWas) {
            return this.compareTo((UnitWas)other) == 0;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.unit);
        hash = 37 * hash + Utils.hashCode(this.type);
        hash = 37 * hash + Utils.hashCode(this.role);
        hash = 37 * hash + this.roleCount;
        hash = 37 * hash + Utils.hashCode(this.loc);
        hash = 37 * hash + Utils.hashCode(this.work);
        hash = 37 * hash + this.workAmount;
        hash = 37 * hash + this.movesLeft;
        return 37 * hash + Utils.hashCode(this.colony);
    }

    public String toString() {
        Tile tile = this.colony.getTile();
        String roleStr = "/" + this.role.getSuffix();
        if (this.roleCount > 0) {
            roleStr = roleStr + "." + this.roleCount;
        }
        String locStr = this.loc == null ? "" : (this.loc instanceof Building ? ((Building)this.loc).getType().getSuffix() : (this.loc instanceof ColonyTile ? tile.getDirection(((ColonyTile)this.loc).getWorkTile()).toString() : (this.loc instanceof Tile ? this.loc.getId() + roleStr : this.loc.getId())));
        Location newLoc = this.unit.getLocation();
        String newRoleStr = "/" + this.unit.getRole().getSuffix();
        if (this.unit.getRoleCount() > 0) {
            newRoleStr = newRoleStr + "." + this.unit.getRoleCount();
        }
        String newLocStr = newLoc == null ? "" : (newLoc instanceof Building ? ((Building)newLoc).getType().getSuffix() : (newLoc instanceof ColonyTile ? tile.getDirection(((ColonyTile)newLoc).getWorkTile()).toString() : (newLoc instanceof Tile ? newLoc.getId() + newRoleStr : newLoc.getId())));
        GoodsType newWork = this.unit.getWorkType();
        int newWorkAmount = newWork == null ? 0 : this.getAmount(newLoc, newWork);
        return String.format("%-30s %-25s -> %-25s", this.unit.getId() + ":" + this.unit.getType().getSuffix(), locStr + (this.work == null || this.workAmount <= 0 ? "" : "(" + Integer.toString(this.workAmount) + " " + this.work.getSuffix() + ")"), newLocStr + (newWork == null || newWorkAmount <= 0 ? "" : "(" + Integer.toString(newWorkAmount) + " " + newWork.getSuffix() + ")")).trim();
    }
}

