/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;

public class UnitTradeItem
extends TradeItem {
    private Unit unit;
    private static final String UNIT_TAG = "unit";

    public UnitTradeItem(Game game, Player source, Player destination, Unit unit) {
        super(game, "tradeItem.unit", source, destination);
        this.unit = unit;
    }

    public UnitTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.unit.getOwner() == this.getSource() && this.unit.getType().isAvailableTo(this.getDestination());
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public StringTemplate getLabel() {
        return this.unit.getLabel();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(UNIT_TAG, this.unit);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" ").append(this.unit.getId()).append("]");
        return sb.toString();
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.unit = xr.getAttribute(this.getGame(), UNIT_TAG, Unit.class, (Unit)null);
    }

    @Override
    public String getXMLTagName() {
        return UnitTradeItem.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "unitTradeItem";
    }
}

