/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.Unit;

public class TradeRouteStop
extends FreeColObject
implements TradeLocation {
    private static final Logger logger = Logger.getLogger(TradeRouteStop.class.getName());
    private final Game game;
    private Location location;
    private final List<GoodsType> cargo = new ArrayList<GoodsType>();
    private static final String CARGO_TAG = "cargo";
    private static final String LOCATION_TAG = "location";

    public TradeRouteStop(Game game, Location location) {
        this.setId("");
        this.setSpecification(game.getSpecification());
        this.game = game;
        this.location = location;
        this.cargo.clear();
    }

    public TradeRouteStop(TradeRouteStop other) {
        this(other.game, other.location);
        this.setCargo(other.cargo);
    }

    public TradeRouteStop(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this(game, (Location)null);
        this.readFromXML(xr);
    }

    public final Location getLocation() {
        return this.location;
    }

    public TradeLocation getTradeLocation() {
        return (TradeLocation)((Object)this.location);
    }

    public boolean isValid(Player player) {
        return this.location instanceof TradeLocation && !((FreeColGameObject)((Object)this.location)).isDisposed() && this.location instanceof Ownable && player.owns((Ownable)((Object)this.location));
    }

    public final List<GoodsType> getCargo() {
        return this.cargo;
    }

    public final void setCargo(List<GoodsType> newCargo) {
        this.cargo.clear();
        this.cargo.addAll(newCargo);
    }

    public void addCargo(GoodsType newCargo) {
        this.cargo.add(newCargo);
    }

    public List<AbstractGoods> getCompactCargo() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        for (GoodsType type : this.getCargo()) {
            AbstractGoods ag = AbstractGoods.findByType(type, result);
            if (ag != null) {
                ag.setAmount(ag.getAmount() + 100);
                continue;
            }
            result.add(new AbstractGoods(type, 100));
        }
        return result;
    }

    public StringTemplate getLabelFor(String key, Player player) {
        return StringTemplate.template(key).addStringTemplate("%location%", this.getLocation().getLocationLabelFor(player));
    }

    public boolean hasWork(Unit unit, int turns) {
        List<AbstractGoods> stopGoods = this.getCompactCargo();
        for (AbstractGoods ag : stopGoods) {
            if (unit.getGoodsCount(ag.getType()) >= ag.getAmount() || this.getExportAmount(ag.getType(), turns) <= 0) continue;
            return true;
        }
        for (Goods goods : unit.getCompactGoodsList()) {
            GoodsType type = goods.getType();
            if (AbstractGoods.findByType(type, stopGoods) != null || this.getImportAmount(type, turns) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getGoodsCount(GoodsType goodsType) {
        return this.location instanceof TradeLocation ? ((TradeLocation)((Object)this.location)).getGoodsCount(goodsType) : 0;
    }

    @Override
    public int getExportAmount(GoodsType goodsType, int turns) {
        return this.location instanceof TradeLocation ? ((TradeLocation)((Object)this.location)).getExportAmount(goodsType, turns) : 0;
    }

    @Override
    public int getImportAmount(GoodsType goodsType, int turns) {
        return this.location instanceof TradeLocation ? ((TradeLocation)((Object)this.location)).getImportAmount(goodsType, turns) : 0;
    }

    @Override
    public void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeLocationAttribute(LOCATION_TAG, this.location);
    }

    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        for (GoodsType cargoType : this.cargo) {
            xw.writeStartElement(CARGO_TAG);
            xw.writeAttribute("id", cargoType);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.location = xr.getLocationAttribute(this.game, LOCATION_TAG, true);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.cargo.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (CARGO_TAG.equals(tag)) {
            this.cargo.add(xr.getType(spec, "id", GoodsType.class, null));
            xr.closeTag(CARGO_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getXMLTagName()).append(" ").append(this.getLocation().getId());
        for (GoodsType goodsType : this.getCargo()) {
            sb.append(" ").append(goodsType);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return TradeRouteStop.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tradeRouteStop";
    }
}

