/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TileTypeChange;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

public final class TileImprovementType
extends FreeColGameObjectType {
    private boolean natural;
    private int magnitude;
    private int addWorkTurns;
    private TileImprovementType requiredImprovementType;
    private Role requiredRole;
    private int expendedAmount;
    private GoodsType deliverGoodsType = null;
    private int deliverAmount;
    private int movementCost = -1;
    private int zIndex;
    private int exposeResourcePercent;
    private Set<String> allowedWorkers = null;
    private Map<TileType, TileTypeChange> tileTypeChanges = null;
    private List<RandomChoice<Disaster>> disasters = null;
    private List<Scope> scopes = null;
    private static final String ADD_WORK_TURNS_TAG = "add-work-turns";
    private static final String CHANGE_TAG = "change";
    private static final String DELIVER_AMOUNT_TAG = "deliver-amount";
    private static final String DELIVER_GOODS_TYPE_TAG = "deliver-goods-type";
    private static final String DISASTER_TAG = "disaster";
    private static final String EXPENDED_AMOUNT_TAG = "expended-amount";
    private static final String EXPOSE_RESOURCE_PERCENT_TAG = "exposeResourcePercent";
    private static final String FROM_TAG = "from";
    private static final String MAGNITUDE_TAG = "magnitude";
    private static final String MOVEMENT_COST_TAG = "movement-cost";
    private static final String NATURAL_TAG = "natural";
    private static final String PROBABILITY_TAG = "probability";
    private static final String REQUIRED_IMPROVEMENT_TAG = "required-improvement";
    private static final String REQUIRED_ROLE_TAG = "required-role";
    private static final String TO_TAG = "to";
    private static final String WORKER_TAG = "worker";
    private static final String ZINDEX_TAG = "zIndex";
    private static final String EXPENDED_EQUIPMENT_TYPE_TAG = "expended-equipment-type";

    public TileImprovementType(String id, Specification specification) {
        super(id, specification);
    }

    public boolean isNatural() {
        return this.natural;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public int getAddWorkTurns() {
        return this.addWorkTurns;
    }

    public TileImprovementType getRequiredImprovementType() {
        return this.requiredImprovementType;
    }

    public Role getRequiredRole() {
        return this.requiredRole;
    }

    public int getExpendedAmount() {
        return this.expendedAmount;
    }

    public int getExposeResourcePercent() {
        return this.exposeResourcePercent;
    }

    public List<Scope> getScopes() {
        return this.scopes == null ? Collections.emptyList() : this.scopes;
    }

    private void addScope(Scope scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.add(scope);
    }

    public List<RandomChoice<Disaster>> getDisasters() {
        return this.disasters == null ? Collections.emptyList() : this.disasters;
    }

    private void addDisaster(Disaster disaster, int probability) {
        if (this.disasters == null) {
            this.disasters = new ArrayList<RandomChoice<Disaster>>();
        }
        this.disasters.add(new RandomChoice<Disaster>(disaster, probability));
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int newZIndex) {
        this.zIndex = newZIndex;
    }

    private void addAllowedWorker(String id) {
        if (this.allowedWorkers == null) {
            this.allowedWorkers = new HashSet<String>();
        }
        this.allowedWorkers.add(id);
    }

    public boolean isWorkerTypeAllowed(UnitType unitType) {
        return this.allowedWorkers == null || this.allowedWorkers.isEmpty() || this.allowedWorkers.contains(unitType.getId());
    }

    public boolean isWorkerAllowed(Unit unit) {
        return this.isWorkerTypeAllowed(unit.getType()) && (this.requiredRole == null || unit.getRole() == this.requiredRole);
    }

    public boolean isTileTypeAllowed(TileType tileType) {
        for (Scope scope : this.getScopes()) {
            if (scope.appliesTo(tileType)) continue;
            return false;
        }
        return true;
    }

    public int getBonus(GoodsType goodsType) {
        Modifier result = this.getProductionModifier(goodsType);
        if (result == null) {
            return 0;
        }
        return (int)result.getValue();
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        Set<Modifier> modifierSet = this.getModifiers(goodsType.getId());
        if (modifierSet == null || modifierSet.isEmpty()) {
            return null;
        }
        if (modifierSet.size() > 1) {
            logger.warning("Only one Modifier for " + goodsType.getId() + " expected!");
        }
        return modifierSet.iterator().next();
    }

    public boolean isChangeType() {
        return this.tileTypeChanges != null && !this.tileTypeChanges.isEmpty();
    }

    public AbstractGoods getProduction(TileType from) {
        if (this.tileTypeChanges == null) {
            return null;
        }
        TileTypeChange change = this.tileTypeChanges.get(from);
        return change == null ? null : change.getProduction();
    }

    public TileType getChange(TileType tileType) {
        if (this.tileTypeChanges == null) {
            return null;
        }
        TileTypeChange change = this.tileTypeChanges.get(tileType);
        return change == null ? null : change.getTo();
    }

    public boolean changeContainsTarget(TileType tileType) {
        if (this.tileTypeChanges == null) {
            return false;
        }
        for (TileTypeChange change : this.tileTypeChanges.values()) {
            if (change.getTo() != tileType) continue;
            return true;
        }
        return false;
    }

    private void addChange(TileTypeChange change) {
        if (this.tileTypeChanges == null) {
            this.tileTypeChanges = new HashMap<TileType, TileTypeChange>();
        }
        this.tileTypeChanges.put(change.getFrom(), change);
    }

    public int getMoveCost(int originalCost) {
        return this.movementCost > 0 && this.movementCost < originalCost ? this.movementCost : originalCost;
    }

    public int getImprovementValue(Tile tile, GoodsType goodsType) {
        UnitType colonistType = this.getSpecification().getDefaultUnitType();
        int value = 0;
        if (goodsType.isFarmed()) {
            int oldProduction = tile.getType().getPotentialProduction(goodsType, colonistType);
            TileType tt = this.getChange(tile.getType());
            if (tt == null) {
                int production = tile.getPotentialProduction(goodsType, colonistType);
                if (production > 0) {
                    float chg = this.applyModifiers(production, null, goodsType.getId());
                    value = (int)(chg - (float)production);
                }
            } else {
                int chg;
                value = chg = tt.getPotentialProduction(goodsType, colonistType) - oldProduction;
            }
        }
        return value;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NATURAL_TAG, this.natural);
        xw.writeAttribute(MAGNITUDE_TAG, this.magnitude);
        xw.writeAttribute(ADD_WORK_TURNS_TAG, this.addWorkTurns);
        if (this.requiredImprovementType != null) {
            xw.writeAttribute(REQUIRED_IMPROVEMENT_TAG, this.requiredImprovementType);
        }
        if (this.requiredRole != null) {
            xw.writeAttribute(REQUIRED_ROLE_TAG, this.requiredRole);
        }
        if (this.expendedAmount != 0) {
            xw.writeAttribute(EXPENDED_AMOUNT_TAG, this.expendedAmount);
        }
        xw.writeAttribute(MOVEMENT_COST_TAG, this.movementCost);
        xw.writeAttribute(ZINDEX_TAG, this.zIndex);
        xw.writeAttribute(EXPOSE_RESOURCE_PERCENT_TAG, this.exposeResourcePercent);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Scope scope : this.getScopes()) {
            scope.toXML(xw);
        }
        if (this.allowedWorkers != null) {
            for (String string : this.allowedWorkers) {
                xw.writeStartElement(WORKER_TAG);
                xw.writeAttribute("id", string);
                xw.writeEndElement();
            }
        }
        if (this.tileTypeChanges != null) {
            ArrayList<TileTypeChange> sorted = new ArrayList<TileTypeChange>(this.tileTypeChanges.values());
            Collections.sort(sorted);
            for (TileTypeChange change : sorted) {
                change.toXML(xw);
            }
        }
        for (RandomChoice randomChoice : this.getDisasters()) {
            xw.writeStartElement(DISASTER_TAG);
            xw.writeAttribute("id", ((Disaster)randomChoice.getObject()).getId());
            xw.writeAttribute(PROBABILITY_TAG, randomChoice.getProbability());
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.natural = xr.getAttribute(NATURAL_TAG, false);
        this.magnitude = xr.getAttribute(MAGNITUDE_TAG, 1);
        this.addWorkTurns = xr.getAttribute(ADD_WORK_TURNS_TAG, 0);
        this.requiredImprovementType = xr.getType(spec, REQUIRED_IMPROVEMENT_TAG, TileImprovementType.class, null);
        this.requiredRole = xr.getType(spec, REQUIRED_ROLE_TAG, Role.class, null);
        if (xr.hasAttribute(EXPENDED_EQUIPMENT_TYPE_TAG)) {
            this.requiredRole = spec.getRole("model.role.pioneer");
        }
        this.expendedAmount = xr.getAttribute(EXPENDED_AMOUNT_TAG, 0);
        this.deliverGoodsType = xr.getType(spec, DELIVER_GOODS_TYPE_TAG, GoodsType.class, null);
        this.deliverAmount = xr.getAttribute(DELIVER_AMOUNT_TAG, 0);
        this.movementCost = xr.getAttribute(MOVEMENT_COST_TAG, 0);
        this.zIndex = xr.getAttribute(ZINDEX_TAG, 0);
        this.exposeResourcePercent = xr.getAttribute(EXPOSE_RESOURCE_PERCENT_TAG, 0);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.scopes = null;
            this.allowedWorkers = null;
            this.tileTypeChanges = null;
            this.disasters = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (CHANGE_TAG.equals(tag)) {
            TileTypeChange change = new TileTypeChange();
            if (this.deliverGoodsType == null) {
                change.readFromXML(xr, spec);
            } else {
                TileType from = xr.getType(spec, FROM_TAG, TileType.class, null);
                TileType to = xr.getType(spec, TO_TAG, TileType.class, null);
                change.setFrom(from);
                change.setTo(to);
                change.setProduction(new AbstractGoods(this.deliverGoodsType, this.deliverAmount));
                xr.closeTag(CHANGE_TAG);
            }
            this.addChange(change);
        } else if (DISASTER_TAG.equals(tag)) {
            Disaster disaster = xr.getType(spec, "id", Disaster.class, null);
            int probability = xr.getAttribute(PROBABILITY_TAG, 100);
            this.addDisaster(disaster, probability);
            xr.closeTag(DISASTER_TAG);
        } else if (WORKER_TAG.equals(tag)) {
            this.addAllowedWorker(xr.readId());
            xr.closeTag(WORKER_TAG);
        } else if (Scope.getXMLElementTagName().equals(tag)) {
            this.addScope(new Scope(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TileImprovementType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tileimprovement-type";
    }
}

