/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public class TileImprovement
extends TileItem
implements Named {
    private static Logger logger = Logger.getLogger(TileImprovement.class.getName());
    public static final int NO_RIVER = 0;
    public static final int SMALL_RIVER = 1;
    public static final int LARGE_RIVER = 2;
    public static final int FJORD_RIVER = 3;
    private TileImprovementType type;
    private int turnsToComplete;
    private int magnitude;
    private TileImprovementStyle style;
    private boolean virtual;
    private long connected = 0L;
    private static final String MAGNITUDE_TAG = "magnitude";
    private static final String STYLE_TAG = "style";
    private static final String TILE_TAG = "tile";
    private static final String TURNS_TAG = "turns";
    private static final String TYPE_TAG = "type";
    private static final String VIRTUAL_TAG = "virtual";

    public TileImprovement(Game game, Tile tile, TileImprovementType type) {
        super(game, tile);
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be 'null'.");
        }
        this.type = type;
        if (!type.isNatural()) {
            this.turnsToComplete = tile.getType().getBasicWorkTurns() + type.getAddWorkTurns();
        }
        this.magnitude = type.getMagnitude();
        this.style = null;
        this.connected = 0L;
    }

    public TileImprovement(Game game, Tile tile, TileImprovement template) {
        super(game, tile);
        this.type = template.type;
        this.turnsToComplete = template.turnsToComplete;
        this.magnitude = template.magnitude;
        this.style = template.style;
        this.virtual = template.virtual;
        this.connected = this.getConnectionsFromStyle();
    }

    public TileImprovement(Game game, String id) {
        super(game, id);
    }

    public TileImprovementType getType() {
        return this.type;
    }

    public boolean isRiver() {
        return "model.improvement.river".equals(this.type.getId());
    }

    public boolean isRoad() {
        return "model.improvement.road".equals(this.type.getId());
    }

    public List<Map.Direction> getConnectionDirections() {
        return this.isRoad() ? Map.Direction.allDirections : (this.isRiver() ? Map.Direction.longSides : null);
    }

    @Override
    public String getNameKey() {
        return this.type.getNameKey();
    }

    public int getTurnsToComplete() {
        return this.turnsToComplete;
    }

    public boolean isComplete() {
        return this.turnsToComplete <= 0;
    }

    public void setTurnsToComplete(int turns) {
        this.turnsToComplete = turns;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(int magnitude) {
        this.magnitude = magnitude;
    }

    public TileImprovementStyle getStyle() {
        return this.style;
    }

    public final boolean isVirtual() {
        return this.virtual;
    }

    public final void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isConnectedTo(Map.Direction direction) {
        return (this.connected & (long)(1 << direction.ordinal())) != 0L;
    }

    public void setConnected(Map.Direction direction, boolean value) {
        boolean now = this.isConnectedTo(direction);
        if (now != value) {
            this.connected = value ? (this.connected |= (long)(1 << direction.ordinal())) : (this.connected &= (long)(~(1 << direction.ordinal())));
            this.style = TileImprovementStyle.getInstance(this.encodeConnections());
        }
    }

    private String encodeConnections() {
        List<Map.Direction> dirns = this.getConnectionDirections();
        if (dirns == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Direction d : dirns) {
            sb.append(this.isConnectedTo(d) ? Integer.toString(this.magnitude) : "0");
        }
        return sb.toString();
    }

    public Map<Map.Direction, Integer> getConnections() {
        List<Map.Direction> dirns = this.getConnectionDirections();
        if (dirns == null) {
            return Collections.emptyMap();
        }
        EnumMap<Map.Direction, Integer> result = new EnumMap<Map.Direction, Integer>(Map.Direction.class);
        for (Map.Direction d : dirns) {
            if (!this.isConnectedTo(d)) continue;
            result.put(d, this.magnitude);
        }
        return result;
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        return this.isComplete() ? this.type.getProductionModifier(goodsType) : null;
    }

    public int getMoveCost(Map.Direction direction, int moveCost) {
        return this.isComplete() && this.isConnectedTo(direction) ? this.type.getMoveCost(moveCost) : moveCost;
    }

    public TileType getChange(TileType tileType) {
        return this.isComplete() ? this.type.getChange(tileType) : null;
    }

    public boolean isWorkerAllowed(Unit unit) {
        return unit == null || this.isComplete() ? false : this.type.isWorkerAllowed(unit);
    }

    public final long getConnectionsFromStyle() {
        List<Map.Direction> directions;
        long conn = 0L;
        if (this.style != null && (directions = this.getConnectionDirections()) != null) {
            String mask = this.style.getMask();
            for (int i = 0; i < directions.size(); ++i) {
                if (mask.charAt(i) == '0') continue;
                conn |= 1L << directions.get(i).ordinal();
            }
        }
        return conn;
    }

    public String updateRiverConnections(String conns) {
        if (!this.isRiver()) {
            return null;
        }
        Tile tile = this.getTile();
        int i = 0;
        String ret = "";
        for (Map.Direction d : Map.Direction.longSides) {
            String c;
            Map.Direction dReverse = d.getReverseDirection();
            Tile t = tile.getNeighbourOrNull(d);
            TileImprovement river = t == null ? null : t.getRiver();
            String string = c = conns == null ? "0" : conns.substring(i, i + 1);
            if ("0".equals(c)) {
                if (river != null && river.isConnectedTo(dReverse)) {
                    river.setConnected(dReverse, false);
                }
                this.setConnected(d, false);
            } else {
                if (river != null) {
                    river.setConnected(dReverse, true);
                }
                this.setConnected(d, true);
            }
            ret = ret + c;
            ++i;
        }
        return this.style == null ? null : this.style.getString();
    }

    public String updateRoadConnections(boolean connect) {
        if (!this.isRoad() || !this.isComplete()) {
            return null;
        }
        Tile tile = this.getTile();
        String ret = "";
        for (Map.Direction d : Map.Direction.values()) {
            TileImprovement road;
            Tile t = tile.getNeighbourOrNull(d);
            TileImprovement tileImprovement = road = t == null ? null : t.getRoad();
            if (road == null || !road.isComplete()) continue;
            road.setConnected(d.getReverseDirection(), connect);
            this.setConnected(d, connect);
        }
        return this.style == null ? null : this.style.getString();
    }

    @Override
    public final int getZIndex() {
        return this.type.getZIndex();
    }

    @Override
    public boolean isTileTypeAllowed(TileType tileType) {
        return this.type.isTileTypeAllowed(tileType);
    }

    @Override
    public int applyBonus(GoodsType goodsType, UnitType unitType, int potential) {
        int result = potential;
        if (potential > 0 && this.isComplete()) {
            result += this.type.getBonus(goodsType);
        }
        return result;
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return false;
    }

    @Override
    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        Modifier modifier;
        if (goodsType != null && (modifier = this.getProductionModifier(goodsType)) != null && this.isComplete()) {
            ArrayList<Modifier> result = new ArrayList<Modifier>();
            result.add(modifier);
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isNatural() {
        return this.type.isNatural();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        String found;
        String curr;
        int result = super.checkIntegrity(fix);
        String string = curr = this.style == null ? null : this.style.getString();
        String string2 = this.isRiver() ? this.updateRiverConnections(curr) : (found = this.isRoad() && this.isComplete() ? this.updateRoadConnections(true) : null);
        if (found == null && curr == null || found != null && curr != null && found.equals(curr)) {
            result = Math.min(1, result);
        } else if (fix) {
            this.style = TileImprovementStyle.getInstance(found);
            if (this.style != null != (this.isRiver() || this.isRoad() && this.isComplete())) {
                logger.warning("Bad style for improvement: " + this);
                result = -1;
            } else {
                logger.warning("Fixing improvement style from " + curr + " to " + found + " at " + this.tile);
                result = Math.min(0, result);
            }
        } else {
            logger.warning("Broken improvement style " + curr + " should be " + found + " at " + this.tile);
            result = -1;
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TILE_TAG, this.getTile());
        xw.writeAttribute(TYPE_TAG, this.getType());
        xw.writeAttribute(TURNS_TAG, this.turnsToComplete);
        xw.writeAttribute(MAGNITUDE_TAG, this.magnitude);
        if (this.style != null) {
            xw.writeAttribute(STYLE_TAG, this.style);
        }
        if (this.virtual) {
            xw.writeAttribute(VIRTUAL_TAG, this.virtual);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.tile = xr.findFreeColGameObject(game, TILE_TAG, Tile.class, null, false);
        this.type = xr.getType(spec, TYPE_TAG, TileImprovementType.class, null);
        this.turnsToComplete = xr.getAttribute(TURNS_TAG, 0);
        this.magnitude = xr.getAttribute(MAGNITUDE_TAG, 0);
        this.virtual = xr.getAttribute(VIRTUAL_TAG, false);
        String str = xr.getAttribute(STYLE_TAG, null);
        List<Map.Direction> dirns = this.getConnectionDirections();
        if (dirns == null || str == null || "".equals(str)) {
            this.style = null;
        } else if (str.length() < 4) {
            String old = TileImprovementStyle.decodeOldStyle(str, dirns.size());
            this.style = old == null ? null : TileImprovementStyle.getInstance(old);
        } else {
            this.style = TileImprovementStyle.getInstance(str);
            if (this.style == null) {
                logger.warning("At " + this.tile + " ignored bogus TileImprovementStyle: " + str);
            }
        }
        if (this.style != null && this.style.toString().length() != dirns.size()) {
            if ("0000".equals(this.style.getString())) {
                this.style = null;
            } else {
                throw new XMLStreamException("For " + this.type + ", bogus style: " + str + " -> /" + this.style + "/ at " + this.tile);
            }
        }
        this.connected = this.getConnectionsFromStyle();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getType().getId());
        if (this.turnsToComplete > 0) {
            sb.append(" (").append(this.turnsToComplete).append(" turns left)");
        }
        if (this.style != null) {
            sb.append(" ").append(this.style.getString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return TileImprovement.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tileimprovement";
    }
}

