/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;

public final class Tile
extends UnitLocation
implements Named,
Ownable {
    private static final Logger logger = Logger.getLogger(Tile.class.getName());
    public static final String UNIT_CHANGE = "TILE_UNIT_CHANGE";
    public static final int FLAG_RECALCULATE = Integer.MAX_VALUE;
    private static final int LOW_PRODUCTION_WARNING_VALUE = 4;
    public static final int NEAR_RADIUS = 8;
    private TileType type;
    private int x;
    private int y;
    private Player owner;
    private Settlement settlement;
    private Settlement owningSettlement;
    private TileItemContainer tileItemContainer;
    private Region region;
    private int highSeasCount = -1;
    private Boolean moveToEurope;
    private int style;
    private int contiguity = -1;
    private final java.util.Map<Player, Tile> cachedTiles;
    private final java.util.Map<Player, IndianSettlementInternals> playerIndianSettlements;
    private static final String CACHED_TILE_TAG = "cachedTile";
    private static final String CONNECTED_TAG = "connected";
    private static final String CONTIGUITY_TAG = "contiguity";
    private static final String COPIED_TAG = "copied";
    private static final String MOVE_TO_EUROPE_TAG = "moveToEurope";
    private static final String OWNER_TAG = "owner";
    private static final String OWNING_SETTLEMENT_TAG = "owningSettlement";
    private static final String PLAYER_TAG = "player";
    private static final String REGION_TAG = "region";
    private static final String STYLE_TAG = "style";
    private static final String TYPE_TAG = "type";
    private static final String X_TAG = "x";
    private static final String Y_TAG = "y";
    public static final String OLD_UNITS_TAG = "units";

    public Tile(Game game, TileType type, int locX, int locY) {
        super(game);
        this.type = type;
        this.x = locX;
        this.y = locY;
        this.owningSettlement = null;
        this.settlement = null;
        if (game.isInServer()) {
            this.cachedTiles = new HashMap<Player, Tile>();
            this.playerIndianSettlements = new HashMap<Player, IndianSettlementInternals>();
        } else {
            this.cachedTiles = null;
            this.playerIndianSettlements = null;
        }
    }

    public Tile(Game game, String id) {
        super(game, id);
        if (game.isInServer()) {
            this.cachedTiles = new HashMap<Player, Tile>();
            this.playerIndianSettlements = new HashMap<Player, IndianSettlementInternals>();
        } else {
            this.cachedTiles = null;
            this.playerIndianSettlements = null;
        }
    }

    public TileType getType() {
        return this.type;
    }

    public void setType(TileType t) {
        this.type = t;
    }

    public boolean isExplored() {
        return this.type != null;
    }

    public boolean isLand() {
        return this.type != null && !this.type.isWater();
    }

    public boolean isForested() {
        return this.type != null && this.type.isForested();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Map getMap() {
        return this.getGame().getMap();
    }

    @Override
    public Settlement getSettlement() {
        return this.settlement;
    }

    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    public boolean hasSettlement() {
        return this.settlement != null;
    }

    public Settlement getOwningSettlement() {
        return this.owningSettlement;
    }

    public void setOwningSettlement(Settlement owner) {
        this.owningSettlement = owner;
    }

    public TileItemContainer getTileItemContainer() {
        return this.tileItemContainer;
    }

    public void setTileItemContainer(TileItemContainer newTileItemContainer) {
        this.tileItemContainer = newTileItemContainer;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region newRegion) {
        this.region = newRegion;
    }

    public Region getDiscoverableRegion() {
        return this.region == null ? null : this.region.getDiscoverableRegion();
    }

    public boolean isHighSeasConnected() {
        return this.highSeasCount >= 0;
    }

    public int getHighSeasCount() {
        return this.highSeasCount;
    }

    public void setHighSeasCount(int count) {
        this.highSeasCount = count;
    }

    public boolean isCoastland() {
        return this.isLand() && this.getHighSeasCount() > 0;
    }

    public Boolean getMoveToEurope() {
        return this.moveToEurope;
    }

    public void setMoveToEurope(Boolean moveToEurope) {
        this.moveToEurope = moveToEurope;
    }

    public boolean isDirectlyHighSeasConnected() {
        return this.moveToEurope != null ? this.moveToEurope : (this.type == null ? false : this.type.isDirectlyHighSeasConnected());
    }

    public boolean isRiverCorner() {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (Tile t : this.getSurroundingTiles(1)) {
            if (!t.isOnRiver()) continue;
            tiles.add(t);
        }
        switch (tiles.size()) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                return ((Tile)tiles.get(0)).isAdjacent((Tile)tiles.get(1));
            }
            case 3: {
                return ((Tile)tiles.get(0)).isAdjacent((Tile)tiles.get(1)) || ((Tile)tiles.get(1)).isAdjacent((Tile)tiles.get(2)) || ((Tile)tiles.get(2)).isAdjacent((Tile)tiles.get(0));
            }
        }
        return true;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int newStyle) {
        this.style = newStyle;
    }

    public int getContiguity() {
        return this.contiguity;
    }

    public void setContiguity(int contiguity) {
        this.contiguity = contiguity;
    }

    public boolean isConnectedTo(Tile other) {
        return this.getContiguity() == other.getContiguity();
    }

    public Set<Tile> getContiguityAdjacent(int contiguity) {
        HashSet<Tile> ret = new HashSet<Tile>();
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.getContiguity() != contiguity) continue;
            ret.add(t);
        }
        return ret;
    }

    public boolean isOnRiver() {
        TileType greatRiver = this.getSpecification().getTileType("model.tile.greatRiver");
        TileType ocean = this.getSpecification().getTileType("model.tile.ocean");
        boolean ret = this.getType() == greatRiver;
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.getType() == ocean) {
                return false;
            }
            ret |= t.getType() == greatRiver;
        }
        return ret;
    }

    public boolean isBlocked(Unit unit) {
        Player owner = unit.getOwner();
        Unit u = this.getFirstUnit();
        if (u != null && !owner.owns(u)) {
            return true;
        }
        if (this.isLand()) {
            Settlement s = this.getSettlement();
            if (unit.isNaval()) {
                return s == null || !owner.owns(s);
            }
            return s != null && !owner.owns(s);
        }
        return !unit.isNaval();
    }

    private IndianSettlementInternals getPlayerIndianSettlement(Player player) {
        return this.playerIndianSettlements == null ? null : this.playerIndianSettlements.get(player);
    }

    public List<TileImprovement> getTileImprovements() {
        return this.tileItemContainer == null ? Collections.emptyList() : this.tileItemContainer.getImprovements();
    }

    public List<TileImprovement> getCompletedTileImprovements() {
        return this.tileItemContainer == null ? Collections.emptyList() : this.tileItemContainer.getCompletedImprovements();
    }

    public boolean hasTileImprovement(TileImprovementType type) {
        return type.isChangeType() ? type.changeContainsTarget(this.getType()) : (this.tileItemContainer == null ? false : this.tileItemContainer.hasImprovement(type));
    }

    public TileImprovement getTileImprovement(TileImprovementType type) {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getImprovement(type);
    }

    public boolean hasLostCityRumour() {
        return this.tileItemContainer != null && this.tileItemContainer.getLostCityRumour() != null;
    }

    public LostCityRumour getLostCityRumour() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getLostCityRumour();
    }

    public boolean hasResource() {
        return this.tileItemContainer != null && this.tileItemContainer.getResource() != null;
    }

    public boolean hasRiver() {
        return this.tileItemContainer != null && this.tileItemContainer.getRiver() != null;
    }

    public TileImprovement getRiver() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getRiver();
    }

    public TileImprovementStyle getRiverStyle() {
        TileImprovement river;
        return this.tileItemContainer == null ? null : ((river = this.tileItemContainer.getRiver()) == null ? null : river.getStyle());
    }

    public boolean hasRoad() {
        return this.tileItemContainer != null && this.tileItemContainer.getRoad() != null;
    }

    public TileImprovement getRoad() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getRoad();
    }

    private boolean addTileItem(TileItem item) {
        TileItem added;
        if (item == null) {
            return false;
        }
        if (this.tileItemContainer == null) {
            this.tileItemContainer = new TileItemContainer(this.getGame(), this);
        }
        return (added = this.tileItemContainer.addTileItem(item)) == item;
    }

    private <T extends TileItem> T removeTileItem(T item) {
        if (item == null || this.tileItemContainer == null) {
            return null;
        }
        return this.tileItemContainer.removeTileItem(item);
    }

    public void addLostCityRumour(LostCityRumour rumour) {
        this.addTileItem(rumour);
    }

    public LostCityRumour removeLostCityRumour() {
        return this.removeTileItem(this.getLostCityRumour());
    }

    public TileImprovement addRiver(int magnitude, String conns) {
        if (magnitude == 0) {
            return null;
        }
        TileImprovementType riverType = this.getSpecification().getTileImprovementType("model.improvement.river");
        TileImprovement river = new TileImprovement(this.getGame(), this, riverType);
        river.setTurnsToComplete(0);
        river.setMagnitude(magnitude);
        if (!this.addTileItem(river)) {
            return null;
        }
        river.updateRiverConnections(conns);
        return river;
    }

    public TileImprovement removeRiver() {
        TileImprovement river = this.getRiver();
        if (river == null) {
            return null;
        }
        TileImprovement result = this.removeTileItem(river);
        if (result == river) {
            river.updateRiverConnections(null);
        }
        return result;
    }

    public TileImprovement addRoad() {
        TileImprovementType roadType = this.getSpecification().getTileImprovementType("model.improvement.road");
        TileImprovement road = new TileImprovement(this.getGame(), this, roadType);
        road.setMagnitude(1);
        return this.addTileItem(road) ? road : null;
    }

    public TileImprovement removeRoad() {
        TileImprovement road = this.getRoad();
        if (road == null) {
            return null;
        }
        road.updateRoadConnections(false);
        return this.removeTileItem(road);
    }

    public Resource getResource() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getResource();
    }

    public void addResource(Resource resource) {
        this.addTileItem(resource);
    }

    public Resource removeResource() {
        Resource resource = this.getResource();
        if (resource == null) {
            return null;
        }
        return this.removeTileItem(resource);
    }

    public int getWorkAmount(TileImprovementType workType) {
        return workType == null ? -1 : (this.getTileImprovement(workType) != null ? -1 : this.getType().getBasicWorkTurns() + workType.getAddWorkTurns());
    }

    public boolean isImprovementTypeAllowed(TileImprovementType type) {
        TileImprovement ti;
        return type != null && type.isTileTypeAllowed(this.getType()) && ((ti = this.getTileImprovement(type)) == null || !ti.isComplete());
    }

    public boolean isImprovementAllowed(TileImprovement tip) {
        TileImprovementType type = tip.getType();
        if (!this.isImprovementTypeAllowed(type)) {
            return false;
        }
        TileImprovementType req = type.getRequiredImprovementType();
        if (req != null && this.getTileImprovement(req) == null) {
            return false;
        }
        TileImprovement ti = this.getTileImprovement(type);
        return ti == null || !ti.isComplete();
    }

    public List<RandomChoice<Disaster>> getDisasters() {
        ArrayList<RandomChoice<Disaster>> disasters = new ArrayList<RandomChoice<Disaster>>();
        disasters.addAll(this.type.getDisasters());
        for (TileImprovement ti : this.getCompletedTileImprovements()) {
            disasters.addAll(ti.getType().getDisasters());
        }
        return disasters;
    }

    public StringTemplate getLabel() {
        StringTemplate label = StringTemplate.key(this.type.getNameKey());
        if (this.tileItemContainer != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (TileItem item : this.tileItemContainer.getTileItems()) {
                if (item instanceof Resource) {
                    keys.add(((Resource)item).getType().getNameKey());
                    continue;
                }
                if (!(item instanceof TileImprovement) || !((TileImprovement)item).isComplete()) continue;
                keys.add(((TileImprovement)item).getType().getNameKey());
            }
            if (!keys.isEmpty()) {
                label = StringTemplate.label("/").add(this.type.getNameKey());
                for (String key : keys) {
                    label.add(key);
                }
            }
        }
        return label;
    }

    public int getDistanceTo(Tile tile) {
        return this.getMap().getDistance(this, tile);
    }

    public Map.Direction getDirection(Tile tile) {
        return this.getMap().getDirection(this, tile);
    }

    public Tile getNeighbourOrNull(Map.Direction direction) {
        return this.getMap().getAdjacentTile(this, direction);
    }

    public boolean isAdjacent(Tile tile) {
        return tile == null ? false : this.getDistanceTo(tile) == 1;
    }

    public boolean isPolar() {
        return this.getMap().isPolar(this);
    }

    public boolean isLandLocked() {
        if (!this.isLand()) {
            return false;
        }
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.isLand()) continue;
            return false;
        }
        return true;
    }

    public boolean isShore() {
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.isLand() == this.isLand()) continue;
            return true;
        }
        return false;
    }

    public Iterable<Tile> getSurroundingTiles(int range) {
        return this.getMap().getCircleTiles(this, true, range);
    }

    public List<Tile> getSurroundingTiles(int rangeMin, int rangeMax) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        if (rangeMin > rangeMax || rangeMin < 0) {
            return result;
        }
        if (rangeMin == 0) {
            result.add(this);
        }
        if (rangeMax > 0) {
            for (Tile t : this.getSurroundingTiles(rangeMax)) {
                result.add(t);
            }
        }
        if (rangeMin > 1) {
            for (Tile t : this.getSurroundingTiles(rangeMin - 1)) {
                result.remove(t);
            }
        }
        return result;
    }

    public boolean hasUnexploredAdjacent() {
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.isExplored()) continue;
            return true;
        }
        return false;
    }

    public int getAvailableAdjacentCount() {
        int n = 0;
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.isLand() != this.isLand()) continue;
            ++n;
        }
        return n;
    }

    public List<Colony> getAdjacentColonies() {
        ArrayList<Colony> result = new ArrayList<Colony>();
        for (Tile t : this.getSurroundingTiles(1)) {
            Colony c = t.getColony();
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    public Settlement getNearestSettlement(Player owner, int radius, boolean same) {
        if (radius <= 0) {
            radius = Integer.MAX_VALUE;
        }
        Map map = this.getGame().getMap();
        for (Tile t : map.getCircleTiles(this, true, radius)) {
            Settlement settlement;
            if (t == this || same && !this.isConnectedTo(t) || (settlement = t.getSettlement()) == null || owner != null && !owner.owns(settlement)) continue;
            return settlement;
        }
        return null;
    }

    public Tile getSafeTile(Player player, Random random) {
        if (!(this.getFirstUnit() != null && this.getFirstUnit().getOwner() != player || this.hasSettlement() && this.getSettlement().getOwner() != player)) {
            return this;
        }
        int r = 1;
        List<Tile> tiles;
        while (!(tiles = this.getSurroundingTiles(r, r)).isEmpty()) {
            if (random != null) {
                RandomUtils.randomShuffle(logger, "Safe tile", tiles, random);
            }
            for (Tile t : tiles) {
                if (t.getFirstUnit() != null && t.getFirstUnit().getOwner() != player || t.getSettlement() != null && t.getSettlement().getOwner() != player) continue;
                return t;
            }
            ++r;
        }
        return null;
    }

    public float getDefenceValue() {
        TileType type = this.getType();
        return type == null ? 0.0f : Tile.applyModifiers(1.0f, null, type.getDefenceModifiers());
    }

    public List<Tile> getSafestSurroundingLandTiles(Player player) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (Tile t : this.getSurroundingTiles(1)) {
            if (!t.isLand() || t.hasSettlement() && !player.owns(t.getSettlement())) continue;
            tiles.add(t);
        }
        Collections.sort(tiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile t1, Tile t2) {
                float f = t2.getDefenceValue() - t1.getDefenceValue();
                return f < 0.0f ? -1 : (f > 0.0f ? 1 : 0);
            }
        });
        return tiles;
    }

    public Tile getBestDisembarkTile(Player player) {
        for (Tile t : this.getSafestSurroundingLandTiles(player)) {
            if (!t.isHighSeasConnected()) continue;
            return t;
        }
        return null;
    }

    public boolean isDangerousToShip(Unit ship) {
        Player player = ship.getOwner();
        for (Tile t : this.getSurroundingTiles(1)) {
            Settlement settlement;
            if (!t.hasSettlement() || player.owns(settlement = t.getSettlement()) || !settlement.canBombardEnemyShip() || !player.atWarWith(settlement.getOwner()) && !ship.hasAbility("model.ability.piracy")) continue;
            return true;
        }
        return false;
    }

    public List<Tile> getSafeAnchoringTiles(Unit unit) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.isLand() || !t.isHighSeasConnected() || t.isDangerousToShip(unit)) continue;
            result.add(t);
        }
        return result;
    }

    public void changeType(TileType type) {
        this.setType(type);
        if (this.tileItemContainer != null) {
            this.tileItemContainer.removeIncompatibleImprovements();
        }
        if (!this.isLand()) {
            this.settlement = null;
        }
        this.updateColonyTiles();
    }

    public boolean isInUse() {
        return this.getOwningSettlement() instanceof Colony && ((Colony)this.getOwningSettlement()).isTileInUse(this);
    }

    public void changeOwningSettlement(Settlement settlement) {
        if (this.owningSettlement != null) {
            this.owningSettlement.removeTile(this);
        }
        this.setOwningSettlement(settlement);
        if (settlement != null) {
            settlement.addTile(this);
        }
    }

    public void changeOwnership(Player player, Settlement settlement) {
        this.setOwner(player);
        this.changeOwningSettlement(settlement);
    }

    public String getBuildColonyWarnings(Unit unit) {
        Specification spec = this.getSpecification();
        boolean landLocked = true;
        boolean ownedByEuropeans = false;
        boolean ownedBySelf = false;
        boolean ownedByIndians = false;
        HashMap<GoodsType, Integer> goodsMap = new HashMap<GoodsType, Integer>();
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            if (goodsType.isBuildingMaterial()) {
                while (goodsType.isRefined()) {
                    goodsType = goodsType.getInputType();
                }
            } else if (!goodsType.isFoodType()) continue;
            for (ProductionType productionType : this.getType().getAvailableProductionTypes(false)) {
                int potential = productionType.getOutput(goodsType) == null ? 0 : this.getPotentialProduction(goodsType, null);
                Integer oldPotential = (Integer)goodsMap.get(goodsType);
                if (oldPotential != null && potential <= oldPotential) continue;
                goodsMap.put(goodsType, potential);
            }
        }
        block3: for (Tile t : this.getSurroundingTiles(1)) {
            if (!t.isLand()) {
                landLocked = false;
            }
            for (Map.Entry entry : goodsMap.entrySet()) {
                entry.setValue((Integer)entry.getValue() + t.getPotentialProduction((GoodsType)entry.getKey(), spec.getDefaultUnitType()));
            }
            Player tileOwner = t.getOwner();
            if (unit.getOwner() == tileOwner) {
                if (t.getOwningSettlement() != null) {
                    ownedBySelf = true;
                    continue;
                }
                for (Tile ownTile : t.getSurroundingTiles(1)) {
                    Colony colony = ownTile.getColony();
                    if (colony == null || colony.getOwner() != unit.getOwner()) continue;
                    ownedBySelf = true;
                    continue block3;
                }
                continue;
            }
            if (tileOwner != null && tileOwner.isEuropean()) {
                ownedByEuropeans = true;
                continue;
            }
            if (tileOwner == null) continue;
            ownedByIndians = true;
        }
        int food = 0;
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (!((GoodsType)entry.getKey()).isFoodType()) continue;
            food += ((Integer)entry.getValue()).intValue();
        }
        LogBuilder lb = new LogBuilder(256);
        lb.mark();
        if (landLocked) {
            lb.add(Messages.message("buildColony.landLocked"), "\n");
        }
        if (food < 8) {
            lb.add(Messages.message("buildColony.noFood"), "\n");
        }
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (((GoodsType)entry.getKey()).isFoodType() || (Integer)entry.getValue() >= 4) continue;
            lb.add(Messages.message(StringTemplate.template("buildColony.noBuildingMaterials").add("%goods%", ((GoodsType)entry.getKey()).getNameKey())), "\n");
        }
        if (ownedBySelf) {
            lb.add(Messages.message("buildColony.ownLand"), "\n");
        }
        if (ownedByEuropeans) {
            lb.add(Messages.message("buildColony.EuropeanLand"), "\n");
        }
        if (ownedByIndians) {
            lb.add(Messages.message("buildColony.IndianLand"), "\n");
        }
        return !lb.grew(new Object[0]) ? null : lb.toString();
    }

    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return this.type != null && this.type.canProduce(goodsType, unitType) || this.tileItemContainer != null && this.tileItemContainer.canProduce(goodsType, unitType);
    }

    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        if (this.type == null || goodsType == null || !goodsType.isFarmed()) {
            return 0;
        }
        int amount = this.type.getBaseProduction(productionType, goodsType, unitType);
        return amount < 0 ? 0 : amount;
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return 0;
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        return (amount = (int)Tile.applyModifiers(amount, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType))) < 0 ? 0 : amount;
    }

    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return Collections.emptyList();
        }
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        if (this.tileItemContainer != null) {
            result.addAll(this.tileItemContainer.getProductionModifiers(goodsType, unitType));
        }
        return result;
    }

    public int getMaximumPotential(GoodsType goodsType, UnitType unitType) {
        Specification spec = this.getSpecification();
        ArrayList<TileType> tileTypes = new ArrayList<TileType>();
        tileTypes.add(this.type);
        for (TileImprovementType impType : spec.getTileImprovementTypeList()) {
            if (impType.getChange(this.type) == null) continue;
            tileTypes.add(impType.getChange(this.type));
        }
        int maxProduction = 0;
        for (TileType tileType : tileTypes) {
            float potential = tileType.getPotentialProduction(goodsType, unitType);
            if (tileType == this.type && this.hasResource()) {
                for (TileItem item : this.tileItemContainer.getTileItems()) {
                    if (!(item instanceof Resource)) continue;
                    potential = item.applyBonus(goodsType, unitType, (int)potential);
                }
            }
            for (TileImprovementType ti : spec.getTileImprovementTypeList()) {
                if (ti.isNatural() || !ti.isTileTypeAllowed(tileType) || ti.getBonus(goodsType) <= 0) continue;
                potential = ti.getProductionModifier(goodsType).applyTo(potential);
            }
            maxProduction = Math.max((int)potential, maxProduction);
        }
        return maxProduction;
    }

    public List<AbstractGoods> getSortedPotential() {
        return this.getSortedPotential(null, null);
    }

    public List<AbstractGoods> getSortedPotential(Unit unit) {
        return this.getSortedPotential(unit.getType(), unit.getOwner());
    }

    public Comparator<AbstractGoods> getMarketGoodsComparator(final Market market) {
        return new Comparator<AbstractGoods>(){

            @Override
            public int compare(AbstractGoods o, AbstractGoods p) {
                return market.getSalePrice(p.getType(), p.getAmount()) - market.getSalePrice(o.getType(), o.getAmount());
            }
        };
    }

    public List<AbstractGoods> getSortedPotential(UnitType unitType, Player owner) {
        Specification spec = this.getSpecification();
        ArrayList<AbstractGoods> goodsTypeList = new ArrayList<AbstractGoods>();
        if (this.getType() != null) {
            for (GoodsType goodsType : spec.getFarmedGoodsTypeList()) {
                int potential = this.getPotentialProduction(goodsType, unitType);
                if (potential <= 0) continue;
                goodsTypeList.add(new AbstractGoods(goodsType, potential));
            }
            Collections.sort(goodsTypeList, owner == null || owner.getMarket() == null ? AbstractGoods.goodsAmountComparator : this.getMarketGoodsComparator(owner.getMarket()));
        }
        return goodsTypeList;
    }

    private void updateColonyTiles() {
        for (Player player : this.getGame().getLiveEuropeanPlayers(null)) {
            for (Colony colony : player.getColonies()) {
                for (ColonyTile colonyTile : colony.getColonyTiles()) {
                    if (colonyTile.getWorkTile() != this) continue;
                    colonyTile.updateProductionType();
                }
            }
        }
    }

    public Tile getCachedTile(Player player) {
        return this.cachedTiles == null ? null : (player.isEuropean() ? this.cachedTiles.get(player) : this);
    }

    public void setCachedTile(Player player, Tile tile) {
        if (this.cachedTiles == null || !player.isEuropean()) {
            return;
        }
        this.cachedTiles.put(player, tile);
    }

    public void seeTile() {
        for (Player p : this.getGame().getLiveEuropeanPlayers(null)) {
            if (!p.canSee(this)) continue;
            this.seeTile(p);
        }
    }

    public void seeTile(Player player) {
        this.setCachedTile(player, this);
    }

    public void cacheUnseen() {
        this.cacheUnseen(null, null);
    }

    public Tile getTileToCache() {
        Tile tile = this.copy(this.getGame(), Tile.class);
        tile.clearUnitList();
        Colony colony = this.getColony();
        if (colony != null) {
            tile.getColony().setDisplayUnitCount(colony.getUnitCount());
        }
        return tile;
    }

    public void cacheUnseen(Player player) {
        this.cacheUnseen(player, null);
    }

    public void cacheUnseen(Tile copied) {
        this.cacheUnseen(null, copied);
    }

    public void cacheUnseen(Player player, Tile copied) {
        if (this.cachedTiles == null) {
            return;
        }
        for (Player p : this.getGame().getLiveEuropeanPlayers(player)) {
            if (p.canSee(this) || this.getCachedTile(p) != this) continue;
            if (copied == null) {
                copied = this.getTileToCache();
            }
            this.setCachedTile(p, copied);
        }
    }

    public void updateIndianSettlement(Player player) {
        if (this.playerIndianSettlements == null || !player.isEuropean()) {
            return;
        }
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        IndianSettlement is = this.getIndianSettlement();
        if (is == null) {
            if (isi != null) {
                this.removeIndianSettlementInternals(player);
            }
        } else {
            if (isi == null) {
                isi = new IndianSettlementInternals();
                this.playerIndianSettlements.put(player, isi);
            }
            isi.update(is);
        }
    }

    public void removeIndianSettlementInternals(Player player) {
        if (this.playerIndianSettlements == null) {
            return;
        }
        this.playerIndianSettlements.remove(player);
    }

    public UnitType getLearnableSkill(Player player) {
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        return isi == null ? null : isi.skill;
    }

    public GoodsType[] getWantedGoods(Player player) {
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        return isi == null ? null : isi.wantedGoods;
    }

    public void setIndianSettlementInternals(Player player, UnitType skill, GoodsType[] wanted) {
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        if (isi == null) {
            isi = new IndianSettlementInternals();
            this.playerIndianSettlements.put(player, isi);
        }
        isi.setValues(skill, wanted);
    }

    public boolean isExploredBy(Player player) {
        return !player.isEuropean() ? true : (!this.isExplored() ? false : (this.cachedTiles == null ? true : this.getCachedTile(player) != null));
    }

    public void setExplored(Player player, boolean reveal) {
        if (this.cachedTiles == null || !player.isEuropean()) {
            return;
        }
        if (reveal) {
            this.seeTile(player);
        } else {
            this.cachedTiles.remove(player);
        }
    }

    public Unit getDefendingUnit(Unit attacker) {
        float power;
        CombatModel cm = this.getGame().getCombatModel();
        Unit defender = null;
        float defenderPower = -1.0f;
        for (Unit u : this.getUnitList()) {
            if (this.isLand() == u.isNaval() || !Unit.betterDefender(defender, defenderPower, u, power = cm.getDefencePower(attacker, u))) continue;
            defender = u;
            defenderPower = power;
        }
        if ((defender == null || !defender.isDefensiveUnit()) && this.hasSettlement()) {
            Unit u = null;
            try {
                u = this.settlement.getDefendingUnit(attacker);
            }
            catch (IllegalStateException e) {
                logger.log(Level.WARNING, "Empty settlement: " + this.settlement.getName(), e);
            }
            if (u != null && Unit.betterDefender(defender, defenderPower, u, power = cm.getDefencePower(attacker, u))) {
                defender = u;
            }
        }
        if (defender == null && this.isLand()) {
            defender = this.getFirstUnit();
        }
        return defender;
    }

    public Unit getOccupyingUnit() {
        Unit unit = this.getFirstUnit();
        Player owner = null;
        if (this.getOwningSettlement() != null) {
            owner = this.getOwningSettlement().getOwner();
        }
        if (owner != null && unit != null && unit.getOwner() != owner && unit.getOwner().atWarWith(owner)) {
            for (Unit enemyUnit : this.getUnitList()) {
                if (!enemyUnit.isOffensiveUnit()) continue;
                return enemyUnit;
            }
        }
        return null;
    }

    public boolean isOccupied() {
        return this.getOccupyingUnit() != null;
    }

    @Override
    public Tile getTile() {
        return this;
    }

    @Override
    public StringTemplate getLocationLabel() {
        if (this.settlement != null) {
            return this.settlement.getLocationLabel();
        }
        Settlement nearSettlement = null;
        for (Tile tile : this.getSurroundingTiles(8)) {
            nearSettlement = tile.getSettlement();
            if (nearSettlement == null || nearSettlement.getName() == null) continue;
            String name = nearSettlement.getName();
            Map.Direction d = Map.getRoughDirection(tile, this);
            StringTemplate l = StringTemplate.template("nearLocation").add("%direction%", d.getNameKey()).addName("%location%", name);
            return StringTemplate.template("nameLocation").add("%name%", this.type == null ? "unexplored" : this.type.getNameKey()).addStringTemplate("%location%", l);
        }
        if (this.region != null && this.region.getName() != null) {
            return StringTemplate.template("nameLocation").add("%name%", this.type.getNameKey()).add("%location%", this.region.getNameKey());
        }
        return StringTemplate.key(this.type.getNameKey());
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        if (this.settlement != null) {
            return this.settlement.getLocationLabelFor(player);
        }
        Settlement nearSettlement = null;
        for (Tile tile : this.getSurroundingTiles(8)) {
            nearSettlement = tile.getSettlement();
            if (nearSettlement == null) continue;
            StringTemplate name = nearSettlement.getLocationLabelFor(player);
            Map.Direction d = Map.getRoughDirection(tile, this);
            StringTemplate l = StringTemplate.template("nearLocation").add("%direction%", d.getNameKey()).addStringTemplate("%location%", name);
            return StringTemplate.template("nameLocation").add("%name%", this.type == null ? "unexplored" : this.type.getNameKey()).addStringTemplate("%location%", l);
        }
        if (this.region != null && this.region.getName() != null) {
            return StringTemplate.template("nameLocation").add("%name%", this.type.getNameKey()).addStringTemplate("%location%", this.region.getLabel());
        }
        return StringTemplate.key(this.type.getNameKey());
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof TileItem) {
            return this.addTileItem((TileItem)locatable);
        }
        if (locatable instanceof Unit) {
            if (super.add(locatable)) {
                ((Unit)locatable).setState(Unit.UnitState.ACTIVE);
                return true;
            }
            return false;
        }
        return super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof TileItem) {
            return this.removeTileItem((TileItem)locatable) == (TileItem)locatable;
        }
        return super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof TileItem) {
            return this.tileItemContainer != null && this.tileItemContainer.contains((TileItem)locatable);
        }
        return super.contains(locatable);
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Unit) {
            return ((Unit)locatable).isTileAccessible(this);
        }
        if (locatable instanceof TileImprovement) {
            return ((TileImprovement)locatable).getType().isTileTypeAllowed(this.getType());
        }
        return false;
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder(16);
        TileType type = this.getType();
        sb.append(this.getX()).append(",").append(this.getY()).append("-").append(type == null ? "?" : type.getSuffix());
        return sb.toString();
    }

    @Override
    public String getNameKey() {
        if (this.getGame().isInClient()) {
            return this.isExplored() ? this.getType().getNameKey() : "unexplored";
        }
        Player player = this.getGame().getCurrentPlayer();
        if (player != null) {
            return this.getCachedTile(player) == null ? "unexplored" : this.getType().getNameKey();
        }
        logger.warning("player == null");
        return "";
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player owner) {
        this.owner = owner;
    }

    @Override
    public void dispose() {
        if (this.settlement != null) {
            this.settlement.dispose();
            this.settlement = null;
        }
        if (this.tileItemContainer != null) {
            this.tileItemContainer.dispose();
            this.tileItemContainer = null;
        }
        super.dispose();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        Settlement settlement = this.getSettlement();
        if (settlement != null) {
            result = Math.min(result, settlement.checkIntegrity(fix));
        }
        if (this.tileItemContainer != null) {
            result = Math.min(result, this.tileItemContainer.checkIntegrity(fix));
        }
        return result;
    }

    @Override
    public Set<Ability> getAbilities(String id, FreeColGameObjectType fcgot, Turn turn) {
        return this.getType().getAbilities(id, fcgot, turn);
    }

    @Override
    public void toXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        Tile tile;
        Player player = xw.getClientPlayer();
        Tile tile2 = tile = player == null ? this : this.getCachedTile(player);
        if (tile == null) {
            xw.writeStartElement(tag);
            xw.writeAttribute("id", this.getId());
            xw.writeAttribute(X_TAG, this.x);
            xw.writeAttribute(Y_TAG, this.y);
            xw.writeEndElement();
        } else {
            tile.internalToXML(xw, tag);
        }
    }

    public void internalToXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        xw.writeStartElement(tag);
        this.writeAttributes(xw);
        this.writeChildren(xw);
        xw.writeEndElement();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(X_TAG, this.x);
        xw.writeAttribute(Y_TAG, this.y);
        xw.writeAttribute(TYPE_TAG, this.type);
        if (this.owner != null) {
            xw.writeAttribute(OWNER_TAG, this.owner);
        }
        if (this.owningSettlement != null) {
            if (this.owningSettlement.isDisposed()) {
                this.owningSettlement = null;
            } else {
                xw.writeAttribute(OWNING_SETTLEMENT_TAG, this.owningSettlement);
            }
        }
        xw.writeAttribute(STYLE_TAG, this.style);
        if (this.region != null) {
            xw.writeAttribute(REGION_TAG, this.region);
        }
        if (this.moveToEurope != null) {
            xw.writeAttribute(MOVE_TO_EUROPE_TAG, this.moveToEurope);
        }
        if (this.highSeasCount >= 0) {
            xw.writeAttribute(CONNECTED_TAG, this.highSeasCount);
        }
        if (this.contiguity >= 0) {
            xw.writeAttribute(CONTIGUITY_TAG, this.contiguity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        Player player = xw.getClientPlayer();
        if ((player == null || player.canSee(this)) && (this.settlement == null || xw.validFor(this.settlement.getOwner()))) {
            super.writeChildren(xw);
        }
        if (this.settlement != null) {
            this.settlement.toXML(xw);
        }
        if (this.tileItemContainer != null) {
            this.tileItemContainer.toXML(xw);
        }
        if (xw.validForSave() && this.cachedTiles != null) {
            for (Player p : this.getGame().getLiveEuropeanPlayers(null)) {
                Tile t = this.getCachedTile(p);
                if (t == null) continue;
                if (t == this && this.getIndianSettlement() != null) {
                    t = this.getTileToCache();
                    t.setIndianSettlementInternals(p, this.getLearnableSkill(p), this.getWantedGoods(p));
                }
                xw.writeStartElement(CACHED_TILE_TAG);
                xw.writeAttribute(PLAYER_TAG, p);
                xw.writeAttribute(COPIED_TAG, t != this);
                if (t != this) {
                    FreeColXMLWriter.WriteScope scope = xw.getWriteScope();
                    xw.setWriteScope(FreeColXMLWriter.WriteScope.toClient(p));
                    try {
                        t.internalToXML(xw, Tile.getXMLElementTagName());
                    }
                    finally {
                        xw.setWriteScope(scope);
                    }
                }
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.x = xr.getAttribute(X_TAG, 0);
        this.y = xr.getAttribute(Y_TAG, 0);
        this.type = xr.getType(spec, TYPE_TAG, TileType.class, null);
        if (this.type == null) {
            this.style = 0;
            this.highSeasCount = -1;
            this.owner = null;
            this.region = null;
            this.moveToEurope = null;
            this.contiguity = -1;
            return;
        }
        this.style = xr.getAttribute(STYLE_TAG, 0);
        String str = xr.getAttribute(CONNECTED_TAG, null);
        if (str == null || "".equals(str)) {
            this.highSeasCount = -1;
            String typeStr = xr.getAttribute(TYPE_TAG, null);
            if ("model.tile.highSeas".equals(typeStr)) {
                this.highSeasCount = Integer.MAX_VALUE;
            }
        } else {
            try {
                this.highSeasCount = Integer.parseInt(str);
            }
            catch (NumberFormatException nfe) {
                this.highSeasCount = -1;
                this.highSeasCount = Integer.MAX_VALUE;
            }
        }
        this.owner = xr.findFreeColGameObject(game, OWNER_TAG, Player.class, null, false);
        this.region = xr.findFreeColGameObject(game, REGION_TAG, Region.class, null, false);
        this.moveToEurope = xr.hasAttribute(MOVE_TO_EUROPE_TAG) ? Boolean.valueOf(xr.getAttribute(MOVE_TO_EUROPE_TAG, false)) : null;
        this.contiguity = xr.getAttribute(CONTIGUITY_TAG, -1);
        Location loc = xr.getLocationAttribute(game, OWNING_SETTLEMENT_TAG, true);
        this.owningSettlement = loc instanceof Settlement ? (Settlement)loc : null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.settlement = null;
        super.readChildren(xr);
        if (this.getSettlement() != null) {
            Settlement settlement = this.getSettlement();
            Player owner = settlement.getOwner();
            if (owner != null && this.getOwner() != owner) {
                this.owner = owner;
            }
            if (this.owningSettlement != settlement) {
                this.owningSettlement = settlement;
            }
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Unit missionary;
        Player player;
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (this.cachedTiles != null && CACHED_TILE_TAG.equals(tag)) {
            player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            boolean copied = xr.getAttribute(COPIED_TAG, false);
            if (copied) {
                FreeColXMLReader.ReadScope scope = xr.getReadScope();
                xr.setReadScope(FreeColXMLReader.ReadScope.NOINTERN);
                xr.nextTag();
                xr.expectTag(Tile.getXMLElementTagName());
                Tile tile = xr.readFreeColGameObject(game, Tile.class);
                Colony colony = tile.getColony();
                if (colony != null && colony.getDisplayUnitCount() <= 0) {
                    logger.warning("Copied colony " + colony.getId() + " display unit count set to 1 from corrupt: " + colony.getDisplayUnitCount());
                    colony.setDisplayUnitCount(1);
                }
                this.setCachedTile(player, tile);
                xr.setReadScope(scope);
                IndianSettlement is = tile.getIndianSettlement();
                if (is == null) {
                    this.removeIndianSettlementInternals(player);
                } else {
                    this.setIndianSettlementInternals(player, is.getLearnableSkill(), is.getWantedGoods());
                }
            } else {
                this.setCachedTile(player, this);
            }
            xr.closeTag(CACHED_TILE_TAG);
        } else if (OLD_UNITS_TAG.equals(tag)) {
            while (xr.nextTag() != 2) {
                super.readChild(xr);
            }
        } else if (Colony.getXMLElementTagName().equals(tag)) {
            this.settlement = xr.readFreeColGameObject(game, Colony.class);
        } else if (IndianSettlement.getXMLElementTagName().equals(tag)) {
            this.settlement = xr.readFreeColGameObject(game, IndianSettlement.class);
        } else if (PlayerExploredTile.getXMLElementTagName().equals(tag)) {
            player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            if (xr.hasAttribute("learnableSkill") || xr.hasAttribute("wantedGoods0")) {
                UnitType skill = xr.getType(spec, "learnableSkill", UnitType.class, null);
                GoodsType[] wanted = new GoodsType[3];
                for (int i = 0; i < wanted.length; ++i) {
                    wanted[i] = xr.getType(spec, "wantedGoods" + i, GoodsType.class, null);
                }
                this.setIndianSettlementInternals(player, skill, wanted);
            }
            PlayerExploredTile pet = xr.readFreeColGameObject(game, PlayerExploredTile.class);
            pet.fixCache();
        } else if (TileItemContainer.getXMLElementTagName().equals(tag)) {
            this.tileItemContainer = xr.readFreeColGameObject(game, TileItemContainer.class);
        } else {
            super.readChild(xr);
        }
        if (this.settlement instanceof IndianSettlement && (missionary = ((IndianSettlement)this.settlement).getMissionary()) != null) {
            missionary.setLocationNoUpdate(this.settlement);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(this.getId()).append(" ").append(this.type == null ? "unknown" : this.type.getSuffix()).append(" ").append(this.x).append(",").append(this.y).append(!this.hasSettlement() ? "" : " " + this.getSettlement().getName()).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return Tile.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tile";
    }

    private static class IndianSettlementInternals {
        public UnitType skill = null;
        public GoodsType[] wantedGoods = null;

        private IndianSettlementInternals() {
        }

        public void update(IndianSettlement indianSettlement) {
            this.setValues(indianSettlement.getLearnableSkill(), indianSettlement.getWantedGoods());
        }

        public void setValues(UnitType skill, GoodsType[] wanted) {
            this.skill = skill;
            if (wanted == null) {
                this.wantedGoods = null;
            } else {
                if (this.wantedGoods == null) {
                    this.wantedGoods = new GoodsType[3];
                }
                System.arraycopy(wanted, 0, this.wantedGoods, 0, Math.min(wanted.length, this.wantedGoods.length));
            }
        }
    }
}

