/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.util.Utils;

public class StringTemplate
extends FreeColObject {
    private TemplateType templateType = TemplateType.KEY;
    private String defaultId;
    private List<String> keys = null;
    private List<StringTemplate> replacements = null;
    private static final String DEFAULT_ID_TAG = "defaultId";
    private static final String KEY_TAG = "key";
    private static final String TEMPLATE_TYPE_TAG = "templateType";

    protected StringTemplate() {
    }

    public StringTemplate(String id, StringTemplate template) {
        this.setId(id);
        this.templateType = template.templateType;
        this.keys = template.keys;
        this.replacements = template.replacements;
    }

    protected StringTemplate(String id, TemplateType templateType) {
        this.setId(id);
        this.templateType = templateType;
        this.keys = null;
        this.replacements = null;
    }

    public StringTemplate(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final String getDefaultId() {
        return this.defaultId;
    }

    public StringTemplate setDefaultId(String newDefaultId) {
        this.defaultId = newDefaultId;
        return this;
    }

    public final TemplateType getTemplateType() {
        return this.templateType;
    }

    public final List<String> getKeys() {
        return this.keys == null ? Collections.emptyList() : this.keys;
    }

    private void addKey(String key) {
        if (this.keys == null) {
            this.keys = new ArrayList<String>();
        }
        this.keys.add(key);
    }

    public final List<StringTemplate> getReplacements() {
        return this.replacements == null ? Collections.emptyList() : this.replacements;
    }

    private void addReplacement(StringTemplate replacement) {
        if (this.replacements == null) {
            this.replacements = new ArrayList<StringTemplate>();
        }
        this.replacements.add(replacement);
    }

    public static StringTemplate name(String value) {
        return new StringTemplate(value, TemplateType.NAME);
    }

    public static StringTemplate key(String value) {
        return new StringTemplate(value, TemplateType.KEY);
    }

    public static StringTemplate template(String value) {
        return new StringTemplate(value, TemplateType.TEMPLATE);
    }

    public static StringTemplate label(String value) {
        return new StringTemplate(value, TemplateType.LABEL);
    }

    public final StringTemplate getReplacement(String key) {
        if (this.keys != null && this.replacements != null) {
            for (int index = 0; index < this.keys.size(); ++index) {
                if (!key.equals(this.keys.get(index))) continue;
                if (this.replacements.size() > index) {
                    return this.replacements.get(index);
                }
                return null;
            }
        }
        return null;
    }

    public StringTemplate add(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-value pair to StringTemplate type " + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(new StringTemplate(value, TemplateType.KEY));
        return this;
    }

    public StringTemplate add(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a single string to StringTemplate type " + (Object)((Object)this.templateType));
        }
        this.addReplacement(new StringTemplate(value, TemplateType.KEY));
        return this;
    }

    public StringTemplate addName(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-value pair to StringTemplate type " + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(new StringTemplate(value, TemplateType.NAME));
        return this;
    }

    public StringTemplate addName(String key, FreeColObject object) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-value pair to StringTemplate type " + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(new StringTemplate(Messages.nameKey(object.getId()), TemplateType.KEY));
        return this;
    }

    public StringTemplate addName(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a single string to StringTemplate type " + (Object)((Object)this.templateType));
        }
        this.addReplacement(new StringTemplate(value, TemplateType.NAME));
        return this;
    }

    public StringTemplate addAmount(String key, Number amount) {
        this.addName(key, amount.toString());
        return this;
    }

    public StringTemplate addStringTemplate(String key, StringTemplate template) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add a key-template pair to a StringTemplate type " + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(template);
        return this;
    }

    public StringTemplate addStringTemplate(StringTemplate template) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a StringTemplate to StringTemplate type " + (Object)((Object)this.templateType));
        }
        this.addReplacement(template);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringTemplate)) return false;
        StringTemplate t = (StringTemplate)o;
        if (!super.equals(o) || this.templateType != t.templateType || !Utils.equals(this.defaultId, t.defaultId)) {
            return false;
        }
        if (this.templateType == TemplateType.LABEL) {
            if (this.replacements == null != (t.replacements == null)) {
                return false;
            }
            if (this.replacements == null) return true;
            if (this.replacements.size() != t.replacements.size()) return false;
            for (int index = 0; index < this.replacements.size(); ++index) {
                if (this.replacements.get(index).equals(t.replacements.get(index))) continue;
                return false;
            }
            return true;
        } else {
            if (this.templateType != TemplateType.TEMPLATE) return true;
            if (this.keys == null != (t.keys == null) || this.replacements == null != (t.replacements == null)) {
                return false;
            }
            if (this.keys == null || this.replacements == null) return true;
            if (this.keys.size() != t.keys.size() || this.replacements.size() != t.replacements.size() || this.keys.size() != this.replacements.size()) return false;
            for (int index = 0; index < this.replacements.size(); ++index) {
                if (this.keys.get(index).equals(t.keys.get(index)) && this.replacements.get(index).equals(t.replacements.get(index))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash;
        block4: {
            block3: {
                hash = super.hashCode();
                hash = 31 * hash + this.templateType.ordinal();
                hash = 31 * hash + Utils.hashCode(this.defaultId);
                if (this.templateType != TemplateType.LABEL) break block3;
                if (this.replacements == null) break block4;
                for (StringTemplate replacement : this.replacements) {
                    hash = 31 * hash + Utils.hashCode(replacement);
                }
                break block4;
            }
            if (this.templateType == TemplateType.TEMPLATE && this.keys != null && this.replacements != null) {
                for (int index = 0; index < this.keys.size(); ++index) {
                    hash = 31 * hash + Utils.hashCode(this.keys.get(index));
                    hash = 31 * hash + Utils.hashCode(this.replacements.get(index));
                }
            }
        }
        return hash;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TEMPLATE_TYPE_TAG, this.templateType);
        if (this.defaultId != null) {
            xw.writeAttribute(DEFAULT_ID_TAG, this.defaultId);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.keys != null) {
            for (String key : this.keys) {
                xw.writeStartElement(KEY_TAG);
                xw.writeAttribute("value", key);
                xw.writeEndElement();
            }
        }
        if (this.replacements != null) {
            for (StringTemplate replacement : this.replacements) {
                replacement.toXML(xw);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.templateType = xr.getAttribute(TEMPLATE_TYPE_TAG, TemplateType.class, TemplateType.TEMPLATE);
        this.defaultId = xr.getAttribute(DEFAULT_ID_TAG, null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.keys != null) {
            this.keys.clear();
        }
        if (this.replacements != null) {
            this.replacements.clear();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (KEY_TAG.equals(tag)) {
            this.addKey(xr.getAttribute("value", null));
            xr.closeTag(KEY_TAG);
        } else if (StringTemplate.getXMLElementTagName().equals(tag)) {
            this.addReplacement(new StringTemplate(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append((Object)this.templateType).append(": ");
        switch (this.templateType) {
            case LABEL: {
                if (this.replacements == null) {
                    sb.append(this.getId());
                    break;
                }
                for (StringTemplate object : this.replacements) {
                    sb.append(object).append(this.getId());
                }
                break;
            }
            case TEMPLATE: {
                sb.append(this.getId());
                if (this.defaultId != null) {
                    sb.append(" (").append(this.defaultId).append(")");
                }
                sb.append(" [");
                for (int index = 0; index < this.keys.size(); ++index) {
                    sb.append("[").append(this.keys.get(index)).append(": ").append(this.replacements.get(index)).append("]");
                }
                sb.append("]");
                break;
            }
            case KEY: {
                sb.append(this.getId());
                if (this.defaultId == null) break;
                sb.append(" (").append(this.defaultId).append(")");
                break;
            }
            default: {
                sb.append(this.getId());
            }
        }
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return StringTemplate.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "stringTemplate";
    }

    public static enum TemplateType {
        NAME,
        KEY,
        TEMPLATE,
        LABEL;

    }
}

