/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;

public class ProductionType
extends FreeColObject {
    private boolean unattended;
    private String productionLevel;
    private List<AbstractGoods> outputs = null;
    private List<AbstractGoods> inputs = null;
    private static final String UNATTENDED_TAG = "unattended";
    private static final String GOODS_TYPE_TAG = "goods-type";
    private static final String INPUT_TAG = "input";
    private static final String OUTPUT_TAG = "output";
    private static final String PRODUCTION_LEVEL_TAG = "productionLevel";

    public ProductionType(Specification specification) {
        this.setSpecification(specification);
    }

    public ProductionType(List<AbstractGoods> outputs) {
        this.outputs = outputs;
    }

    public ProductionType(List<AbstractGoods> inputs, List<AbstractGoods> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public ProductionType(AbstractGoods output, boolean unattended, String level) {
        this.outputs = new ArrayList<AbstractGoods>();
        this.outputs.add(output);
        this.unattended = unattended;
        this.productionLevel = level;
    }

    public ProductionType(GoodsType input, GoodsType output, int amount) {
        if (input != null) {
            this.inputs = new ArrayList<AbstractGoods>();
            this.inputs.add(new AbstractGoods(input, amount));
        }
        if (output != null) {
            this.outputs = new ArrayList<AbstractGoods>();
            this.outputs.add(new AbstractGoods(output, amount));
        }
    }

    public ProductionType(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this(specification);
        this.readFromXML(xr);
    }

    public final List<AbstractGoods> getInputs() {
        return this.inputs == null ? Collections.emptyList() : this.inputs;
    }

    public final void setInputs(List<AbstractGoods> newInputs) {
        this.inputs = newInputs;
    }

    private void addInput(GoodsType type, int amount) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<AbstractGoods>(1);
        }
        this.inputs.add(new AbstractGoods(type, amount));
    }

    public final List<AbstractGoods> getOutputs() {
        return this.outputs == null ? Collections.emptyList() : this.outputs;
    }

    public final void setOutputs(List<AbstractGoods> newOutputs) {
        this.outputs = newOutputs;
    }

    private void addOutput(GoodsType type, int amount) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<AbstractGoods>(1);
        }
        this.outputs.add(new AbstractGoods(type, amount));
    }

    public AbstractGoods getOutput(GoodsType goodsType) {
        AbstractGoods output;
        if (this.outputs != null && (output = AbstractGoods.findByType(goodsType, this.outputs)) != null) {
            return output;
        }
        return null;
    }

    public GoodsType getBestOutputType() {
        AbstractGoods best = null;
        if (this.outputs != null) {
            int amount = 0;
            for (AbstractGoods output : this.outputs) {
                if (amount >= output.getAmount()) continue;
                amount = output.getAmount();
                best = output;
            }
        }
        return best == null ? null : best.getType();
    }

    public final boolean isUnattended() {
        return this.unattended;
    }

    public final void setUnattended(boolean unattended) {
        this.unattended = unattended;
    }

    public final String getProductionLevel() {
        return this.productionLevel;
    }

    public boolean appliesTo(String level) {
        return level == null || this.productionLevel == null || level.equals(this.productionLevel);
    }

    public boolean appliesExactly(String level) {
        return level != null && level.equals(this.productionLevel);
    }

    public static boolean canProduce(GoodsType goodsType, Collection<ProductionType> types) {
        for (ProductionType productionType : types) {
            AbstractGoods output = AbstractGoods.findByType(goodsType, productionType.getOutputs());
            if (output == null) continue;
            return true;
        }
        return false;
    }

    public static ProductionType getBestProductionType(GoodsType goodsType, Collection<ProductionType> types) {
        ProductionType best = null;
        int bestSum = 0;
        for (ProductionType pt : types) {
            int sum = 0;
            for (AbstractGoods output : pt.getOutputs()) {
                if (goodsType != null && goodsType != output.getType()) continue;
                sum += output.getAmount();
            }
            if (bestSum >= sum) continue;
            bestSum = sum;
            best = pt;
        }
        return best;
    }

    public static AbstractGoods getBestOutputFor(GoodsType goodsType, Collection<ProductionType> types) {
        AbstractGoods best = null;
        for (ProductionType productionType : types) {
            for (AbstractGoods output : productionType.getOutputs()) {
                if (output.getType() != goodsType || best != null && output.getAmount() <= best.getAmount()) continue;
                best = output;
            }
        }
        return best;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.unattended) {
            xw.writeAttribute(UNATTENDED_TAG, this.unattended);
        }
        if (this.productionLevel != null) {
            xw.writeAttribute(PRODUCTION_LEVEL_TAG, this.productionLevel);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.inputs != null) {
            for (AbstractGoods input : this.inputs) {
                xw.writeStartElement(INPUT_TAG);
                xw.writeAttribute(GOODS_TYPE_TAG, input.getType());
                xw.writeAttribute("value", input.getAmount());
                xw.writeEndElement();
            }
        }
        if (this.outputs != null) {
            for (AbstractGoods output : this.outputs) {
                xw.writeStartElement(OUTPUT_TAG);
                xw.writeAttribute(GOODS_TYPE_TAG, output.getType());
                xw.writeAttribute("value", output.getAmount());
                xw.writeEndElement();
            }
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.unattended = xr.getAttribute(UNATTENDED_TAG, false);
        this.productionLevel = xr.getAttribute(PRODUCTION_LEVEL_TAG, null);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.inputs != null) {
            this.inputs.clear();
        }
        if (this.outputs != null) {
            this.outputs.clear();
        }
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (INPUT_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
            this.addInput(type, xr.getAttribute("value", -1));
            xr.closeTag(INPUT_TAG);
        } else if (OUTPUT_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
            this.addOutput(type, xr.getAttribute("value", -1));
            xr.closeTag(OUTPUT_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(64);
        result.append("[").append(this.getId()).append(":");
        if (this.productionLevel != null) {
            result.append(" ").append(this.productionLevel);
        }
        if (this.unattended) {
            result.append(" unattended");
        }
        if (this.inputs != null && !this.inputs.isEmpty()) {
            result.append(" [inputs: ");
            for (AbstractGoods input : this.inputs) {
                result.append(input).append(", ");
            }
            int length = result.length();
            result.replace(length - 2, length, "]");
        }
        if (this.outputs != null && !this.outputs.isEmpty()) {
            result.append(" [outputs: ");
            for (AbstractGoods output : this.outputs) {
                result.append(output).append(", ");
            }
            int length = result.length();
            result.replace(length - 2, length, "]");
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public String getXMLTagName() {
        return ProductionType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "production";
    }
}

