/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

public class Game
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Game.class.getName());
    protected int nextId = 1;
    private UUID uuid = UUID.randomUUID();
    private String clientUserName;
    protected final List<Player> players = new ArrayList<Player>();
    private Player unknownEnemy;
    private Map map = null;
    private NationOptions nationOptions = null;
    protected Player currentPlayer = null;
    private Turn turn = new Turn(1);
    private boolean spanishSuccession = false;
    protected final List<String> citiesOfCibola = new ArrayList<String>();
    private Specification specification = null;
    protected HashMap<String, WeakReference<FreeColGameObject>> freeColGameObjects = new HashMap(10000);
    protected CombatModel combatModel = null;
    private static final int REMOVE_GC_THRESHOLD = 64;
    private int removeCount = 0;
    protected FreeColGameObjectListener freeColGameObjectListener = null;
    private static final String CIBOLA_TAG = "cibola";
    private static final String CURRENT_PLAYER_TAG = "currentPlayer";
    private static final String NEXT_ID_TAG = "nextId";
    private static final String SPANISH_SUCCESSION_TAG = "spanishSuccession";
    private static final String TURN_TAG = "turn";
    private static final String UUID_TAG = "UUID";
    private static final String OLD_NEXT_ID_TAG = "nextID";

    protected Game(Specification specification) {
        super(null);
        this.specification = specification;
        this.clientUserName = null;
    }

    public Game(Element element, String clientUserName) {
        super(null);
        this.clientUserName = clientUserName;
        this.combatModel = new SimpleCombatModel();
        this.readFromXMLElement(element);
        this.setFreeColGameObject(this.getId(), this);
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    public final OptionGroup getDifficultyOptionGroup() {
        return this.specification.getDifficultyOptionGroup();
    }

    public OptionGroup getGameOptions() {
        return this.specification.getGameOptions();
    }

    public void setGameOptions(OptionGroup go) {
        this.specification.setGameOptions(go);
    }

    public OptionGroup getMapGeneratorOptions() {
        return this.specification.getMapGeneratorOptions();
    }

    public void setMapGeneratorOptions(OptionGroup mgo) {
        this.specification.setMapGeneratorOptions(mgo);
    }

    public String getNextId() {
        throw new IllegalStateException("game.getNextId not implemented");
    }

    public FreeColGameObject getFreeColGameObject(String id) {
        WeakReference<FreeColGameObject> ro;
        if (id != null && !id.isEmpty() && (ro = this.freeColGameObjects.get(id)) != null) {
            FreeColGameObject o = (FreeColGameObject)ro.get();
            if (o != null) {
                return o;
            }
            this.freeColGameObjects.remove(id);
        }
        return null;
    }

    public <T extends FreeColGameObject> T getFreeColGameObject(String id, Class<T> returnClass) {
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        try {
            return (T)((FreeColGameObject)returnClass.cast(fcgo));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void setFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Null/empty id.");
        }
        if (fcgo == null) {
            throw new IllegalArgumentException("Null FreeColGameObject.");
        }
        WeakReference<FreeColGameObject> wr = new WeakReference<FreeColGameObject>(fcgo);
        FreeColGameObject old = this.getFreeColGameObject(id);
        if (old != null) {
            throw new IllegalArgumentException("Replacing FreeColGameObject " + id + " : " + old.getClass() + " with " + fcgo.getId() + " : " + fcgo.getClass());
        }
        this.freeColGameObjects.put(id, wr);
        this.notifySetFreeColGameObject(id, fcgo);
    }

    public void removeFreeColGameObject(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Null/empty identifier.");
        }
        this.freeColGameObjects.remove(id);
        this.notifyRemoveFreeColGameObject(id);
        if (++this.removeCount > 64) {
            Iterator<FreeColGameObject> i = this.getFreeColGameObjectIterator();
            while (i.hasNext()) {
                i.next();
            }
            this.removeCount = 0;
            System.gc();
        }
    }

    public Location findFreeColLocation(String id) {
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        return fcgo instanceof Location ? (Location)((Object)fcgo) : null;
    }

    public Location makeFreeColLocation(String id) {
        String tag;
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        if (fcgo != null) {
            if (fcgo instanceof Location) {
                return (Location)((Object)fcgo);
            }
            logger.warning("Not a location: " + id);
            return null;
        }
        int idx = id.indexOf(58);
        String string = tag = idx >= 0 ? id.substring(0, id.indexOf(58)) : id;
        if (!"newWorld".equals(tag)) {
            if (Building.getXMLElementTagName().equals(tag)) {
                return new Building(this, id);
            }
            if (Colony.getXMLElementTagName().equals(tag)) {
                return new Colony(this, id);
            }
            if (ColonyTile.getXMLElementTagName().equals(tag)) {
                return new ColonyTile(this, id);
            }
            if (Europe.getXMLElementTagName().equals(tag)) {
                return new Europe(this, id);
            }
            if (HighSeas.getXMLElementTagName().equals(tag)) {
                return new HighSeas(this, id);
            }
            if (IndianSettlement.getXMLElementTagName().equals(tag)) {
                return new IndianSettlement(this, id);
            }
            if (Map.getXMLElementTagName().equals(tag)) {
                return new Map(this, id);
            }
            if (Tile.getXMLElementTagName().equals(tag)) {
                return new Tile(this, id);
            }
            if (Unit.getXMLElementTagName().equals(tag)) {
                return new Unit(this, id);
            }
            throw new IllegalArgumentException("Not a FCGO: " + id);
        }
        return null;
    }

    public Iterator<FreeColGameObject> getFreeColGameObjectIterator() {
        return new Iterator<FreeColGameObject>(){
            final Iterator<Map.Entry<String, WeakReference<FreeColGameObject>>> it;
            FreeColGameObject nextValue;
            String lastId;
            {
                this.it = Game.this.freeColGameObjects.entrySet().iterator();
                this.nextValue = null;
                this.lastId = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nextValue == null) {
                    if (!this.it.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, WeakReference<FreeColGameObject>> entry = this.it.next();
                    WeakReference<FreeColGameObject> wr = entry.getValue();
                    FreeColGameObject o = (FreeColGameObject)wr.get();
                    if (o == null) {
                        this.lastId = null;
                        Game.this.notifyRemoveFreeColGameObject(entry.getKey());
                        this.it.remove();
                        continue;
                    }
                    this.lastId = o.getId();
                    this.nextValue = o;
                }
                return true;
            }

            @Override
            public FreeColGameObject next() {
                this.hasNext();
                FreeColGameObject o = this.nextValue;
                this.nextValue = null;
                return o;
            }

            @Override
            public void remove() {
                if (this.lastId != null) {
                    Game.this.notifyRemoveFreeColGameObject(this.lastId);
                }
                this.it.remove();
            }
        };
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public List<Player> getLivePlayers(Player other) {
        ArrayList<Player> result = new ArrayList<Player>();
        for (Player player : this.players) {
            if (player.isUnknownEnemy() || player.isDead() || player == other) continue;
            result.add(player);
        }
        return result;
    }

    public List<Player> getLiveEuropeanPlayers(Player other) {
        ArrayList<Player> result = new ArrayList<Player>();
        for (Player player : this.players) {
            if (player.isUnknownEnemy() || player.isDead() || !player.isEuropean() || player == other) continue;
            result.add(player);
        }
        return result;
    }

    public List<Player> getLiveNativePlayers(Player other) {
        ArrayList<Player> result = new ArrayList<Player>();
        for (Player player : this.players) {
            if (player.isUnknownEnemy() || player.isDead() || !player.isIndian() || player == other) continue;
            result.add(player);
        }
        return result;
    }

    public Player getPlayer(String nationId) {
        for (Player player : this.players) {
            if (!player.getNationId().equals(nationId)) continue;
            return player;
        }
        return null;
    }

    public Player getNextPlayer() {
        return this.getPlayerAfter(this.currentPlayer);
    }

    public Player getPlayerAfter(Player beforePlayer) {
        int start;
        if (this.players.isEmpty()) {
            return null;
        }
        int index = start = this.players.indexOf(beforePlayer);
        do {
            Player player;
            if (++index >= this.players.size()) {
                index = 0;
            }
            if ((player = this.players.get(index)).isUnknownEnemy() || player.isDead()) continue;
            return player;
        } while (index != start);
        return null;
    }

    public Player getFirstPlayer() {
        return this.players.isEmpty() ? null : this.players.get(0);
    }

    public Player getPlayerByName(String name) {
        for (Player player : this.players) {
            if (!player.getName().equals(name)) continue;
            return player;
        }
        return null;
    }

    public boolean playerNameInUse(String name) {
        for (Player player : this.players) {
            if (!player.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean addPlayer(Player player) {
        if (player.isAI() || this.canAddNewPlayer()) {
            this.players.add(player);
            Nation nation = this.getSpecification().getNation(player.getNationId());
            this.nationOptions.getNations().put(nation, NationOptions.NationState.NOT_AVAILABLE);
            if (this.currentPlayer == null) {
                this.currentPlayer = player;
            }
            return true;
        }
        logger.warning("Game already full, but tried to add: " + player.getName());
        return false;
    }

    public boolean removePlayer(Player player) {
        Player newCurrent;
        Player player2 = newCurrent = this.currentPlayer != player ? null : this.getPlayerAfter(this.currentPlayer);
        if (!this.players.remove(player)) {
            return false;
        }
        Nation nation = this.getSpecification().getNation(player.getNationId());
        this.nationOptions.getNations().put(nation, NationOptions.NationState.AVAILABLE);
        player.dispose();
        if (newCurrent != null) {
            this.currentPlayer = newCurrent;
        }
        return true;
    }

    public Player getUnknownEnemy() {
        return this.unknownEnemy;
    }

    public void setUnknownEnemy(Player player) {
        this.unknownEnemy = player;
    }

    public Player getClientPlayer() {
        return this.clientUserName == null ? null : this.getPlayerByName(this.clientUserName);
    }

    public boolean isInClient() {
        return this.clientUserName != null;
    }

    public boolean isInServer() {
        return this.clientUserName == null;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(Player newCurrentPlayer) {
        if (newCurrentPlayer == null) {
            logger.info("Current player set to 'null'.");
        }
        this.currentPlayer = newCurrentPlayer;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map newMap) {
        if (this.map != newMap) {
            for (Player player : this.getLivePlayers(null)) {
                if (player.getHighSeas() == null) continue;
                player.getHighSeas().removeDestination(this.map);
                player.getHighSeas().addDestination(newMap);
            }
        }
        this.map = newMap;
    }

    public final NationOptions getNationOptions() {
        return this.nationOptions;
    }

    public final void setNationOptions(NationOptions newNationOptions) {
        this.nationOptions = newNationOptions;
    }

    public Nation getVacantNation() {
        for (Map.Entry<Nation, NationOptions.NationState> entry : this.nationOptions.getNations().entrySet()) {
            if (entry.getValue() != NationOptions.NationState.AVAILABLE) continue;
            return entry.getKey();
        }
        return null;
    }

    public final List<Nation> getVacantNations() {
        ArrayList<Nation> result = new ArrayList<Nation>();
        for (Map.Entry<Nation, NationOptions.NationState> entry : this.nationOptions.getNations().entrySet()) {
            if (entry.getValue() != NationOptions.NationState.AVAILABLE) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public boolean canAddNewPlayer() {
        return this.getVacantNation() != null;
    }

    public Turn getTurn() {
        return this.turn;
    }

    public void setTurn(Turn newTurn) {
        this.turn = newTurn;
    }

    public final CombatModel getCombatModel() {
        return this.combatModel;
    }

    public final void setCombatModel(CombatModel newCombatModel) {
        this.combatModel = newCombatModel;
    }

    public final boolean getSpanishSuccession() {
        return this.spanishSuccession;
    }

    public final void setSpanishSuccession(boolean spanishSuccession) {
        this.spanishSuccession = spanishSuccession;
    }

    public String nextCityOfCibola() {
        return this.citiesOfCibola.isEmpty() ? null : this.citiesOfCibola.remove(0);
    }

    public void setFreeColGameObjectListener(FreeColGameObjectListener fcgol) {
        this.freeColGameObjectListener = fcgol;
    }

    public void notifySetFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.setFreeColGameObject(id, fcgo);
        }
    }

    public void notifyRemoveFreeColGameObject(String id) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.removeFreeColGameObject(id);
        }
    }

    public void notifyOwnerChanged(FreeColGameObject source, Player oldOwner, Player newOwner) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.ownerChanged(source, oldOwner, newOwner);
        }
    }

    public void checkOwners(Ownable o, Player oldOwner) {
        Player newOwner = o.getOwner();
        if (oldOwner == newOwner) {
            return;
        }
        if (oldOwner != null && oldOwner.removeOwnable(o)) {
            oldOwner.invalidateCanSeeTiles();
        }
        if (newOwner != null && newOwner.addOwnable(o)) {
            newOwner.invalidateCanSeeTiles();
        }
    }

    public boolean allPlayersReadyToLaunch() {
        for (Player player : this.getLivePlayers(null)) {
            if (player.isReady()) continue;
            return false;
        }
        return true;
    }

    public Settlement getSettlement(String name) {
        for (Player p : this.getLivePlayers(null)) {
            for (Settlement s : p.getSettlements()) {
                if (!name.equals(s.getName())) continue;
                return s;
            }
        }
        return null;
    }

    public FreeColGameObject getMessageSource(ModelMessage message) {
        return this.getFreeColGameObject(message.getSourceId());
    }

    public FreeColObject getMessageDisplay(ModelMessage message) {
        FreeColObject o;
        String id = message.getDisplayId();
        if (id == null) {
            id = message.getSourceId();
        }
        if ((o = this.getFreeColGameObject(id)) == null) {
            try {
                o = this.getSpecification().findType(id);
            }
            catch (Exception e) {
                o = null;
            }
        }
        return o;
    }

    public java.util.Map<String, String> getStatistics() {
        HashMap<String, String> stats = new HashMap<String, String>();
        System.gc();
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        stats.put("freeMemory", Long.toString(free));
        stats.put("totalMemory", Long.toString(total));
        stats.put("maxMemory", Long.toString(max));
        HashMap<String, Long> objStats = new HashMap<String, Long>();
        long disposed = 0L;
        Iterator<FreeColGameObject> iter = this.getFreeColGameObjectIterator();
        while (iter.hasNext()) {
            Long count;
            FreeColGameObject obj = iter.next();
            String className = obj.getClass().getSimpleName();
            if (objStats.containsKey(className)) {
                Long l = count = (Long)objStats.get(className);
                Long l2 = count = Long.valueOf(count + 1L);
                objStats.put(className, count);
            } else {
                count = new Long(1L);
                objStats.put(className, count);
            }
            if (!obj.isDisposed()) continue;
            ++disposed;
        }
        stats.put("disposed", Long.toString(disposed));
        for (Map.Entry entry : objStats.entrySet()) {
            stats.put((String)entry.getKey(), Long.toString((Long)entry.getValue()));
        }
        return stats;
    }

    public <T extends FreeColObject> T newInstance(Class<T> returnClass) throws IOException {
        try {
            Constructor<T> c = returnClass.getConstructor(Game.class, String.class);
            return (T)((FreeColObject)c.newInstance(this, null));
        }
        catch (NoSuchMethodException nsme) {
            throw new IOException(nsme);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public <T extends FreeColObject> T unserialize(String xml, Class<T> returnClass) throws XMLStreamException {
        try {
            FreeColXMLReader xr = new FreeColXMLReader(new StringReader(xml));
            xr.nextTag();
            T ret = this.newInstance(returnClass);
            ((FreeColObject)ret).readFromXML(xr);
            return ret;
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        Iterator<FreeColGameObject> iterator = this.getFreeColGameObjectIterator();
        while (iterator.hasNext()) {
            FreeColGameObject fcgo = iterator.next();
            if (!fcgo.isUninitialized()) continue;
            if (fix) {
                logger.warning("Uninitialized object: " + fcgo.getId() + " (" + StringUtils.lastPart(fcgo.getClass().getName(), ".") + "), dropping.");
                iterator.remove();
                result = 0;
                continue;
            }
            logger.warning("Uninitialized object: " + fcgo.getId() + " (" + StringUtils.lastPart(fcgo.getClass().getName(), ".") + ").");
            result = -1;
        }
        Map map = this.getMap();
        if (map != null) {
            result = Math.min(result, this.getMap().checkIntegrity(fix));
        }
        for (Player player : this.getPlayers()) {
            result = Math.min(result, player.checkIntegrity(fix));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.getId());
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (xw.validForSave()) {
            xw.writeAttribute(NEXT_ID_TAG, this.nextId);
        }
        xw.writeAttribute(UUID_TAG, this.getUUID());
        xw.writeAttribute(TURN_TAG, this.getTurn().getNumber());
        xw.writeAttribute(SPANISH_SUCCESSION_TAG, this.spanishSuccession);
        if (this.currentPlayer != null) {
            xw.writeAttribute(CURRENT_PLAYER_TAG, this.currentPlayer);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.specification.toXML(xw);
        for (String cityName : this.citiesOfCibola) {
            xw.writeStartElement(CIBOLA_TAG);
            xw.writeAttribute("id", cityName);
            xw.writeEndElement();
        }
        this.nationOptions.toXML(xw);
        List<Player> players = Game.getSortedCopy(this.getPlayers());
        Player unknown = this.getUnknownEnemy();
        if (unknown != null) {
            players.add(unknown);
        }
        for (Player p : players) {
            p.toXML(xw);
        }
        if (this.map != null) {
            this.map.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        String str;
        super.readAttributes(xr);
        this.nextId = xr.getAttribute(NEXT_ID_TAG, -1);
        if (this.nextId < 0) {
            this.nextId = xr.getAttribute(OLD_NEXT_ID_TAG, 0);
        }
        if ((str = xr.getAttribute(UUID_TAG, null)) != null) {
            try {
                UUID u;
                this.uuid = u = UUID.fromString(str);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.turn = new Turn(xr.getAttribute(TURN_TAG, 1));
        this.spanishSuccession = xr.getAttribute(SPANISH_SUCCESSION_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.citiesOfCibola.clear();
        this.players.clear();
        this.unknownEnemy = null;
        String current = xr.getAttribute(CURRENT_PLAYER_TAG, null);
        super.readChildren(xr);
        for (Player player : this.getLiveEuropeanPlayers(null)) {
            for (Unit unit : player.getUnits()) {
                if (!unit.isInColony()) continue;
                unit.getWorkLocation().updateProductionType();
            }
        }
        this.currentPlayer = current == null ? null : this.getFreeColGameObject(current, Player.class);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        logger.finest("Found game tag " + tag + " id=" + xr.readId());
        if (CIBOLA_TAG.equals(tag)) {
            this.citiesOfCibola.add(xr.readId());
            xr.closeTag(CIBOLA_TAG);
        } else if (Map.getXMLElementTagName().equals(tag)) {
            this.map = xr.readFreeColGameObject(game, Map.class);
        } else if (NationOptions.getXMLElementTagName().equals(tag)) {
            this.nationOptions = new NationOptions(xr, this.specification);
        } else if (Player.getXMLElementTagName().equals(tag)) {
            Player player = xr.readFreeColGameObject(game, Player.class);
            if (player.isUnknownEnemy()) {
                this.setUnknownEnemy(player);
            } else {
                this.players.add(player);
            }
        } else if (Specification.getXMLElementTagName().equals(tag)) {
            logger.info((this.specification == null ? "Loading" : "Reloading") + " specification.");
            this.specification = new Specification(xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return Game.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "game";
    }
}

