/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Specification;

public class Event
extends FreeColGameObjectType {
    private String value;
    private int scoreValue = 0;
    private Map<String, Limit> limits = null;
    private static final String SCORE_VALUE_TAG = "scoreValue";

    public Event(String id, Specification specification) {
        super(id, specification);
    }

    public Event(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        super(specification);
        this.readFromXML(xr);
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String newValue) {
        this.value = newValue;
    }

    public final Collection<Limit> getLimits() {
        return this.limits == null ? Collections.emptyList() : this.limits.values();
    }

    public final Limit getLimit(String id) {
        return this.limits == null ? null : this.limits.get(id);
    }

    private void addLimit(Limit limit) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Limit>();
        }
        this.limits.put(limit.getId(), limit);
    }

    public final int getScoreValue() {
        return this.scoreValue;
    }

    public final void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value);
        }
        if (this.scoreValue != 0) {
            xw.writeAttribute(SCORE_VALUE_TAG, this.scoreValue);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Limit limit : this.getLimits()) {
            limit.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.value = xr.getAttribute("value", null);
        this.scoreValue = xr.getAttribute(SCORE_VALUE_TAG, 0);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.limits = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (Limit.getXMLElementTagName().equals(tag)) {
            Limit limit = new Limit(xr, spec);
            if ("model.limit.independence.colonies".equals(limit.getId())) {
                limit.setId("model.limit.independence.coastalColonies");
                limit.getLeftHandSide().setMethodName("isConnectedPort");
            }
            this.addLimit(limit);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return Event.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "event";
    }
}

