/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionCache;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;

public class Colony
extends Settlement
implements Nameable,
TradeLocation {
    private static final Logger logger = Logger.getLogger(Colony.class.getName());
    public static final String REARRANGE_WORKERS = "rearrangeWorkers";
    public static final int LIBERTY_PER_REBEL = 200;
    protected final Map<String, Building> buildingMap = new HashMap<String, Building>();
    protected final List<ColonyTile> colonyTiles = new ArrayList<ColonyTile>();
    protected final Map<String, ExportData> exportData = new HashMap<String, ExportData>();
    protected int liberty;
    protected int sonsOfLiberty;
    protected int oldSonsOfLiberty;
    protected int tories;
    protected int oldTories;
    protected int productionBonus;
    protected int immigration;
    protected Turn established = new Turn(0);
    protected BuildQueue<BuildableType> buildQueue = new BuildQueue(this, BuildQueue.CompletionAction.REMOVE_EXCEPT_LAST, 500);
    protected BuildQueue<UnitType> populationQueue = new BuildQueue(this, BuildQueue.CompletionAction.SHUFFLE, 300);
    protected int displayUnitCount = -1;
    private ProductionCache productionCache = new ProductionCache(this);
    private boolean traceOccupation = false;
    private static final String BUILD_QUEUE_TAG = "buildQueueItem";
    private static final String ESTABLISHED_TAG = "established";
    private static final String IMMIGRATION_TAG = "immigration";
    private static final String LIBERTY_TAG = "liberty";
    private static final String PRODUCTION_BONUS_TAG = "productionBonus";
    private static final String NAME_TAG = "name";
    private static final String OLD_SONS_OF_LIBERTY_TAG = "oldSonsOfLiberty";
    private static final String OLD_TORIES_TAG = "oldTories";
    private static final String POPULATION_QUEUE_TAG = "populationQueueItem";
    private static final String SONS_OF_LIBERTY_TAG = "sonsOfLiberty";
    private static final String TORIES_TAG = "tories";
    private static final String UNIT_COUNT_TAG = "unitCount";

    protected Colony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public Colony(Game game, String id) {
        super(game, id);
    }

    public List<Building> getBuildings() {
        return new ArrayList<Building>(this.buildingMap.values());
    }

    public Building getBuilding(BuildingType type) {
        return this.buildingMap.get(type.getFirstLevel().getId());
    }

    public List<ColonyTile> getColonyTiles() {
        return this.colonyTiles;
    }

    public ColonyTile getColonyTile(Tile t) {
        for (ColonyTile c : this.colonyTiles) {
            if (c.getWorkTile() != t) continue;
            return c;
        }
        return null;
    }

    public ExportData getExportData(GoodsType goodsType) {
        ExportData result = this.exportData.get(goodsType.getId());
        if (result == null) {
            result = new ExportData(goodsType);
            this.setExportData(result);
        }
        return result;
    }

    public final void setExportData(ExportData newExportData) {
        this.exportData.put(newExportData.getId(), newExportData);
    }

    public int getLiberty() {
        return this.liberty;
    }

    public int getProductionBonus() {
        return this.productionBonus;
    }

    public int getImmigration() {
        return this.immigration;
    }

    public void modifyImmigration(int amount) {
        this.immigration += amount;
    }

    public Turn getEstablished() {
        return this.established;
    }

    public void setEstablished(Turn newEstablished) {
        this.established = newEstablished;
    }

    public List<BuildableType> getBuildQueue() {
        return this.buildQueue.getValues();
    }

    public void setBuildQueue(List<BuildableType> newBuildQueue) {
        this.buildQueue.setValues(newBuildQueue);
    }

    public boolean getOccupationTrace() {
        return this.traceOccupation;
    }

    public boolean setOccupationTrace(boolean trace) {
        boolean ret = this.traceOccupation;
        this.traceOccupation = trace;
        return ret;
    }

    private int getMinimumGoodsCount(List<AbstractGoods> goodsList) {
        int result = Integer.MAX_VALUE;
        if (goodsList != null) {
            for (AbstractGoods ag : goodsList) {
                result = Math.min(result, Math.max(this.getGoodsCount(ag.getType()), this.getNetProductionOf(ag.getType())));
            }
        }
        return result;
    }

    private void logWorkTypes(Collection<GoodsType> workTypes, LogBuilder lb) {
        lb.add("[");
        for (GoodsType gt : workTypes) {
            lb.add(gt.getSuffix(), " ");
        }
        lb.shrink(" ");
        lb.add("]");
    }

    private void accumulateChoices(Collection<GoodsType> workTypes, Collection<GoodsType> tried, List<Collection<GoodsType>> result) {
        workTypes.removeAll(tried);
        if (!workTypes.isEmpty()) {
            result.add(workTypes);
            tried.addAll(workTypes);
        }
    }

    private void accumulateChoice(GoodsType workType, Collection<GoodsType> tried, List<Collection<GoodsType>> result) {
        if (workType == null) {
            return;
        }
        this.accumulateChoices(workType.getEquivalentTypes(), tried, result);
    }

    public List<Collection<GoodsType>> getWorkTypeChoices(Unit unit, boolean userMode) {
        Specification spec = this.getSpecification();
        ArrayList<Collection<GoodsType>> result = new ArrayList<Collection<GoodsType>>();
        HashSet<GoodsType> tried = new HashSet<GoodsType>();
        HashSet<GoodsType> food = new HashSet<GoodsType>();
        HashSet<GoodsType> nonFood = new HashSet<GoodsType>();
        for (AbstractGoods ag : unit.getType().getConsumedGoods()) {
            if (this.productionCache.getNetProductionOf(ag.getType()) >= ag.getAmount()) continue;
            if (ag.getType().isFoodType()) {
                food.addAll(ag.getType().getEquivalentTypes());
                continue;
            }
            nonFood.addAll(ag.getType().getEquivalentTypes());
        }
        if (userMode) {
            this.accumulateChoice(unit.getWorkType(), tried, result);
            this.accumulateChoice(unit.getType().getExpertProduction(), tried, result);
            this.accumulateChoice(unit.getExperienceType(), tried, result);
            this.accumulateChoices(food, tried, result);
            this.accumulateChoices(nonFood, tried, result);
        } else {
            this.accumulateChoices(food, tried, result);
            this.accumulateChoices(nonFood, tried, result);
            this.accumulateChoice(unit.getWorkType(), tried, result);
            this.accumulateChoice(unit.getType().getExpertProduction(), tried, result);
            this.accumulateChoice(unit.getExperienceType(), tried, result);
        }
        this.accumulateChoices(spec.getFoodGoodsTypeList(), tried, result);
        this.accumulateChoices(spec.getNewWorldLuxuryGoodsTypeList(), tried, result);
        this.accumulateChoices(spec.getGoodsTypeList(), tried, result);
        return result;
    }

    private int getOccupationAt(Unit unit, WorkLocation wl, Occupation best, int bestAmount, Collection<GoodsType> workTypes, LogBuilder lb) {
        UnitType type = unit.getType();
        boolean present = unit.getLocation() == wl;
        lb.add("\n    ", wl, !present && !wl.canAdd(unit) ? " no-add" : "");
        if (!present && !wl.canAdd(unit)) {
            return bestAmount;
        }
        boolean alone = wl.getProductionType() == null || wl.isEmpty() || present && wl.getUnitCount() == 1;
        lb.add(" alone=", alone);
        ArrayList<ProductionType> productionTypes = new ArrayList<ProductionType>();
        if (alone) {
            productionTypes.addAll(wl.getAvailableProductionTypes(false));
        } else {
            productionTypes.add(wl.getProductionType());
        }
        for (ProductionType pt : productionTypes) {
            lb.add("\n      try=", pt);
            for (GoodsType gt : workTypes) {
                if (pt.getOutput(gt) == null) continue;
                int amount = this.getMinimumGoodsCount(pt.getInputs());
                amount = Math.min(amount, wl.getPotentialProduction(gt, type));
                lb.add(" ", gt.getSuffix(), "=", amount, "/", this.getMinimumGoodsCount(pt.getInputs()), "/", wl.getPotentialProduction(gt, type), bestAmount < amount ? "!" : "");
                if (bestAmount >= amount) continue;
                bestAmount = amount;
                best.workLocation = wl;
                best.productionType = pt;
                best.workType = gt;
            }
        }
        return bestAmount;
    }

    private Occupation getOccupationFor(Unit unit, Collection<GoodsType> workTypes, LogBuilder lb) {
        if (workTypes.isEmpty()) {
            return null;
        }
        Occupation best = new Occupation(null, null, null);
        int bestAmount = 0;
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            bestAmount = this.getOccupationAt(unit, wl, best, bestAmount, workTypes, lb);
        }
        if (best.workLocation != null) {
            lb.add("\n  => ", best, " = ", bestAmount);
        }
        return best.workLocation == null ? null : best;
    }

    private Occupation getOccupationFor(Unit unit, boolean userMode, LogBuilder lb) {
        for (Collection<GoodsType> types : this.getWorkTypeChoices(unit, userMode)) {
            lb.add("\n  ");
            this.logWorkTypes(types, lb);
            Occupation occupation = this.getOccupationFor(unit, types, lb);
            if (occupation == null) continue;
            return occupation;
        }
        lb.add("\n  => FAILED");
        return null;
    }

    private Occupation getOccupationFor(Unit unit, Collection<GoodsType> workTypes) {
        LogBuilder lb = new LogBuilder(this.getOccupationTrace() ? 64 : 0);
        lb.add(this.getName(), ".getOccupationFor(", unit, ", ");
        this.logWorkTypes(workTypes, lb);
        lb.add(")");
        Occupation occupation = this.getOccupationFor(unit, workTypes, lb);
        lb.log(logger, Level.WARNING);
        return occupation;
    }

    private Occupation getOccupationFor(Unit unit, boolean userMode) {
        LogBuilder lb = new LogBuilder(this.getOccupationTrace() ? 64 : 0);
        lb.add(this.getName(), ".getOccupationFor(", unit, ")");
        Occupation occupation = this.getOccupationFor(unit, userMode, lb);
        lb.log(logger, Level.WARNING);
        return occupation;
    }

    private Occupation getOccupationAt(Unit unit, WorkLocation wl, boolean userMode) {
        LogBuilder lb = new LogBuilder(this.getOccupationTrace() ? 64 : 0);
        lb.add(this.getName(), ".getOccupationAt(", unit, ", ", wl, ")");
        Occupation best = new Occupation(null, null, null);
        int bestAmount = 0;
        for (Collection<GoodsType> types : this.getWorkTypeChoices(unit, userMode)) {
            lb.add("\n  ");
            this.logWorkTypes(types, lb);
            bestAmount = this.getOccupationAt(unit, wl, best, bestAmount, types, lb);
            if (best.workType == null) continue;
            lb.add("\n  => ", best);
            break;
        }
        if (best.workType == null) {
            lb.add("\n  FAILED");
        }
        lb.log(logger, Level.WARNING);
        return best.workType == null ? null : best;
    }

    public boolean setOccupationAt(Unit unit, WorkLocation wl, boolean userMode) {
        Occupation occupation = this.getOccupationAt(unit, wl, userMode);
        return occupation != null && occupation.install(unit);
    }

    public List<WorkLocation> getAllWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.colonyTiles);
        result.addAll(this.buildingMap.values());
        return result;
    }

    public List<WorkLocation> getAvailableWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.buildingMap.values());
        for (ColonyTile ct : this.colonyTiles) {
            Tile tile = ct.getWorkTile();
            if (tile.getOwningSettlement() != this && !this.getOwner().canClaimForSettlement(tile)) continue;
            result.add(ct);
        }
        return result;
    }

    public List<WorkLocation> getCurrentWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.buildingMap.values());
        for (ColonyTile ct : this.colonyTiles) {
            Tile tile = ct.getWorkTile();
            if (tile.getOwningSettlement() != this) continue;
            result.add(ct);
        }
        return result;
    }

    public void addBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        this.buildingMap.put(buildingType.getId(), building);
        this.addFeatures(building.getType());
        this.invalidateCache();
    }

    public boolean removeBuilding(Building building) {
        boolean result;
        BuildingType buildingType = building.getType().getFirstLevel();
        boolean bl = result = this.buildingMap.remove(buildingType.getId()) != null;
        if (result) {
            this.removeFeatures(building.getType());
            this.invalidateCache();
            this.checkBuildQueueIntegrity(true);
        }
        return result;
    }

    public WorkLocation getWorkLocationWithAbility(String ability) {
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            if (!wl.hasAbility(ability)) continue;
            return wl;
        }
        return null;
    }

    public List<WorkLocation> getWorkLocationsForConsuming(GoodsType goodsType) {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>();
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            for (AbstractGoods input : wl.getInputs()) {
                if (input.getType() != goodsType) continue;
                result.add(wl);
            }
        }
        return result;
    }

    public List<WorkLocation> getWorkLocationsForProducing(GoodsType goodsType) {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>();
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            for (AbstractGoods ag : wl.getOutputs()) {
                if (ag.getType() != goodsType) continue;
                result.add(wl);
            }
        }
        return result;
    }

    public WorkLocation getWorkLocationForProducing(GoodsType goodsType) {
        List<WorkLocation> wls = this.getWorkLocationsForProducing(goodsType);
        return wls.isEmpty() ? null : wls.get(0);
    }

    public WorkLocation getWorkLocationFor(Unit unit, GoodsType goodsType) {
        if (goodsType == null) {
            return this.getWorkLocationFor(unit);
        }
        Occupation occupation = this.getOccupationFor(unit, goodsType.getEquivalentTypes());
        return occupation == null ? null : occupation.workLocation;
    }

    public WorkLocation getWorkLocationFor(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit, false);
        return occupation == null ? null : occupation.workLocation;
    }

    public GoodsType getWorkTypeFor(Unit unit, WorkLocation wl) {
        Occupation occupation = this.getOccupationAt(unit, wl, true);
        return occupation == null ? null : occupation.workType;
    }

    public boolean isTileInUse(Tile tile) {
        ColonyTile colonyTile = this.getColonyTile(tile);
        return colonyTile != null && !colonyTile.isEmpty();
    }

    public Building getWarehouse() {
        for (Building building : this.buildingMap.values()) {
            if (!building.getType().hasModifier("model.modifier.warehouseStorage")) continue;
            return building;
        }
        return null;
    }

    public boolean hasStockade() {
        return this.getStockade() != null;
    }

    public Building getStockade() {
        for (Building building : this.buildingMap.values()) {
            if (!building.getType().hasModifier("model.modifier.defence")) continue;
            return building;
        }
        return null;
    }

    public String getStockadeKey() {
        Building stockade = this.getStockade();
        return stockade == null ? null : stockade.getType().getSuffix();
    }

    public List<RandomChoice<Disaster>> getDisasters() {
        ArrayList<RandomChoice<Disaster>> disasters = new ArrayList<RandomChoice<Disaster>>();
        for (ColonyTile tile : this.colonyTiles) {
            disasters.addAll(tile.getWorkTile().getDisasters());
        }
        return disasters;
    }

    public boolean isAutomaticBuild(BuildingType buildingType) {
        float value = this.owner.applyModifiers(100.0f, this.getGame().getTurn(), "model.modifier.buildingPriceBonus", buildingType);
        return value == 0.0f && this.canBuild(buildingType);
    }

    public List<UnitType> getBuildableUnits() {
        ArrayList<UnitType> buildableUnits = new ArrayList<UnitType>();
        List<UnitType> unitTypes = this.getSpecification().getUnitTypeList();
        for (UnitType unitType : unitTypes) {
            if (!unitType.needsGoodsToBuild() || !this.canBuild(unitType)) continue;
            buildableUnits.add(unitType);
        }
        return buildableUnits;
    }

    public int getTurnsToComplete(BuildableType buildable) {
        return this.getTurnsToComplete(buildable, null);
    }

    public int getTurnsToComplete(BuildableType buildable, AbstractGoods needed) {
        int result = 0;
        boolean goodsMissing = false;
        boolean goodsBeingProduced = false;
        boolean productionMissing = false;
        ProductionInfo info = this.productionCache.getProductionInfo(this.buildQueue);
        for (AbstractGoods ag : buildable.getRequiredGoods()) {
            AbstractGoods consumed;
            int amountNeeded = ag.getAmount();
            int amountAvailable = this.getGoodsCount(ag.getType());
            if (amountAvailable >= amountNeeded) continue;
            goodsMissing = true;
            int amountProduced = this.productionCache.getNetProductionOf(ag.getType());
            if (info != null && (consumed = AbstractGoods.findByType(ag.getType(), info.getConsumption())) != null) {
                amountProduced += consumed.getAmount();
            }
            if (amountProduced <= 0) {
                productionMissing = true;
                if (needed == null) continue;
                needed.setType(ag.getType());
                needed.setAmount(ag.getAmount());
                continue;
            }
            goodsBeingProduced = true;
            int amountRemaining = amountNeeded - amountAvailable;
            int eta = amountRemaining / amountProduced;
            if (amountRemaining % amountProduced != 0) {
                ++eta;
            }
            result = Math.max(result, eta);
        }
        return !goodsMissing ? 0 : (!goodsBeingProduced ? Integer.MIN_VALUE : (productionMissing ? -result : result));
    }

    public boolean canBreed(GoodsType goodsType) {
        int breedingNumber = goodsType.getBreedingNumber();
        return breedingNumber < Integer.MAX_VALUE && breedingNumber <= this.getGoodsCount(goodsType);
    }

    public BuildableType getCurrentlyBuilding() {
        return this.buildQueue.getCurrentlyBuilding();
    }

    public void setCurrentlyBuilding(BuildableType buildable) {
        this.buildQueue.setCurrentlyBuilding(buildable);
    }

    public boolean canBuild() {
        return this.canBuild(this.getCurrentlyBuilding());
    }

    public boolean canBuild(BuildableType buildableType) {
        return this.getNoBuildReason(buildableType, null) == NoBuildReason.NONE;
    }

    public NoBuildReason getNoBuildReason(BuildableType buildableType, List<BuildableType> assumeBuilt) {
        if (buildableType == null) {
            return NoBuildReason.NOT_BUILDING;
        }
        if (!buildableType.needsGoodsToBuild()) {
            return NoBuildReason.NOT_BUILDABLE;
        }
        if (buildableType.getRequiredPopulation() > this.getUnitCount()) {
            return NoBuildReason.POPULATION_TOO_SMALL;
        }
        if (buildableType.hasAbility("model.ability.coastalOnly") && !this.getTile().isCoastland()) {
            return NoBuildReason.COASTAL;
        }
        for (Map.Entry<String, Boolean> entry : buildableType.getRequiredAbilities().entrySet()) {
            if (this.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return NoBuildReason.MISSING_ABILITY;
        }
        if (buildableType.getLimits() != null) {
            for (Limit limit : buildableType.getLimits()) {
                if (limit.evaluate(this)) continue;
                return NoBuildReason.LIMIT_EXCEEDED;
            }
        }
        if (assumeBuilt == null) {
            assumeBuilt = Collections.emptyList();
        }
        if (buildableType instanceof BuildingType) {
            BuildingType from;
            BuildingType newBuildingType = (BuildingType)buildableType;
            Building colonyBuilding = this.getBuilding(newBuildingType);
            if (colonyBuilding == null ? (from = newBuildingType.getUpgradesFrom()) != null && !assumeBuilt.contains(from) : (from = colonyBuilding.getType().getUpgradesTo()) != newBuildingType && !assumeBuilt.contains(from)) {
                return NoBuildReason.WRONG_UPGRADE;
            }
        } else if (buildableType instanceof UnitType && !buildableType.hasAbility("model.ability.person") && !this.hasAbility("model.ability.build", buildableType)) {
            return NoBuildReason.MISSING_BUILD_ABILITY;
        }
        return NoBuildReason.NONE;
    }

    public int getPriceForBuilding() {
        return this.getPriceForBuilding(this.getCurrentlyBuilding());
    }

    public int getPriceForBuilding(BuildableType type) {
        return this.priceGoodsForBuilding(this.getRequiredGoods(type));
    }

    public int priceGoodsForBuilding(List<AbstractGoods> required) {
        int price = 0;
        Market market = this.getOwner().getMarket();
        for (AbstractGoods ag : required) {
            GoodsType goodsType = ag.getType();
            int amount = ag.getAmount();
            if (goodsType.isStorable()) {
                price += market.getBidPrice(goodsType, amount) * 110 / 100;
                continue;
            }
            price += goodsType.getPrice() * amount;
        }
        return price;
    }

    public List<AbstractGoods> getRequiredGoods(BuildableType type) {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        for (AbstractGoods goods : type.getRequiredGoods()) {
            GoodsType goodsType = goods.getType();
            int remaining = goods.getAmount() - this.getGoodsCount(goodsType);
            if (remaining <= 0) continue;
            result.add(new AbstractGoods(goodsType, remaining));
        }
        return result;
    }

    public List<AbstractGoods> getFullRequiredGoods(BuildableType buildable) {
        ArrayList<AbstractGoods> required = new ArrayList<AbstractGoods>();
        if (buildable == null) {
            return required;
        }
        for (AbstractGoods ag : buildable.getRequiredGoods()) {
            int amount = ag.getAmount();
            for (GoodsType type = ag.getType(); type != null && amount > this.getGoodsCount(type); type = type.getInputType()) {
                required.add(0, new AbstractGoods(type, amount - this.getGoodsCount(type)));
            }
        }
        return required;
    }

    public boolean canPayToFinishBuilding() {
        return this.canPayToFinishBuilding(this.getCurrentlyBuilding());
    }

    public boolean canPayToFinishBuilding(BuildableType buildableType) {
        return buildableType != null && this.getOwner().checkGold(this.getPriceForBuilding(buildableType));
    }

    public void addLiberty(int amount) {
        List<GoodsType> libertyTypeList = this.getSpecification().getLibertyGoodsTypeList();
        int uc = this.getUnitCount();
        if (Colony.calculateRebels(uc, this.sonsOfLiberty) <= uc + 1 && amount > 0 && !libertyTypeList.isEmpty()) {
            this.addGoods(libertyTypeList.get(0), amount);
        }
        this.updateSoL();
        this.updateProductionBonus();
    }

    public void modifyLiberty(int amount) {
        this.getOwner().modifyLiberty(amount);
        this.liberty += amount;
        this.liberty = Math.max(0, this.liberty);
        this.updateSoL();
        this.updateProductionBonus();
        boolean capped = this.getSpecification().getBoolean("model.option.bellAccumulationCapped");
        if (capped && this.sonsOfLiberty >= 100) {
            this.liberty = 200 * this.getUnitCount();
        }
    }

    public void updateSoL() {
        int uc = this.getUnitCount();
        this.oldSonsOfLiberty = this.sonsOfLiberty;
        this.oldTories = this.tories;
        this.sonsOfLiberty = this.calculateSoLPercentage(uc, this.getLiberty());
        this.tories = uc - Colony.calculateRebels(uc, this.sonsOfLiberty);
    }

    private int calculateSoLPercentage(int uc, int liberty) {
        if (uc <= 0) {
            return -1;
        }
        float membership = (float)liberty * 100.0f / (float)(200 * uc);
        if ((membership = Colony.applyModifiers(membership, this.getGame().getTurn(), this.getOwner().getModifiers("model.modifier.SoL"))) < 0.0f) {
            membership = 0.0f;
        } else if (membership > 100.0f) {
            membership = 100.0f;
        }
        return (int)membership;
    }

    public int getSoLPercentage() {
        return this.calculateSoLPercentage(this.getUnitCount(), this.getLiberty());
    }

    public static int calculateRebels(int uc, int solPercent) {
        return (int)Math.floor(0.01 * (double)solPercent * (double)uc);
    }

    public int getTory() {
        return 100 - this.getSoL();
    }

    protected boolean updateProductionBonus() {
        int newBonus;
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int n = this.sonsOfLiberty >= veryGoodGovernment ? 2 : (this.sonsOfLiberty >= goodGovernment ? 1 : (this.tories > veryBadGovernment ? -2 : (newBonus = this.tories > badGovernment ? -1 : 0)));
        if (this.productionBonus != newBonus) {
            this.invalidateCache();
            this.productionBonus = newBonus;
            return true;
        }
        return false;
    }

    public int getPreferredSizeChange() {
        int i;
        int pop = this.getUnitCount();
        if (this.productionBonus < 0) {
            int i2;
            int limit = pop;
            for (i2 = 1; i2 < limit && this.governmentChange(pop - i2) != 1; ++i2) {
            }
            return -i2;
        }
        Specification spec = this.getSpecification();
        int limit = spec.getInteger("model.option.badGovernmentLimit");
        for (i = 1; i < limit && this.governmentChange(pop + i) != -1; ++i) {
        }
        return i - 1;
    }

    public boolean joinColony(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit, false);
        if (occupation == null) {
            if (!this.traceOccupation) {
                LogBuilder lb = new LogBuilder(64);
                this.getOccupationFor(unit, false, lb);
                lb.log(logger, Level.WARNING);
            }
            return false;
        }
        return occupation.install(unit);
    }

    public boolean canReducePopulation() {
        return (float)this.getUnitCount() > this.applyModifiers(0.0f, this.getGame().getTurn(), "model.modifier.minimumColonySize");
    }

    public StringTemplate getReducePopulationMessage() {
        if (this.canReducePopulation()) {
            return null;
        }
        Set<Modifier> modifierSet = this.getModifiers("model.modifier.minimumColonySize");
        Iterator<Modifier> i$ = modifierSet.iterator();
        if (i$.hasNext()) {
            Modifier modifier = i$.next();
            FreeColObject source = modifier.getSource();
            if (source instanceof BuildingType) {
                source = this.getBuilding((BuildingType)source).getType();
            }
            return StringTemplate.template("colonyPanel.minimumColonySize").addName("%object%", source);
        }
        return null;
    }

    public int governmentChange(int unitCount) {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int rebelPercent = this.calculateSoLPercentage(unitCount, this.getLiberty());
        int rebelCount = Colony.calculateRebels(unitCount, rebelPercent);
        int loyalistCount = unitCount - rebelCount;
        int result = 0;
        if (rebelPercent >= veryGoodGovernment) {
            if (this.sonsOfLiberty < veryGoodGovernment) {
                result = 1;
            }
        } else if (rebelPercent >= goodGovernment) {
            if (this.sonsOfLiberty >= veryGoodGovernment) {
                result = -1;
            } else if (this.sonsOfLiberty < goodGovernment) {
                result = 1;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            result = -1;
        } else if (loyalistCount > veryBadGovernment) {
            if (this.tories <= veryBadGovernment) {
                result = -1;
            }
        } else if (loyalistCount > badGovernment) {
            if (this.tories <= badGovernment) {
                result = -1;
            } else if (this.tories > veryBadGovernment) {
                result = 1;
            }
        } else if (this.tories > badGovernment) {
            result = 1;
        }
        return result;
    }

    public ModelMessage checkForGovMgtChangeMessage() {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        String msgId = null;
        int number = 0;
        ModelMessage.MessageType msgType = ModelMessage.MessageType.GOVERNMENT_EFFICIENCY;
        if (this.sonsOfLiberty >= veryGoodGovernment) {
            if (this.oldSonsOfLiberty < veryGoodGovernment) {
                msgId = "model.colony.veryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            if (this.oldSonsOfLiberty == veryGoodGovernment) {
                msgId = "model.colony.lostVeryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            } else if (this.oldSonsOfLiberty < goodGovernment) {
                msgId = "model.colony.goodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
        } else {
            if (this.oldSonsOfLiberty >= goodGovernment) {
                msgId = "model.colony.lostGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
            if (this.tories > veryBadGovernment) {
                if (this.oldTories <= veryBadGovernment) {
                    msgId = "model.colony.veryBadGovernment";
                }
            } else if (this.tories > badGovernment) {
                if (this.oldTories <= badGovernment) {
                    msgId = "model.colony.badGovernment";
                } else if (this.oldTories > veryBadGovernment) {
                    msgId = "model.colony.governmentImproved1";
                }
            } else if (this.oldTories > badGovernment) {
                msgId = "model.colony.governmentImproved2";
            }
        }
        GoodsType bells = this.getSpecification().getGoodsType("model.goods.bells");
        return msgId == null ? null : new ModelMessage(msgType, msgId, this, bells).addName("%colony%", this.getName()).addAmount("%number%", number);
    }

    public void updatePopulation() {
        this.updateSoL();
        this.updateProductionBonus();
        if (this.getOwner().isAI()) {
            this.firePropertyChange(REARRANGE_WORKERS, true, false);
        }
    }

    public void updateEducation(Unit unit, boolean enable) {
        WorkLocation wl = unit.getWorkLocation();
        if (wl == null) {
            throw new RuntimeException("updateEducation(" + unit + ") unit not at work location.");
        }
        if (wl.getColony() != this) {
            throw new RuntimeException("updateEducation(" + unit + ") unit not at work location in this colony.");
        }
        if (enable) {
            if (wl.canTeach()) {
                Unit student = unit.getStudent();
                if (student == null && (student = this.findStudent(unit)) != null) {
                    unit.setStudent(student);
                    student.setTeacher(unit);
                    unit.setTurnsOfTraining(0);
                    unit.changeWorkType(null);
                }
            } else {
                Unit teacher = unit.getTeacher();
                if (teacher == null && (teacher = this.findTeacher(unit)) != null) {
                    unit.setTeacher(teacher);
                    teacher.setStudent(unit);
                }
            }
        } else if (wl.canTeach()) {
            Unit student = unit.getStudent();
            if (student != null) {
                student.setTeacher(null);
                unit.setStudent(null);
                unit.setTurnsOfTraining(0);
            }
        } else {
            Unit teacher = unit.getTeacher();
            if (teacher != null) {
                teacher.setStudent(null);
                unit.setTeacher(null);
            }
        }
    }

    public boolean isUndead() {
        Unit u = this.getFirstUnit();
        return u != null && u.isUndead();
    }

    public int getDisplayUnitCount() {
        return this.displayUnitCount > 0 ? this.displayUnitCount : this.getUnitCount();
    }

    public void setDisplayUnitCount(int count) {
        this.displayUnitCount = count;
    }

    public UnitType getBestDefenderType() {
        UnitType bestDefender = null;
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!(unitType.getDefence() > 0.0f) || bestDefender != null && !(bestDefender.getDefence() < unitType.getDefence()) || unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(this.getOwner())) continue;
            bestDefender = unitType;
        }
        return bestDefender;
    }

    public float getTotalDefencePower() {
        CombatModel cm = this.getGame().getCombatModel();
        float defence = 0.0f;
        for (Unit unit : this.getTile().getUnitList()) {
            if (!unit.isDefensiveUnit()) continue;
            defence += cm.getDefencePower(null, unit);
        }
        return defence;
    }

    public boolean canBePillaged(Unit attacker) {
        return !this.hasStockade() && attacker.hasAbility("model.ability.pillageUnprotectedColony") && (!this.getBurnableBuildings().isEmpty() || !this.getTile().getNavalUnits().isEmpty() || !this.getLootableGoodsList().isEmpty() && attacker.getType().canCarryGoods() && attacker.hasSpaceLeft() || this.canBePlundered());
    }

    public boolean canBePlundered() {
        return this.owner.checkGold(1);
    }

    public List<Building> getBurnableBuildings() {
        ArrayList<Building> buildingList = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (!building.canBeDamaged()) continue;
            buildingList.add(building);
        }
        return buildingList;
    }

    public List<Goods> getLootableGoodsList() {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (Goods goods : this.getGoodsContainer().getGoods()) {
            if (!goods.getType().isStorable()) continue;
            goodsList.add(goods);
        }
        return goodsList;
    }

    public boolean isUnderSiege() {
        int friendlyUnits = 0;
        int enemyUnits = 0;
        for (ColonyTile colonyTile : this.colonyTiles) {
            for (Unit unit : colonyTile.getWorkTile().getUnitList()) {
                if (unit.getOwner() == this.getOwner()) {
                    if (!unit.isDefensiveUnit()) continue;
                    ++friendlyUnits;
                    continue;
                }
                if (!this.getOwner().atWarWith(unit.getOwner()) || !unit.isOffensiveUnit()) continue;
                ++enemyUnits;
            }
        }
        return enemyUnits > friendlyUnits;
    }

    public boolean canTrain(Unit unit) {
        return this.canTrain(unit.getType());
    }

    public boolean canTrain(UnitType unitType) {
        if (!this.hasAbility("model.ability.teach")) {
            return false;
        }
        for (Building building : this.buildingMap.values()) {
            if (!building.canTeach() || !building.canAddType(unitType)) continue;
            return true;
        }
        return false;
    }

    public List<Unit> getTeachers() {
        ArrayList<Unit> teachers = new ArrayList<Unit>();
        for (Building building : this.buildingMap.values()) {
            if (!building.canTeach()) continue;
            teachers.addAll(building.getUnitList());
        }
        return teachers;
    }

    public Unit findTeacher(Unit student) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        for (Building building : this.getBuildings()) {
            if (!building.canTeach()) continue;
            for (Unit unit : building.getUnitList()) {
                if (unit.getStudent() != null || !student.canBeStudent(unit)) continue;
                return unit;
            }
        }
        return null;
    }

    public Unit findStudent(Unit teacher) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        Unit student = null;
        GoodsType expertProduction = teacher.getType().getExpertProduction();
        int skillLevel = Integer.MAX_VALUE;
        for (Unit potentialStudent : this.getUnitList()) {
            if (potentialStudent.getTeacher() != null || !potentialStudent.canBeStudent(teacher) || student != null && potentialStudent.getSkillLevel() >= skillLevel && (potentialStudent.getSkillLevel() != skillLevel || potentialStudent.getWorkType() != expertProduction)) continue;
            student = potentialStudent;
            skillLevel = student.getSkillLevel();
        }
        return student;
    }

    public List<Consumer> getConsumers() {
        ArrayList<Consumer> result = new ArrayList<Consumer>();
        result.addAll(this.getUnitList());
        result.addAll(this.buildingMap.values());
        result.add(this.buildQueue);
        result.add(this.populationQueue);
        Collections.sort(result, Consumer.COMPARATOR);
        return result;
    }

    @Override
    public int getConsumptionOf(GoodsType goodsType) {
        Specification spec = this.getSpecification();
        int result = super.getConsumptionOf(goodsType);
        if (spec.getGoodsType("model.goods.bells").equals(goodsType)) {
            result -= spec.getInteger("model.option.unitsThatUseNoBells");
        }
        return Math.max(0, result);
    }

    public int getFoodProduction() {
        int result = 0;
        for (GoodsType foodType : this.getSpecification().getFoodGoodsTypeList()) {
            result += this.getTotalProductionOf(foodType);
        }
        return result;
    }

    public List<Modifier> getProductionModifiers(GoodsType goodsType) {
        if (this.productionBonus == 0) {
            return Collections.emptyList();
        }
        Modifier mod = new Modifier(goodsType.getId(), this.productionBonus, Modifier.ModifierType.ADDITIVE, Specification.SOL_MODIFIER_SOURCE);
        mod.setModifierIndex(20);
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.add(mod);
        return result;
    }

    public int getNetProductionOf(GoodsType goodsType) {
        return this.productionCache.getNetProductionOf(goodsType);
    }

    public boolean isProductive(WorkLocation workLocation) {
        ProductionInfo info = this.productionCache.getProductionInfo(workLocation);
        return info != null && info.getProduction() != null && !info.getProduction().isEmpty() && info.getProduction().get(0).getAmount() > 0;
    }

    public int getAdjustedNetProductionOf(GoodsType goodsType) {
        int result = this.productionCache.getNetProductionOf(goodsType);
        for (BuildQueue queue : new BuildQueue[]{this.buildQueue, this.populationQueue}) {
            AbstractGoods goods;
            ProductionInfo info = this.productionCache.getProductionInfo(queue);
            if (info == null || (goods = AbstractGoods.findByType(goodsType, info.getConsumption())) == null) continue;
            result += goods.getAmount();
        }
        return result;
    }

    protected TypeCountMap<GoodsType> getProductionMap() {
        return this.productionCache.getProductionMap();
    }

    public ProductionInfo getProductionInfo(Object object) {
        return this.productionCache.getProductionInfo(object);
    }

    public void invalidateCache() {
        this.productionCache.invalidate();
    }

    public boolean canProduce(GoodsType goodsType) {
        if (this.getNetProductionOf(goodsType) > 0) {
            return true;
        }
        if (goodsType.isBreedable()) {
            return this.getGoodsCount(goodsType) >= goodsType.getBreedingNumber();
        }
        block0: for (WorkLocation wl : this.getWorkLocationsForProducing(goodsType)) {
            for (AbstractGoods ag : wl.getInputs()) {
                if (this.canProduce(ag.getType())) continue;
                continue block0;
            }
            if (wl.getGenericPotential(goodsType) <= 0) continue;
            return true;
        }
        return false;
    }

    public void getColonyTileTodo(List<Tile> exploreTiles, List<Tile> clearTiles, List<Tile> plowTiles, List<Tile> roadTiles) {
        Specification spec = this.getSpecification();
        TileImprovementType clearImprovement = spec.getTileImprovementType("model.improvement.clearForest");
        TileImprovementType plowImprovement = spec.getTileImprovementType("model.improvement.plow");
        TileImprovementType roadImprovement = spec.getTileImprovementType("model.improvement.road");
        for (Tile t : this.getTile().getSurroundingTiles(1)) {
            if (!t.hasLostCityRumour()) continue;
            exploreTiles.add(t);
        }
        block1: for (ColonyTile ct : this.getColonyTiles()) {
            TileType newType;
            Tile t = ct.getWorkTile();
            if (t == null) continue;
            if ((t.getTileItemContainer() == null || t.getTileItemContainer().getImprovement(plowImprovement) == null) && plowImprovement.isTileTypeAllowed(t.getType())) {
                if (ct.isColonyCenterTile()) {
                    plowTiles.add(t);
                } else {
                    for (Unit u : ct.getUnitList()) {
                        if (u == null || u.getWorkType() == null || plowImprovement.getBonus(u.getWorkType()) <= 0) continue;
                        plowTiles.add(t);
                        break;
                    }
                }
            }
            if (ct.isColonyCenterTile() || ct.isEmpty()) continue;
            TileType oldType = t.getType();
            if ((t.getTileItemContainer() == null || t.getTileItemContainer().getImprovement(clearImprovement) == null) && clearImprovement.isTileTypeAllowed(t.getType()) && (newType = clearImprovement.getChange(oldType)) != null) {
                for (Unit u : ct.getUnitList()) {
                    if (newType.getPotentialProduction(u.getWorkType(), u.getType()) <= oldType.getPotentialProduction(u.getWorkType(), u.getType())) continue;
                    clearTiles.add(t);
                    break;
                }
            }
            if (t.getRoad() != null || !roadImprovement.isTileTypeAllowed(t.getType())) continue;
            for (Unit u : ct.getUnitList()) {
                if (roadImprovement.getBonus(u.getWorkType()) <= 0) continue;
                roadTiles.add(t);
                continue block1;
            }
        }
    }

    public Unit getBetterExpert(Unit expert) {
        GoodsType production = expert.getWorkType();
        UnitType expertType = expert.getType();
        GoodsType expertise = expertType.getExpertProduction();
        Unit bestExpert = null;
        int bestImprovement = 0;
        if (production == null || expertise == null || production == expertise) {
            return null;
        }
        for (Unit nonExpert : this.getUnitList()) {
            int improvement;
            ColonyTile nwl;
            if (nonExpert.getWorkType() != expertise || nonExpert.getType() == expertType) continue;
            int expertProductionNow = 0;
            int nonExpertProductionNow = 0;
            int expertProductionPotential = 0;
            int nonExpertProductionPotential = 0;
            WorkLocation ewl = expert.getWorkLocation();
            if (ewl != null) {
                expertProductionNow = ewl.getPotentialProduction(expertise, expert.getType());
                nonExpertProductionPotential = ewl.getPotentialProduction(expertise, nonExpert.getType());
            }
            if ((nwl = nonExpert.getWorkTile()) != null) {
                nonExpertProductionNow = nwl.getPotentialProduction(expertise, nonExpert.getType());
                expertProductionPotential = nwl.getPotentialProduction(expertise, expertType);
            }
            if ((improvement = expertProductionPotential + nonExpertProductionPotential - expertProductionNow - nonExpertProductionNow) <= bestImprovement) continue;
            bestImprovement = improvement;
            bestExpert = nonExpert;
        }
        return bestExpert;
    }

    public Collection<StringTemplate> getWarnings(GoodsType goodsType, int amount, int production) {
        BuildableType currentlyBuilding;
        LinkedList<StringTemplate> result = new LinkedList<StringTemplate>();
        if (goodsType.isFoodType() && goodsType.isStorable()) {
            if (amount + production < 0) {
                result.add(StringTemplate.template("model.colony.famineFeared").addName("%colony%", this.getName()).addAmount("%number%", 0));
            }
        } else {
            int waste = amount + production - this.getWarehouseCapacity();
            if (waste > 0 && !this.getExportData(goodsType).getExported() && !goodsType.limitIgnored()) {
                result.add(StringTemplate.template("model.building.warehouseSoonFull").add("%goods%", goodsType.getNameKey()).addName("%colony%", this.getName()).addAmount("%amount%", waste));
            }
        }
        if ((currentlyBuilding = this.getCurrentlyBuilding()) != null) {
            for (AbstractGoods goods : currentlyBuilding.getRequiredGoods()) {
                if (!goods.getType().equals(goodsType) || amount >= goods.getAmount()) continue;
                result.add(StringTemplate.template("model.colony.buildableNeedsGoods").addName("%colony%", this.getName()).add("%buildable%", currentlyBuilding.getNameKey()).addAmount("%amount%", goods.getAmount() - amount).add("%goodsType%", goodsType.getNameKey()));
            }
        }
        for (WorkLocation wl : this.getWorkLocationsForProducing(goodsType)) {
            this.addInsufficientProductionMessage(result, this.productionCache.getProductionInfo(wl));
        }
        for (WorkLocation wl : this.getWorkLocationsForConsuming(goodsType)) {
            for (AbstractGoods ag : wl.getOutputs()) {
                if (ag.getType().isStorable()) continue;
                this.addInsufficientProductionMessage(result, this.productionCache.getProductionInfo(wl));
            }
        }
        return result;
    }

    private void addInsufficientProductionMessage(List<StringTemplate> warnings, ProductionInfo info) {
        if (info == null || info.getMaximumProduction().isEmpty()) {
            return;
        }
        GoodsType outputType = info.getProduction().get(0).getType();
        int missingOutput = info.getMaximumProduction().get(0).getAmount() - info.getProduction().get(0).getAmount();
        if (missingOutput <= 0) {
            return;
        }
        GoodsType inputType = info.getConsumption().isEmpty() ? null : info.getConsumption().get(0).getType();
        int missingInput = info.getMaximumConsumption().get(0).getAmount() - info.getConsumption().get(0).getAmount();
        if (inputType == null) {
            return;
        }
        warnings.add(StringTemplate.template("model.colony.insufficientProduction").addAmount("%outputAmount%", missingOutput).add("%outputType%", outputType.getNameKey()).addName("%colony%", this.getName()).addAmount("%inputAmount%", missingInput).add("%inputType%", inputType.getNameKey()));
    }

    public Colony copyColony() {
        Game game = this.getGame();
        Tile tile = this.getTile();
        Tile tileCopy = (Tile)tile.copy(game, tile.getClass());
        Colony colony = tileCopy.getColony();
        for (ColonyTile ct : colony.getColonyTiles()) {
            Tile wt;
            if (ct.isColonyCenterTile()) {
                wt = tileCopy;
            } else {
                wt = ct.getWorkTile();
                if ((wt = (Tile)wt.copy(game, wt.getClass())).getOwningSettlement() == this) {
                    wt.setOwningSettlement(colony);
                }
            }
            ct.setWorkTile(wt);
        }
        return colony;
    }

    public <T extends FreeColObject> T getCorresponding(T fco) {
        block6: {
            String id;
            block7: {
                block5: {
                    id = fco.getId();
                    if (!(fco instanceof WorkLocation)) break block5;
                    for (WorkLocation t : this.getAllWorkLocations()) {
                        if (!t.getId().equals(id)) continue;
                        return (T)t;
                    }
                    break block6;
                }
                if (!(fco instanceof Tile)) break block7;
                if (this.getTile().getId().equals(id)) {
                    return (T)this.getTile();
                }
                for (ColonyTile ct : this.getColonyTiles()) {
                    if (!ct.getWorkTile().getId().equals(id)) continue;
                    return (T)ct.getWorkTile();
                }
                break block6;
            }
            if (!(fco instanceof Unit)) break block6;
            for (Unit t : this.getUnitList()) {
                if (!t.getId().equals(id)) continue;
                return (T)t;
            }
            for (Unit t : this.getTile().getUnitList()) {
                if (!t.getId().equals(id)) continue;
                return (T)t;
            }
        }
        return null;
    }

    @Override
    public Set<Ability> getAbilities(String id, FreeColGameObjectType type, Turn turn) {
        if (turn == null) {
            turn = this.getGame().getTurn();
        }
        Set<Ability> result = super.getAbilities(id, type, turn);
        if (this.owner != null) {
            result.addAll(this.owner.getAbilities(id, type, turn));
        }
        return result;
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        for (WorkLocation workLocation : this.getAllWorkLocations()) {
            objects.addAll(workLocation.disposeList());
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return StringTemplate.name(this.getName());
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.joinColony((Unit)locatable);
        }
        return super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            WorkLocation wl;
            Location loc = ((Unit)locatable).getLocation();
            if (loc instanceof WorkLocation && (wl = (WorkLocation)loc).getColony() == this) {
                return wl.remove(locatable);
            }
            return false;
        }
        return super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            for (WorkLocation wl : this.getAvailableWorkLocations()) {
                if (!wl.contains(locatable)) continue;
                return true;
            }
            return false;
        }
        return super.contains(locatable);
    }

    @Override
    public int getUnitCount() {
        int n = 0;
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            n += wl.getUnitCount();
        }
        return n;
    }

    @Override
    public List<Unit> getUnitList() {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            units.addAll(wl.getUnitList());
        }
        return units;
    }

    @Override
    public String toShortString() {
        return this.getName();
    }

    @Override
    public int getGoodsCapacity() {
        return (int)this.applyModifiers(0.0f, this.getGame().getTurn(), "model.modifier.warehouseStorage");
    }

    @Override
    public boolean addGoods(GoodsType type, int amount) {
        super.addGoods(type, amount);
        this.productionCache.invalidate(type);
        this.modifySpecialGoods(type, amount);
        return true;
    }

    @Override
    public Goods removeGoods(GoodsType type, int amount) {
        Goods removed = super.removeGoods(type, amount);
        this.productionCache.invalidate(type);
        if (removed != null) {
            this.modifySpecialGoods(type, -removed.getAmount());
        }
        return removed;
    }

    private void modifySpecialGoods(GoodsType goodsType, int amount) {
        Turn turn = this.getGame().getTurn();
        Set<Modifier> mods = goodsType.getModifiers("model.modifier.liberty");
        if (!mods.isEmpty()) {
            int liberty = (int)Colony.applyModifiers(amount, turn, mods);
            this.modifyLiberty(liberty);
        }
        if (!(mods = goodsType.getModifiers("model.modifier.immigration")).isEmpty()) {
            int migration = (int)Colony.applyModifiers(amount, turn, mods);
            this.modifyImmigration(migration);
            this.getOwner().modifyImmigration(migration);
        }
    }

    @Override
    public String getImageKey() {
        if (this.isUndead()) {
            return "undead";
        }
        int count = this.getDisplayUnitCount();
        String key = count <= 3 ? "small" : (count <= 7 ? "medium" : "large");
        String stockade = this.getStockadeKey();
        if (stockade != null) {
            key = key + "." + stockade;
        }
        return "model.settlement." + key + ".image";
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        if (this.displayUnitCount > 0) {
            return null;
        }
        List<Unit> unitList = this.getUnitList();
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : unitList) {
            float unitPower;
            if (!Unit.betterDefender(defender, defencePower, nextUnit, unitPower = this.getGame().getCombatModel().getDefencePower(attacker, nextUnit))) continue;
            defender = nextUnit;
            defencePower = unitPower;
        }
        if (defender == null) {
            throw new IllegalStateException("Colony " + this.getName() + " contains no units!");
        }
        return defender;
    }

    @Override
    public float getDefenceRatio() {
        return this.getTotalDefencePower() / (float)(1 + this.getUnitCount());
    }

    @Override
    public boolean isBadlyDefended() {
        return this.getTotalDefencePower() < 0.95f * (float)this.getUnitCount() - 2.5f;
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        int upper;
        if (this.canBePlundered() && (upper = this.owner.getGold() * (this.getUnitCount() + 1) / (this.owner.getColoniesPopulation() + 1)) > 0) {
            return new RandomRange(100, 1, upper + 1, 1);
        }
        return null;
    }

    @Override
    public int getSoL() {
        return this.sonsOfLiberty;
    }

    @Override
    public int getUpkeep() {
        int upkeep = 0;
        for (Building building : this.buildingMap.values()) {
            upkeep += building.getType().getUpkeep();
        }
        return upkeep;
    }

    @Override
    public int getTotalProductionOf(GoodsType goodsType) {
        int amount = 0;
        for (WorkLocation workLocation : this.getCurrentWorkLocations()) {
            amount += workLocation.getTotalProductionOf(goodsType);
        }
        return amount;
    }

    @Override
    public boolean canProvideGoods(List<AbstractGoods> requiredGoods) {
        BuildableType buildable = this.getCurrentlyBuilding();
        for (AbstractGoods goods : requiredGoods) {
            int available = this.getGoodsCount(goods.getType());
            int breedingNumber = goods.getType().getBreedingNumber();
            if (breedingNumber != Integer.MAX_VALUE) {
                available -= breedingNumber;
            }
            if (buildable != null) {
                available -= AbstractGoods.getCount(goods.getType(), buildable.getRequiredGoods());
            }
            if (available >= goods.getAmount()) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringTemplate getAlarmLevelMessage(Player player) {
        Player.Stance stance = this.getOwner().getStance(player);
        return StringTemplate.template("colony.tension." + stance.getKey()).addStringTemplate("%nation%", this.getOwner().getNationName());
    }

    @Override
    public int getExportAmount(GoodsType goodsType, int turns) {
        ExportData ed = this.getExportData(goodsType);
        int present = Math.max(0, this.getGoodsCount(goodsType) + turns * this.getNetProductionOf(goodsType));
        int wanted = ed.getExportLevel();
        return Math.max(0, present - wanted);
    }

    @Override
    public int getImportAmount(GoodsType goodsType, int turns) {
        if (goodsType.limitIgnored()) {
            return 10000;
        }
        int present = Math.max(0, this.getGoodsCount(goodsType) - turns * this.getNetProductionOf(goodsType));
        int capacity = this.getWarehouseCapacity();
        return Math.max(0, capacity - present);
    }

    private int checkBuildQueueIntegrity(boolean fix) {
        int result = 1;
        List<BuildableType> buildables = this.buildQueue.getValues();
        ArrayList<BuildableType> assumeBuilt = new ArrayList<BuildableType>();
        for (int i = 0; i < buildables.size(); ++i) {
            BuildableType bt = buildables.get(i);
            NoBuildReason reason = this.getNoBuildReason(bt, assumeBuilt);
            if (reason == NoBuildReason.NONE) {
                assumeBuilt.add(bt);
                continue;
            }
            if (fix) {
                this.buildQueue.remove(i);
                result = Math.min(result, 0);
                continue;
            }
            result = -1;
        }
        List<UnitType> unitTypes = this.populationQueue.getValues();
        assumeBuilt.clear();
        for (int i = 0; i < unitTypes.size(); ++i) {
            UnitType ut = unitTypes.get(i);
            NoBuildReason reason = this.getNoBuildReason(ut, assumeBuilt);
            if (reason == NoBuildReason.NONE) {
                assumeBuilt.add(ut);
                continue;
            }
            if (fix) {
                this.populationQueue.remove(i);
                result = Math.min(result, 0);
                continue;
            }
            result = -1;
        }
        return result;
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (!this.isLandLocked() && !this.hasAbility("model.ability.hasPort")) {
            if (fix) {
                this.addAbility(new Ability("model.ability.hasPort"));
                result = Math.min(result, 0);
            } else {
                result = -1;
            }
        }
        return Math.min(result, this.checkBuildQueueIntegrity(fix));
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NAME_TAG, this.getName());
        xw.writeAttribute(ESTABLISHED_TAG, this.established.getNumber());
        xw.writeAttribute(SONS_OF_LIBERTY_TAG, this.sonsOfLiberty);
        if (xw.validFor(this.getOwner())) {
            xw.writeAttribute(OLD_SONS_OF_LIBERTY_TAG, this.oldSonsOfLiberty);
            xw.writeAttribute(TORIES_TAG, this.tories);
            xw.writeAttribute(OLD_TORIES_TAG, this.oldTories);
            xw.writeAttribute(LIBERTY_TAG, this.liberty);
            xw.writeAttribute(IMMIGRATION_TAG, this.immigration);
            xw.writeAttribute(PRODUCTION_BONUS_TAG, this.productionBonus);
        } else {
            int uc = this.getDisplayUnitCount();
            if (uc <= 0) {
                logger.warning("Unit count fail: " + uc + " id=" + this.getId() + " unitCount=" + this.getUnitCount() + " scope=" + (Object)((Object)xw.getWriteScope()) + " player=" + xw.getWriteScope().getClient() + "\n" + FreeColDebugger.stackTraceToString());
            }
            xw.writeAttribute(UNIT_COUNT_TAG, uc);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.getOwner())) {
            ArrayList<String> keys = new ArrayList<String>(this.exportData.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.exportData.get(key).toXML(xw);
            }
            Turn turn = this.getGame().getTurn();
            for (Modifier modifier : this.getSortedModifiers()) {
                if (!modifier.hasIncrement() || modifier.isOutOfDate(turn)) continue;
                modifier.toXML(xw);
            }
            for (WorkLocation workLocation : Colony.getSortedCopy(this.getAllWorkLocations())) {
                workLocation.toXML(xw);
            }
            for (BuildableType buildableType : this.buildQueue.getValues()) {
                xw.writeStartElement(BUILD_QUEUE_TAG);
                xw.writeAttribute("id", buildableType);
                xw.writeEndElement();
            }
            for (BuildableType buildableType : this.populationQueue.getValues()) {
                xw.writeStartElement(POPULATION_QUEUE_TAG);
                xw.writeAttribute("id", buildableType);
                xw.writeEndElement();
            }
        } else {
            Building stockade = this.getStockade();
            if (stockade != null) {
                stockade.toXML(xw);
            }
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.established = new Turn(xr.getAttribute(ESTABLISHED_TAG, 0));
        this.sonsOfLiberty = xr.getAttribute(SONS_OF_LIBERTY_TAG, 0);
        this.oldSonsOfLiberty = xr.getAttribute(OLD_SONS_OF_LIBERTY_TAG, 0);
        this.tories = xr.getAttribute(TORIES_TAG, 0);
        this.oldTories = xr.getAttribute(OLD_TORIES_TAG, 0);
        this.liberty = xr.getAttribute(LIBERTY_TAG, 0);
        this.immigration = xr.getAttribute(IMMIGRATION_TAG, 0);
        this.productionBonus = xr.getAttribute(PRODUCTION_BONUS_TAG, 0);
        this.displayUnitCount = xr.getAttribute(UNIT_COUNT_TAG, -1);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.colonyTiles.clear();
        this.buildingMap.clear();
        this.exportData.clear();
        this.buildQueue.clear();
        this.populationQueue.clear();
        super.readChildren(xr);
        this.invalidateCache();
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (BUILD_QUEUE_TAG.equals(tag)) {
            BuildableType bt = xr.getType(spec, "id", BuildableType.class, null);
            if (bt != null) {
                this.buildQueue.add(bt);
            }
            xr.closeTag(BUILD_QUEUE_TAG);
        } else if (POPULATION_QUEUE_TAG.equals(xr.getLocalName())) {
            UnitType ut = xr.getType(spec, "id", UnitType.class, null);
            if (ut != null) {
                this.populationQueue.add(ut);
            }
            xr.closeTag(POPULATION_QUEUE_TAG);
        } else if (Building.getXMLElementTagName().equals(tag)) {
            this.addBuilding(xr.readFreeColGameObject(game, Building.class));
        } else if (ColonyTile.getXMLElementTagName().equals(tag)) {
            this.colonyTiles.add(xr.readFreeColGameObject(game, ColonyTile.class));
        } else if (ExportData.getXMLElementTagName().equals(tag)) {
            ExportData data = new ExportData(xr);
            this.exportData.put(data.getId(), data);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getXMLTagName() {
        return Colony.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "colony";
    }

    private static class Occupation {
        public WorkLocation workLocation;
        public ProductionType productionType;
        public GoodsType workType;

        public Occupation(WorkLocation workLocation, ProductionType productionType, GoodsType workType) {
            this.workLocation = workLocation;
            this.productionType = productionType;
            this.workType = workType;
        }

        public boolean install(Unit unit) {
            if (!unit.setLocation(this.workLocation)) {
                return false;
            }
            if (this.productionType != this.workLocation.getProductionType()) {
                this.workLocation.setProductionType(this.productionType);
            }
            if (this.workType != unit.getWorkType()) {
                unit.changeWorkType(this.workType);
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[Occupation ").append(this.workLocation).append(" ").append(this.workType.getSuffix()).append("]");
            return sb.toString();
        }
    }

    public static enum NoBuildReason {
        NONE,
        NOT_BUILDING,
        NOT_BUILDABLE,
        POPULATION_TOO_SMALL,
        MISSING_BUILD_ABILITY,
        MISSING_ABILITY,
        WRONG_UPGRADE,
        COASTAL,
        LIMIT_EXCEEDED;

    }

    public static enum ColonyChangeEvent {
        POPULATION_CHANGE,
        PRODUCTION_CHANGE,
        BONUS_CHANGE,
        WAREHOUSE_CHANGE,
        BUILD_QUEUE_CHANGE,
        UNIT_TYPE_CHANGE;

    }
}

