/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;

public final class BuildingType
extends BuildableType {
    private int level = 1;
    private int workPlaces = 3;
    private int minSkill = Integer.MIN_VALUE;
    private int maxSkill = Integer.MAX_VALUE;
    private int upkeep = 0;
    private int priority = 800;
    private BuildingType upgradesFrom = null;
    private BuildingType upgradesTo = null;
    private final List<ProductionType> productionTypes = new ArrayList<ProductionType>();
    private static final String BASIC_PRODUCTION_TAG = "basicProduction";
    private static final String CONSUMES_TAG = "consumes";
    private static final String MAX_SKILL_TAG = "maxSkill";
    private static final String MIN_SKILL_TAG = "minSkill";
    private static final String PRIORITY_TAG = "priority";
    private static final String PRODUCES_TAG = "produces";
    private static final String PRODUCTION_TAG = "production";
    private static final String UPGRADES_FROM_TAG = "upgradesFrom";
    private static final String UPKEEP_TAG = "upkeep";
    private static final String WORKPLACES_TAG = "workplaces";

    public BuildingType(String id, Specification specification) {
        super(id, specification);
    }

    public int getLevel() {
        return this.level;
    }

    public int getWorkPlaces() {
        return this.workPlaces;
    }

    public int getUpkeep() {
        return this.upkeep;
    }

    public int getPriority() {
        return this.priority;
    }

    public UnitLocation.NoAddReason getNoAddReason(UnitType unitType) {
        return this.workPlaces == 0 ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : (!unitType.hasSkill() ? UnitLocation.NoAddReason.MISSING_SKILL : (unitType.getSkill() < this.minSkill ? UnitLocation.NoAddReason.MINIMUM_SKILL : (unitType.getSkill() > this.maxSkill ? UnitLocation.NoAddReason.MAXIMUM_SKILL : UnitLocation.NoAddReason.NONE)));
    }

    public boolean canAdd(UnitType unitType) {
        return this.getNoAddReason(unitType) == UnitLocation.NoAddReason.NONE;
    }

    public FreeColGameObjectType getType() {
        return this;
    }

    public BuildingType getUpgradesFrom() {
        return this.upgradesFrom;
    }

    public BuildingType getUpgradesTo() {
        return this.upgradesTo;
    }

    public BuildingType getFirstLevel() {
        BuildingType buildingType = this;
        while (buildingType.getUpgradesFrom() != null) {
            buildingType = buildingType.getUpgradesFrom();
        }
        return buildingType;
    }

    public boolean isAutomaticBuild() {
        return !this.needsGoodsToBuild() && this.getUpgradesFrom() == null;
    }

    public void addProductionType(ProductionType productionType) {
        if (productionType != null) {
            this.productionTypes.add(productionType);
        }
    }

    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.getAvailableProductionTypes(unattended, null);
    }

    public List<ProductionType> getAvailableProductionTypes(boolean unattended, String level) {
        ArrayList<ProductionType> result = new ArrayList<ProductionType>();
        for (ProductionType productionType : this.productionTypes) {
            if (productionType.isUnattended() != unattended || !productionType.appliesTo(level)) continue;
            result.add(productionType);
        }
        return result;
    }

    private GoodsType getConsumedGoodsType() {
        if (this.productionTypes.isEmpty()) {
            return null;
        }
        List<AbstractGoods> inputs = this.productionTypes.get(0).getInputs();
        return inputs.isEmpty() ? null : inputs.get(0).getType();
    }

    public GoodsType getProducedGoodsType() {
        if (this.productionTypes.isEmpty()) {
            return null;
        }
        List<AbstractGoods> outputs = this.productionTypes.get(0).getOutputs();
        return outputs.isEmpty() ? null : outputs.get(0).getType();
    }

    public boolean isDefenceType() {
        return this.containsModifierKey("model.modifier.defence");
    }

    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return goodsType != null && ProductionType.canProduce(goodsType, this.getAvailableProductionTypes(unitType == null));
    }

    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            return 0;
        }
        if (productionType == null) {
            productionType = ProductionType.getBestProductionType(goodsType, this.getAvailableProductionTypes(unitType == null));
        }
        if (productionType == null) {
            return 0;
        }
        AbstractGoods best = productionType.getOutput(goodsType);
        return best == null ? 0 : best.getAmount();
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            return 0;
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        return (amount = (int)this.applyModifiers(amount, null, goodsType.getId(), unitType)) < 0 ? 0 : amount;
    }

    @Override
    public int compareTo(FreeColObject other) {
        int cmp = 0;
        if (other instanceof BuildingType) {
            BuildingType bt = (BuildingType)other;
            cmp = this.getIndex() - bt.getIndex();
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.upgradesFrom != null) {
            xw.writeAttribute(UPGRADES_FROM_TAG, this.upgradesFrom);
        }
        xw.writeAttribute(WORKPLACES_TAG, this.workPlaces);
        if (this.minSkill != Integer.MIN_VALUE) {
            xw.writeAttribute(MIN_SKILL_TAG, this.minSkill);
        }
        if (this.maxSkill < Integer.MAX_VALUE) {
            xw.writeAttribute(MAX_SKILL_TAG, this.maxSkill);
        }
        if (this.upkeep > 0) {
            xw.writeAttribute(UPKEEP_TAG, this.upkeep);
        }
        if (this.priority != 800) {
            xw.writeAttribute(PRIORITY_TAG, this.priority);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (ProductionType productionType : this.productionTypes) {
            productionType.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        BuildingType parent = xr.getType(spec, "extends", BuildingType.class, this);
        this.upgradesFrom = xr.getType(spec, UPGRADES_FROM_TAG, BuildingType.class, null);
        if (this.upgradesFrom == null) {
            this.level = 1;
        } else {
            this.upgradesFrom.upgradesTo = this;
            this.level = this.upgradesFrom.level + 1;
        }
        this.workPlaces = xr.getAttribute(WORKPLACES_TAG, parent.workPlaces);
        this.minSkill = xr.getAttribute(MIN_SKILL_TAG, parent.minSkill);
        this.maxSkill = xr.getAttribute(MAX_SKILL_TAG, parent.maxSkill);
        this.upkeep = xr.getAttribute(UPKEEP_TAG, parent.upkeep);
        this.priority = xr.getAttribute(PRIORITY_TAG, parent.priority);
        int basicProduction = xr.getAttribute(BASIC_PRODUCTION_TAG, -1);
        if (basicProduction > 0) {
            GoodsType consumes = xr.getType(spec, CONSUMES_TAG, GoodsType.class, parent.getConsumedGoodsType());
            GoodsType produces = xr.getType(spec, PRODUCES_TAG, GoodsType.class, parent.getProducedGoodsType());
            this.productionTypes.add(new ProductionType(consumes, produces, basicProduction));
        }
        if (parent != this) {
            if (!xr.hasAttribute("required-population")) {
                this.setRequiredPopulation(parent.getRequiredPopulation());
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (PRODUCTION_TAG.equals(tag)) {
            if (xr.getAttribute("delete", false)) {
                this.productionTypes.clear();
                xr.closeTag(PRODUCTION_TAG);
            } else {
                this.addProductionType(new ProductionType(xr, spec));
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return BuildingType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "building-type";
    }
}

