/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Specification;

public abstract class BuildableType
extends FreeColGameObjectType {
    private static final int DEFAULT_REQUIRED_POPULATION = 1;
    private int requiredPopulation = 1;
    private Map<String, Boolean> requiredAbilities = null;
    private List<AbstractGoods> requiredGoods = null;
    private List<Limit> limits = null;
    private static final String REQUIRED_ABILITY_TAG = "required-ability";
    private static final String REQUIRED_GOODS_TAG = "required-goods";
    public static final String REQUIRED_POPULATION_TAG = "required-population";

    public BuildableType(String id, Specification specification) {
        super(id, specification);
    }

    public int getRequiredPopulation() {
        return this.requiredPopulation;
    }

    public void setRequiredPopulation(int newPopulation) {
        this.requiredPopulation = newPopulation;
    }

    public Map<String, Boolean> getRequiredAbilities() {
        return this.requiredAbilities == null ? Collections.emptyMap() : new HashMap<String, Boolean>(this.requiredAbilities);
    }

    public boolean requiresAbility(String key) {
        return this.requiredAbilities == null ? false : (!this.requiredAbilities.containsKey(key) ? false : this.requiredAbilities.get(key));
    }

    public void setRequiredAbilities(Map<String, Boolean> abilities) {
        this.requiredAbilities = abilities;
    }

    private void addRequiredAbility(String tag, boolean value) {
        if (this.requiredAbilities == null) {
            this.requiredAbilities = new HashMap<String, Boolean>();
        }
        this.requiredAbilities.put(tag, value);
    }

    public boolean isAvailableTo(FreeColObject ... fco) {
        if (this.requiredAbilities != null) {
            FreeColObject[] objects = fco;
            for (Map.Entry<String, Boolean> entry : this.requiredAbilities.entrySet()) {
                boolean found = false;
                for (int i = 0; i < objects.length && !(found = objects[i].hasAbility(entry.getKey())); ++i) {
                }
                if (found == entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public List<AbstractGoods> getRequiredGoods() {
        if (this.requiredGoods == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        for (AbstractGoods ag : this.requiredGoods) {
            result.add(new AbstractGoods(ag.getType(), ag.getAmount()));
        }
        return result;
    }

    public int getRequiredAmountOf(GoodsType type) {
        return AbstractGoods.getCount(type, this.getRequiredGoods());
    }

    private void addRequiredGoods(AbstractGoods ag) {
        if (this.requiredGoods == null) {
            this.requiredGoods = new ArrayList<AbstractGoods>();
        }
        this.requiredGoods.add(ag);
    }

    public boolean needsGoodsToBuild() {
        return !this.getRequiredGoods().isEmpty();
    }

    public List<Limit> getLimits() {
        return this.limits == null ? Collections.emptyList() : this.limits;
    }

    public void setLimits(List<Limit> newLimits) {
        this.limits = newLimits;
    }

    private void addLimit(Limit limit) {
        if (this.limits == null) {
            this.limits = new ArrayList<Limit>();
        }
        this.limits.add(limit);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.requiredPopulation > 1) {
            xw.writeAttribute(REQUIRED_POPULATION_TAG, this.requiredPopulation);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.requiredAbilities != null) {
            for (Map.Entry entry : this.requiredAbilities.entrySet()) {
                xw.writeStartElement(REQUIRED_ABILITY_TAG);
                xw.writeAttribute("id", (String)entry.getKey());
                xw.writeAttribute("value", entry.getValue());
                xw.writeEndElement();
            }
        }
        for (AbstractGoods abstractGoods : this.getRequiredGoods()) {
            xw.writeStartElement(REQUIRED_GOODS_TAG);
            xw.writeAttribute("id", abstractGoods.getType());
            xw.writeAttribute("value", abstractGoods.getAmount());
            xw.writeEndElement();
        }
        for (Limit limit : this.getLimits()) {
            limit.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.requiredPopulation = xr.getAttribute(REQUIRED_POPULATION_TAG, 1);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.requiredAbilities = null;
            this.requiredGoods = null;
            this.limits = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (REQUIRED_ABILITY_TAG.equals(tag)) {
            String id = xr.readId();
            this.addRequiredAbility(id, xr.getAttribute("value", true));
            spec.addAbility(id);
            xr.closeTag(REQUIRED_ABILITY_TAG);
        } else if (REQUIRED_GOODS_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, "id", GoodsType.class, null);
            int amount = xr.getAttribute("value", 0);
            this.addRequiredGoods(new AbstractGoods(type, amount));
            xr.closeTag(REQUIRED_GOODS_TAG);
        } else if (Limit.getXMLElementTagName().equals(tag)) {
            Limit limit = new Limit(xr, spec);
            if (limit.getLeftHandSide().getType() == null) {
                limit.getLeftHandSide().setType(this.getId());
            }
            this.addLimit(limit);
        } else {
            super.readChild(xr);
        }
    }
}

