/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class DebugUtils {
    private static final Logger logger = Logger.getLogger(DebugUtils.class.getName());

    public static void addBuildings(FreeColClient freeColClient, String buildingTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ArrayList buildings = new ArrayList();
        for (BuildingType b : game.getSpecification().getBuildingTypeList()) {
            String msg = Messages.getName(b);
            buildings.add(new ChoiceItem<BuildingType>(msg, b));
        }
        Collections.sort(buildings);
        BuildingType buildingType = (BuildingType)gui.getChoice(true, null, buildingTitle, null, "cancel", buildings);
        if (buildingType == null) {
            return;
        }
        ServerGame sGame = server.getGame();
        BuildingType sBuildingType = server.getSpecification().getBuildingType(buildingType.getId());
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        ArrayList<String> results = new ArrayList<String>();
        int fails = 0;
        for (Colony sColony : sPlayer.getColonies()) {
            Colony.NoBuildReason reason = sColony.getNoBuildReason(sBuildingType, null);
            results.add(sColony.getName() + ": " + (Object)((Object)reason));
            if (reason == Colony.NoBuildReason.NONE) {
                if (sBuildingType.isDefenceType()) {
                    sColony.getTile().cacheUnseen();
                }
                ServerBuilding sBuilding = new ServerBuilding(sGame, sColony, sBuildingType);
                sColony.addBuilding(sBuilding);
                continue;
            }
            ++fails;
        }
        gui.showInformationMessage(StringUtils.join(", ", results));
        if (fails < sPlayer.getNumberOfSettlements()) {
            freeColClient.getConnectController().reconnect();
        }
    }

    public static void addFathers(FreeColClient freeColClient, String fatherTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        ArrayList fathers = new ArrayList();
        for (FoundingFather father : sSpec.getFoundingFathers()) {
            if (sPlayer.hasFather(father)) continue;
            String msg = Messages.getName(father);
            fathers.add(new ChoiceItem<FoundingFather>(msg, father));
        }
        Collections.sort(fathers);
        FoundingFather father = (FoundingFather)gui.getChoice(true, null, fatherTitle, null, "cancel", fathers);
        if (father != null) {
            server.getInGameController().addFoundingFather((ServerPlayer)sPlayer, father);
        }
    }

    public static void addGold(FreeColClient freeColClient) {
        int gold;
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        String response = gui.getInput(true, null, StringTemplate.key("menuBar.debug.addGold"), Integer.toString(1000), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            gold = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        player.modifyGold(gold);
        sPlayer.modifyGold(gold);
    }

    public static void addImmigration(FreeColClient freeColClient) {
        int crosses;
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        String response = gui.getInput(true, null, StringTemplate.key("menuBar.debug.addImmigration"), Integer.toString(100), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            crosses = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        player.modifyImmigration(crosses);
        sPlayer.modifyImmigration(crosses);
    }

    public static void addLiberty(FreeColClient freeColClient) {
        int liberty;
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        String response = gui.getInput(true, null, StringTemplate.key("menuBar.debug.addLiberty"), Integer.toString(100), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            liberty = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        for (Colony c : player.getColonies()) {
            c.addLiberty(liberty);
            sGame.getFreeColGameObject(c.getId(), Colony.class).addLiberty(liberty);
        }
    }

    public static void addSkipChangeListener(FreeColClient freeColClient, JMenu menu, final JMenuItem item) {
        final FreeColServer server = freeColClient.getFreeColServer();
        if (server == null) {
            return;
        }
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean skipping = server.getInGameController().getSkippedTurns() > 0;
                item.setText(Messages.message(skipping ? "menuBar.debug.stopSkippingTurns" : "menuBar.debug.skipTurns"));
            }
        });
    }

    public static void addNewUnitToTile(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        Player player = freeColClient.getMyPlayer();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        GUI gui = freeColClient.getGUI();
        ArrayList uts = new ArrayList();
        for (UnitType t : sSpec.getUnitTypeList()) {
            String msg = Messages.getName(t);
            uts.add(new ChoiceItem<UnitType>(msg, t));
        }
        Collections.sort(uts);
        UnitType unitChoice = (UnitType)gui.getChoice(true, null, "Select Unit Type", null, "cancel", uts);
        if (unitChoice == null) {
            return;
        }
        Object carrier = null;
        UnitLocation sCarrier = null;
        if (!sTile.isLand() && !unitChoice.isNaval()) {
            for (Unit u : sTile.getUnitList()) {
                if (!u.isNaval() || u.getSpaceLeft() < unitChoice.getSpaceTaken()) continue;
                sCarrier = u;
                break;
            }
        }
        Tile loc = sCarrier != null ? sCarrier : sTile;
        ServerUnit sUnit = new ServerUnit(sGame, loc, sPlayer, unitChoice);
        ((ServerPlayer)sPlayer).exploreForUnit(sUnit);
        sUnit.setMovesLeft(sUnit.getInitialMovesLeft());
        sPlayer.invalidateCanSeeTiles();
        freeColClient.getConnectController().reconnect();
        Unit unit = freeColClient.getGame().getFreeColGameObject(sUnit.getId(), Unit.class);
        if (unit != null) {
            gui.setActiveUnit(unit);
            gui.refresh();
            gui.resetMenuBar();
        }
    }

    public static void addUnitGoods(FreeColClient freeColClient, Unit unit) {
        int a;
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        GUI gui = freeColClient.getGUI();
        ArrayList gtl = new ArrayList();
        for (GoodsType t : sSpec.getGoodsTypeList()) {
            if (t.isFoodType() && t != sSpec.getPrimaryFoodType()) continue;
            String msg = Messages.getName(t);
            gtl.add(new ChoiceItem<GoodsType>(msg, t));
        }
        Collections.sort(gtl);
        GoodsType goodsType = (GoodsType)gui.getChoice(true, null, "Select Goods Type", null, "cancel", gtl);
        if (goodsType == null) {
            return;
        }
        String amount = gui.getInput(true, null, StringTemplate.name("Select Goods Amount"), "20", "ok", "cancel");
        if (amount == null) {
            return;
        }
        try {
            a = Integer.parseInt(amount);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        GoodsType sGoodsType = sSpec.getGoodsType(goodsType.getId());
        GoodsContainer ugc = unit.getGoodsContainer();
        GoodsContainer sgc = sGame.getFreeColGameObject(ugc.getId(), GoodsContainer.class);
        ugc.setAmount(goodsType, a);
        sgc.setAmount(sGoodsType, a);
    }

    public static void applyDisaster(FreeColClient freeColClient, Colony colony) {
        GUI gui = freeColClient.getGUI();
        List<RandomChoice<Disaster>> disasters = colony.getDisasters();
        if (disasters.isEmpty()) {
            gui.showErrorMessage(null, "No disasters available for " + colony.getName());
            return;
        }
        ArrayList choices = new ArrayList();
        for (RandomChoice<Disaster> rc : disasters) {
            String label = Messages.getName(rc.getObject()) + " " + Integer.toString(rc.getProbability());
            choices.add(new ChoiceItem<Disaster>(label, rc.getObject()));
        }
        Collections.sort(choices);
        Disaster disaster = (Disaster)gui.getChoice(true, null, "Select disaster", null, "cancel", choices);
        if (disaster == null) {
            return;
        }
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        ServerColony sColony = sGame.getFreeColGameObject(colony.getId(), ServerColony.class);
        Disaster sDisaster = sGame.getSpecification().getDisaster(disaster.getId());
        if (server.getInGameController().debugApplyDisaster(sColony, sDisaster) <= 0) {
            gui.showErrorMessage(null, "Disaster " + Messages.getName(disaster) + " avoided.");
        }
        freeColClient.getInGameController().nextModelMessage();
    }

    public static void changeOwnership(FreeColClient freeColClient, Colony colony) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        ServerColony sColony = sGame.getFreeColGameObject(colony.getId(), ServerColony.class);
        GUI gui = freeColClient.getGUI();
        Game game = freeColClient.getGame();
        ArrayList pcs = new ArrayList();
        for (Player p : game.getLiveEuropeanPlayers(colony.getOwner())) {
            String msg = Messages.message(p.getNationName());
            pcs.add(new ChoiceItem<Player>(msg, p));
        }
        Collections.sort(pcs);
        Player player = (Player)gui.getChoice(true, null, "Select owner", null, "cancel", pcs);
        if (player == null) {
            return;
        }
        ServerPlayer sPlayer = sGame.getFreeColGameObject(player.getId(), ServerPlayer.class);
        server.getInGameController().debugChangeOwner(sColony, sPlayer);
        Player myPlayer = freeColClient.getMyPlayer();
        if (gui.getActiveUnit() != null && gui.getActiveUnit().getOwner() != myPlayer) {
            freeColClient.getInGameController().nextActiveUnit();
        }
        gui.refresh();
        gui.resetMenuBar();
    }

    public static void changeOwnership(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Game game = unit.getGame();
        ArrayList pcs = new ArrayList();
        for (Player p : game.getLivePlayers(null)) {
            if (!unit.getType().isAvailableTo(p)) continue;
            String msg = Messages.message(p.getNationName());
            pcs.add(new ChoiceItem<Player>(msg, p));
        }
        Collections.sort(pcs);
        Player player = (Player)gui.getChoice(true, null, "Select owner", null, "cancel", pcs);
        if (player == null || unit.getOwner() == player) {
            return;
        }
        ServerGame sGame = server.getGame();
        ServerUnit sUnit = sGame.getFreeColGameObject(unit.getId(), ServerUnit.class);
        ServerPlayer sPlayer = sGame.getFreeColGameObject(player.getId(), ServerPlayer.class);
        server.getInGameController().debugChangeOwner(sUnit, sPlayer);
        Player myPlayer = freeColClient.getMyPlayer();
        if (unit.getOwner() == myPlayer) {
            gui.setActiveUnit(unit);
        } else {
            freeColClient.getInGameController().nextActiveUnit();
        }
        gui.refresh();
        gui.resetMenuBar();
    }

    public static void changeRole(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Unit sUnit = sGame.getFreeColGameObject(unit.getId(), Unit.class);
        GUI gui = freeColClient.getGUI();
        ArrayList rcs = new ArrayList();
        for (Role role : sGame.getSpecification().getRoles()) {
            rcs.add(new ChoiceItem<Role>(role.getId(), role));
        }
        Collections.sort(rcs);
        Role roleChoice = (Role)gui.getChoice(true, null, "Select role", null, "cancel", rcs);
        if (roleChoice == null) {
            return;
        }
        sUnit.changeRole(roleChoice, roleChoice.getMaximumCount());
        freeColClient.getConnectController().reconnect();
    }

    public static boolean checkDesyncAction(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        Map map = game.getMap();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Map sMap = sGame.getMap();
        ServerPlayer sPlayer = sGame.getFreeColGameObject(player.getId(), ServerPlayer.class);
        boolean problemDetected = false;
        LogBuilder lb = new LogBuilder(256);
        lb.add("Desynchronization detected\n");
        for (Tile t : sMap.getAllTiles()) {
            if (!sPlayer.canSee(t)) continue;
            for (Unit u : t.getUnitList()) {
                if (!sPlayer.owns(u) && (t.hasSettlement() || u.isOnCarrier())) continue;
                if (game.getFreeColGameObject(u.getId(), Unit.class) == null) {
                    lb.add("Unit missing on client-side.\n", "  Server: ", u.getDescription(Unit.UnitLabelType.NATIONAL), "(", u.getId(), ") from: ", u.getLocation().getId(), ".\n");
                    try {
                        lb.add("  Client: ", map.getTile(u.getTile().getX(), u.getTile().getY()).getFirstUnit().getId(), "\n");
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    problemDetected = true;
                    continue;
                }
                Unit cUnit = game.getFreeColGameObject(u.getId(), Unit.class);
                if (!cUnit.hasTile() || cUnit.getTile().getId().equals(u.getTile().getId())) continue;
                lb.add("Unit located on different tiles.\n", "  Server: ", u.getDescription(Unit.UnitLabelType.NATIONAL), "(", u.getId(), ") from: ", u.getLocation().getId(), "\n", "  Client: ", cUnit.getDescription(Unit.UnitLabelType.NATIONAL), "(", cUnit.getId(), ") at: ", cUnit.getLocation().getId(), "\n");
                problemDetected = true;
            }
            Tile ct = game.getFreeColGameObject(t.getId(), Tile.class);
            Settlement sSettlement = t.getSettlement();
            Settlement cSettlement = ct.getSettlement();
            if (sSettlement == null) {
                if (cSettlement == null) continue;
                lb.add("Settlement still present in client: ", cSettlement);
                problemDetected = true;
                continue;
            }
            if (cSettlement == null) {
                lb.add("Settlement not present in client: ", sSettlement);
                problemDetected = true;
                continue;
            }
            if (sSettlement.getId().equals(cSettlement.getId())) continue;
            lb.add("Settlements differ.\n  Server: ", sSettlement.toString(), "\n  Client: ", cSettlement.toString(), "\n");
        }
        boolean goodsProblemDetected = false;
        for (GoodsType sg : sGame.getSpecification().getGoodsTypeList()) {
            int sPrice = sPlayer.getMarket().getBidPrice(sg, 1);
            GoodsType cg = game.getSpecification().getGoodsType(sg.getId());
            int cPrice = player.getMarket().getBidPrice(cg, 1);
            if (sPrice == cPrice) continue;
            lb.add("Goods prices for ", sg, " differ.\n");
            goodsProblemDetected = true;
        }
        if (goodsProblemDetected) {
            lb.add("  Server:\n", sPlayer.getMarket(), "\n", "  Client:\n", player.getMarket(), "\n");
            problemDetected = true;
        }
        if (problemDetected) {
            lb.shrink("\n");
            String err = lb.toString();
            freeColClient.getGUI().showInformationMessage(err);
            logger.severe(err);
        }
        return problemDetected;
    }

    public static void displayColonyPlan(FreeColClient freeColClient, Colony colony) {
        FreeColServer server = freeColClient.getFreeColServer();
        AIMain aiMain = server.getAIMain();
        AIColony aiColony = aiMain.getAIColony(colony);
        freeColClient.getGUI().showInformationMessage(aiColony == null ? colony.getName() + "is not an AI colony." : aiColony.planToString());
    }

    public static String getColonyValue(Tile tile) {
        Player player = FreeColDebugger.debugDisplayColonyValuePlayer();
        if (player == null) {
            return null;
        }
        int value = player.getColonyValue(tile);
        if (value < 0) {
            return Player.NoValueType.fromValue(value).toString();
        }
        return Integer.toString(value);
    }

    public static void displayEurope(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        AIMain aiMain = server.getAIMain();
        LogBuilder lb = new LogBuilder(256);
        ArrayList<Unit> inEurope = new ArrayList<Unit>();
        ArrayList<Unit> toEurope = new ArrayList<Unit>();
        ArrayList<Unit> toAmerica = new ArrayList<Unit>();
        HashMap<String, ArrayList<Unit>> units = new HashMap<String, ArrayList<Unit>>();
        for (Player tp : sGame.getLiveEuropeanPlayers(null)) {
            Player p = sGame.getFreeColGameObject(tp.getId(), Player.class);
            if (p.getEurope() == null) continue;
            inEurope.clear();
            toEurope.clear();
            toAmerica.clear();
            units.clear();
            units.put("To Europe", toEurope);
            units.put("In Europe", inEurope);
            units.put("To America", toAmerica);
            lb.add("\n==", Messages.message(p.getNationName()), "==\n");
            for (Unit unit : p.getEurope().getUnitList()) {
                if (unit.getDestination() instanceof Map) {
                    toAmerica.add(unit);
                    continue;
                }
                if (unit.getDestination() instanceof Europe) {
                    toEurope.add(unit);
                    continue;
                }
                inEurope.add(unit);
            }
            for (Map.Entry entry : units.entrySet()) {
                String label = (String)entry.getKey();
                List list = (List)entry.getValue();
                if (list.isEmpty()) continue;
                lb.add("\n->", label, "\n");
                for (Unit u : list) {
                    lb.add("\n", u.getDescription(Unit.UnitLabelType.NATIONAL));
                    if (u.isDamaged()) {
                        lb.add(" (Repairing)");
                        continue;
                    }
                    lb.add("    ");
                    AIUnit aiu = aiMain.getAIUnit(u);
                    if (!aiu.hasMission()) {
                        lb.add(" (None)");
                        continue;
                    }
                    lb.add(aiu.getMission().toString().replaceAll("\n", "    \n"));
                }
                lb.add("\n");
            }
            lb.add("\n->Recruitable units\n\n");
            for (UnitType unitType : p.getEurope().getRecruitables()) {
                lb.add(Messages.getName(unitType), "\n");
            }
            lb.add("\n");
        }
        freeColClient.getGUI().showInformationMessage(lb.toString());
    }

    public static void displayMission(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        AIMain aiMain = server.getAIMain();
        AIUnit aiUnit = aiMain.getAIUnit(unit);
        Mission m = aiUnit.getMission();
        String msg = m == null ? "No mission" : (m instanceof TransportMission ? ((TransportMission)m).toFullString() : m.toString());
        freeColClient.getGUI().showInformationMessage(msg);
    }

    public static void displayUnits(FreeColClient freeColClient) {
        Unit u;
        Player player = freeColClient.getMyPlayer();
        List<Unit> all = player.getUnits();
        LogBuilder lb = new LogBuilder(256);
        lb.add("\nActive units:\n");
        Unit first = player.getNextActiveUnit();
        if (first != null) {
            lb.add(first.toString(), "\nat ", first.getLocation(), "\n");
            all.remove(first);
            while (player.hasNextActiveUnit() && (u = player.getNextActiveUnit()) != first) {
                lb.add(u, "\nat ", u.getLocation(), "\n");
                all.remove(u);
            }
        }
        lb.add("Going-to units:\n");
        first = player.getNextGoingToUnit();
        if (first != null) {
            all.remove(first);
            lb.add(first, "\nat ", first.getLocation(), "\n");
            while (player.hasNextGoingToUnit() && (u = player.getNextGoingToUnit()) != first) {
                lb.add(u, "\nat ", u.getLocation(), "\n");
                all.remove(u);
            }
        }
        lb.add("Remaining units:\n");
        while (!all.isEmpty()) {
            u = all.remove(0);
            lb.add(u, "\nat ", u.getLocation(), "\n");
        }
        freeColClient.getGUI().showInformationMessage(lb.toString());
    }

    public static void dumpTile(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Player player = freeColClient.getMyPlayer();
        System.err.println("\nClient (" + player.getId() + "):");
        tile.save(System.err, FreeColXMLWriter.WriteScope.toClient(player), true);
        System.err.println("\n\nServer:");
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        sTile.save(System.err, FreeColXMLWriter.WriteScope.toServer(), true);
        System.err.println("\n\nSave:");
        sTile.save(System.err, FreeColXMLWriter.WriteScope.toSave(), true);
        System.err.println("\n");
    }

    public static void resetMoves(FreeColClient freeColClient, List<Unit> units) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        GUI gui = freeColClient.getGUI();
        boolean first = true;
        for (Unit u : units) {
            Unit su = sGame.getFreeColGameObject(u.getId(), Unit.class);
            u.setMovesLeft(u.getInitialMovesLeft());
            su.setMovesLeft(su.getInitialMovesLeft());
            if (first) {
                gui.setActiveUnit(u);
                first = false;
            }
            for (Unit u2 : u.getUnitList()) {
                Unit su2 = sGame.getFreeColGameObject(u2.getId(), Unit.class);
                u2.setMovesLeft(u2.getInitialMovesLeft());
                su2.setMovesLeft(su2.getInitialMovesLeft());
            }
        }
        gui.refresh();
        gui.resetMenuBar();
    }

    public static void revealMap(FreeColClient freeColClient, boolean reveal) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        server.exploreMapForAllPlayers(reveal);
        BooleanOption fogOfWarSetting = game.getSpecification().getBooleanOption("model.option.fogOfWar");
        if (reveal) {
            FreeColDebugger.setNormalGameFogOfWar(fogOfWarSetting.getValue());
            fogOfWarSetting.setValue(false);
        } else {
            fogOfWarSetting.setValue(FreeColDebugger.getNormalGameFogOfWar());
        }
    }

    public static void setColonyGoods(FreeColClient freeColClient, Colony colony) {
        int a;
        Specification spec = colony.getSpecification();
        ArrayList gtl = new ArrayList();
        for (GoodsType t : spec.getGoodsTypeList()) {
            if (t.isFoodType() && t != spec.getPrimaryFoodType()) continue;
            String msg = Messages.getName(t);
            gtl.add(new ChoiceItem<GoodsType>(msg, t));
        }
        Collections.sort(gtl);
        GoodsType goodsType = (GoodsType)freeColClient.getGUI().getChoice(true, null, "Select Goods Type", null, "cancel", gtl);
        if (goodsType == null) {
            return;
        }
        String response = freeColClient.getGUI().getInput(true, null, StringTemplate.name("Select Goods Amount"), Integer.toString(colony.getGoodsCount(goodsType)), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            a = Integer.parseInt(response);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = server.getSpecification();
        GoodsType sGoodsType = sSpec.getGoodsType(goodsType.getId());
        GoodsContainer cgc = colony.getGoodsContainer();
        GoodsContainer sgc = sGame.getFreeColGameObject(cgc.getId(), GoodsContainer.class);
        cgc.setAmount(goodsType, a);
        sgc.setAmount(sGoodsType, a);
    }

    public static void setMonarchAction(FreeColClient freeColClient, String monarchTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Player player = freeColClient.getMyPlayer();
        ServerPlayer sPlayer = sGame.getFreeColGameObject(player.getId(), ServerPlayer.class);
        GUI gui = freeColClient.getGUI();
        ArrayList actions = new ArrayList();
        for (Monarch.MonarchAction action : Monarch.MonarchAction.values()) {
            actions.add(new ChoiceItem<Monarch.MonarchAction>(action));
        }
        Collections.sort(actions);
        Monarch.MonarchAction action = (Monarch.MonarchAction)((Object)gui.getChoice(true, null, monarchTitle, null, "cancel", actions));
        server.getInGameController().setMonarchAction(sPlayer, action);
    }

    public static void setRumourType(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        ArrayList rumours = new ArrayList();
        for (LostCityRumour.RumourType rumour : LostCityRumour.RumourType.values()) {
            if (rumour == LostCityRumour.RumourType.NO_SUCH_RUMOUR) continue;
            rumours.add(new ChoiceItem<LostCityRumour.RumourType>(rumour.toString(), rumour));
        }
        Collections.sort(rumours);
        LostCityRumour.RumourType rumourChoice = (LostCityRumour.RumourType)((Object)freeColClient.getGUI().getChoice(true, null, "Select Lost City Rumour", null, "cancel", rumours));
        tile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
        sTile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
    }

    public static void skipTurns(FreeColClient freeColClient) {
        int skip;
        FreeColServer server = freeColClient.getFreeColServer();
        if (server.getInGameController().getSkippedTurns() > 0) {
            server.getInGameController().setSkippedTurns(0);
            return;
        }
        String response = freeColClient.getGUI().getInput(true, null, StringTemplate.key("menuBar.debug.skipTurns"), Integer.toString(10), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            skip = Integer.parseInt(response);
        }
        catch (NumberFormatException nfe) {
            skip = -1;
        }
        if (skip > 0) {
            freeColClient.skipTurns(skip);
        }
    }

    public static void stepRNG(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        boolean more = true;
        while (more) {
            int val = server.getInGameController().stepRandom();
            more = gui.confirm(true, null, StringTemplate.template("menuBar.debug.randomValue").addAmount("%value%", val), null, "more", "cancel");
        }
    }

    public static void summarizeSettlement(FreeColClient freeColClient, IndianSettlement is) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        AIMain aiMain = server.getAIMain();
        Specification sSpec = sGame.getSpecification();
        IndianSettlement sis = sGame.getFreeColGameObject(is.getId(), IndianSettlement.class);
        LogBuilder lb = new LogBuilder(256);
        lb.add(sis.getName(), "\n\nAlarm\n");
        Player mostHated = sis.getMostHated();
        for (Player p : sGame.getLiveEuropeanPlayers(null)) {
            Tension tension = sis.getAlarm(p);
            lb.add(new Object[]{Messages.message(p.getNationName()), " ", tension == null ? "(none)" : Integer.toString(tension.getValue()), mostHated == p ? " (most hated)" : "", " ", Messages.message(sis.getShortAlarmLevelMessageId(p)), " ", sis.getContactLevel(p), "\n"});
        }
        lb.add("\nGoods Present\n");
        for (Goods goods : sis.getCompactGoods()) {
            lb.add(Messages.message(goods.getLabel(true)), "\n");
        }
        lb.add("\nGoods Production\n");
        for (GoodsType type : sSpec.getGoodsTypeList()) {
            int prod = sis.getTotalProductionOf(type);
            if (prod <= 0) continue;
            lb.add(Messages.getName(type), " ", prod, "\n");
        }
        lb.add("\nPrices (buy 1/100 / sell 1/100)\n");
        GoodsType[] wanted = sis.getWantedGoods();
        for (GoodsType type : sSpec.getGoodsTypeList()) {
            int i;
            if (!type.isStorable()) continue;
            for (i = wanted.length - 1; i >= 0 && type != wanted[i]; --i) {
            }
            lb.add(Messages.getName(type), ": ", sis.getPriceToBuy(type, 1), "/", sis.getPriceToBuy(type, 100), " / ", sis.getPriceToSell(type, 1), "/", sis.getPriceToSell(type, 100), i < 0 ? "" : " wanted[" + Integer.toString(i) + "]", "\n");
        }
        lb.add("\nUnits present\n");
        for (Unit u : sis.getUnitList()) {
            Mission m = aiMain.getAIUnit(u).getMission();
            lb.add(u, " at ", u.getLocation());
            if (m != null) {
                lb.add(" ", m.getClass(), ".");
            }
            lb.add("\n");
        }
        lb.add("\nUnits owned\n");
        for (Unit u : sis.getOwnedUnits()) {
            Mission m = aiMain.getAIUnit(u).getMission();
            lb.add(u, " at ", u.getLocation());
            if (m != null) {
                lb.add(" ", m.getClass(), ".");
            }
            lb.add("\n");
        }
        lb.add("\nTiles\n");
        for (Tile t : sis.getOwnedTiles()) {
            lb.add(t, "\n");
        }
        lb.add("\nConvert Progress = ", sis.getConvertProgress());
        lb.add("\nLast Tribute = ", sis.getLastTribute());
        freeColClient.getGUI().showInformationMessage(lb.toString());
    }

    public static void useAI(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        Player player = freeColClient.getMyPlayer();
        AIMain aiMain = server.getAIMain();
        AIPlayer ap = aiMain.getAIPlayer(player);
        ap.setDebuggingConnection(freeColClient.askServer().getConnection());
        ap.startWorking();
        freeColClient.getConnectController().reconnect();
    }
}

