/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import net.sf.freecol.client.gui.ImageLibrary;

public class FreeColToolTipUI
extends BasicToolTipUI {
    private static FreeColToolTipUI sharedInstance = new FreeColToolTipUI();
    private static FontRenderContext frc = new FontRenderContext(null, true, false);
    private static int margin = 5;
    private static int maximumWidth = 300;
    private static int LEADING = 5;
    private static final Pattern lineBreak = Pattern.compile("\n");

    private FreeColToolTipUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public static void setMaximumWidth(int width) {
        maximumWidth = width;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            ImageLibrary.drawTiledImage("background.FreeColToolTip", g, c, null);
        }
        g.setColor(Color.BLACK);
        Graphics2D graphics = (Graphics2D)g;
        float x = margin;
        float y = margin;
        for (String line : lineBreak.split(((JToolTip)c).getTipText())) {
            if (line.isEmpty()) {
                y += (float)LEADING;
                continue;
            }
            AttributedCharacterIterator styledText = new AttributedString(line).getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
            while (measurer.getPosition() < styledText.getEndIndex()) {
                TextLayout layout = measurer.nextLayout(maximumWidth);
                float dx = layout.isLeftToRight() ? 0.0f : (float)maximumWidth - layout.getAdvance();
                layout.draw(graphics, x + dx, y += layout.getAscent());
                y += layout.getDescent() + layout.getLeading();
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null || tipText.isEmpty()) {
            return new Dimension(0, 0);
        }
        float x = 0.0f;
        float y = 0.0f;
        for (String line : lineBreak.split(tipText)) {
            if (line.isEmpty()) {
                y += (float)LEADING;
                continue;
            }
            AttributedCharacterIterator styledText = new AttributedString(line).getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
            while (measurer.getPosition() < styledText.getEndIndex()) {
                TextLayout layout = measurer.nextLayout(maximumWidth);
                x = Math.max(x, layout.getVisibleAdvance());
                y += layout.getAscent() + layout.getDescent() + layout.getLeading();
            }
        }
        return new Dimension((int)(x + (float)(2 * margin)), (int)(y + (float)(2 * margin)));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

