/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

public class WorkProductionPanel
extends FreeColPanel {
    private final Turn turn = this.getGame().getTurn();

    public WorkProductionPanel(FreeColClient freeColClient, Unit unit) {
        super(freeColClient, new MigLayout("wrap 3, insets 10 10 10 10", "[]30:push[right][]", ""));
        ImageLibrary lib = this.getGUI().getImageLibrary();
        Colony colony = unit.getColony();
        UnitType unitType = unit.getType();
        WorkLocation wl = (WorkLocation)unit.getLocation();
        GoodsType workType = unit.getWorkType();
        List<Modifier> attendedModifiers = wl.getProductionModifiers(workType, unitType);
        List<Modifier> unattendedModifiers = wl.getProductionModifiers(workType, null);
        String shortName = "";
        String longName = "";
        Image image = null;
        float result = wl.getBaseProduction(wl.getProductionType(), workType, unitType);
        if (wl instanceof ColonyTile) {
            ColonyTile colonyTile = (ColonyTile)wl;
            Tile tile = colonyTile.getWorkTile();
            TileType tileType = tile.getType();
            shortName = Messages.getName(tileType);
            longName = Messages.message(colonyTile.getLabel());
            Image terrain = lib.getTerrainImage(tileType, tile.getX(), tile.getY());
            image = new BufferedImage(terrain.getWidth(null), terrain.getHeight(null), 2);
            this.getGUI().displayColonyTile((Graphics2D)image.getGraphics(), tile, colony);
        } else if (wl instanceof Building) {
            Building building = (Building)wl;
            longName = shortName = Messages.getName(building.getType());
            image = lib.getBuildingImage(building);
        } else {
            throw new IllegalStateException("WorkLocation OO fail.");
        }
        this.add((Component)new JLabel(longName), "span, align center, wrap 30");
        this.add(new JLabel(new ImageIcon(image)));
        this.add((Component)new UnitLabel(this.getFreeColClient(), unit, false, false), "wrap");
        this.add(new JLabel(shortName));
        this.add(new JLabel(ModifierFormat.format(result)));
        Collections.sort(attendedModifiers);
        this.output(attendedModifiers, unitType);
        result = wl.getPotentialProduction(workType, unitType);
        if (result < 0.0f) {
            this.add((Component)GUI.localizedLabel("model.source.zeroThreshold.name"), "newline");
            this.add((Component)new JLabel(ModifierFormat.format(-result)), "wrap 30");
            result = 0.0f;
        }
        Font bigFont = this.getFont().deriveFont(1, 16.0f);
        JLabel finalLabel = GUI.localizedLabel("model.source.finalResult.name");
        finalLabel.setFont(bigFont);
        this.add((Component)finalLabel, "newline");
        JLabel finalResult = new JLabel(ModifierFormat.format(result));
        finalResult.setFont(bigFont);
        finalResult.setBorder(GUI.PRODUCTION_BORDER);
        this.add((Component)finalResult, "wrap 30");
        if (wl instanceof Building && (result = (float)wl.getBaseProduction(null, workType, null)) > 0.0f) {
            this.add(GUI.localizedLabel(wl.getLabel()));
            this.add((Component)new JLabel(ModifierFormat.format(result)), "wrap 30");
            Collections.sort(unattendedModifiers);
            this.output(unattendedModifiers, unitType);
        }
        this.add((Component)this.okButton, "newline, span, tag ok");
        this.setSize(this.getPreferredSize());
    }

    private void output(List<Modifier> modifiers, UnitType unitType) {
        for (Modifier m : modifiers) {
            JLabel[] mLabels = ModifierFormat.getModifierLabels(m, unitType, this.turn);
            for (int i = 0; i < mLabels.length; ++i) {
                if (mLabels[i] == null) continue;
                if (i == 0) {
                    this.add((Component)mLabels[i], "newline");
                    continue;
                }
                this.add(mLabels[i]);
            }
        }
    }
}

