/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColDialog;

public final class SaveDialog
extends FreeColDialog<File> {
    private static final File cancelFile = new File(".");

    public SaveDialog(FreeColClient freeColClient, File directory, FileFilter[] fileFilters, String defaultName, final String ext) {
        super(freeColClient);
        final JFileChooser fileChooser = new JFileChooser(directory);
        if (fileFilters.length > 0) {
            for (FileFilter fileFilter : fileFilters) {
                fileChooser.addChoosableFileFilter(fileFilter);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setDialogType(1);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setSelectedFile(new File(defaultName));
        fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if ("ApproveSelection".equals(cmd)) {
                    File file = fileChooser.getSelectedFile();
                    if (!file.getName().endsWith(ext)) {
                        file = new File(file.getAbsolutePath() + ext);
                    }
                    SaveDialog.this.setValue(file);
                } else {
                    SaveDialog.this.setValue(cancelFile);
                }
            }
        });
        List c = SaveDialog.choices();
        this.initializeDialog(FreeColDialog.DialogType.QUESTION, true, fileChooser, null, c);
    }

    @Override
    public File getResponse() {
        if (this.responded()) {
            File value = (File)this.getValue();
            return value == cancelFile ? null : value;
        }
        return null;
    }
}

