/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.TypeCountMap;

public final class ReportProductionPanel
extends ReportPanel {
    private static final int NUMBER_OF_GOODS = 4;
    private final List<GoodsType> goodsTypes;
    private final List<JComboBox<String>> boxes = new ArrayList<JComboBox<String>>();

    public ReportProductionPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportProductionAction");
        this.goodsTypes = new ArrayList<GoodsType>();
        ArrayList<String> goodsNames = new ArrayList<String>();
        goodsNames.add(Messages.message("nothing"));
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (goodsType.isFarmed()) continue;
            this.goodsTypes.add(goodsType);
            goodsNames.add(Messages.getName(goodsType));
        }
        String[] model = goodsNames.toArray(new String[0]);
        for (int index = 0; index < 4; ++index) {
            JComboBox<String> newBox = new JComboBox<String>(model);
            newBox.setSelectedIndex(0);
            this.boxes.add(newBox);
        }
        this.reportPanel.setLayout(new MigLayout("gap 0 0", "[fill]", "[fill]"));
        this.update();
    }

    private void update() {
        this.reportPanel.removeAll();
        JLabel selectLabel = GUI.localizedLabel("report.production.selectGoods");
        this.reportPanel.add((Component)selectLabel, "span, split 6");
        JButton selectButton = GUI.localizedButton("report.production.update");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ReportProductionPanel.this.update();
            }
        });
        this.reportPanel.add((Component)selectButton, "wrap 20");
        ArrayList<GoodsType> selectedTypes = new ArrayList<GoodsType>();
        for (int index = 0; index < 4; ++index) {
            JComboBox<String> box = this.boxes.get(index);
            this.reportPanel.add(box);
            int selectedIndex = box.getSelectedIndex();
            if (selectedIndex <= 0) continue;
            selectedTypes.add(this.goodsTypes.get(selectedIndex - 1));
        }
        if (!selectedTypes.isEmpty()) {
            TypeCountMap<BuildingType> buildingCount = new TypeCountMap<BuildingType>();
            ArrayList basicBuildingTypes = new ArrayList();
            for (GoodsType goodsType : selectedTypes) {
                ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
                for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
                    BuildingType firstLevel;
                    if (!goodsType.equals(buildingType.getProducedGoodsType()) && !buildingType.hasModifier(goodsType.getId()) || buildingTypes.contains(firstLevel = buildingType.getFirstLevel())) continue;
                    buildingTypes.add(firstLevel);
                }
                basicBuildingTypes.add(buildingTypes);
            }
            JLabel newLabel = GUI.localizedLabel("Colony");
            newLabel.setBorder(GUI.TOPLEFTCELLBORDER);
            this.reportPanel.add((Component)newLabel, "newline 20");
            for (int index = 0; index < selectedTypes.size(); ++index) {
                newLabel = GUI.localizedLabel(((GoodsType)selectedTypes.get(index)).getNameKey());
                newLabel.setBorder(GUI.TOPCELLBORDER);
                this.reportPanel.add(newLabel);
                for (BuildingType buildingType : (List)basicBuildingTypes.get(index)) {
                    newLabel = GUI.localizedLabel(buildingType.getNameKey());
                    newLabel.setBorder(GUI.TOPCELLBORDER);
                    this.reportPanel.add(newLabel);
                }
            }
            int[] totalProduction = new int[selectedTypes.size()];
            for (Colony colony : this.getFreeColClient().getMySortedColonies()) {
                JButton colonyButton = GUI.getLinkButton(colony.getName(), null, colony.getId());
                colonyButton.setBorder(GUI.LEFTCELLBORDER);
                colonyButton.addActionListener(this);
                this.reportPanel.add((Component)colonyButton, "newline");
                for (int index = 0; index < selectedTypes.size(); ++index) {
                    GoodsType goodsType = (GoodsType)selectedTypes.get(index);
                    int newValue = colony.getNetProductionOf(goodsType);
                    int n = index;
                    totalProduction[n] = totalProduction[n] + newValue;
                    Goods goods = new Goods(colony.getGame(), colony, goodsType, newValue);
                    GoodsLabel goodsLabel = new GoodsLabel(goods, this.getGUI());
                    goodsLabel.setHorizontalAlignment(10);
                    goodsLabel.setBorder(GUI.CELLBORDER);
                    this.reportPanel.add(goodsLabel);
                    for (BuildingType buildingType : (List)basicBuildingTypes.get(index)) {
                        Building building = colony.getBuilding(buildingType);
                        if (building == null) {
                            newLabel = new JLabel();
                            newLabel.setBorder(GUI.CELLBORDER);
                            this.reportPanel.add(newLabel);
                            continue;
                        }
                        buildingCount.incrementCount(building.getType(), 1);
                        BuildingPanel buildingPanel = new BuildingPanel(this.getFreeColClient(), building);
                        buildingPanel.setBorder(GUI.CELLBORDER);
                        buildingPanel.initialize();
                        this.reportPanel.add(buildingPanel);
                    }
                }
            }
        }
        this.revalidate();
        this.repaint();
    }
}

