/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ReportUnitPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportNavalPanel
extends ReportUnitPanel {
    public ReportNavalPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportNavalAction", false);
    }

    @Override
    protected void addREFUnits() {
        Player player = this.getMyPlayer();
        Specification spec = this.getSpecification();
        this.reportPanel.add((Component)new JLabel(Messages.getName(player.getNation().getREFNation())), "span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<AbstractUnit> refUnits = this.igc().getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit unit : refUnits) {
                if (!unit.getType(spec).hasAbility("model.ability.navalUnit")) continue;
                this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
            }
        }
    }

    @Override
    protected void addOwnUnits() {
        Player player = this.getMyPlayer();
        this.reportPanel.add((Component)GUI.localizedLabel(StringTemplate.template("report.military.forces").addStringTemplate("%nation%", player.getNationName())), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isAvailableTo(player) || !unitType.hasAbility("model.ability.navalUnit")) continue;
            AbstractUnit unit = new AbstractUnit(unitType, "model.role.default", this.getCount("naval", unitType));
            this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
        }
    }

    @Override
    protected void gatherData() {
        for (Unit unit : this.getMyPlayer().getUnits()) {
            if (!unit.isNaval()) continue;
            this.addUnit(unit, "naval");
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(750, 600);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

