/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.text.DateFormat;
import java.util.List;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;

public final class ReportHighScoresPanel
extends ReportPanel {
    public ReportHighScoresPanel(FreeColClient freeColClient, String prefix, List<HighScore> highScores) {
        super(freeColClient, "reportHighScoresAction");
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("wrap 3, gapx 30", "[][][align right]", ""));
        if (prefix != null) {
            this.reportPanel.add((Component)GUI.localizedLabel(prefix), "span, wrap 10");
        }
        for (HighScore highScore : highScores) {
            JLabel scoreValue = new JLabel(String.valueOf(highScore.getScore()));
            scoreValue.setFont(GUI.SMALL_HEADER_FONT);
            this.reportPanel.add(scoreValue);
            String messageId = highScore.getIndependenceTurn() > 0 ? "report.highScores.president" : "report.highScores.governor";
            StringTemplate template = StringTemplate.template(messageId).addName("%name%", highScore.getPlayerName()).addName("%nation%", highScore.getNewLandName());
            JLabel headline = GUI.localizedLabel(template);
            headline.setFont(GUI.SMALL_HEADER_FONT);
            this.reportPanel.add((Component)headline, "span, wrap 10");
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.turn"), "skip");
            int retirementTurn = highScore.getRetirementTurn();
            this.reportPanel.add(retirementTurn <= 0 ? GUI.localizedLabel("notApplicable.short") : GUI.localizedLabel(Turn.getLabel(retirementTurn)));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.score"), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getScore())));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.difficulty"), "skip");
            this.reportPanel.add(new JLabel(Messages.getName(highScore.getDifficulty())));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.independence"), "skip");
            int independenceTurn = highScore.getIndependenceTurn();
            this.reportPanel.add(independenceTurn <= 0 ? GUI.localizedLabel("no") : GUI.localizedLabel(Turn.getLabel(independenceTurn)));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.nation"), "skip");
            this.reportPanel.add(new JLabel(highScore.getIndependenceTurn() > 0 ? highScore.getNationName() : highScore.getOldNationNameKey()));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.nationType"), "skip");
            this.reportPanel.add(GUI.localizedLabel(Messages.nameKey(highScore.getNationTypeId())));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.units"), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getUnits())));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.colonies"), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getColonies())));
            this.reportPanel.add((Component)GUI.localizedLabel("report.highScores.retired"), "skip");
            DateFormat format = DateFormat.getDateTimeInstance(2, 3);
            this.reportPanel.add((Component)new JLabel(format.format(highScore.getDate())), "wrap 20");
        }
        this.reportPanel.doLayout();
    }
}

