/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;

public class RebelToolTip
extends JToolTip {
    public RebelToolTip(FreeColClient freeColClient, Colony colony) {
        Specification spec = colony.getSpecification();
        int population = colony.getUnitCount();
        int solPercent = colony.getSoL();
        int rebels = Colony.calculateRebels(population, solPercent);
        Turn turn = colony.getGame().getTurn();
        this.setLayout(new MigLayout("fillx, wrap 3", "[][right][right]", ""));
        this.add(GUI.localizedLabel(StringTemplate.template("colonyPanel.rebelLabel").addName("%number%", "")));
        this.add(new JLabel(Integer.toString(rebels)));
        this.add(new JLabel(solPercent + "%"));
        this.add(GUI.localizedLabel(StringTemplate.template("colonyPanel.royalistLabel").addName("%number%", "")));
        this.add(new JLabel(Integer.toString(population - rebels)));
        this.add(new JLabel(colony.getTory() + "%"));
        Set<Modifier> modifiers = colony.getOwner().getModifiers("model.modifier.liberty");
        int libertyProduction = 0;
        for (GoodsType goodsType : spec.getLibertyGoodsTypeList()) {
            this.add(new JLabel(Messages.getName(goodsType)));
            int production = colony.getNetProductionOf(goodsType);
            libertyProduction += production;
            this.add((Component)new ProductionLabel(freeColClient, goodsType, production), "span 2");
        }
        libertyProduction = (int)FeatureContainer.applyModifiers(libertyProduction, turn, modifiers);
        for (Modifier m : modifiers) {
            JLabel[] labels;
            for (JLabel j : labels = ModifierFormat.getModifierLabels(m, null, turn)) {
                this.add(j);
            }
        }
        boolean capped = spec.getBoolean("model.option.bellAccumulationCapped") && colony.getSoL() >= 100;
        int liberty = colony.getLiberty();
        int modulo = liberty % 200;
        int width = (int)this.getPreferredSize().getWidth() - 32;
        FreeColProgressBar progress = new FreeColProgressBar(freeColClient.getGUI(), null, 0, 200, modulo, capped ? 0 : libertyProduction);
        progress.setPreferredSize(new Dimension(width, 20));
        this.add((Component)progress, "span 3");
        double turnsNext = -1.0;
        double turns100 = -1.0;
        double turns50 = -1.0;
        if (libertyProduction > 0 && !capped) {
            int requiredLiberty = 200 - modulo;
            turnsNext = (double)(1 + requiredLiberty) / (double)libertyProduction;
            requiredLiberty = 200 * colony.getUnitCount();
            if (liberty < requiredLiberty) {
                turns100 = (double)(1 + requiredLiberty - liberty) / (double)libertyProduction;
            }
            if (liberty < (requiredLiberty /= 2)) {
                turns50 = (double)(1 + requiredLiberty - liberty) / (double)libertyProduction;
            }
        }
        String na = Messages.message("notApplicable.short");
        this.add(GUI.localizedLabel("report.nextMember"));
        this.add((Component)new JLabel(turnsNext < 0.0 ? na : Integer.toString((int)Math.ceil(turnsNext))), "skip");
        this.add(GUI.localizedLabel("report.50percent"));
        this.add((Component)new JLabel(turns50 < 0.0 ? na : Integer.toString((int)Math.ceil(turns50))), "skip");
        this.add(GUI.localizedLabel("report.100percent"));
        this.add((Component)new JLabel(turns100 < 0.0 ? na : Integer.toString((int)Math.ceil(turns100))), "skip");
        int grow = colony.getPreferredSizeChange();
        if (grow > 0) {
            this.add(GUI.localizedLabel("report.changeMore"));
            this.add((Component)new JLabel(Integer.toString(grow)), "skip");
        } else if (grow < 0) {
            this.add(GUI.localizedLabel("report.changeLess"));
            this.add((Component)new JLabel(Integer.toString(-grow)), "skip");
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(350, 250);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.setLayout(null);
    }
}

