/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColorCellEditor;
import net.sf.freecol.client.gui.panel.ColorCellRenderer;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;

public final class PlayersTable
extends JTable {
    public static final int NATION_COLUMN = 0;
    public static final int AVAILABILITY_COLUMN = 1;
    public static final int ADVANTAGE_COLUMN = 2;
    public static final int COLOR_COLUMN = 3;
    public static final int PLAYER_COLUMN = 4;
    private static final String[] columnNames = new String[]{Messages.message("nation"), Messages.message("availability"), Messages.message("advantage"), Messages.message("color"), Messages.message("player")};
    private final ImageLibrary library;

    public PlayersTable(FreeColClient freeColClient, NationOptions nationOptions, Player myPlayer) {
        final GUI gui = freeColClient.getGUI();
        Specification spec = freeColClient.getGame().getSpecification();
        this.library = gui.getImageLibrary();
        this.setModel(new PlayersTableModel(freeColClient.getPreGameController(), nationOptions, myPlayer));
        this.setRowHeight(47);
        JButton nationButton = GUI.localizedButton("nation");
        nationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                gui.showColopediaPanel(ColopediaAction.PanelType.NATIONS.toString());
            }
        });
        JLabel availabilityLabel = GUI.localizedLabel("availability");
        JButton advantageButton = GUI.localizedButton("advantage");
        advantageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                gui.showColopediaPanel(ColopediaAction.PanelType.NATION_TYPES.toString());
            }
        });
        JLabel colorLabel = GUI.localizedLabel("color");
        JLabel playerLabel = GUI.localizedLabel("player");
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setOpaque(false);
        HeaderRenderer renderer = new HeaderRenderer(nationButton, availabilityLabel, advantageButton, colorLabel, playerLabel);
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(new HeaderListener(header, renderer));
        TableColumn nationColumn = this.getColumnModel().getColumn(0);
        nationColumn.setCellRenderer(new NationCellRenderer());
        nationColumn.setHeaderRenderer(renderer);
        TableColumn availableColumn = this.getColumnModel().getColumn(1);
        availableColumn.setCellRenderer(new AvailableCellRenderer());
        availableColumn.setCellEditor(new AvailableCellEditor());
        TableColumn advantagesColumn = this.getColumnModel().getColumn(2);
        switch (nationOptions.getNationalAdvantages()) {
            case SELECTABLE: {
                advantagesColumn.setCellEditor(new AdvantageCellEditor(spec.getEuropeanNationTypes()));
                break;
            }
            case FIXED: {
                break;
            }
            case NONE: {
                spec.clearEuropeanNationalAdvantages();
                break;
            }
        }
        advantagesColumn.setCellRenderer(new AdvantageCellRenderer(nationOptions.getNationalAdvantages()));
        advantagesColumn.setHeaderRenderer(renderer);
        TableColumn colorsColumn = this.getColumnModel().getColumn(3);
        colorsColumn.setCellRenderer(new ColorCellRenderer(true));
        colorsColumn.setCellEditor(new ColorCellEditor(freeColClient));
        TableColumn playerColumn = this.getColumnModel().getColumn(4);
        playerColumn.setCellEditor(new PlayerCellEditor());
        playerColumn.setCellRenderer(new PlayerCellRenderer());
    }

    public void update() {
        ((PlayersTableModel)this.getModel()).update();
    }

    private static class PlayersTableModel
    extends AbstractTableModel {
        private final PreGameController preGameController;
        private NationOptions nationOptions;
        private Player thisPlayer;
        private List<Nation> nations;
        private Map<Nation, Player> players;

        public PlayersTableModel(PreGameController preGameController, NationOptions nationOptions, Player thisPlayer) {
            this.preGameController = preGameController;
            this.nationOptions = nationOptions;
            this.thisPlayer = thisPlayer;
            this.nations = new ArrayList<Nation>();
            this.players = new HashMap<Nation, Player>();
            for (Nation nation : thisPlayer.getSpecification().getNations()) {
                NationOptions.NationState state;
                if (nation.isUnknownEnemy() || (state = nationOptions.getNations().get(nation)) == null) continue;
                this.nations.add(nation);
                this.players.put(nation, null);
            }
            this.players.put(thisPlayer.getNation(), thisPlayer);
        }

        public void update() {
            for (Nation nation : this.nations) {
                this.players.put(nation, null);
            }
            for (Player player : this.thisPlayer.getGame().getLivePlayers(null)) {
                this.players.put(player.getNation(), player);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Nation.class;
                }
                case 1: {
                    return NationOptions.NationState.class;
                }
                case 2: {
                    return NationType.class;
                }
                case 3: {
                    return Color.class;
                }
                case 4: {
                    return Player.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.nations.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= 0 && row < this.getRowCount() && column >= 0 && column < this.getColumnCount()) {
                Nation nation = this.nations.get(row);
                switch (column) {
                    case 0: {
                        return nation;
                    }
                    case 1: {
                        return this.nationOptions.getNationState(nation);
                    }
                    case 2: {
                        return this.players.get(nation) == null ? nation.getType() : this.players.get(nation).getNationType();
                    }
                    case 3: {
                        return nation.getColor();
                    }
                    case 4: {
                        return this.players.get(nation);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (row >= 0 && row < this.getRowCount()) {
                Nation nation = this.nations.get(row);
                boolean ownRow = this.thisPlayer == this.players.get(nation) && !this.thisPlayer.isReady();
                switch (column) {
                    case 1: {
                        return !ownRow && this.thisPlayer.isAdmin();
                    }
                    case 2: {
                        return nation.getType() instanceof EuropeanNationType && ownRow;
                    }
                    case 3: {
                        return nation.getType() instanceof EuropeanNationType;
                    }
                    case 4: {
                        return nation.getType() instanceof EuropeanNationType && this.players.get(nation) == null;
                    }
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row >= 0 && row < this.getRowCount() && column > 0 && column < this.getColumnCount()) {
                Nation nation = this.nations.get(row);
                switch (column) {
                    case 2: {
                        this.preGameController.setNationType((NationType)value);
                        break;
                    }
                    case 1: {
                        this.preGameController.setAvailable(this.nations.get(row), (NationOptions.NationState)((Object)value));
                        this.update();
                        break;
                    }
                    case 3: {
                        this.preGameController.setColor(nation, (Color)value);
                        break;
                    }
                    case 4: {
                        if (this.nationOptions.getNationState(nation) != NationOptions.NationState.AVAILABLE) break;
                        this.preGameController.setNation(nation);
                        this.preGameController.setNationType(nation.getType());
                        this.update();
                        break;
                    }
                }
                this.fireTableCellUpdated(row, column);
            }
        }
    }

    private final class PlayerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JButton button = GUI.localizedButton("select");

        public PlayerCellEditor() {
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayerCellEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return Boolean.TRUE;
        }
    }

    private static class PlayerCellRenderer
    implements TableCellRenderer {
        private JLabel label = new JLabel();
        private JButton button = GUI.localizedButton("select");

        public PlayerCellRenderer() {
            this.label.setHorizontalAlignment(0);
            GUI.padBorder(this.button, 5, 10, 5, 10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Player player = (Player)value;
            if (player == null) {
                NationOptions.NationState nationState;
                NationType nationType = (NationType)table.getValueAt(row, 2);
                if (nationType instanceof EuropeanNationType && (nationState = (NationOptions.NationState)((Object)table.getValueAt(row, 1))) == NationOptions.NationState.AVAILABLE) {
                    return this.button;
                }
                Nation nation = (Nation)table.getValueAt(row, 0);
                this.label.setText(nation.getRulerName());
            } else {
                this.label.setText(player.getName());
            }
            return this.label;
        }
    }

    private static class NationStateRenderer
    extends JLabel
    implements ListCellRenderer<NationOptions.NationState> {
        private NationStateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends NationOptions.NationState> list, NationOptions.NationState value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(Messages.message("nationState." + (Object)((Object)value)));
            return this;
        }
    }

    private class NationCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private NationCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Nation nation = (Nation)value;
            this.setText(Messages.getName(nation));
            PlayersTable.this.library;
            this.setIcon(new ImageIcon(ImageLibrary.getCoatOfArmsImage(nation, 0.5)));
            return this;
        }
    }

    private static class HeaderRenderer
    implements TableCellRenderer {
        private static final int NO_COLUMN = -1;
        private int pressedColumn = -1;
        private Component[] components;

        public HeaderRenderer(Component ... components) {
            this.components = components;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.components[column] instanceof JButton) {
                boolean isPressed = column == this.pressedColumn;
                ((JButton)this.components[column]).getModel().setPressed(isPressed);
                ((JButton)this.components[column]).getModel().setArmed(isPressed);
            }
            return this.components[column];
        }

        public void setPressedColumn(int column) {
            this.pressedColumn = column;
        }
    }

    private static class HeaderListener
    extends MouseAdapter {
        private JTableHeader header;
        private HeaderRenderer renderer;

        public HeaderListener(JTableHeader header, HeaderRenderer renderer) {
            this.header = header;
            this.renderer = renderer;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int col = this.header.columnAtPoint(e.getPoint());
            this.renderer.setPressedColumn(col);
            this.header.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }

    private final class AvailableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox<NationOptions.NationState> aiStateBox = new JComboBox<NationOptions.NationState>(new NationOptions.NationState[]{NationOptions.NationState.AI_ONLY, NationOptions.NationState.NOT_AVAILABLE});
        private JComboBox<NationOptions.NationState> allStateBox = new JComboBox<NationOptions.NationState>(NationOptions.NationState.values());
        private JComboBox activeBox;
        private ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvailableCellEditor.this.stopCellEditing();
            }
        };

        public AvailableCellEditor() {
            this.aiStateBox.setRenderer(new NationStateRenderer());
            this.aiStateBox.addActionListener(this.listener);
            this.allStateBox.setRenderer(new NationStateRenderer());
            this.allStateBox.addActionListener(this.listener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            NationType nationType = ((Nation)PlayersTable.this.getValueAt(row, 0)).getType();
            this.activeBox = nationType instanceof EuropeanNationType ? this.allStateBox : this.aiStateBox;
            return this.activeBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.activeBox.getSelectedItem();
        }
    }

    private static class AvailableCellRenderer
    implements TableCellRenderer {
        private JComboBox<NationOptions.NationState> box = new JComboBox<NationOptions.NationState>(NationOptions.NationState.values());

        public AvailableCellRenderer() {
            this.box.setRenderer(new NationStateRenderer());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.box.setSelectedItem(value);
            return this.box;
        }
    }

    private class AdvantageCellRenderer
    implements TableCellRenderer {
        private NationOptions.Advantages advantages;

        public AdvantageCellRenderer(NationOptions.Advantages advantages) {
            this.advantages = advantages;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label;
            Player player = (Player)table.getValueAt(row, 4);
            NationType nationType = ((Nation)table.getValueAt(row, 0)).getType();
            switch (this.advantages) {
                case SELECTABLE: {
                    return new JLabel(Messages.getName(player == null ? nationType : player.getNationType()));
                }
                case FIXED: {
                    label = new JLabel(Messages.getName(nationType));
                    break;
                }
                default: {
                    label = new JLabel(Messages.getName("model.nationType.none"));
                }
            }
            if (player != null && player.isReady()) {
                label.setForeground(Color.GRAY);
            } else {
                label.setForeground(table.getForeground());
            }
            label.setBackground(table.getBackground());
            return label;
        }
    }

    private class AdvantageCellEditor
    extends DefaultCellEditor {
        private final JComboBox<EuropeanNationType> box;

        private AdvantageCellEditor(JComboBox<EuropeanNationType> box) {
            super(box);
            this.box = box;
        }

        public AdvantageCellEditor(List<EuropeanNationType> nationTypes) {
            this(new JComboBox<EuropeanNationType>(nationTypes.toArray(new EuropeanNationType[0])));
            this.box.setRenderer(new FreeColComboBoxRenderer());
        }

        @Override
        public Object getCellEditorValue() {
            return ((JComboBox)this.getComponent()).getSelectedItem();
        }
    }
}

