/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.StringTemplate;

public final class MonarchDialog
extends FreeColDialog<Boolean> {
    public MonarchDialog(FreeColClient freeColClient, Monarch.MonarchAction action, StringTemplate template, String monarchKey) {
        super(freeColClient);
        String noId;
        ImageLibrary lib = freeColClient.getGUI().getImageLibrary();
        String messageId = "model.monarch.action." + (Object)((Object)action);
        if (!Messages.containsKey(messageId)) {
            throw new IllegalStateException("Unrecognized monarch action: " + (Object)((Object)action));
        }
        String yesId = messageId + ".yes";
        if (!Messages.containsKey(yesId)) {
            yesId = null;
        }
        if (!Messages.containsKey(noId = messageId + ".no")) {
            noId = "close";
        }
        String hdrKey = action == Monarch.MonarchAction.HESSIAN_MERCENARIES ? "monarchDialog.header.fromHessians" : "monarchDialog.header.fromCrown";
        String hdr = Messages.message(hdrKey);
        JTextArea header = GUI.getDefaultTextArea(hdr);
        header.setFont(GUI.MEDIUM_HEADER_FONT);
        MigPanel panel = new MigPanel(new MigLayout("wrap 2, insets 10", "[]20[]"));
        panel.add((Component)header, "span, align center, wrap 20");
        if (action == Monarch.MonarchAction.RAISE_TAX_ACT || action == Monarch.MonarchAction.RAISE_TAX_WAR) {
            JButton helpButton = GUI.localizedButton("help");
            helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonarchDialog.this.getGUI().showColopediaPanel("colopedia.concepts.taxes");
                }
            });
            panel.add((Component)helpButton, "tag help");
        }
        JTextArea text = GUI.getDefaultTextArea(template == null ? Messages.message(messageId) : Messages.message(new StringTemplate(messageId, template)), 30);
        panel.add(text);
        panel.setSize(panel.getPreferredSize());
        List c = MonarchDialog.choices();
        if (yesId != null) {
            c.add(new ChoiceItem<Boolean>(Messages.message(yesId), Boolean.TRUE).okOption());
        }
        c.add(new ChoiceItem<Boolean>(Messages.message(noId), Boolean.FALSE).cancelOption().defaultOption());
        this.initializeDialog(FreeColDialog.DialogType.QUESTION, false, panel, lib.getMiscImageIcon(monarchKey), c);
    }
}

