/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColInputDialog;
import net.sf.freecol.client.gui.panel.MigPanel;

public final class MapSizeDialog
extends FreeColInputDialog<Dimension> {
    private static final int COLUMNS = 5;
    private static final int DEFAULT_HEIGHT = 100;
    private static final int DEFAULT_WIDTH = 40;
    private JTextField inputWidth = new JTextField(Integer.toString(40), 5);
    private JTextField inputHeight = new JTextField(Integer.toString(100), 5);

    public MapSizeDialog(FreeColClient freeColClient) {
        super(freeColClient);
        JLabel widthLabel = GUI.localizedLabel("width");
        widthLabel.setLabelFor(this.inputWidth);
        JLabel heightLabel = GUI.localizedLabel("height");
        heightLabel.setLabelFor(this.inputHeight);
        MigPanel panel = new MigPanel(new MigLayout("wrap 2"));
        panel.add((Component)GUI.localizedLabel("editor.mapSize"), "span, align center");
        panel.add((Component)widthLabel, "newline 20");
        panel.add(this.inputWidth);
        panel.add(heightLabel);
        panel.add(this.inputHeight);
        this.initializeInputDialog(true, panel, null, "ok", "cancel");
    }

    @Override
    protected Dimension getInputValue() {
        int height;
        int width;
        try {
            width = Integer.parseInt(this.inputWidth.getText());
            height = Integer.parseInt(this.inputHeight.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return width <= 0 || height <= 0 ? null : new Dimension(width, height);
    }

    @Override
    public void requestFocus() {
        this.inputWidth.requestFocus();
    }
}

