/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.i18n.Messages;

public final class LoadDialog
extends FreeColDialog<File> {
    private static final File cancelFile = new File("");

    public LoadDialog(FreeColClient freeColClient, File directory, FileFilter[] fileFilters) {
        super(freeColClient);
        JFileChooser fileChooser = new JFileChooser(directory);
        if (fileFilters.length > 0) {
            for (FileFilter fileFilter : fileFilters) {
                fileChooser.addChoosableFileFilter(fileFilter);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setControlButtonsAreShown(true);
        fileChooser.setApproveButtonText(Messages.message("ok"));
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileHidingEnabled(false);
        fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                File value = "ApproveSelection".equals(cmd) ? ((JFileChooser)event.getSource()).getSelectedFile() : cancelFile;
                LoadDialog.this.setValue(value);
            }
        });
        List c = LoadDialog.choices();
        this.initializeDialog(FreeColDialog.DialogType.QUESTION, true, fileChooser, null, c);
    }

    @Override
    public File getResponse() {
        File value = (File)this.getValue();
        return value == cancelFile ? null : value;
    }
}

