/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.resources.ResourceManager;

public class InformationPanel
extends FreeColPanel {
    public InformationPanel(FreeColClient freeColClient, String text, FreeColObject fco, ImageIcon image) {
        this(freeColClient, new String[]{text}, new FreeColObject[]{fco}, new ImageIcon[]{image});
    }

    public InformationPanel(FreeColClient freeColClient, String[] texts, FreeColObject[] fcos, ImageIcon[] images) {
        super(freeColClient, new MigLayout("wrap 1, insets 200 10 10 10", "[510]", "[242]20[20]"));
        final GUI gui = this.getGUI();
        MigPanel textPanel = new MigPanel();
        textPanel.setOpaque(false);
        textPanel.setLayout(new MigLayout("wrap 2", "", ""));
        for (int i = 0; i < texts.length; ++i) {
            StringTemplate disp;
            if (images != null && images[i] != null) {
                textPanel.add(new JLabel(images[i]));
                textPanel.add(GUI.getDefaultTextArea(texts[i], 30));
            } else {
                textPanel.add((Component)GUI.getDefaultTextArea(texts[i], 30), "skip");
            }
            StringTemplate stringTemplate = disp = fcos == null ? null : this.displayLabel(fcos[i]);
            if (disp == null) continue;
            JButton button = GUI.localizedButton(StringTemplate.template("informationPanel.display").addStringTemplate("%object%", disp));
            final FreeColObject fco = fcos[i];
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InformationPanel.this.displayFCO(gui, fco);
                }
            });
            textPanel.add((Component)button, "skip");
        }
        JScrollPane scrollPane = new JScrollPane(textPanel, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.setBorder(null);
        this.add(scrollPane);
        this.add((Component)this.okButton, "tag ok");
    }

    private StringTemplate displayLabel(FreeColObject fco) {
        return fco instanceof Colony ? (this.getMyPlayer().owns((Colony)fco) ? ((Colony)fco).getLocationLabel() : null) : (fco instanceof Europe ? ((Europe)fco).getLocationLabel() : (fco instanceof IndianSettlement ? ((IndianSettlement)fco).getLocationLabel() : (fco instanceof Tile ? (((Tile)fco).hasSettlement() ? this.displayLabel(((Tile)fco).getSettlement()) : StringTemplate.template("tile").addAmount("%x%", ((Tile)fco).getX()).addAmount("%y%", ((Tile)fco).getY())) : (fco instanceof Unit ? this.displayLabel((FreeColObject)((Object)((Unit)fco).getLocation())) : (fco instanceof WorkLocation ? ((WorkLocation)fco).getColony().getLocationLabel() : null)))));
    }

    private void displayFCO(GUI gui, FreeColObject fco) {
        if (fco instanceof Colony) {
            gui.showColonyPanel((Colony)fco, null);
        } else if (fco instanceof Europe) {
            gui.showEuropePanel();
        } else if (fco instanceof IndianSettlement) {
            gui.showIndianSettlementPanel((IndianSettlement)fco);
        } else if (fco instanceof Tile) {
            gui.setFocus((Tile)fco);
        } else if (fco instanceof Unit) {
            this.displayFCO(gui, (FreeColObject)((Object)((Unit)fco).getLocation()));
        } else if (fco instanceof WorkLocation) {
            gui.showColonyPanel(((WorkLocation)fco).getColony(), null);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(ResourceManager.getImage("InformationPanel.backgroundImage"), 0, 0, this);
    }
}

