/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.i18n.Messages;

public abstract class FreeColInputDialog<T>
extends FreeColDialog<T> {
    private static final Logger logger = Logger.getLogger(FreeColInputDialog.class.getName());

    protected FreeColInputDialog(FreeColClient freeColClient) {
        super(freeColClient);
    }

    public FreeColInputDialog(FreeColClient freeColClient, boolean modal, Object obj, ImageIcon icon, String okKey, String cancelKey) {
        this(freeColClient);
        this.initializeInputDialog(modal, obj, icon, okKey, cancelKey);
    }

    protected final void initializeInputDialog(boolean modal, Object obj, ImageIcon icon, String okKey, String cancelKey) {
        List c = FreeColInputDialog.choices();
        c.add(new ChoiceItem<Object>(Messages.message(okKey), null).okOption());
        if (cancelKey != null) {
            c.add(new ChoiceItem<Object>(Messages.message(cancelKey), null).cancelOption().defaultOption());
        }
        this.initializeDialog(FreeColDialog.DialogType.QUESTION, modal, obj, icon, c);
    }

    @Override
    public T getResponse() {
        Object value;
        if (this.responded() && (value = this.getValue()) == this.options.get(0)) {
            return this.getInputValue();
        }
        return (T)((Object)null);
    }

    protected abstract T getInputValue();
}

