/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public final class EndTurnDialog
extends FreeColConfirmDialog {
    private static final Logger logger = Logger.getLogger(EndTurnDialog.class.getName());
    private JList<UnitWrapper> unitList;

    public EndTurnDialog(FreeColClient freeColClient, List<Unit> units) {
        super(freeColClient);
        Player player = this.getMyPlayer();
        String endName = Messages.message("endTurnDialog.name");
        JLabel header = GUI.getDefaultHeader(endName);
        StringTemplate template = StringTemplate.template("endTurnDialog.areYouSure").addAmount("%number%", units.size());
        JTextArea text = GUI.getDefaultTextArea(template);
        DefaultListModel<UnitWrapper> model = new DefaultListModel<UnitWrapper>();
        for (Unit unit : units) {
            model.addElement(new UnitWrapper(unit));
        }
        this.unitList = new JList(model);
        this.unitList.setCellRenderer(new UnitCellRenderer());
        this.unitList.setFixedCellHeight(48);
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.unitList.getActionMap().put("select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EndTurnDialog.this.selectUnit();
            }
        });
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.unitList.getActionMap().put("quit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EndTurnDialog.this.setValue(EndTurnDialog.this.options.get(1));
            }
        });
        this.unitList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                EndTurnDialog.this.selectUnit();
            }
        });
        JScrollPane listScroller = new JScrollPane(this.unitList);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1, fill", "[400, align center]"));
        panel.add(header);
        panel.add((Component)text, "newline 20");
        panel.add((Component)listScroller, "newline 10");
        panel.setSize(panel.getPreferredSize());
        ImageIcon icon = this.getImageLibrary().getImageIcon(player, false);
        this.initializeConfirmDialog(false, panel, icon, "ok", "cancel");
    }

    private void selectUnit() {
        UnitWrapper wrapper = this.unitList.getSelectedValue();
        if (wrapper != null && wrapper.unit != null) {
            if (wrapper.unit.isInEurope()) {
                this.getGUI().showEuropePanel();
            } else {
                this.getGUI().setActiveUnit(wrapper.unit);
                if (wrapper.unit.getColony() != null) {
                    this.getGUI().showColonyPanel(wrapper.unit.getColony(), wrapper.unit);
                } else if (wrapper.unit.hasTile()) {
                    this.getGUI().setFocus(wrapper.unit.getTile());
                }
            }
        }
    }

    private class UnitCellRenderer
    implements ListCellRenderer<UnitWrapper> {
        private JPanel itemPanel = new MigPanel();
        private JPanel selectedPanel = new MigPanel();
        private JLabel imageLabel = new JLabel();
        private JLabel nameLabel = new JLabel();
        private JLabel locationLabel = new JLabel();

        public UnitCellRenderer() {
            this.itemPanel.setOpaque(false);
            this.itemPanel.setLayout(new MigLayout("", "[60]"));
            this.selectedPanel.setOpaque(false);
            this.selectedPanel.setLayout(new MigLayout("", "[60]"));
            this.selectedPanel.setUI((PanelUI)FreeColSelectedPanelUI.createUI(this.selectedPanel));
            this.locationLabel.setFont(this.locationLabel.getFont().deriveFont(2));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends UnitWrapper> list, UnitWrapper value, int index, boolean isSelected, boolean cellHasFocus) {
            EndTurnDialog.this.getImageLibrary();
            this.imageLabel.setIcon(ImageLibrary.getUnitImageIcon(value.unit, 0.5));
            this.nameLabel.setText(value.name);
            this.locationLabel.setText(value.location);
            JPanel panel = isSelected ? this.selectedPanel : this.itemPanel;
            panel.removeAll();
            panel.add((Component)this.imageLabel, "center");
            panel.add((Component)this.nameLabel, "split 2, flowy");
            panel.add(this.locationLabel);
            return panel;
        }
    }

    private static class UnitWrapper {
        public Unit unit;
        public String name;
        public String location;

        public UnitWrapper(Unit unit) {
            this.unit = unit;
            this.name = unit.getDescription(Unit.UnitLabelType.NATIONAL);
            this.location = Messages.message(unit.getLocation().getLocationLabelFor(unit.getOwner()));
        }

        public String toString() {
            return this.name;
        }
    }
}

