/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public final class DumpCargoDialog
extends FreeColDialog<List<Goods>> {
    private static final Logger logger = Logger.getLogger(DumpCargoDialog.class.getName());
    private final List<Goods> goodsList;
    private final List<JCheckBox> checkBoxes;

    public DumpCargoDialog(FreeColClient freeColClient, Unit unit) {
        super(freeColClient);
        ImageLibrary lib = this.getGUI().getImageLibrary();
        this.goodsList = unit.getGoodsList();
        this.checkBoxes = new ArrayList<JCheckBox>(this.goodsList.size());
        JLabel header = GUI.getDefaultHeader(Messages.message("dumpCargo"));
        header.setFont(GUI.SMALL_HEADER_FONT);
        for (Goods goods : this.goodsList) {
            JCheckBox jCheckBox = new JCheckBox(Messages.message(goods.getLabel(true)), true);
            this.checkBoxes.add(jCheckBox);
        }
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "", ""));
        panel.add(header);
        for (JCheckBox jCheckBox : this.checkBoxes) {
            panel.add(jCheckBox);
        }
        panel.setSize(panel.getPreferredSize());
        Object fake = null;
        List list = DumpCargoDialog.choices();
        list.add(new ChoiceItem<Object>(Messages.message("ok"), fake).okOption().defaultOption());
        list.add(new ChoiceItem<Object>(Messages.message("cancel"), fake).cancelOption());
        this.initializeDialog(FreeColDialog.DialogType.QUESTION, false, panel, lib.getImageIcon(unit, false), list);
    }

    @Override
    public List<Goods> getResponse() {
        Object value = this.getValue();
        ArrayList<Goods> gl = new ArrayList<Goods>();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            for (int i = 0; i < this.checkBoxes.size(); ++i) {
                if (!this.checkBoxes.get(i).isSelected()) continue;
                gl.add(this.goodsList.get(i));
            }
        }
        return gl;
    }
}

