/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.Draggable;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ImageSelection;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Unit;

public final class DefaultTransferHandler
extends TransferHandler {
    private static Logger logger = Logger.getLogger(DefaultTransferHandler.class.getName());
    public static final DataFlavor flavor = new DataFlavor(ImageSelection.class, "ImageSelection");
    private final FreeColPanel parentPanel;
    private FreeColClient freeColClient;
    private GUI gui;
    private static FreeColDragGestureRecognizer recognizer = null;

    public DefaultTransferHandler(FreeColClient freeColClient, FreeColPanel parentPanel) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        this.parentPanel = parentPanel;
    }

    @Override
    public int getSourceActions(JComponent comp) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        if (comp instanceof JPanel || comp instanceof JLabel) {
            for (int i = 0; i < flavor.length; ++i) {
                if (!flavor[i].equals(DefaultTransferHandler.flavor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent comp) {
        if (comp instanceof JLabel && comp instanceof Draggable) {
            return new ImageSelection((JLabel)comp);
        }
        return null;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        try {
            AbstractGoodsLabel label;
            UnitLabel oldSelectedUnit = null;
            if (!t.isDataFlavorSupported(flavor)) {
                logger.warning("Data flavor is not supported!");
                return false;
            }
            JLabel data = (JLabel)t.getTransferData(flavor);
            if (comp == data) {
                return false;
            }
            if (comp instanceof UnitLabel) {
                UnitLabel unitLabel = (UnitLabel)comp;
                if (unitLabel.getUnit().isCarrier() && unitLabel.getParent() instanceof InPortPanel && this.parentPanel instanceof PortPanel) {
                    PortPanel portPanel = (PortPanel)this.parentPanel;
                    if (data instanceof Draggable && ((Draggable)((Object)data)).isOnCarrier()) {
                        oldSelectedUnit = portPanel.getSelectedUnitLabel();
                    }
                    portPanel.setSelectedUnitLabel(unitLabel);
                    comp = portPanel.getCargoPanel();
                } else if (!unitLabel.canUnitBeEquippedWith(data)) {
                    comp = this.getDropTarget(comp);
                }
            } else if (comp instanceof AbstractGoodsLabel) {
                comp = this.getDropTarget(comp);
            }
            if (data.getParent() == comp) {
                return false;
            }
            if (data instanceof UnitLabel) {
                Unit unit = ((UnitLabel)data).getUnit();
                if (!(comp instanceof DropTarget)) {
                    return false;
                }
                DropTarget target = (DropTarget)((Object)comp);
                if (!target.accepts(unit)) {
                    return false;
                }
                target.add(data, true);
                this.restoreSelection(oldSelectedUnit);
                comp.revalidate();
                return true;
            }
            if (data instanceof GoodsLabel) {
                label = (GoodsLabel)data;
                Goods goods = ((GoodsLabel)label).getGoods();
                if (label.isPartialChosen()) {
                    int amount;
                    int defaultAmount = goods.getAmount();
                    if (goods.getLocation() instanceof GoodsLocation) {
                        GoodsLocation loc = (GoodsLocation)goods.getLocation();
                        if (goods.getAmount() > loc.getGoodsCapacity()) {
                            defaultAmount = Math.min(100, goods.getAmount() - loc.getGoodsCapacity());
                        }
                    }
                    if ((amount = this.getAmount(goods.getType(), goods.getAmount(), defaultAmount, false)) <= 0) {
                        return false;
                    }
                    goods.setAmount(amount);
                } else if (goods.getAmount() > 100) {
                    goods.setAmount(100);
                }
                if (comp instanceof UnitLabel) {
                    return this.equipUnitIfPossible((UnitLabel)comp, goods);
                }
                if (comp instanceof DropTarget) {
                    DropTarget target = (DropTarget)((Object)comp);
                    if (!target.accepts(goods)) {
                        return false;
                    }
                    target.add(data, true);
                    this.restoreSelection(oldSelectedUnit);
                    comp.revalidate();
                    return true;
                }
                if (comp instanceof JLabel) {
                    logger.warning("Oops, I thought we didn't have to write this part.");
                    return true;
                }
            } else if (data instanceof MarketLabel) {
                label = (MarketLabel)data;
                if (label.isPartialChosen()) {
                    int amount = this.getAmount(label.getType(), label.getAmount(), -1, true);
                    if (amount <= 0) {
                        return false;
                    }
                    ((MarketLabel)label).setAmount(amount);
                }
                if (comp instanceof UnitLabel) {
                    if (this.equipUnitIfPossible((UnitLabel)comp, label.getGoods())) {
                        return true;
                    }
                    if (comp.getParent() instanceof JComponent) {
                        comp = (JComponent)comp.getParent();
                    } else {
                        return false;
                    }
                }
                if (comp instanceof CargoPanel) {
                    ((CargoPanel)comp).add((Component)data, true);
                    comp.revalidate();
                    return true;
                }
                if (comp instanceof JLabel) {
                    logger.warning("Oops, I thought we didn't have to write this part.");
                    return true;
                }
                logger.warning("The receiving component is of an invalid type.");
                return false;
            }
            logger.warning("The dragged component is of an invalid type.");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Import data fail", e);
        }
        return false;
    }

    public JComponent getDropTarget(JComponent component) {
        if (component instanceof DropTarget) {
            return component;
        }
        if (component.getParent() instanceof JComponent) {
            return this.getDropTarget((JComponent)component.getParent());
        }
        return null;
    }

    private void restoreSelection(UnitLabel oldSelectedUnit) {
        if (oldSelectedUnit != null && oldSelectedUnit.getParent() instanceof InPortPanel) {
            ((PortPanel)this.parentPanel).setSelectedUnitLabel(oldSelectedUnit);
        }
    }

    private boolean equipUnitIfPossible(UnitLabel unitLabel, AbstractGoods goods) {
        Unit unit = unitLabel.getUnit();
        if (!unit.hasAbility("model.ability.canBeEquipped") || unit.getRole().hasAbility("model.ability.establishMission")) {
            return false;
        }
        for (Role role : unit.getAvailableRoles(null)) {
            int count;
            List<AbstractGoods> required;
            if (role.isDefaultRole() || (required = unit.getGoodsDifference(role, 1)).size() != 1 || required.get(0).getType() != goods.getType() || (count = Math.min(role.getMaximumCount(), goods.getAmount() / required.get(0).getAmount())) <= 0 || role == unit.getRole() && count == unit.getRoleCount()) continue;
            this.freeColClient.getInGameController().equipUnitForRole(unit, role, count);
            unitLabel.updateIcon();
            return true;
        }
        return false;
    }

    private int getAmount(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return this.gui.showSelectAmountDialog(goodsType, available, defaultAmount, needToPay);
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        int srcActions = this.getSourceActions(comp);
        int dragAction = srcActions & action;
        if (!(e instanceof MouseEvent)) {
            dragAction = 0;
        }
        if (dragAction != 0) {
            if (recognizer == null) {
                recognizer = new FreeColDragGestureRecognizer(new FreeColDragHandler());
            }
            recognizer.gestured(comp, (MouseEvent)e, srcActions, dragAction);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    private static class FreeColDragGestureRecognizer
    extends DragGestureRecognizer {
        FreeColDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    private static class FreeColDragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private FreeColDragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            DefaultTransferHandler th = (DefaultTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    if (c instanceof JLabel && ((JLabel)c).getIcon() instanceof ImageIcon) {
                        Cursor cursor;
                        Toolkit tk = Toolkit.getDefaultToolkit();
                        ImageIcon imageIcon = (ImageIcon)((JLabel)c).getIcon();
                        Dimension bestSize = tk.getBestCursorSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
                        if (bestSize.width == 0 || bestSize.height == 0) {
                            dge.startDrag(null, t, this);
                            return;
                        }
                        if (bestSize.width > bestSize.height) {
                            bestSize.height = (int)((double)bestSize.width / (double)imageIcon.getIconWidth() * (double)imageIcon.getIconHeight());
                        } else {
                            bestSize.width = (int)((double)bestSize.height / (double)imageIcon.getIconHeight() * (double)imageIcon.getIconWidth());
                        }
                        Image image = imageIcon.getImage().getScaledInstance(bestSize.width, bestSize.height, 1);
                        MediaTracker mt = new MediaTracker(c);
                        mt.addImage(image, 0, bestSize.width, bestSize.height);
                        try {
                            mt.waitForID(0);
                        }
                        catch (InterruptedException e) {
                            dge.startDrag(null, t, this);
                            return;
                        }
                        Point point = new Point(bestSize.width / 2, bestSize.height / 2);
                        try {
                            cursor = tk.createCustomCursor(image, point, "freeColDragIcon");
                        }
                        catch (RuntimeException re) {
                            cursor = null;
                        }
                        dge.startDrag(cursor, t, this);
                    } else {
                        dge.startDrag(null, t, this);
                    }
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, null, 0);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (dsde.getDropSuccess()) {
                ((DefaultTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), dsde.getDropAction());
            } else {
                ((DefaultTransferHandler)c.getTransferHandler()).exportDone(c, null, 0);
            }
            c.setAutoscrolls(this.scrolls);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent comp = (JComponent)dsc.getComponent();
            this.updatePartialChosen(comp, dsde.getUserAction() == 2);
        }

        private void updatePartialChosen(JComponent comp, boolean partialChosen) {
            if (comp instanceof GoodsLabel) {
                ((GoodsLabel)comp).setPartialChosen(partialChosen);
            } else if (comp instanceof MarketLabel) {
                ((MarketLabel)comp).setPartialChosen(partialChosen);
            }
        }
    }
}

