/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.StringTemplate;

public class ConstructionPanel
extends MigPanel
implements PropertyChangeListener {
    public static final String EVENT = Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString();
    private final FreeColClient freeColClient;
    private final boolean openBuildQueue;
    private Colony colony;
    private StringTemplate defaultLabel = StringTemplate.key("colonyPanel.clickToBuild");

    public ConstructionPanel(FreeColClient freeColClient, Colony colony, boolean openBuildQueue) {
        super("ConstructionPanelUI");
        this.freeColClient = freeColClient;
        this.colony = colony;
        this.openBuildQueue = openBuildQueue;
        this.setLayout(new MigLayout("fill, gapy 2:5, wrap 2", "push[]10[center]push"));
        this.setOpaque(openBuildQueue);
    }

    public void setColony(Colony newColony) {
        if (newColony != this.colony) {
            this.cleanup();
            this.colony = newColony;
            this.initialize();
        }
    }

    public void initialize() {
        if (this.colony != null) {
            this.colony.addPropertyChangeListener(EVENT, this);
            if (this.openBuildQueue) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        ConstructionPanel.this.freeColClient.getGUI().showBuildQueuePanel(ConstructionPanel.this.colony);
                    }
                });
            }
        }
        this.update();
    }

    public void cleanup() {
        if (this.colony != null) {
            this.colony.removePropertyChangeListener(EVENT, this);
        }
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
    }

    public void update() {
        this.update(this.colony == null ? null : this.colony.getCurrentlyBuilding());
    }

    public void update(BuildableType buildable) {
        GUI gui = this.freeColClient.getGUI();
        this.removeAll();
        if (buildable == null) {
            String clickToBuild = Messages.message(this.getDefaultLabel());
            int breakingPoint = Messages.getBreakingPoint(clickToBuild);
            if (breakingPoint > 0) {
                this.add((Component)new JLabel(clickToBuild.substring(0, breakingPoint)), "span, align center");
                this.add((Component)new JLabel(clickToBuild.substring(breakingPoint + 1)), "span, align center");
            } else {
                this.add((Component)new JLabel(clickToBuild), "span, align center");
            }
        } else {
            Image image;
            int turnsToComplete = this.colony.getTurnsToComplete(buildable);
            String turnsStr = Messages.getTurnsText(turnsToComplete);
            if (buildable instanceof BuildingType) {
                gui.getImageLibrary();
                image = ImageLibrary.getBuildingImage((BuildingType)buildable, this.colony.getOwner(), 0.75);
            } else {
                gui.getImageLibrary();
                image = ImageLibrary.getImage(buildable, 0.75);
            }
            Image image2 = image;
            this.add((Component)new JLabel(new ImageIcon(image2)), "spany");
            this.add(GUI.localizedLabel(StringTemplate.template("colonyPanel.currentlyBuilding").addName("%buildable%", buildable)));
            this.add(GUI.localizedLabel(StringTemplate.template("turnsToComplete.long").addName("%number%", turnsStr)));
            for (AbstractGoods ag : buildable.getRequiredGoods()) {
                int amountNeeded = ag.getAmount();
                int amountAvailable = this.colony.getGoodsCount(ag.getType());
                int amountProduced = this.colony.getAdjustedNetProductionOf(ag.getType());
                this.add((Component)new FreeColProgressBar(gui, ag.getType(), 0, amountNeeded, amountAvailable, amountProduced), "height 20:");
            }
        }
        this.revalidate();
        this.repaint();
    }

    public final StringTemplate getDefaultLabel() {
        return this.defaultLabel;
    }

    public final void setDefaultLabel(StringTemplate newDefaultLabel) {
        this.defaultLabel = newDefaultLabel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }
}

