/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.ColorChooserPanel;

public final class ColorCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final Logger logger = Logger.getLogger(ColorCellEditor.class.getName());
    private static final String EDIT = "EDIT";
    private final FreeColClient freeColClient;
    private final JButton colorEditButton;
    private ColorChooserPanel colorChooserPanel = null;
    private Color currentColor;

    public ColorCellEditor(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.colorEditButton = new JButton();
        this.colorEditButton.setActionCommand(EDIT);
        this.colorEditButton.addActionListener(this);
        this.colorEditButton.setBorderPainted(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean hasFocus, int row, int column) {
        this.currentColor = (Color)value;
        return this.colorEditButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        GUI gui = this.freeColClient.getGUI();
        if (EDIT.equals(command)) {
            this.colorChooserPanel = gui.showColorChooserPanel(this);
        } else if ("OK".equals(command)) {
            if (this.colorChooserPanel != null) {
                this.currentColor = this.colorChooserPanel.getColor();
                gui.removeFromCanvas(this.colorChooserPanel);
            }
            this.fireEditingStopped();
        } else if ("CANCEL".equals(command)) {
            if (this.colorChooserPanel != null) {
                gui.removeFromCanvas(this.colorChooserPanel);
            }
            this.fireEditingCanceled();
        } else {
            logger.warning("Bad event: " + command);
        }
    }
}

