/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.UnitButton;

public final class ClassicMapControls
extends MapControls {
    private JPanel panel;
    private Font arrowFont;
    private ActionManager am;

    public ClassicMapControls(FreeColClient freeColClient) {
        super(freeColClient, false);
        this.am = freeColClient.getActionManager();
        this.arrowFont = GUI.SMALL_SIMPLE_FONT;
        this.panel = new MigPanel();
        this.panel.setLayout(new MigLayout("wrap 3"));
        this.panel.add((Component)this.miniMap, "span, width 220, height 128");
        this.panel.add((Component)this.miniMapZoomInButton, "newline 10");
        this.panel.add((Component)this.miniMapZoomOutButton, "skip");
        this.panel.add((Component)this.makeButton("NW", "\u2196"), "newline 20");
        this.panel.add(this.makeButton("N", "\u2191"));
        this.panel.add(this.makeButton("NE", "\u2197"));
        this.panel.add(this.makeButton("W", "\u2190"));
        this.panel.add((Component)this.makeButton("E", "\u2192"), "skip");
        this.panel.add(this.makeButton("SW", "\u2199"));
        this.panel.add(this.makeButton("S", "\u2193"));
        this.panel.add((Component)this.makeButton("SE", "\u2198"), "wrap 20");
        for (UnitButton button : this.unitButtons) {
            this.panel.add(button);
        }
        this.panel.add((Component)this.infoPanel, "newline push, span, width " + this.infoPanel.getWidth() + ", height " + this.infoPanel.getHeight());
    }

    @Override
    public void addToComponent(Canvas component) {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        int width = (int)this.panel.getPreferredSize().getWidth();
        this.panel.setSize(width, component.getHeight());
        this.panel.setLocation(component.getWidth() - width, 0);
        component.add((Component)this.panel, CONTROLS_LAYER);
    }

    @Override
    public boolean isShowing() {
        return this.panel.getParent() != null;
    }

    @Override
    public void removeFromComponent(Canvas canvas) {
        canvas.removeFromCanvas(this.panel);
    }

    @Override
    public void repaint() {
        this.panel.repaint();
    }

    private JButton makeButton(String direction, String arrow) {
        JButton button = new JButton(this.am.getFreeColAction("moveAction." + direction));
        button.setFont(this.arrowFont);
        button.setText(arrow);
        return button;
    }
}

