/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public class BuildingToolTip
extends JToolTip {
    private static final JLabel arrow = new JLabel("\u2192");

    public BuildingToolTip(FreeColClient freeColClient, Building building) {
        int breedingNumber;
        ImageLibrary lib = freeColClient.getGUI().getImageLibrary();
        Game game = building.getGame();
        int workplaces = building.getUnitCapacity();
        List<AbstractGoods> outputs = building.getOutputs();
        GoodsType output = outputs.isEmpty() ? null : outputs.get(0).getType();
        String columns = "[align center]";
        for (int index = 0; index < workplaces; ++index) {
            columns = columns + "20[]5[]";
        }
        MigLayout layout = new MigLayout("fill, insets 20, wrap " + (2 * workplaces + 1), columns, "[][][align bottom]");
        this.setLayout(layout);
        JLabel buildingName = new JLabel(Messages.getName(building));
        buildingName.setFont(GUI.SMALLER_SIMPLE_FONT);
        this.add((Component)buildingName, "span");
        ProductionInfo info = building.getProductionInfo();
        if (info == null || info.getProduction().isEmpty()) {
            this.add((Component)new JLabel(), "span");
        } else {
            AbstractGoods production = info.getProduction().get(0);
            AbstractGoods maximumProduction = info.getMaximumProduction().isEmpty() ? production : info.getMaximumProduction().get(0);
            ProductionLabel productionOutput = new ProductionLabel(freeColClient, production, maximumProduction);
            if (info.getConsumption().isEmpty()) {
                this.add((Component)productionOutput, "span");
            } else {
                AbstractGoods consumption = info.getConsumption().get(0);
                if (consumption.getAmount() > 0) {
                    AbstractGoods maximumConsumption = info.getMaximumConsumption().isEmpty() ? consumption : info.getMaximumConsumption().get(0);
                    ProductionLabel productionInput = new ProductionLabel(freeColClient, consumption, maximumConsumption);
                    this.add((Component)productionInput, "span, split 3");
                    this.add(arrow);
                    this.add(productionOutput);
                } else {
                    this.add((Component)new JLabel(ImageLibrary.getGoodsImageIcon(consumption.getType())), "span, split 3");
                    this.add(arrow);
                    this.add(new JLabel(ImageLibrary.getGoodsImageIcon(production.getType())));
                }
            }
        }
        this.add(new JLabel(new ImageIcon(lib.getBuildingImage(building))));
        for (Unit unit : building.getUnitList()) {
            UnitLabel unitLabel = new UnitLabel(freeColClient, unit, false);
            int production = building.getUnitProduction(unit, output);
            if (production > 0) {
                this.add(unitLabel);
                ProductionLabel pLabel = new ProductionLabel(freeColClient, output, production);
                this.add((Component)pLabel, "split 2");
                this.add(new JLabel());
                continue;
            }
            if (building.canTeach() && unit.getStudent() != null) {
                JLabel progress = new JLabel(unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
                UnitLabel sLabel = new UnitLabel(freeColClient, unit.getStudent(), true);
                sLabel.setIgnoreLocation(true);
                this.add(unitLabel);
                this.add((Component)progress, "split 2, flowy");
                this.add(sLabel);
                continue;
            }
            this.add((Component)unitLabel, "span 2");
        }
        int diff = building.getUnitCapacity() - building.getUnitCount();
        for (int index = 0; index < diff; ++index) {
            this.add((Component)new JLabel(new ImageIcon(ResourceManager.getImage("placeholder.image"))), "span 2");
        }
        int n = breedingNumber = output == null ? Integer.MAX_VALUE : output.getBreedingNumber();
        if (breedingNumber < Integer.MAX_VALUE && breedingNumber > building.getColony().getGoodsCount(output)) {
            StringTemplate t = StringTemplate.template("buildingToolTip.breeding").addAmount("%number%", breedingNumber).add("%goods%", output.getNameKey());
            this.add(GUI.localizedLabel(t));
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            if (output != null) {
                modifiers.addAll(building.getProductionModifiers(output, null));
            }
            Collections.sort(modifiers);
            for (Modifier m : modifiers) {
                JLabel[] mLabels = ModifierFormat.getModifierLabels(m, null, game.getTurn());
                for (int i = 0; i < mLabels.length; ++i) {
                    if (mLabels[i] == null) continue;
                    if (i == 0) {
                        this.add((Component)mLabels[i], "newline");
                        continue;
                    }
                    this.add(mLabels[i]);
                }
            }
        }
        this.setPreferredSize(layout.preferredLayoutSize(this));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setLayout(null);
    }

    static {
        arrow.setFont(GUI.SMALL_SIMPLE_FONT);
    }
}

