/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.util.Hashtable;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.SliderOptionUI;
import net.sf.freecol.common.option.RangeOption;

public final class RangeOptionUI
extends SliderOptionUI<RangeOption> {
    public RangeOptionUI(GUI gui, RangeOption option, boolean editable) {
        super(gui, option, editable);
        JSlider slider = this.getComponent();
        slider.setModel(new DefaultBoundedRangeModel(option.getValueRank(), 0, 0, option.getItemValues().size() - 1));
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        int index = 0;
        for (String string : option.getItemValues().values()) {
            if (option.localizeLabels()) {
                labels.put(index, GUI.localizedLabel(string));
            } else {
                labels.put(index, new JLabel(string));
            }
            ++index;
        }
        slider.setLabelTable(labels);
        slider.setValue(option.getValueRank());
        slider.setMajorTickSpacing(1);
        slider.setSnapToTicks(true);
    }

    @Override
    public void updateOption() {
        ((RangeOption)this.getOption()).setValueRank(this.getComponent().getValue());
    }

    @Override
    public void reset() {
        this.getComponent().setValue(((RangeOption)this.getOption()).getValueRank());
    }
}

