/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.IntegerOptionUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.option.StringOptionUI;
import net.sf.freecol.client.gui.option.UnitTypeOptionUI;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitTypeOption;

public final class AbstractUnitOptionUI
extends OptionUI<AbstractUnitOption>
implements ItemListener {
    private JPanel panel = new MigPanel();
    private IntegerOptionUI numberUI;
    private UnitTypeOptionUI typeUI;
    private StringOptionUI roleUI;
    private boolean roleEditable;

    public AbstractUnitOptionUI(GUI gui, AbstractUnitOption option, boolean editable) {
        super(gui, option, editable);
        this.panel.setLayout(new MigLayout());
        IntegerOption numberOption = option.getNumber();
        UnitTypeOption typeOption = option.getUnitType();
        StringOption roleOption = option.getRole();
        boolean numberEditable = editable && numberOption.getMaximumValue() > numberOption.getMinimumValue();
        this.numberUI = new IntegerOptionUI(gui, numberOption, numberEditable);
        GUI.localizeToolTip(this.numberUI.getComponent(), "report.numberOfUnits");
        this.panel.add((Component)this.numberUI.getComponent(), "width 30%");
        boolean typeEditable = editable && typeOption.getChoices().size() > 1;
        this.typeUI = new UnitTypeOptionUI(gui, typeOption, typeEditable);
        GUI.localizeToolTip((JComponent)this.typeUI.getComponent(), "model.unit.type");
        this.typeUI.getComponent().addItemListener(this);
        this.panel.add((Component)this.typeUI.getComponent(), "width 35%");
        this.roleEditable = editable && roleOption.getChoices().size() > 1;
        this.roleUI = new StringOptionUI(gui, roleOption, this.roleEditable);
        GUI.localizeToolTip(this.roleUI.getComponent(), "model.role.name");
        ((JComboBox)this.roleUI.getComponent()).setRenderer(new RoleRenderer());
        this.panel.add((Component)this.roleUI.getComponent(), "width 35%");
        this.initialize();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        DefaultComboBoxModel<String> model;
        JComponent box = this.roleUI.getComponent();
        boolean enable = false;
        UnitType type = (UnitType)this.typeUI.getComponent().getSelectedItem();
        if (type.hasAbility("model.ability.canBeEquipped")) {
            model = new DefaultComboBoxModel<String>(((StringOption)this.roleUI.getOption()).getChoices().toArray(new String[0]));
            enable = this.roleEditable;
        } else {
            model = new DefaultComboBoxModel<String>(new String[]{"model.role.default"});
        }
        ((JComboBox)box).setModel(model);
        ((JComboBox)box).setEnabled(enable);
    }

    @Override
    public ListCellRenderer getListCellRenderer() {
        return new AbstractUnitRenderer();
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        this.typeUI.updateOption();
        this.roleUI.updateOption();
        this.numberUI.updateOption();
        UnitType type = ((UnitTypeOption)this.typeUI.getOption()).getValue();
        String roleId = ((StringOption)this.roleUI.getOption()).getValue();
        int number = ((IntegerOption)this.numberUI.getOption()).getValue();
        ((AbstractUnitOption)this.getOption()).setValue(new AbstractUnit(type, roleId, number));
    }

    @Override
    public void reset() {
        this.typeUI.reset();
        this.roleUI.reset();
        this.numberUI.reset();
    }

    private class RoleRenderer
    extends FreeColComboBoxRenderer<String> {
        private RoleRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, String value) {
            label.setText(Messages.getName(value));
        }
    }

    private class AbstractUnitRenderer
    extends FreeColComboBoxRenderer<AbstractUnitOption> {
        private AbstractUnitRenderer() {
        }

        @Override
        public void setLabelValues(JLabel label, AbstractUnitOption value) {
            label.setText(Messages.message(value.getValue().getLabel()));
        }
    }
}

