/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public class NewEmptyMapAction
extends MapboardAction {
    public static final String id = "newEmptyMapAction";

    public NewEmptyMapAction(FreeColClient freeColClient) {
        super(freeColClient, id);
    }

    @Override
    protected boolean shouldBeEnabled() {
        return this.freeColClient.isMapEditor();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Dimension size = this.getGUI().showMapSizeDialog();
        if (size == null) {
            return;
        }
        Game game = this.getGame();
        Map map = this.getFreeColClient().getFreeColServer().createEmptyMap(game, size.width, size.height);
        game.setMap(map);
        Tile tile = map.getTile(size.width / 2, size.height / 2);
        this.getGUI().setFocus(tile);
        this.getFreeColClient().updateActions();
        this.getGUI().refresh();
    }
}

