/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.ScrollThread;
import net.sf.freecol.common.model.Map;

public class AbstractCanvasListener {
    protected static final int AUTO_SCROLL_SPACE = 1;
    private static final int DRAG_SCROLL_SPACE = 100;
    protected final FreeColClient freeColClient;
    protected final MapViewer mapViewer;
    protected ScrollThread scrollThread = null;

    public AbstractCanvasListener(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.mapViewer = freeColClient.getGUI().getMapViewer();
        this.scrollThread = null;
    }

    protected void performAutoScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.autoScroll")) {
            this.scroll(e.getX(), e.getY(), 1);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    protected void performDragScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            this.scroll(e.getX(), e.getY(), 100);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    protected void stopScrollIfScrollIsActive() {
        if (this.scrollThread != null) {
            this.scrollThread.interrupt();
            this.scrollThread = null;
        }
    }

    private void scroll(int x, int y, int scrollSpace) {
        Map.Direction direction = x < scrollSpace && y < scrollSpace ? Map.Direction.NW : (x >= this.mapViewer.getWidth() - scrollSpace && y < scrollSpace ? Map.Direction.NE : (x >= this.mapViewer.getWidth() - scrollSpace && y >= this.mapViewer.getHeight() - scrollSpace ? Map.Direction.SE : (x < scrollSpace && y >= this.mapViewer.getHeight() - scrollSpace ? Map.Direction.SW : (y < scrollSpace ? Map.Direction.N : (x >= this.mapViewer.getWidth() - scrollSpace ? Map.Direction.E : (y >= this.mapViewer.getHeight() - scrollSpace ? Map.Direction.S : (x < scrollSpace ? Map.Direction.W : null)))))));
        if (direction == null) {
            this.stopScrollIfScrollIsActive();
        } else if (this.scrollThread == null || this.scrollThread.isInterrupted()) {
            this.scrollThread = new ScrollThread(this.mapViewer);
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        } else {
            this.scrollThread.setDirection(direction);
        }
    }
}

