/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.viewers;

import java.util.Collection;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingEvent;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMappingChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMultiMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMultiMappingWithDomain;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.MappingDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.WritableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;
import org.eclipse.jface.internal.databinding.provisional.viewers.IObservableCollectionWithLabels;

public class MultiMappingAndListBinding
extends Binding {
    private boolean updating = false;
    private IObservableCollectionWithLabels target;
    private IObservableMultiMappingWithDomain model;
    private IObservableList modelList;
    private final IObservableList targetList;
    private final IListChangeListener targetChangeListener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
        }
    };
    private IMappingChangeListener cellsChangeListener = new IMappingChangeListener(){

        public void handleMappingValueChange(IObservable source, MappingDiff diff) {
            MultiMappingAndListBinding.this.target.updateElements(diff.getElements().toArray());
        }
    };
    private IListChangeListener modelChangeListener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
            if (MultiMappingAndListBinding.this.updating) {
                return;
            }
            BindingEvent e = new BindingEvent(MultiMappingAndListBinding.this.model, MultiMappingAndListBinding.this.targetList, diff, 0, 0);
            if (MultiMappingAndListBinding.this.failure(MultiMappingAndListBinding.this.errMsg(MultiMappingAndListBinding.this.fireBindingEvent(e)))) {
                return;
            }
            try {
                ListDiff setDiff = (ListDiff)e.diff;
                ListDiffEntry[] differences = setDiff.getDifferences();
                int i = 0;
                while (i < differences.length) {
                    ListDiffEntry entry = differences[i];
                    if (entry.isAddition()) {
                        MultiMappingAndListBinding.this.targetList.add(entry.getPosition(), entry.getElement());
                    } else {
                        MultiMappingAndListBinding.this.targetList.remove(entry.getPosition());
                    }
                    ++i;
                }
                e.pipelinePosition = 4;
                if (MultiMappingAndListBinding.this.failure(MultiMappingAndListBinding.this.errMsg(MultiMappingAndListBinding.this.fireBindingEvent(e)))) {
                    return;
                }
            }
            finally {
                MultiMappingAndListBinding.this.updating = false;
            }
        }
    };
    private WritableValue partialValidationErrorObservable = new WritableValue(null);
    private WritableValue validationErrorObservable = new WritableValue(null);

    public MultiMappingAndListBinding(DataBindingContext context, IObservableList targetList, IObservableCollectionWithLabels target, IObservableList modelList, IObservableMultiMappingWithDomain model, BindSpec bindSpec) {
        super(context);
        this.targetList = targetList;
        this.target = target;
        this.model = model;
        this.modelList = modelList;
        targetList.addListChangeListener(this.targetChangeListener);
        model.addMappingChangeListener(this.cellsChangeListener);
        modelList.addListChangeListener(this.modelChangeListener);
        this.updateTargetFromModel();
    }

    private ValidationError errMsg(ValidationError validationError) {
        this.partialValidationErrorObservable.setValue(null);
        this.validationErrorObservable.setValue(validationError);
        return validationError;
    }

    private boolean failure(ValidationError errorMessage) {
        return errorMessage != null && errorMessage.status == 2;
    }

    public void updateTargetFromModel() {
        this.targetList.clear();
        this.targetList.addAll((Collection)this.modelList);
        this.target.init(new IMultiMapping(){

            public Object[] getMappingValues(Object element, int[] indices) {
                return MultiMappingAndListBinding.this.model.getMappingValues(element, indices);
            }

            public void setMappingValues(Object element, int[] indices, Object[] values) {
                MultiMappingAndListBinding.this.model.setMappingValues(element, indices, values);
            }
        });
    }

    public IObservableValue getValidationError() {
        return this.validationErrorObservable;
    }

    public IObservableValue getPartialValidationError() {
        return this.partialValidationErrorObservable;
    }

    public void updateModelFromTarget() {
    }
}

