/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public final class Color
extends Resource {
    public GdkColor handle;

    Color() {
    }

    public Color(Device device, int red, int green, int blue) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, red, green, blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Color(Device device, RGB rgb) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(device, rgb.red, rgb.green, rgb.blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        int pixel = this.handle.pixel;
        if (this.device.colorRefCount != null) {
            int n = pixel;
            this.device.colorRefCount[n] = this.device.colorRefCount[n] - 1;
            if (this.device.colorRefCount[n] == 0) {
                this.device.gdkColors[pixel] = null;
            }
        }
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_free_colors(colormap, this.handle, 1);
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        GdkColor gdkColor = color.handle;
        if (this.handle == gdkColor) {
            return true;
        }
        return this.device == color.device && this.handle.red == gdkColor.red && this.handle.green == gdkColor.green && this.handle.blue == gdkColor.blue;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.blue >> 8 & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.green >> 8 & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.red >> 8 & 0xFF;
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return this.handle.red ^ this.handle.green ^ this.handle.blue;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public static Color gtk_new(Device device, GdkColor gdkColor) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color = new Color();
        color.handle = gdkColor;
        color.device = device;
        return color;
    }

    void init(Device device, int red, int green, int blue) {
        this.device = device;
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(red & 0xFF | (red & 0xFF) << 8);
        gdkColor.green = (short)(green & 0xFF | (green & 0xFF) << 8);
        gdkColor.blue = (short)(blue & 0xFF | (blue & 0xFF) << 8);
        long colormap = OS.gdk_colormap_get_system();
        if (!OS.gdk_colormap_alloc_color(colormap, gdkColor, true, true)) {
            gdkColor = new GdkColor();
            OS.gdk_colormap_alloc_color(colormap, gdkColor, true, true);
        }
        this.handle = gdkColor;
        if (device.colorRefCount != null) {
            GdkColor colorCopy = new GdkColor();
            colorCopy.red = this.handle.red;
            colorCopy.green = this.handle.green;
            colorCopy.blue = this.handle.blue;
            colorCopy.pixel = this.handle.pixel;
            device.gdkColors[colorCopy.pixel] = colorCopy;
            int n = colorCopy.pixel;
            device.colorRefCount[n] = device.colorRefCount[n] + 1;
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

