/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaBreakpointPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class JavaExceptionBreakpointPage
extends JavaBreakpointPage {
    private Button fCaughtButton;
    private Button fUncaughtButton;
    private Button fSuspendOnSubclasses;
    private static final String fgExceptionBreakpointError = PropertyPageMessages.JavaExceptionBreakpointPage_2;

    protected void doStore() throws CoreException {
        boolean suspend;
        boolean uncaught;
        super.doStore();
        IJavaExceptionBreakpoint breakpoint = (IJavaExceptionBreakpoint)this.getBreakpoint();
        boolean caught = this.fCaughtButton.getSelection();
        if (caught != breakpoint.isCaught()) {
            breakpoint.setCaught(caught);
        }
        if ((uncaught = this.fUncaughtButton.getSelection()) != breakpoint.isUncaught()) {
            breakpoint.setUncaught(uncaught);
        }
        if ((suspend = this.fSuspendOnSubclasses.getSelection()) != ((JavaExceptionBreakpoint)breakpoint).isSuspendOnSubclasses()) {
            ((JavaExceptionBreakpoint)breakpoint).setSuspendOnSubclasses(suspend);
        }
    }

    protected void createTypeSpecificEditors(Composite parent) {
        IJavaExceptionBreakpoint breakpoint = (IJavaExceptionBreakpoint)this.getBreakpoint();
        SelectionAdapter exceptionBreakpointValidator = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaExceptionBreakpointPage.this.validateExceptionBreakpoint();
            }
        };
        this.createLabel(parent, PropertyPageMessages.JavaExceptionBreakpointPage_3);
        this.fEnabledButton.addSelectionListener((SelectionListener)exceptionBreakpointValidator);
        this.fCaughtButton = this.createCheckButton(parent, PropertyPageMessages.JavaExceptionBreakpointPage_0);
        try {
            this.fCaughtButton.setSelection(breakpoint.isCaught());
        }
        catch (CoreException e) {
            JDIDebugPlugin.log((Throwable)e);
        }
        this.fCaughtButton.addSelectionListener((SelectionListener)exceptionBreakpointValidator);
        this.fUncaughtButton = this.createCheckButton(parent, PropertyPageMessages.JavaExceptionBreakpointPage_1);
        try {
            this.fUncaughtButton.setSelection(breakpoint.isUncaught());
        }
        catch (CoreException e) {
            JDIDebugPlugin.log((Throwable)e);
        }
        this.fUncaughtButton.addSelectionListener((SelectionListener)exceptionBreakpointValidator);
        this.fSuspendOnSubclasses = this.createCheckButton(parent, PropertyPageMessages.JavaExceptionBreakpointPage_4);
        try {
            this.fSuspendOnSubclasses.setSelection(((JavaExceptionBreakpoint)breakpoint).isSuspendOnSubclasses());
        }
        catch (CoreException ce) {
            JDIDebugPlugin.log((Throwable)ce);
        }
    }

    private void validateExceptionBreakpoint() {
        if (this.fEnabledButton.getSelection() && !this.fCaughtButton.getSelection() && !this.fUncaughtButton.getSelection()) {
            this.addErrorMessage(fgExceptionBreakpointError);
        } else {
            this.removeErrorMessage(fgExceptionBreakpointError);
        }
    }
}

