/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.CreateStepFilterDialog;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.Filter;
import org.eclipse.jdt.internal.debug.ui.FilterLabelProvider;
import org.eclipse.jdt.internal.debug.ui.FilterViewerSorter;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JavaStepFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer fTableViewer;
    private Button fUseStepFiltersButton;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fFilterSyntheticButton;
    private Button fFilterStaticButton;
    private Button fFilterConstructorButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Label fTableLabel;

    public JavaStepFilterPreferencePage() {
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setTitle(DebugUIMessages.JavaStepFilterPreferencePage_title);
        this.setDescription(DebugUIMessages.JavaStepFilterPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_STEP_FILTER_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleFilterViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeFilters();
        }
    }

    private void createStepFilterPreferences(Composite parent) {
        Font font = parent.getFont();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFont(font);
        this.fUseStepFiltersButton = this.createCheckButton(container, DebugUIMessages.JavaStepFilterPreferencePage__Use_step_filters, 2, DebugUITools.isUseStepFilters());
        this.fUseStepFiltersButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaStepFilterPreferencePage.this.setPageEnablement(JavaStepFilterPreferencePage.this.fUseStepFiltersButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTableLabel = new Label(container, 0);
        this.fTableLabel.setText(DebugUIMessages.JavaStepFilterPreferencePage_Defined_step_fi_lters__8);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fTableLabel.setLayoutData((Object)gd);
        this.fTableLabel.setFont(font);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)68354);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fTableViewer.setSorter((ViewerSorter)new FilterViewerSorter());
        this.fTableViewer.setContentProvider((IContentProvider)new StepFilterContentProvider());
        this.fTableViewer.setInput((Object)this.getAllStoredFilters(false));
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((Filter)event.getElement()).setChecked(event.getChecked());
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    JavaStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    JavaStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(true);
                }
            }
        });
        this.fTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                JavaStepFilterPreferencePage.this.handleFilterViewerKeyPress(event);
            }
        });
        this.createStepFilterButtons(container);
        this.createStepFilterCheckboxes(container);
        this.setPageEnablement(this.fUseStepFiltersButton.getSelection());
    }

    private void initTableState(boolean defaults) {
        Filter[] filters = this.getAllStoredFilters(defaults);
        int i = 0;
        while (i < filters.length) {
            this.fTableViewer.add((Object)filters[i]);
            this.fTableViewer.setChecked((Object)filters[i], filters[i].isChecked());
            ++i;
        }
    }

    private Button createCheckButton(Composite parent, String text, int span, boolean selection) {
        Button button = new Button(parent, 32);
        button.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        button.setFont(parent.getFont());
        button.setSelection(selection);
        return button;
    }

    private Button createButton(Composite parent, String text, String tooltip) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setToolTipText(tooltip);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData(768));
        return button;
    }

    protected void setPageEnablement(boolean enabled) {
        this.fAddFilterButton.setEnabled(enabled);
        this.fAddPackageButton.setEnabled(enabled);
        this.fAddTypeButton.setEnabled(enabled);
        this.fDeselectAllButton.setEnabled(enabled);
        this.fSelectAllButton.setEnabled(enabled);
        this.fFilterConstructorButton.setEnabled(enabled);
        this.fFilterStaticButton.setEnabled(enabled);
        this.fFilterSyntheticButton.setEnabled(enabled);
        this.fTableViewer.getTable().setEnabled(enabled);
        this.fRemoveFilterButton.setEnabled(enabled & !this.fTableViewer.getSelection().isEmpty());
    }

    private void createStepFilterCheckboxes(Composite container) {
        this.fFilterSyntheticButton = this.createCheckButton(container, DebugUIMessages.JavaStepFilterPreferencePage_Filter_s_ynthetic_methods__requires_VM_support__17, 2, this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS));
        this.fFilterStaticButton = this.createCheckButton(container, DebugUIMessages.JavaStepFilterPreferencePage_Filter_static__initializers_18, 2, this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS));
        this.fFilterConstructorButton = this.createCheckButton(container, DebugUIMessages.JavaStepFilterPreferencePage_Filter_co_nstructors_19, 2, this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS));
    }

    private void createStepFilterButtons(Composite container) {
        this.initializeDialogUnits((Control)container);
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = this.createButton(buttonContainer, DebugUIMessages.JavaStepFilterPreferencePage_Add__Filter_9, DebugUIMessages.JavaStepFilterPreferencePage_Key_in_the_name_of_a_new_step_filter_10);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.addFilter();
            }
        });
        this.fAddTypeButton = this.createButton(buttonContainer, DebugUIMessages.JavaStepFilterPreferencePage_Add__Type____11, DebugUIMessages.JavaStepFilterPreferencePage_Choose_a_Java_type_and_add_it_to_step_filters_12);
        this.fAddTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.addType();
            }
        });
        this.fAddPackageButton = this.createButton(buttonContainer, DebugUIMessages.JavaStepFilterPreferencePage_Add__Package____13, DebugUIMessages.JavaStepFilterPreferencePage_Choose_a_package_and_add_it_to_step_filters_14);
        this.fAddPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.addPackage();
            }
        });
        this.fRemoveFilterButton = this.createButton(buttonContainer, DebugUIMessages.JavaStepFilterPreferencePage__Remove_15, DebugUIMessages.JavaStepFilterPreferencePage_Remove_all_selected_step_filters_16);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        Label separator = new Label(buttonContainer, 0);
        separator.setVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSelectAllButton = this.createButton(buttonContainer, DebugUIMessages.JavaStepFilterPreferencePage__Select_All_1, DebugUIMessages.JavaStepFilterPreferencePage_Selects_all_step_filters_2);
        this.fSelectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.fTableViewer.setAllChecked(true);
            }
        });
        this.fDeselectAllButton = this.createButton(buttonContainer, DebugUIMessages.JavaStepFilterPreferencePage_Deselect_All_3, DebugUIMessages.JavaStepFilterPreferencePage_Deselects_all_step_filters_4);
        this.fDeselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaStepFilterPreferencePage.this.fTableViewer.setAllChecked(false);
            }
        });
    }

    private void addFilter() {
        Filter newfilter = CreateStepFilterDialog.showCreateStepFilterDialog(this.getShell(), this.getAllFiltersFromTable());
        if (newfilter != null) {
            this.fTableViewer.add((Object)newfilter);
            this.fTableViewer.setChecked((Object)newfilter, true);
            this.fTableViewer.refresh((Object)newfilter);
        }
    }

    private void addType() {
        try {
            Object[] types;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
            dialog.setTitle(DebugUIMessages.JavaStepFilterPreferencePage_Add_type_to_step_filters_20);
            dialog.setMessage(DebugUIMessages.JavaStepFilterPreferencePage_Select_a_type_to_filter_when_stepping_23);
            if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                IType type = (IType)types[0];
                this.addFilter(type.getFullyQualifiedName(), true);
            }
        }
        catch (JavaModelException jme) {
            ExceptionHandler.handle((CoreException)((Object)jme), DebugUIMessages.JavaStepFilterPreferencePage_Add_type_to_step_filters_20, DebugUIMessages.JavaStepFilterPreferencePage_Could_not_open_type_selection_dialog_for_step_filters_21);
        }
    }

    private void addPackage() {
        try {
            Object[] packages;
            ElementListSelectionDialog dialog = JDIDebugUIPlugin.createAllPackagesDialog(this.getShell(), null, false);
            dialog.setTitle(DebugUIMessages.JavaStepFilterPreferencePage_Add_package_to_step_filters_24);
            dialog.setMessage(DebugUIMessages.JavaStepFilterPreferencePage_Select_a_package_to_filter_when_stepping_27);
            dialog.setMultipleSelection(true);
            if (dialog.open() == 0 && (packages = dialog.getResult()) != null) {
                IJavaElement pkg = null;
                int i = 0;
                while (i < packages.length) {
                    pkg = (IJavaElement)packages[i];
                    String filter = String.valueOf(pkg.getElementName()) + ".*";
                    this.addFilter(filter, true);
                    ++i;
                }
            }
        }
        catch (JavaModelException jme) {
            ExceptionHandler.handle((CoreException)((Object)jme), DebugUIMessages.JavaStepFilterPreferencePage_Add_package_to_step_filters_24, DebugUIMessages.JavaStepFilterPreferencePage_Could_not_open_package_selection_dialog_for_step_filters_25);
        }
    }

    protected void removeFilters() {
        this.fTableViewer.remove(((IStructuredSelection)this.fTableViewer.getSelection()).toArray());
    }

    public boolean performOk() {
        DebugUITools.setUseStepFilters((boolean)this.fUseStepFiltersButton.getSelection());
        IPreferenceStore store = this.getPreferenceStore();
        ArrayList<String> active = new ArrayList<String>();
        ArrayList<String> inactive = new ArrayList<String>();
        String name = "";
        Filter[] filters = this.getAllFiltersFromTable();
        int i = 0;
        while (i < filters.length) {
            name = filters[i].getName();
            if (filters[i].isChecked()) {
                active.add(name);
            } else {
                inactive.add(name);
            }
            ++i;
        }
        String pref = JavaDebugOptionsManager.serializeList(active.toArray(new String[active.size()]));
        store.setValue(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, pref);
        pref = JavaDebugOptionsManager.serializeList(inactive.toArray(new String[inactive.size()]));
        store.setValue(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST, pref);
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS, this.fFilterConstructorButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS, this.fFilterStaticButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS, this.fFilterSyntheticButton.getSelection());
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        boolean stepenabled = DebugUITools.isUseStepFilters();
        this.fUseStepFiltersButton.setSelection(stepenabled);
        this.setPageEnablement(stepenabled);
        this.fFilterSyntheticButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS));
        this.fFilterStaticButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS));
        this.fFilterConstructorButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS));
        this.fTableViewer.getTable().removeAll();
        this.initTableState(true);
        super.performDefaults();
    }

    protected void addFilter(String filter, boolean checked) {
        if (filter != null) {
            Filter f = new Filter(filter, checked);
            this.fTableViewer.add((Object)f);
            this.fTableViewer.setChecked((Object)f, checked);
        }
    }

    protected Filter[] getAllFiltersFromTable() {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        Filter[] filters = new Filter[items.length];
        int i = 0;
        while (i < items.length) {
            filters[i] = (Filter)items[i].getData();
            filters[i].setChecked(items[i].getChecked());
            ++i;
        }
        return filters;
    }

    protected Filter[] getAllStoredFilters(boolean defaults) {
        String[] inactivefilters;
        String[] activefilters;
        Filter[] filters = null;
        IPreferenceStore store = this.getPreferenceStore();
        if (defaults) {
            activefilters = JavaDebugOptionsManager.parseList(store.getDefaultString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
            inactivefilters = JavaDebugOptionsManager.parseList(store.getDefaultString(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST));
        } else {
            activefilters = JavaDebugOptionsManager.parseList(store.getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
            inactivefilters = JavaDebugOptionsManager.parseList(store.getString(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST));
        }
        filters = new Filter[activefilters.length + inactivefilters.length];
        int i = 0;
        while (i < activefilters.length) {
            filters[i] = new Filter(activefilters[i], true);
            ++i;
        }
        i = 0;
        while (i < inactivefilters.length) {
            filters[i + activefilters.length] = new Filter(inactivefilters[i], false);
            ++i;
        }
        return filters;
    }

    class StepFilterContentProvider
    implements IStructuredContentProvider {
        public StepFilterContentProvider() {
            JavaStepFilterPreferencePage.this.initTableState(false);
        }

        public Object[] getElements(Object inputElement) {
            return JavaStepFilterPreferencePage.this.getAllFiltersFromTable();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

