/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class JavaNavigatorLabelProvider
implements ICommonLabelProvider {
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private PackageExplorerLabelProvider delegeteLabelProvider;
    private PackageExplorerContentProvider fContentProvider;
    private IExtensionStateModel fStateModel;

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        this.fStateModel = commonContentExtensionSite.getExtensionStateModel();
        this.fContentProvider = (PackageExplorerContentProvider)commonContentExtensionSite.getExtension().getContentProvider();
        this.delegeteLabelProvider = this.createLabelProvider();
        this.delegeteLabelProvider.setIsFlatLayout(this.fStateModel.getBooleanProperty("isLayoutFlat"));
        this.fStateModel.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("isLayoutFlat".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue() != false;
                    JavaNavigatorLabelProvider.this.delegeteLabelProvider.setIsFlatLayout(newValue);
                }
            }
        });
    }

    public String getDescription(Object element) {
        return this.formatMessage(element);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(36421324767273L, 3, this.fContentProvider);
    }

    public void dispose() {
        this.delegeteLabelProvider.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.delegeteLabelProvider.propertyChange(event);
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        this.delegeteLabelProvider.addLabelDecorator(decorator);
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegeteLabelProvider.addListener(listener);
    }

    public Color getBackground(Object element) {
        return this.delegeteLabelProvider.getBackground(element);
    }

    public Color getForeground(Object element) {
        return this.delegeteLabelProvider.getForeground(element);
    }

    public Image getImage(Object element) {
        return this.delegeteLabelProvider.getImage(element);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.delegeteLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegeteLabelProvider.removeListener(listener);
    }

    public boolean equals(Object obj) {
        return this.delegeteLabelProvider.equals(obj);
    }

    public int hashCode() {
        return this.delegeteLabelProvider.hashCode();
    }

    public String toString() {
        return this.delegeteLabelProvider.toString();
    }

    public String getText(Object element) {
        return this.delegeteLabelProvider.getText(element);
    }

    public void setIsFlatLayout(boolean state) {
        this.delegeteLabelProvider.setIsFlatLayout(state);
    }

    protected String formatMessage(Object element) {
        if (element instanceof IJavaElement) {
            return this.formatJavaElementMessage((IJavaElement)element);
        }
        if (element instanceof IResource) {
            return this.formatResourceMessage((IResource)element);
        }
        return "";
    }

    private String formatJavaElementMessage(IJavaElement element) {
        return JavaElementLabels.getElementLabel(element, this.LABEL_FLAGS);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(element.getName()) + JavaElementLabels.CONCAT_STRING + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }
}

