/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public class LocalVariableIndex
extends ASTVisitor {
    private int fTopIndex;

    public static int perform(BodyDeclaration declaration) {
        Assert.isTrue((declaration != null ? 1 : 0) != 0);
        switch (declaration.getNodeType()) {
            case 31: {
                return LocalVariableIndex.internalPerform((MethodDeclaration)declaration);
            }
            case 28: {
                return LocalVariableIndex.internalPerform((Initializer)declaration);
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private static int internalPerform(MethodDeclaration method) {
        MethodDeclaration target = method;
        while (ASTNodes.getParent((ASTNode)target, 31) != null) {
            target = (MethodDeclaration)ASTNodes.getParent((ASTNode)target, 31);
        }
        return LocalVariableIndex.doPerform((BodyDeclaration)target);
    }

    private static int internalPerform(Initializer initializer) {
        return LocalVariableIndex.doPerform((BodyDeclaration)initializer);
    }

    private static int doPerform(BodyDeclaration node) {
        LocalVariableIndex counter = new LocalVariableIndex();
        node.accept((ASTVisitor)counter);
        return counter.fTopIndex;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.handleVariableBinding(node.resolveBinding());
        return true;
    }

    private void handleVariableBinding(IVariableBinding binding) {
        if (binding == null) {
            return;
        }
        this.fTopIndex = Math.max(this.fTopIndex, binding.getVariableId());
    }
}

