/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;

public class ClasspathModifier {
    private IClasspathModifierListener fListener;

    public ClasspathModifier() {
        this(null);
    }

    protected ClasspathModifier(IClasspathModifierListener listener) {
        this.fListener = listener;
    }

    protected List createLinkedSourceFolder(ClasspathModifierQueries.ILinkToQuery query, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        if (query.doQuery() && (folder = query.getCreatedFolder()) != null) {
            ArrayList<IFolder> folderList = new ArrayList<IFolder>();
            folderList.add(folder);
            List root = this.addToClasspath(folderList, project, query.getOutputFolderQuery(), monitor);
            if (root.size() == 0) {
                folder.delete(false, null);
            }
            return root;
        }
        return new ArrayList();
    }

    protected List createFolder(ClasspathModifierQueries.ICreateFolderQuery folderQuery, ClasspathModifierQueries.OutputFolderQuery outputQuery, IJavaProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        IFolder folder;
        if (folderQuery.doQuery() && (folder = folderQuery.getCreatedFolder()) != null) {
            ArrayList<IFolder> folderList = new ArrayList<IFolder>();
            folderList.add(folder);
            if (folderQuery.isSourceFolder()) {
                List root = this.addToClasspath(folderList, project, outputQuery, monitor);
                if (root.size() == 0) {
                    folder.delete(false, null);
                }
                return root;
            }
            List entries = ClasspathModifier.getExistingEntries(project);
            ClasspathModifier.exclude(folder.getFullPath(), entries, new ArrayList(), project, monitor);
            this.updateClasspath(entries, project, null);
            return folderList;
        }
        return new ArrayList();
    }

    protected List addToClasspath(List elements, IJavaProject project, ClasspathModifierQueries.OutputFolderQuery query, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 2 * elements.size() + 3);
            IWorkspaceRoot workspaceRoot = JavaPlugin.getWorkspace().getRoot();
            if (project.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                IPath outputLocation = project.getOutputLocation();
                IPath projPath = project.getProject().getFullPath();
                List existingEntries = ClasspathModifier.getExistingEntries(project);
                if (!(elements.size() == 1 && elements.get(0) instanceof IJavaProject || !outputLocation.equals((Object)projPath) && query.getDesiredOutputLocation().segmentCount() != 1)) {
                    if (query.doQuery(false, ClasspathModifier.getValidator(elements, project), project)) {
                        IResource res;
                        project.setOutputLocation(query.getOutputLocation(), null);
                        if (query.removeProjectFromClasspath()) {
                            ClasspathModifier.removeFromClasspath(project, existingEntries, null);
                        }
                        BuildPathsBlock.IRemoveOldBinariesQuery reorgQuery = BuildPathsBlock.getRemoveOldBinariesQuery(null);
                        if (BuildPathsBlock.hasClassfiles((IResource)project.getProject()) && outputLocation.equals((Object)projPath) && reorgQuery.doQuery(projPath) && (res = workspaceRoot.findMember(outputLocation)) instanceof IContainer && BuildPathsBlock.hasClassfiles(res)) {
                            BuildPathsBlock.removeOldClassfiles(res);
                        }
                        outputLocation = project.getOutputLocation();
                    } else {
                        ArrayList arrayList = new ArrayList();
                        return arrayList;
                    }
                }
                ArrayList<CPListElement> newEntries = new ArrayList<CPListElement>();
                int i = 0;
                while (i < elements.size()) {
                    Object element = elements.get(i);
                    CPListElement entry = element instanceof IResource ? ClasspathModifier.addToClasspath((IResource)element, existingEntries, newEntries, project, monitor) : ClasspathModifier.addToClasspath((IJavaElement)element, existingEntries, newEntries, project, monitor);
                    newEntries.add(entry);
                    ++i;
                }
                HashSet modifiedSourceEntries = new HashSet();
                BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existingEntries.toArray(new CPListElement[existingEntries.size()]), modifiedSourceEntries);
                ClasspathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
                int i2 = 0;
                while (i2 < newEntries.size()) {
                    IClasspathEntry entry = ((CPListElement)newEntries.get(i2)).getClasspathEntry();
                    Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findPackageFragmentRoot(entry.getPath());
                    if (root != null) {
                        result.add((IJavaProject)root);
                    }
                    ++i2;
                }
                ArrayList<IJavaProject> arrayList = result;
                return arrayList;
            }
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.ClasspathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        finally {
            monitor.done();
        }
    }

    protected List addExternalJars(ClasspathModifierQueries.IAddArchivesQuery query, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IPath[] selected = query.doQuery();
        ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    addedEntries.add(new CPListElement(project, 1, selected[i], null));
                    ++i;
                }
                monitor.worked(1);
                List existingEntries = ClasspathModifier.getExistingEntries(project);
                ClasspathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>(addedEntries.size());
                int i2 = 0;
                while (i2 < addedEntries.size()) {
                    IClasspathEntry entry = ((CPListElement)addedEntries.get(i2)).getClasspathEntry();
                    IPackageFragmentRoot elem = project.findPackageFragmentRoot(entry.getPath());
                    if (elem != null) {
                        result.add(elem);
                    }
                    ++i2;
                }
                monitor.worked(1);
                ArrayList<IPackageFragmentRoot> arrayList = result;
                return arrayList;
            }
        }
        finally {
            monitor.done();
        }
        return new ArrayList();
    }

    protected List addLibraries(ClasspathModifierQueries.IAddLibrariesQuery query, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IClasspathEntry[] selected = query.doQuery(project, project.getRawClasspath());
        ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    addedEntries.add(new CPListElement(project, 5, selected[i].getPath(), null));
                    ++i;
                }
                monitor.worked(1);
                List existingEntries = ClasspathModifier.getExistingEntries(project);
                ClasspathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<ClassPathContainer> result = new ArrayList<ClassPathContainer>(addedEntries.size());
                int i2 = 0;
                while (i2 < addedEntries.size()) {
                    result.add(new ClassPathContainer(project, selected[i2]));
                    ++i2;
                }
                monitor.worked(1);
                ArrayList<ClassPathContainer> arrayList = result;
                return arrayList;
            }
        }
        finally {
            monitor.done();
        }
        return new ArrayList();
    }

    protected List addLibraryEntries(List resources, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            int i = 0;
            while (i < resources.size()) {
                IResource res = (IResource)resources.get(i);
                addedEntries.add(new CPListElement(project, 1, res.getFullPath(), res));
                ++i;
            }
            monitor.worked(1);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ClasspathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>(addedEntries.size());
            int i2 = 0;
            while (i2 < resources.size()) {
                IResource res = (IResource)resources.get(i2);
                IPackageFragmentRoot elem = project.getPackageFragmentRoot(res);
                if (elem != null) {
                    result.add(elem);
                }
                ++i2;
            }
            monitor.worked(1);
            ArrayList<IPackageFragmentRoot> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    protected List removeFromClasspath(ClasspathModifierQueries.IRemoveLinkedFolderQuery query, List elements, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, elements.size() + 1);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ArrayList<IJavaProject> resultElements = new ArrayList<IJavaProject>();
            boolean archiveRemoved = false;
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                IJavaProject res = null;
                if (element instanceof IJavaProject) {
                    res = ClasspathModifier.removeFromClasspath(project, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    if (root.getKind() == 2) {
                        archiveRemoved = true;
                        res = ClasspathModifier.removeFromClasspath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        IResource resource = root.getCorrespondingResource();
                        if (resource instanceof IFolder) {
                            IFolder folder = (IFolder)resource;
                            if (folder.isLinked()) {
                                int result = query.doQuery(folder);
                                if (result != 0) {
                                    if (result == 1) {
                                        res = ClasspathModifier.removeFromClasspath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else if (result == 2) {
                                        res = ClasspathModifier.removeFromClasspath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                }
                            } else {
                                res = ClasspathModifier.removeFromClasspath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        } else {
                            res = ClasspathModifier.removeFromClasspath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                } else {
                    archiveRemoved = true;
                    ClassPathContainer container = (ClassPathContainer)element;
                    existingEntries.remove(CPListElement.createFromExisting(container.getClasspathEntry(), project));
                }
                if (res != null) {
                    resultElements.add(res);
                }
                ++i;
            }
            this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fireEvent(existingEntries);
            if (archiveRemoved && resultElements.size() == 0) {
                resultElements.add(project);
            }
            ArrayList<IJavaProject> arrayList = resultElements;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    protected List include(List elements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List javaElements;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Including, 2 * elements.size());
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < elements.size()) {
                IResource resource;
                if (elements.get(i) instanceof IResource) {
                    resource = (IResource)elements.get(i);
                } else {
                    IJavaElement elem = (IJavaElement)elements.get(i);
                    resource = elem.getResource();
                }
                resources.add(resource);
                IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (root != null) {
                    CPListElement entry = ClasspathModifier.getClasspathEntry(existingEntries, root);
                    this.include(resource, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
            this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            List list = javaElements = ClasspathModifier.getCorrespondingElements(resources, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    protected List exclude(List javaElements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, javaElements.size() + 4);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < javaElements.size()) {
                IPackageFragmentRoot root;
                CPListElement entry;
                IJavaElement javaElement = (IJavaElement)javaElements.get(i);
                IResource resource = ClasspathModifier.exclude(javaElement, entry = ClasspathModifier.getClasspathEntry(existingEntries, root = (IPackageFragmentRoot)javaElement.getAncestor(3)), project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (resource != null) {
                    resources.add(resource);
                }
                ++i;
            }
            this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            ArrayList<IResource> arrayList = resources;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    protected List unInclude(List javaElements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List result;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveInclusion, 10);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            int i = 0;
            while (i < javaElements.size()) {
                IJavaElement javaElement = (IJavaElement)javaElements.get(i);
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement.getAncestor(3);
                CPListElement entry = ClasspathModifier.getClasspathEntry(existingEntries, root);
                this.unInclude(javaElement, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
            this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            List list = result = ClasspathModifier.getCorrespondingElements(javaElements, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    protected List unExclude(List elements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List resultElements;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Including, 2 * elements.size());
            List entries = ClasspathModifier.getExistingEntries(project);
            int i = 0;
            while (i < elements.size()) {
                IResource resource = (IResource)elements.get(i);
                IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (root != null) {
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, root);
                    ClasspathModifier.unExclude(resource, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
            this.updateClasspath(entries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            List list = resultElements = ClasspathModifier.getCorrespondingElements(elements, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    protected IJavaElement editFilters(IJavaElement element, IJavaProject project, ClasspathModifierQueries.IInclusionExclusionQuery query, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_EditInclusionExclusionFilters, 4);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            CPListElement entry = ClasspathModifier.getListElement(element.getPath(), existingEntries);
            if (entry != null && query.doQuery(entry, false)) {
                entry.setAttribute("inclusion", query.getInclusionPattern());
                entry.setAttribute("exclusion", query.getExclusionPattern());
                this.updateClasspath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                IJavaElement iJavaElement = element;
                return iJavaElement;
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    protected CPListElementAttribute createOutputFolder(IPackageFragmentRoot root, ClasspathModifierQueries.IOutputLocationQuery query, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IClasspathEntry entry = root.getRawClasspathEntry();
        CPListElement elem = CPListElement.createFromExisting(entry, project);
        return this.editOutputFolder(elem, project, query, monitor);
    }

    protected CPListElementAttribute editOutputFolder(CPListElement element, IJavaProject project, ClasspathModifierQueries.IOutputLocationQuery query, IProgressMonitor monitor) throws CoreException {
        List entries;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (query.doQuery(element = ClasspathModifier.getClasspathEntry(entries = ClasspathModifier.getExistingEntries(project), element))) {
            ClasspathModifierQueries.OutputFolderQuery outputFolderQuery = query.getOutputFolderQuery(query.getOutputLocation());
            if (outputFolderQuery.getDesiredOutputLocation().segmentCount() == 1) {
                if (!outputFolderQuery.doQuery(true, this.getTrueValidator(project), project)) {
                    return null;
                }
                project.setOutputLocation(outputFolderQuery.getOutputLocation(), null);
                if (outputFolderQuery.removeProjectFromClasspath()) {
                    ClasspathModifier.removeFromClasspath(project, entries, null);
                }
            }
            if (query.getOutputLocation() == null) {
                CPListElementAttribute attr = ClasspathModifier.resetOutputFolder(element, project);
                this.updateClasspath(entries, project, (IProgressMonitor)new NullProgressMonitor());
                return attr;
            }
            ClasspathModifier.exclude(query.getOutputLocation(), entries, new ArrayList(), project, null);
            element.setAttribute("output", query.getOutputLocation());
            CPListElementAttribute outputFolder = new CPListElementAttribute(element, "output", element.getAttribute("output"), true);
            this.updateClasspath(entries, project, (IProgressMonitor)new NullProgressMonitor());
            return outputFolder;
        }
        return null;
    }

    protected void resetOutputFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetOutputFolder, roots.length + 10);
            ArrayList<CPListElementAttribute> entries = new ArrayList<CPListElementAttribute>();
            int i = 0;
            while (i < roots.length) {
                monitor.worked(1);
                if (!roots[i].isArchive()) {
                    IClasspathEntry entry = roots[i].getRawClasspathEntry();
                    CPListElement element = CPListElement.createFromExisting(entry, project);
                    CPListElementAttribute outputFolder = new CPListElementAttribute(element, "output", element.getAttribute("output"), true);
                    entries.add(outputFolder);
                }
                ++i;
            }
            this.reset(entries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
    }

    protected List reset(List elements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Resetting, elements.size());
            List entries = ClasspathModifier.getExistingEntries(project);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                if (element instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)element;
                    IPackageFragmentRoot root = element instanceof IJavaProject ? project.getPackageFragmentRoot(project.getResource()) : (IPackageFragmentRoot)element;
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, root);
                    this.resetFilters(javaElement, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(javaElement);
                } else {
                    CPListElement selElement = ((CPListElementAttribute)element).getParent();
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, selElement);
                    CPListElementAttribute outputFolder = ClasspathModifier.resetOutputFolder(entry, project);
                    result.add(outputFolder);
                }
                ++i;
            }
            this.updateClasspath(entries, project, null);
            this.fireEvent(entries);
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public static List getExistingEntries(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] classpathEntries = project.getRawClasspath();
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr = classpathEntries[i];
            newClassPath.add(CPListElement.createFromExisting(curr, project));
            ++i;
        }
        return newClassPath;
    }

    public static CPListElement getClasspathEntry(List elements, IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry entry = root.getRawClasspathEntry();
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = (CPListElement)elements.get(i);
            if (element.getPath().equals((Object)root.getPath()) && element.getEntryKind() == entry.getEntryKind()) {
                return (CPListElement)elements.get(i);
            }
            ++i;
        }
        CPListElement newElement = CPListElement.createFromExisting(entry, root.getJavaProject());
        elements.add(newElement);
        return newElement;
    }

    public static IPackageFragment getFragment(IResource resource) {
        IJavaElement elem = JavaCore.create((IResource)resource);
        if (elem instanceof IPackageFragment) {
            return (IPackageFragment)elem;
        }
        return null;
    }

    public static IPackageFragmentRoot getFragmentRoot(IResource resource, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IJavaElement javaElem = null;
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return project.getPackageFragmentRoot(resource);
        }
        IContainer container = resource.getParent();
        do {
            if (container instanceof IFolder) {
                javaElem = JavaCore.create((IFolder)((IFolder)container));
            }
            if (container.getFullPath().equals((Object)project.getPath())) {
                javaElem = project;
                break;
            }
            if ((container = container.getParent()) != null) continue;
            return null;
        } while (javaElem == null || !(javaElem instanceof IPackageFragmentRoot));
        if (javaElem instanceof IJavaProject) {
            javaElem = project.getPackageFragmentRoot(project.getResource());
        }
        return (IPackageFragmentRoot)javaElem;
    }

    public static IClasspathEntry getClasspathEntryFor(IPath path, IJavaProject project, int entryKind) throws JavaModelException {
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getPath().equals((Object)path) && ClasspathModifier.equalEntryKind(entry, entryKind)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public static boolean isDefaultOutputFolder(CPListElementAttribute attrib) {
        return attrib.getValue() == null;
    }

    public static boolean isIncluded(IJavaElement selection, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ContainsPath, 4);
            IPackageFragmentRoot root = (IPackageFragmentRoot)selection.getAncestor(3);
            IClasspathEntry entry = root.getRawClasspathEntry();
            if (entry == null) {
                return false;
            }
            boolean bl = ClasspathModifier.contains(selection.getPath().removeFirstSegments(root.getPath().segmentCount()), entry.getInclusionPatterns(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isExcluded(IResource resource, IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return false;
        }
        String fragmentName = ClasspathModifier.getName(resource.getFullPath(), root.getPath());
        fragmentName = ClasspathModifier.completeName(fragmentName);
        IClasspathEntry entry = root.getRawClasspathEntry();
        return entry != null && ClasspathModifier.contains((IPath)new Path(fragmentName), entry.getExclusionPatterns(), null);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parentExcluded(IResource resource, IJavaProject project) throws JavaModelException {
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return false;
        }
        root = ClasspathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return true;
        }
        path = resource.getFullPath().removeFirstSegments(root.getPath().segmentCount());
        entry = root.getRawClasspathEntry();
        if (entry != null) ** GOTO lbl13
        return true;
lbl-1000:
        // 1 sources

        {
            if (ClasspathModifier.contains(path, entry.getExclusionPatterns(), null)) {
                return true;
            }
            path = path.removeLastSegments(1);
lbl13:
            // 2 sources

            ** while (path.segmentCount() > 0)
        }
lbl14:
        // 1 sources

        return false;
    }

    public static boolean hasDefaultOutputFolder(IPackageFragmentRoot root) throws JavaModelException {
        return root.getRawClasspathEntry().getOutputLocation() == null;
    }

    public static boolean hasOutputFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_CheckOutputFolders, roots.length);
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getRawClasspathEntry().getOutputLocation() != null) {
                    return true;
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    protected static String escapeSpecialChars(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    buf.append(" ");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isSourceFolder(IJavaProject project) throws JavaModelException {
        return ClasspathModifier.getClasspathEntryFor(project.getPath(), project, 3) != null;
    }

    public static boolean isDefaultFragment(IPackageFragment fragment) {
        return fragment.getElementName().length() == 0;
    }

    public static boolean includeFiltersEmpty(IResource resource, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ExamineInputFilters, 4);
            IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            if (root != null) {
                IClasspathEntry entry = root.getRawClasspathEntry();
                boolean bl = entry.getInclusionPatterns().length == 0;
                return bl;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean filtersSet(IPackageFragmentRoot root) throws JavaModelException {
        if (root == null) {
            return false;
        }
        IClasspathEntry entry = root.getRawClasspathEntry();
        IPath[] inclusions = entry.getInclusionPatterns();
        IPath[] exclusions = entry.getExclusionPatterns();
        if (inclusions != null && inclusions.length > 0) {
            return true;
        }
        return exclusions != null && exclusions.length > 0;
    }

    public static CPListElement addToClasspath(IResource resource, List existingEntries, List newEntries, IJavaProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 2);
            ClasspathModifier.exclude(resource.getFullPath(), existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CPListElement cPListElement = entry = new CPListElement(project, 3, resource.getFullPath(), resource);
            return cPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isArchive(IFile file, IJavaProject project) throws JavaModelException {
        if (!ArchiveFileFilter.isArchivePath(file.getFullPath())) {
            return false;
        }
        return project != null && project.exists() && project.findPackageFragmentRoot(file.getFullPath()) == null;
    }

    public static CPListElement addToClasspath(IJavaElement javaElement, List existingEntries, List newEntries, IJavaProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 10);
            CPListElement cPListElement = entry = new CPListElement(project, 3, javaElement.getPath(), javaElement.getResource());
            return cPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static IJavaProject removeFromClasspath(IJavaProject project, List existingEntries, IProgressMonitor monitor) throws CoreException {
        CPListElement elem = ClasspathModifier.getListElement(project.getPath(), existingEntries);
        if (elem != null) {
            existingEntries.remove(elem);
        }
        return project;
    }

    public static IResource removeFromClasspath(IPackageFragmentRoot root, List existingEntries, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, 1);
            IClasspathEntry entry = root.getRawClasspathEntry();
            CPListElement elem = CPListElement.createFromExisting(entry, project);
            existingEntries.remove(elem);
            ClasspathModifier.removeFilters(elem.getPath(), project, existingEntries);
            IResource iResource = elem.getResource();
            return iResource;
        }
        finally {
            monitor.done();
        }
    }

    public static List removeFilters(IPath path, IJavaProject project, List existingEntries) {
        if (path == null) {
            return Collections.EMPTY_LIST;
        }
        IPath projPath = project.getPath();
        if (projPath.isPrefixOf(path)) {
            path = path.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        ArrayList<CPListElement> result = new ArrayList<CPListElement>();
        for (CPListElement element : existingEntries) {
            IPath[] inclusion;
            boolean hasChange = false;
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                ArrayList<IPath> exlusionList = new ArrayList<IPath>(exlusions.length);
                int i = 0;
                while (i < exlusions.length) {
                    if (!exlusions[i].equals((Object)path)) {
                        exlusionList.add(exlusions[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusionList.toArray(new IPath[exlusionList.size()]));
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) != null) {
                ArrayList<IPath> inclusionList = new ArrayList<IPath>(inclusion.length);
                int i = 0;
                while (i < inclusion.length) {
                    if (!inclusion[i].equals((Object)path)) {
                        inclusionList.add(inclusion[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("inclusion", inclusionList.toArray(new IPath[inclusionList.size()]));
            }
            if (!hasChange) continue;
            result.add(element);
        }
        return result;
    }

    private void include(IResource resource, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Including, 10);
            String name = ClasspathModifier.getName(resource.getFullPath(), entry.getPath());
            IPath[] includedPath = (IPath[])entry.getAttribute("inclusion");
            IPath[] newIncludedPath = new IPath[includedPath.length + 1];
            String completedName = ClasspathModifier.completeName(name);
            Path relPath = new Path(completedName);
            if (!ClasspathModifier.contains((IPath)relPath, includedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 2))) {
                System.arraycopy(includedPath, 0, newIncludedPath, 0, includedPath.length);
                newIncludedPath[includedPath.length] = relPath;
                entry.setAttribute("inclusion", newIncludedPath);
                entry.setAttribute("exclusion", ClasspathModifier.remove((IPath)relPath, (IPath[])entry.getAttribute("exclusion"), (IProgressMonitor)new SubProgressMonitor(monitor, 2)));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IResource exclude(String name, IPath fullPath, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        IResource result;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 6);
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = new IPath[excludedPath.length + 1];
            name = ClasspathModifier.completeName(name);
            Path path = new Path(name);
            if (!ClasspathModifier.contains((IPath)path, excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 2))) {
                System.arraycopy(excludedPath, 0, newExcludedPath, 0, excludedPath.length);
                newExcludedPath[excludedPath.length] = path;
                entry.setAttribute("exclusion", newExcludedPath);
                entry.setAttribute("inclusion", ClasspathModifier.remove((IPath)path, (IPath[])entry.getAttribute("inclusion"), (IProgressMonitor)new SubProgressMonitor(monitor, 4)));
            }
            result = fullPath == null ? null : ClasspathModifier.getResource(fullPath, project);
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static void exclude(IPath path, List existingEntries, List newEntries, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPath rootPath;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 1);
            CPListElement elem = null;
            CPListElement existingElem = null;
            int i = 0;
            do {
                if ((rootPath = path.removeLastSegments(++i)).segmentCount() == 0) {
                    return;
                }
                elem = ClasspathModifier.getListElement(rootPath, newEntries);
            } while ((existingElem = ClasspathModifier.getListElement(rootPath, existingEntries)) == null && elem == null);
            if (elem == null) {
                elem = existingElem;
            }
            ClasspathModifier.exclude(path.removeFirstSegments(path.segmentCount() - i).toString(), null, elem, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public static IResource exclude(IJavaElement javaElement, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String name = ClasspathModifier.getName(javaElement.getPath(), entry.getPath());
            IResource iResource = ClasspathModifier.exclude(name, javaElement.getPath(), entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iResource;
        }
        finally {
            monitor.done();
        }
    }

    private void unInclude(IJavaElement javaElement, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveInclusion, 10);
            String name = ClasspathModifier.getName(javaElement.getPath(), entry.getPath());
            IPath[] includedPath = (IPath[])entry.getAttribute("inclusion");
            Path relPath = new Path(ClasspathModifier.completeName(name));
            IPath[] newIncludedPath = ClasspathModifier.remove((IPath)relPath, includedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            entry.setAttribute("inclusion", newIncludedPath);
        }
        finally {
            monitor.done();
        }
    }

    public static void unExclude(IResource resource, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveExclusion, 10);
            String name = ClasspathModifier.getName(resource.getFullPath(), entry.getPath());
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = ClasspathModifier.remove((IPath)new Path(ClasspathModifier.completeName(name)), excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            entry.setAttribute("exclusion", newExcludedPath);
        }
        finally {
            monitor.done();
        }
    }

    private void resetFilters(IJavaElement element, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetFilters, 3);
            List exclusionList = this.getFoldersOnCP(element.getPath(), project, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            IPath outputLocation = (IPath)entry.getAttribute("output");
            if (outputLocation != null) {
                IPath[] exclusionPatterns = (IPath[])entry.getAttribute("exclusion");
                if (ClasspathModifier.contains((IPath)new Path(ClasspathModifier.completeName(outputLocation.lastSegment())), exclusionPatterns, null)) {
                    exclusionList.add(new Path(ClasspathModifier.completeName(outputLocation.lastSegment())));
                }
            }
            IPath[] exclusions = exclusionList.toArray(new IPath[exclusionList.size()]);
            entry.setAttribute("inclusion", new IPath[0]);
            entry.setAttribute("exclusion", exclusions);
        }
        finally {
            monitor.done();
        }
    }

    public static CPListElementAttribute resetOutputFolder(CPListElement entry, IJavaProject project) throws JavaModelException {
        entry.setAttribute("output", null);
        CPListElementAttribute outputFolder = new CPListElementAttribute(entry, "output", entry.getAttribute("output"), true);
        return outputFolder;
    }

    public static CPListElement getClasspathEntry(List elements, CPListElement cpElement) throws JavaModelException {
        int i = 0;
        while (i < elements.size()) {
            if (((CPListElement)elements.get(i)).getPath().equals((Object)cpElement.getPath())) {
                return (CPListElement)elements.get(i);
            }
            ++i;
        }
        elements.add(cpElement);
        return cpElement;
    }

    private static CPListElement getListElement(IPath path, List elements) {
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = (CPListElement)elements.get(i);
            if (element.getEntryKind() == 3 && element.getPath().equals((Object)path)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private void updateClasspath(List newEntries, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IClasspathEntry[] entries = ClasspathModifier.convert(newEntries);
            IPath outputLocation = project.getOutputLocation();
            IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)project, (IClasspathEntry[])entries, (IPath)outputLocation);
            if (!status.isOK()) {
                throw new JavaModelException(status);
            }
            project.setRawClasspath(entries, outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.fireEvent(newEntries);
        }
        finally {
            monitor.done();
        }
    }

    public static void commitClassPath(List newEntries, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IClasspathEntry[] entries = ClasspathModifier.convert(newEntries);
            IPath outputLocation = project.getOutputLocation();
            IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)project, (IClasspathEntry[])entries, (IPath)outputLocation);
            if (!status.isOK()) {
                throw new JavaModelException(status);
            }
            project.setRawClasspath(entries, outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static List getCorrespondingElements(List entries, IJavaProject project) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < entries.size()) {
            Object element = entries.get(i);
            IPath path = element instanceof IResource ? ((IResource)element).getFullPath() : ((IJavaElement)element).getPath();
            IResource resource = ClasspathModifier.getResource(path, project);
            if (resource != null) {
                IJavaElement elem = JavaCore.create((IResource)resource);
                if (elem != null && project.isOnClasspath(elem)) {
                    result.add(elem);
                } else {
                    result.add(resource);
                }
            }
            ++i;
        }
        return result;
    }

    private static IResource getResource(IPath path, IJavaProject project) {
        return project.getProject().getWorkspace().getRoot().findMember(path);
    }

    private static boolean contains(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (path == null) {
            return false;
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ComparePaths, paths.length);
            if (path.getFileExtension() == null) {
                path = new Path(ClasspathModifier.completeName(path.toString()));
            }
            int i = 0;
            while (i < paths.length) {
                if (paths[i].equals((Object)path)) {
                    return true;
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private static String completeName(String name) {
        if (!JavaCore.isJavaLikeFileName((String)name)) {
            name = String.valueOf(name) + "/";
            name = name.replace('.', '/');
            return name;
        }
        return name;
    }

    private static IPath[] remove(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemovePath, paths.length + 5);
            if (!ClasspathModifier.contains(path, paths, (IProgressMonitor)new SubProgressMonitor(monitor, 5))) {
                IPath[] iPathArray = paths;
                return iPathArray;
            }
            ArrayList<IPath> newPaths = new ArrayList<IPath>();
            int i = 0;
            while (i < paths.length) {
                monitor.worked(1);
                if (!paths[i].equals((Object)path)) {
                    newPaths.add(paths[i]);
                }
                ++i;
            }
            IPath[] iPathArray = newPaths.toArray(new IPath[newPaths.size()]);
            return iPathArray;
        }
        finally {
            monitor.done();
        }
    }

    private List getFoldersOnCP(IPath path, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<Path> srcFolders = new ArrayList<Path>();
        IClasspathEntry[] cpEntries = project.getRawClasspath();
        int i = 0;
        while (i < cpEntries.length) {
            IPath cpPath = cpEntries[i].getPath();
            if (path.isPrefixOf(cpPath) && path.segmentCount() + 1 == cpPath.segmentCount()) {
                srcFolders.add(new Path(ClasspathModifier.completeName(cpPath.lastSegment())));
            }
            ++i;
        }
        return srcFolders;
    }

    private static String getName(IPath path, IPath rootPath) {
        return path.removeFirstSegments(rootPath.segmentCount()).toString();
    }

    public static void setNewEntry(List existingEntries, List newEntries, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_SetNewEntry, existingEntries.size());
            int i = 0;
            while (i < newEntries.size()) {
                CPListElement entry = (CPListElement)newEntries.get(i);
                ClasspathModifier.validateAndAddEntry(entry, existingEntries, project);
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IClasspathEntry[] convert(List list) {
        IClasspathEntry[] entries = new IClasspathEntry[list.size()];
        int i = 0;
        while (i < list.size()) {
            CPListElement element = (CPListElement)list.get(i);
            entries[i] = element.getClasspathEntry();
            ++i;
        }
        return entries;
    }

    private static void validateAndAddEntry(CPListElement entry, List existingEntries, IJavaProject project) throws CoreException {
        IPath path = entry.getPath();
        IPath projPath = project.getProject().getFullPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        StatusInfo rootStatus = new StatusInfo();
        rootStatus.setOK();
        boolean isExternal = ClasspathModifier.isExternalArchiveOrLibrary(entry, project);
        if (!isExternal && validate.matches(4) && !project.getPath().equals((Object)path)) {
            rootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            throw new CoreException((IStatus)rootStatus);
        }
        if (!isExternal && !project.getPath().equals((Object)path)) {
            IResource res = workspaceRoot.findMember(path);
            if (res != null) {
                if (res.getType() != 2 && res.getType() != 1) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                    throw new CoreException((IStatus)rootStatus);
                }
            } else {
                IFileStore store;
                URI projLocation = project.getProject().getLocationURI();
                if (projLocation != null && (store = EFS.getStore((URI)projLocation).getChild(path)).fetchInfo().exists()) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                    throw new CoreException((IStatus)rootStatus);
                }
            }
        }
        int i = 0;
        while (i < existingEntries.size()) {
            CPListElement curr = (CPListElement)existingEntries.get(i);
            if (curr.getEntryKind() == 3 && path.equals((Object)curr.getPath()) && !project.getPath().equals((Object)path)) {
                rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                throw new CoreException((IStatus)rootStatus);
            }
            ++i;
        }
        if (!isExternal && !entry.getPath().equals((Object)project.getPath())) {
            ClasspathModifier.exclude(entry.getPath(), existingEntries, new ArrayList(), project, null);
        }
        IPath outputLocation = project.getOutputLocation();
        ClasspathModifier.insertAtEndOfCategory(entry, existingEntries);
        IClasspathEntry[] entries = ClasspathModifier.convert(existingEntries);
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)project, (IClasspathEntry[])entries, (IPath)outputLocation);
        if (!status.isOK()) {
            IJavaModelStatus status2;
            if (outputLocation.equals((Object)projPath) && (status2 = JavaConventions.validateClasspath((IJavaProject)project, (IClasspathEntry[])entries, (IPath)outputLocation)).isOK()) {
                if (project.isOnClasspath((IJavaElement)project)) {
                    rootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSFandOL, outputLocation.makeRelative().toString()));
                } else {
                    rootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceOL, outputLocation.makeRelative().toString()));
                }
                return;
            }
            rootStatus.setError(status.getMessage());
            throw new CoreException((IStatus)rootStatus);
        }
        if (ClasspathModifier.isSourceFolder(project) || project.getPath().equals((Object)path)) {
            rootStatus.setWarning(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
            return;
        }
        rootStatus.setOK();
    }

    private static void insertAtEndOfCategory(CPListElement entry, List existingEntries) {
        int length = existingEntries.size();
        CPListElement[] elements = existingEntries.toArray(new CPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getClasspathEntry().getEntryKind() != entry.getClasspathEntry().getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getClasspathEntry().getEntryKind() == entry.getClasspathEntry().getEntryKind()) {
                ++i;
            }
            existingEntries.add(i, entry);
            return;
        }
        switch (entry.getClasspathEntry().getEntryKind()) {
            case 3: {
                existingEntries.add(0, entry);
                break;
            }
            default: {
                existingEntries.add(entry);
            }
        }
    }

    private static boolean isExternalArchiveOrLibrary(CPListElement entry, IJavaProject project) {
        if (entry.getEntryKind() == 1 || entry.getEntryKind() == 5) {
            return !(entry.getResource() instanceof IFolder);
        }
        return false;
    }

    private static boolean equalEntryKind(IClasspathEntry entry, int kind) {
        return entry.getEntryKind() == kind;
    }

    private void fireEvent(List newEntries) {
        if (this.fListener != null) {
            this.fListener.classpathEntryChanged(newEntries);
        }
    }

    private ClasspathModifierQueries.OutputFolderValidator getTrueValidator(IJavaProject project) throws JavaModelException {
        return new ClasspathModifierQueries.OutputFolderValidator(null, project){

            public boolean validate(IPath outputLocation) {
                return true;
            }
        };
    }

    public static ClasspathModifierQueries.OutputFolderValidator getValidator(final List newElements, IJavaProject project) throws JavaModelException {
        return new ClasspathModifierQueries.OutputFolderValidator(newElements, project){

            public boolean validate(IPath outputLocation) {
                int i = 0;
                while (i < newElements.size()) {
                    if (this.isInvalid(newElements.get(i), outputLocation)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.fEntries.length) {
                    if (this.isInvalid(this.fEntries[i], outputLocation)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private boolean isInvalid(Object object, IPath outputLocation) {
                IPath path = null;
                if (object instanceof IFolder) {
                    path = this.getFolderPath(object);
                } else if (object instanceof IJavaElement) {
                    path = this.getJavaElementPath(object);
                } else if (object instanceof IClasspathEntry) {
                    path = this.getCPEntryPath(object);
                }
                return this.isSubFolderOf(path, outputLocation);
            }

            private IPath getFolderPath(Object element) {
                return ((IFolder)element).getFullPath();
            }

            private IPath getJavaElementPath(Object element) {
                return ((IJavaElement)element).getPath();
            }

            private IPath getCPEntryPath(Object entry) {
                return ((IClasspathEntry)entry).getPath();
            }

            private boolean isSubFolderOf(IPath path1, IPath path2) {
                if (path1 == null || path2 == null) {
                    return path1 == null && path2 == null;
                }
                return path2.matchingFirstSegments(path1) == path2.segmentCount();
            }
        };
    }

    public static interface IClasspathModifierListener {
        public void classpathEntryChanged(List var1);
    }
}

