/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.formatter.AbortFormatting;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.InfixExpressionWrappingBuilder;
import org.eclipse.jdt.internal.formatter.MethodInvocationFragmentBuilder;
import org.eclipse.jdt.internal.formatter.Scribe2;
import org.eclipse.jdt.internal.formatter.align.Alignment2;
import org.eclipse.jdt.internal.formatter.align.AlignmentException;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterVisitor2
extends ASTVisitor {
    public static boolean DEBUG = false;
    private static final int[] CLOSING_GENERICS_EXPECTEDTOKENS = new int[]{8, 11, 12};
    private static final int[] NUMBER_LITERALS_EXPECTEDTOKENS = new int[]{47, 48, 49, 50};
    private static final int[] PRIMITIVE_TYPE_EXPECTEDTOKENS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40};
    private Scanner localScanner;
    public DefaultCodeFormatterOptions preferences;
    public Scribe2 scribe;

    public CodeFormatterVisitor2(DefaultCodeFormatterOptions preferences, Map settings, int offset, int length, CompilationUnit unit) {
        long sourceLevel = settings == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(settings.get("org.eclipse.jdt.core.compiler.source"));
        this.localScanner = new Scanner(true, false, false, sourceLevel, null, null, true);
        this.preferences = preferences;
        this.scribe = new Scribe2(this, sourceLevel, offset, length, unit);
    }

    private boolean commentStartsBlock(int start, int end) {
        this.localScanner.resetTo(start, end);
        try {
            if (this.localScanner.getNextToken() == 68) {
                switch (this.localScanner.getNextToken()) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        return true;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public static int extractInfixExpressionOperator(InfixExpression node) {
        InfixExpression.Operator infixOperator = node.getOperator();
        if (infixOperator == InfixExpression.Operator.AND) {
            return 20;
        }
        if (infixOperator == InfixExpression.Operator.CONDITIONAL_AND) {
            return 24;
        }
        if (infixOperator == InfixExpression.Operator.CONDITIONAL_OR) {
            return 25;
        }
        if (infixOperator == InfixExpression.Operator.DIVIDE) {
            return 6;
        }
        if (infixOperator == InfixExpression.Operator.EQUALS) {
            return 18;
        }
        if (infixOperator == InfixExpression.Operator.GREATER) {
            return 12;
        }
        if (infixOperator == InfixExpression.Operator.GREATER_EQUALS) {
            return 17;
        }
        if (infixOperator == InfixExpression.Operator.LEFT_SHIFT) {
            return 13;
        }
        if (infixOperator == InfixExpression.Operator.LESS) {
            return 7;
        }
        if (infixOperator == InfixExpression.Operator.LESS_EQUALS) {
            return 16;
        }
        if (infixOperator == InfixExpression.Operator.MINUS) {
            return 2;
        }
        if (infixOperator == InfixExpression.Operator.NOT_EQUALS) {
            return 19;
        }
        if (infixOperator == InfixExpression.Operator.OR) {
            return 22;
        }
        if (infixOperator == InfixExpression.Operator.PLUS) {
            return 1;
        }
        if (infixOperator == InfixExpression.Operator.REMAINDER) {
            return 5;
        }
        if (infixOperator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
            return 8;
        }
        if (infixOperator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
            return 11;
        }
        if (infixOperator == InfixExpression.Operator.TIMES) {
            return 4;
        }
        return 21;
    }

    private final TextEdit failedToFormat() {
        if (DEBUG) {
            System.out.println("COULD NOT FORMAT \n" + this.scribe.scanner);
            System.out.println(this.scribe);
        }
        return null;
    }

    public TextEdit format(String string, AbstractTypeDeclaration typeDeclaration) {
        this.scribe.reset();
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        try {
            this.scribe.lastNumberOfNewLines = 1;
            this.formatTypeMembers(typeDeclaration.bodyDeclarations(), false);
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    public TextEdit format(String string, Block block) {
        this.scribe.reset();
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        if ((block.getFlags() & 1) != 0) {
            return this.failedToFormat();
        }
        try {
            this.formatStatements(block.statements(), false);
            if (this.hasComments()) {
                this.scribe.printNewLine();
            }
            this.scribe.printComment();
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    public TextEdit format(String string, CompilationUnit compilationUnit) {
        this.scribe.reset();
        if ((compilationUnit.getFlags() & 1) != 0) {
            return this.failedToFormat();
        }
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        try {
            compilationUnit.accept(this);
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    public TextEdit format(String string, Expression expression) {
        this.scribe.reset();
        long startTime = System.currentTimeMillis();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        if ((expression.getFlags() & 1) != 0) {
            return this.failedToFormat();
        }
        try {
            expression.accept(this);
            this.scribe.printComment();
        }
        catch (AbortFormatting abortFormatting) {
            return this.failedToFormat();
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    private void format(AbstractTypeDeclaration memberTypeDeclaration, boolean isChunkStart, boolean isFirstClassBodyDeclaration) {
        if (isFirstClassBodyDeclaration) {
            int newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration;
            if (newLinesBeforeFirstClassBodyDeclaration > 0) {
                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
            }
        } else {
            int newLinesBeforeMember;
            int newLineBeforeChunk;
            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
            if (newLineBeforeChunk > 0) {
                this.scribe.printEmptyLines(newLineBeforeChunk);
            }
            if ((newLinesBeforeMember = this.preferences.blank_lines_before_member_type) > 0) {
                this.scribe.printEmptyLines(newLinesBeforeMember);
            }
        }
        memberTypeDeclaration.accept(this);
    }

    private void format(FieldDeclaration fieldDeclaration, boolean isChunkStart, boolean isFirstClassBodyDeclaration) {
        if (isFirstClassBodyDeclaration) {
            int newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration;
            if (newLinesBeforeFirstClassBodyDeclaration > 0) {
                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
            }
        } else {
            int newLinesBeforeField;
            int newLineBeforeChunk;
            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
            if (newLineBeforeChunk > 0) {
                this.scribe.printEmptyLines(newLineBeforeChunk);
            }
            if ((newLinesBeforeField = this.preferences.blank_lines_before_field) > 0) {
                this.scribe.printEmptyLines(newLinesBeforeField);
            }
        }
        Alignment2 memberAlignment = this.scribe.getMemberAlignment();
        this.scribe.printComment();
        List modifiers = fieldDeclaration.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        fieldDeclaration.getType().accept(this);
        List fragments = fieldDeclaration.fragments();
        int fragmentsLength = fragments.size();
        if (fragmentsLength > 1) {
            Alignment2 multiFieldDeclarationsAlignment = this.scribe.createAlignment("multiple_field", this.preferences.alignment_for_multiple_fields, fragmentsLength - 1, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(multiFieldDeclarationsAlignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < fragmentsLength) {
                        Expression initialization;
                        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
                        if (i == 0) {
                            this.scribe.alignFragment(memberAlignment, 0);
                            this.scribe.printNextToken(26, true);
                        } else {
                            this.scribe.printNextToken(26, false);
                        }
                        int extraDimensions = fragment.getExtraDimensions();
                        if (extraDimensions != 0) {
                            int index = 0;
                            while (index < extraDimensions) {
                                this.scribe.printNextToken(14);
                                this.scribe.printNextToken(70);
                                ++index;
                            }
                        }
                        if ((initialization = fragment.getInitializer()) != null) {
                            if (i == 0) {
                                this.scribe.alignFragment(memberAlignment, 1);
                            }
                            this.scribe.printNextToken(71, this.preferences.insert_space_before_assignment_operator);
                            if (this.preferences.insert_space_after_assignment_operator) {
                                this.scribe.space();
                            }
                            Alignment2 assignmentAlignment = this.scribe.createAlignment("fieldDeclarationAssignmentAlignment", this.preferences.alignment_for_assignment, 1, this.scribe.scanner.currentPosition);
                            this.scribe.enterAlignment(assignmentAlignment);
                            boolean ok2 = false;
                            do {
                                try {
                                    this.scribe.alignFragment(assignmentAlignment, 0);
                                    initialization.accept(this);
                                    ok2 = true;
                                }
                                catch (AlignmentException e) {
                                    this.scribe.redoAlignment(e);
                                }
                            } while (!ok2);
                            this.scribe.exitAlignment(assignmentAlignment, true);
                        }
                        if (i != fragmentsLength - 1) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_multiple_field_declarations);
                            this.scribe.printTrailingComment();
                            this.scribe.alignFragment(multiFieldDeclarationsAlignment, i);
                            if (this.preferences.insert_space_after_comma_in_multiple_field_declarations) {
                                this.scribe.space();
                            }
                        } else {
                            this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
                            this.scribe.alignFragment(memberAlignment, 2);
                            this.scribe.printTrailingComment();
                        }
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(multiFieldDeclarationsAlignment, true);
        } else {
            Expression initialization;
            this.scribe.alignFragment(memberAlignment, 0);
            this.scribe.printNextToken(26, true);
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            int extraDimensions = fragment.getExtraDimensions();
            if (extraDimensions != 0) {
                int i = 0;
                while (i < extraDimensions) {
                    this.scribe.printNextToken(14);
                    this.scribe.printNextToken(70);
                    ++i;
                }
            }
            if ((initialization = fragment.getInitializer()) != null) {
                this.scribe.alignFragment(memberAlignment, 1);
                this.scribe.printNextToken(71, this.preferences.insert_space_before_assignment_operator);
                if (this.preferences.insert_space_after_assignment_operator) {
                    this.scribe.space();
                }
                Alignment2 assignmentAlignment = this.scribe.createAlignment("fieldDeclarationAssignmentAlignment", this.preferences.alignment_for_assignment, 1, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(assignmentAlignment);
                boolean ok = false;
                do {
                    try {
                        this.scribe.alignFragment(assignmentAlignment, 0);
                        initialization.accept(this);
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(assignmentAlignment, true);
            }
            this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
            if (memberAlignment != null) {
                this.scribe.alignFragment(memberAlignment, 2);
                this.scribe.printTrailingComment();
            } else {
                this.scribe.space();
                this.scribe.printTrailingComment();
            }
        }
    }

    private void format(BodyDeclaration bodyDeclaration, boolean isChunkStart, boolean isFirstClassBodyDeclaration) {
        int newLinesBeforeMethod;
        if (isFirstClassBodyDeclaration) {
            int newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration;
            if (newLinesBeforeFirstClassBodyDeclaration > 0) {
                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
            }
        } else {
            int newLineBeforeChunk;
            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
            if (newLineBeforeChunk > 0) {
                this.scribe.printEmptyLines(newLineBeforeChunk);
            }
        }
        if ((newLinesBeforeMethod = this.preferences.blank_lines_before_method) > 0 && !isFirstClassBodyDeclaration) {
            this.scribe.printEmptyLines(newLinesBeforeMethod);
        } else if (this.scribe.line != 0 || this.scribe.column != 1) {
            this.scribe.printNewLine();
        }
        bodyDeclaration.accept(this);
    }

    private void formatAction(int line, Statement action, boolean insertLineForSingleStatement) {
        if (action != null) {
            switch (action.getNodeType()) {
                case 8: {
                    this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                    action.accept(this);
                    break;
                }
                case 20: {
                    this.scribe.indent();
                    action.accept(this);
                    this.scribe.unIndent();
                    break;
                }
                default: {
                    this.scribe.printNewLine();
                    this.scribe.indent();
                    action.accept(this);
                    this.scribe.unIndent();
                    if (insertLineForSingleStatement) {
                        this.scribe.printNewLine();
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            this.scribe.indent();
            action.accept(this);
            this.scribe.unIndent();
        }
    }

    private void formatBlock(Block block, String block_brace_position, boolean insertSpaceBeforeOpeningBrace) {
        this.formatOpeningBrace(block_brace_position, insertSpaceBeforeOpeningBrace);
        List statements = block.statements();
        int statementsLength = statements.size();
        if (statementsLength != 0) {
            this.scribe.printNewLine();
            if (this.preferences.indent_statements_compare_to_block) {
                this.scribe.indent();
            }
            this.formatStatements(statements, true);
            this.scribe.printComment();
            if (this.preferences.indent_statements_compare_to_block) {
                this.scribe.unIndent();
            }
        } else {
            if (this.preferences.insert_new_line_in_empty_block) {
                this.scribe.printNewLine();
            }
            if (this.preferences.indent_statements_compare_to_block) {
                this.scribe.indent();
            }
            this.scribe.printComment();
            if (this.preferences.indent_statements_compare_to_block) {
                this.scribe.unIndent();
            }
        }
        this.scribe.printNextToken(31);
        this.scribe.printTrailingComment();
        if ("next_line_shifted".equals(block_brace_position)) {
            this.scribe.unIndent();
        }
    }

    private void formatEmptyTypeDeclaration(boolean isFirst) {
        boolean hasSemiColon = this.isNextToken(27);
        while (this.isNextToken(27)) {
            this.scribe.printComment();
            this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        if (hasSemiColon && isFirst) {
            this.scribe.printNewLine();
        }
    }

    private void formatLeftCurlyBrace(int line, String bracePosition) {
        this.scribe.printComment();
        if ("next_line_on_wrap".equals(bracePosition) && (this.scribe.line > line || this.scribe.column >= this.preferences.page_width)) {
            this.scribe.printNewLine();
        }
    }

    private void formatLocalDeclaration(VariableDeclarationExpression declarationExpression, boolean insertSpaceBeforeComma, boolean insertSpaceAfterComma) {
        List modifiers = declarationExpression.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        declarationExpression.getType().accept(this);
        this.formatVariableDeclarationFragments(declarationExpression.fragments(), insertSpaceBeforeComma, insertSpaceAfterComma);
    }

    private void formatVariableDeclarationFragments(List fragments, boolean insertSpaceBeforeComma, boolean insertSpaceAfterComma) {
        int fragmentsLength = fragments.size();
        if (fragmentsLength > 1) {
            Alignment2 multiFieldDeclarationsAlignment = this.scribe.createAlignment("multiple_field", this.preferences.alignment_for_multiple_fields, fragmentsLength - 1, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(multiFieldDeclarationsAlignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < fragmentsLength) {
                        Expression initialization;
                        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
                        if (i == 0) {
                            this.scribe.printNextToken(26, true);
                        } else {
                            this.scribe.printNextToken(26, false);
                        }
                        int extraDimensions = fragment.getExtraDimensions();
                        if (extraDimensions != 0) {
                            int index = 0;
                            while (index < extraDimensions) {
                                this.scribe.printNextToken(14);
                                this.scribe.printNextToken(70);
                                ++index;
                            }
                        }
                        if ((initialization = fragment.getInitializer()) != null) {
                            this.scribe.printNextToken(71, this.preferences.insert_space_before_assignment_operator);
                            if (this.preferences.insert_space_after_assignment_operator) {
                                this.scribe.space();
                            }
                            Alignment2 assignmentAlignment = this.scribe.createAlignment("fieldDeclarationAssignmentAlignment", this.preferences.alignment_for_assignment, 1, this.scribe.scanner.currentPosition);
                            this.scribe.enterAlignment(assignmentAlignment);
                            boolean ok2 = false;
                            do {
                                try {
                                    this.scribe.alignFragment(assignmentAlignment, 0);
                                    initialization.accept(this);
                                    ok2 = true;
                                }
                                catch (AlignmentException e) {
                                    this.scribe.redoAlignment(e);
                                }
                            } while (!ok2);
                            this.scribe.exitAlignment(assignmentAlignment, true);
                        }
                        if (i != fragmentsLength - 1) {
                            this.scribe.printNextToken(30, insertSpaceBeforeComma);
                            this.scribe.printTrailingComment();
                            this.scribe.alignFragment(multiFieldDeclarationsAlignment, i);
                            if (insertSpaceAfterComma) {
                                this.scribe.space();
                            }
                        }
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(multiFieldDeclarationsAlignment, true);
        } else {
            Expression initialization;
            this.scribe.printNextToken(26, true);
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            int extraDimensions = fragment.getExtraDimensions();
            if (extraDimensions != 0) {
                int i = 0;
                while (i < extraDimensions) {
                    this.scribe.printNextToken(14);
                    this.scribe.printNextToken(70);
                    ++i;
                }
            }
            if ((initialization = fragment.getInitializer()) != null) {
                this.scribe.printNextToken(71, this.preferences.insert_space_before_assignment_operator);
                if (this.preferences.insert_space_after_assignment_operator) {
                    this.scribe.space();
                }
                Alignment2 assignmentAlignment = this.scribe.createAlignment("localDeclarationAssignmentAlignment", this.preferences.alignment_for_assignment, 1, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(assignmentAlignment);
                boolean ok = false;
                do {
                    try {
                        this.scribe.alignFragment(assignmentAlignment, 0);
                        initialization.accept(this);
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(assignmentAlignment, true);
            }
        }
    }

    private void formatOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace) {
        if ("next_line".equals(bracePosition)) {
            this.scribe.printNewLine();
        } else if ("next_line_shifted".equals(bracePosition)) {
            this.scribe.printNewLine();
            this.scribe.indent();
        }
        this.scribe.printNextToken(68, insertSpaceBeforeBrace);
        this.scribe.printTrailingComment();
    }

    private void formatStatements(List statements, boolean insertNewLineAfterLastStatement) {
        int statementsLength = statements.size();
        if (statementsLength > 1) {
            Statement previousStatement = (Statement)statements.get(0);
            previousStatement.accept(this);
            int previousStatementNodeType = previousStatement.getNodeType();
            int i = 1;
            while (i < statementsLength - 1) {
                Statement statement = (Statement)statements.get(i);
                int statementNodeType = statement.getNodeType();
                if (previousStatementNodeType == 20 && statementNodeType != 20 || previousStatementNodeType != 20 && statementNodeType != 20) {
                    this.scribe.printNewLine();
                }
                statement.accept(this);
                previousStatement = statement;
                ++i;
            }
            Statement statement = (Statement)statements.get(statementsLength - 1);
            int statementNodeType = statement.getNodeType();
            if (previousStatementNodeType == 20 && statementNodeType != 20 || previousStatementNodeType != 20 && statementNodeType != 20) {
                this.scribe.printNewLine();
            }
            statement.accept(this);
        } else {
            ((Statement)statements.get(0)).accept(this);
        }
        if (insertNewLineAfterLastStatement) {
            this.scribe.printNewLine();
        }
    }

    private void formatTypeMembers(List bodyDeclarations, boolean insertLineAfterLastMember) {
        Alignment2 memberAlignment = this.scribe.createMemberAlignment("typeMembers", this.preferences.align_type_members_on_columns ? 256 : 0, 3, this.scribe.scanner.currentPosition);
        this.scribe.enterMemberAlignment(memberAlignment);
        boolean isChunkStart = false;
        boolean ok = false;
        int startIndex = 0;
        do {
            try {
                int i = startIndex;
                int max = bodyDeclarations.size();
                while (i < max) {
                    BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(i);
                    switch (bodyDeclaration.getNodeType()) {
                        case 23: {
                            isChunkStart = memberAlignment.checkChunkStart(1, i, this.scribe.scanner.currentPosition);
                            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                            this.format(fieldDeclaration, isChunkStart, i == 0);
                            break;
                        }
                        case 28: {
                            int newLinesBeforeFirstClassBodyDeclaration;
                            int newLineBeforeChunk;
                            isChunkStart = memberAlignment.checkChunkStart(1, i, this.scribe.scanner.currentPosition);
                            int n = newLineBeforeChunk = isChunkStart ? this.preferences.blank_lines_before_new_chunk : 0;
                            if (newLineBeforeChunk > 0 && i != 0) {
                                this.scribe.printEmptyLines(newLineBeforeChunk);
                            } else if (i == 0 && (newLinesBeforeFirstClassBodyDeclaration = this.preferences.blank_lines_before_first_class_body_declaration) > 0) {
                                this.scribe.printEmptyLines(newLinesBeforeFirstClassBodyDeclaration);
                            }
                            bodyDeclaration.accept(this);
                            break;
                        }
                        case 31: 
                        case 82: {
                            isChunkStart = memberAlignment.checkChunkStart(2, i, this.scribe.scanner.currentPosition);
                            this.format(bodyDeclaration, isChunkStart, i == 0);
                            break;
                        }
                        case 55: 
                        case 71: 
                        case 81: {
                            isChunkStart = memberAlignment.checkChunkStart(3, i, this.scribe.scanner.currentPosition);
                            this.format((AbstractTypeDeclaration)bodyDeclaration, isChunkStart, i == 0);
                        }
                    }
                    if (this.isNextToken(27)) {
                        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
                        this.scribe.printTrailingComment();
                    }
                    if (i < max - 1 || insertLineAfterLastMember) {
                        this.scribe.printNewLine();
                    }
                    if (this.scribe.memberAlignment != null) {
                        this.scribe.indentationLevel = this.scribe.memberAlignment.originalIndentationLevel;
                    }
                    ++i;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                startIndex = memberAlignment.chunkStartIndex;
                this.scribe.redoMemberAlignment(e);
            }
        } while (!ok);
        this.scribe.printComment();
        this.scribe.exitMemberAlignment(memberAlignment);
    }

    private void formatTypeOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace, boolean insertNewLine, ASTNode node) {
        this.formatOpeningBrace(bracePosition, insertSpaceBeforeBrace);
        if (!insertNewLine) {
            switch (node.getNodeType()) {
                case 71: {
                    insertNewLine = this.preferences.insert_new_line_in_empty_enum_declaration;
                    break;
                }
                case 72: {
                    insertNewLine = this.preferences.insert_new_line_in_empty_enum_constant;
                    break;
                }
                case 1: {
                    insertNewLine = this.preferences.insert_new_line_in_empty_anonymous_type_declaration;
                    break;
                }
                case 81: {
                    insertNewLine = this.preferences.insert_new_line_in_empty_annotation_declaration;
                    break;
                }
                default: {
                    insertNewLine = this.preferences.insert_new_line_in_empty_type_declaration;
                }
            }
        }
        if (insertNewLine) {
            this.scribe.printNewLine();
        }
    }

    private boolean hasComments() {
        this.localScanner.resetTo(this.scribe.scanner.startPosition, this.scribe.scannerEndPosition - 1);
        try {
            switch (this.localScanner.getNextToken()) {
                case 1001: 
                case 1002: 
                case 1003: {
                    return true;
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    private boolean isClosingGenericToken() {
        this.localScanner.resetTo(this.scribe.scanner.currentPosition, this.scribe.scannerEndPosition - 1);
        try {
            int token = this.localScanner.getNextToken();
            block8: while (true) {
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        token = this.localScanner.getNextToken();
                        continue block8;
                    }
                }
                break;
            }
            switch (token) {
                case 8: 
                case 11: 
                case 12: {
                    return true;
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    private boolean isGuardClause(Block block, List statements) {
        if (this.commentStartsBlock(block.getStartPosition(), block.getStartPosition() + block.getLength() - 1)) {
            return false;
        }
        int statementsLength = statements.size();
        if (statementsLength != 1) {
            return false;
        }
        switch (((Statement)statements.get(0)).getNodeType()) {
            case 41: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private boolean isNextToken(int tokenName) {
        this.localScanner.resetTo(this.scribe.scanner.currentPosition, this.scribe.scannerEndPosition - 1);
        try {
            int token = this.localScanner.getNextToken();
            block5: while (true) {
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        token = this.localScanner.getNextToken();
                        continue block5;
                    }
                }
                break;
            }
            return token == tokenName;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        this.scribe.printNextToken(53, this.preferences.insert_space_before_at_in_annotation_type_declaration);
        this.scribe.printNextToken(95, this.preferences.insert_space_after_at_in_annotation_type_declaration);
        this.scribe.printNextToken(26, true);
        String class_declaration_brace = this.preferences.brace_position_for_annotation_type_declaration;
        boolean space_before_opening_brace = this.preferences.insert_space_before_opening_brace_in_annotation_type_declaration;
        this.formatLeftCurlyBrace(line, class_declaration_brace);
        List bodyDeclarations = node.bodyDeclarations();
        this.formatTypeOpeningBrace(class_declaration_brace, space_before_opening_brace, bodyDeclarations.size() != 0, node);
        boolean indent_body_declarations_compare_to_header = this.preferences.indent_body_declarations_compare_to_annotation_declaration_header;
        if (indent_body_declarations_compare_to_header) {
            this.scribe.indent();
        }
        this.formatTypeMembers(bodyDeclarations, true);
        if (indent_body_declarations_compare_to_header) {
            this.scribe.unIndent();
        }
        if (this.preferences.insert_new_line_in_empty_annotation_declaration) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(31);
        this.scribe.printTrailingComment();
        if (class_declaration_brace.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        if (this.hasComments()) {
            this.scribe.printNewLine();
        }
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        this.scribe.printComment();
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        node.getType().accept(this);
        this.scribe.printNextToken(26, true);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_annotation_type_member_declaration);
        this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_annotation_type_member_declaration);
        Expression defaultValue = node.getDefault();
        if (defaultValue != null) {
            this.scribe.printNextToken(97, true);
            this.scribe.space();
            defaultValue.accept(this);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        String anonymous_type_declaration_brace_position = this.preferences.brace_position_for_anonymous_type_declaration;
        List bodyDeclarations = node.bodyDeclarations();
        this.formatTypeOpeningBrace(anonymous_type_declaration_brace_position, this.preferences.insert_space_before_opening_brace_in_anonymous_type_declaration, bodyDeclarations.size() != 0, node);
        this.scribe.indent();
        this.formatTypeMembers(bodyDeclarations, true);
        this.scribe.unIndent();
        if (this.preferences.insert_new_line_in_empty_anonymous_type_declaration) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(31);
        if (anonymous_type_declaration_brace_position.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        return false;
    }

    public boolean visit(ArrayAccess node) {
        node.getArray().accept(this);
        this.scribe.printNextToken(14, this.preferences.insert_space_before_opening_bracket_in_array_reference);
        if (this.preferences.insert_space_after_opening_bracket_in_array_reference) {
            this.scribe.space();
        }
        node.getIndex().accept(this);
        this.scribe.printNextToken(70, this.preferences.insert_space_before_closing_bracket_in_array_reference);
        return false;
    }

    public boolean visit(ArrayCreation node) {
        int i;
        this.scribe.printNextToken(43);
        this.scribe.space();
        ArrayType type = node.getType();
        List dimensions = node.dimensions();
        int dimensionsLength = dimensions.size();
        int arrayTypeDimensions = type.getDimensions();
        type.getElementType().accept(this);
        if (dimensionsLength != 0) {
            i = 0;
            while (i < dimensionsLength) {
                this.scribe.printNextToken(14, this.preferences.insert_space_before_opening_bracket_in_array_allocation_expression);
                Expression dimension = (Expression)dimensions.get(i);
                if (dimension != null) {
                    if (this.preferences.insert_space_after_opening_bracket_in_array_allocation_expression) {
                        this.scribe.space();
                    }
                    dimension.accept(this);
                    this.scribe.printNextToken(70, this.preferences.insert_space_before_closing_bracket_in_array_allocation_expression);
                } else {
                    this.scribe.printNextToken(70, this.preferences.insert_space_between_empty_brackets_in_array_allocation_expression);
                }
                ++i;
            }
            i = 0;
            int max = arrayTypeDimensions - dimensionsLength;
            while (i < max) {
                this.scribe.printNextToken(14, this.preferences.insert_space_before_opening_bracket_in_array_allocation_expression);
                this.scribe.printNextToken(70, this.preferences.insert_space_between_empty_brackets_in_array_allocation_expression);
                ++i;
            }
        } else {
            i = 0;
            while (i < arrayTypeDimensions) {
                this.scribe.printNextToken(14, this.preferences.insert_space_before_opening_bracket_in_array_allocation_expression);
                this.scribe.printNextToken(70, this.preferences.insert_space_between_empty_brackets_in_array_allocation_expression);
                ++i;
            }
        }
        ArrayInitializer initializer = node.getInitializer();
        if (initializer != null) {
            initializer.accept(this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        List expressions = node.expressions();
        int expressionsLength = expressions.size();
        if (expressionsLength != 0) {
            String array_initializer_brace_position = this.preferences.brace_position_for_array_initializer;
            this.formatOpeningBrace(array_initializer_brace_position, this.preferences.insert_space_before_opening_brace_in_array_initializer);
            boolean insert_new_line_after_opening_brace = this.preferences.insert_new_line_after_opening_brace_in_array_initializer;
            if (expressionsLength > 1) {
                if (insert_new_line_after_opening_brace) {
                    this.scribe.printNewLine();
                }
                Alignment2 arrayInitializerAlignment = this.scribe.createAlignment("array_initializer", this.preferences.alignment_for_expressions_in_array_initializer, 1, expressionsLength, this.scribe.scanner.currentPosition, this.preferences.continuation_indentation_for_array_initializer, true);
                if (insert_new_line_after_opening_brace) {
                    arrayInitializerAlignment.fragmentIndentations[0] = arrayInitializerAlignment.breakIndentationLevel;
                }
                this.scribe.enterAlignment(arrayInitializerAlignment);
                boolean ok = false;
                do {
                    try {
                        this.scribe.alignFragment(arrayInitializerAlignment, 0);
                        if (this.preferences.insert_space_after_opening_brace_in_array_initializer) {
                            this.scribe.space();
                        }
                        ((Expression)expressions.get(0)).accept(this);
                        int i = 1;
                        while (i < expressionsLength) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                            this.scribe.printTrailingComment();
                            this.scribe.alignFragment(arrayInitializerAlignment, i);
                            if (this.preferences.insert_space_after_comma_in_array_initializer) {
                                this.scribe.space();
                            }
                            ((Expression)expressions.get(i)).accept(this);
                            if (i == expressionsLength - 1 && this.isNextToken(30)) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                                this.scribe.printTrailingComment();
                            }
                            ++i;
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(arrayInitializerAlignment, true);
            } else {
                if (insert_new_line_after_opening_brace) {
                    this.scribe.printNewLine();
                    this.scribe.indent();
                }
                if (this.preferences.insert_space_after_opening_brace_in_array_initializer) {
                    this.scribe.space();
                } else {
                    this.scribe.needSpace = false;
                }
                ((Expression)expressions.get(0)).accept(this);
                if (this.isNextToken(30)) {
                    this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_array_initializer);
                    this.scribe.printTrailingComment();
                }
                if (insert_new_line_after_opening_brace) {
                    this.scribe.unIndent();
                }
            }
            if (this.preferences.insert_new_line_before_closing_brace_in_array_initializer) {
                this.scribe.printNewLine();
            } else if (this.preferences.insert_space_before_closing_brace_in_array_initializer) {
                this.scribe.space();
            }
            this.scribe.printNextToken(31, false);
            if (array_initializer_brace_position.equals("next_line_shifted")) {
                this.scribe.unIndent();
            }
        } else {
            boolean keepEmptyArrayInitializerOnTheSameLine = this.preferences.keep_empty_array_initializer_on_one_line;
            String array_initializer_brace_position = this.preferences.brace_position_for_array_initializer;
            if (keepEmptyArrayInitializerOnTheSameLine) {
                this.scribe.printNextToken(68, this.preferences.insert_space_before_opening_brace_in_array_initializer);
                this.scribe.printNextToken(31, this.preferences.insert_space_between_empty_braces_in_array_initializer);
            } else {
                this.formatOpeningBrace(array_initializer_brace_position, this.preferences.insert_space_before_opening_brace_in_array_initializer);
                this.scribe.printNextToken(31, false);
                if (array_initializer_brace_position.equals("next_line_shifted")) {
                    this.scribe.unIndent();
                }
            }
        }
        return false;
    }

    public boolean visit(ArrayType node) {
        node.getComponentType().accept(this);
        if (this.preferences.insert_space_before_opening_bracket_in_array_type_reference) {
            this.scribe.space();
        }
        this.scribe.printNextToken(14);
        if (this.preferences.insert_space_between_brackets_in_array_type_reference) {
            this.scribe.space();
        }
        this.scribe.printNextToken(70);
        return false;
    }

    public boolean visit(AssertStatement node) {
        this.scribe.printNextToken(74);
        this.scribe.space();
        node.getExpression().accept(this);
        Expression message = node.getMessage();
        if (message != null) {
            this.scribe.printNextToken(65, this.preferences.insert_space_before_colon_in_assert);
            if (this.preferences.insert_space_after_colon_in_assert) {
                this.scribe.space();
            }
            message.accept(this);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept(this);
        Assignment.Operator operator = node.getOperator();
        if (operator == Assignment.Operator.ASSIGN) {
            this.scribe.printNextToken(71, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.MINUS_ASSIGN) {
            this.scribe.printNextToken(85, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.PLUS_ASSIGN) {
            this.scribe.printNextToken(84, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.TIMES_ASSIGN) {
            this.scribe.printNextToken(86, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.DIVIDE_ASSIGN) {
            this.scribe.printNextToken(87, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.REMAINDER_ASSIGN) {
            this.scribe.printNextToken(91, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.LEFT_SHIFT_ASSIGN) {
            this.scribe.printNextToken(92, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN) {
            this.scribe.printNextToken(93, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN) {
            this.scribe.printNextToken(94, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.BIT_AND_ASSIGN) {
            this.scribe.printNextToken(88, this.preferences.insert_space_before_assignment_operator);
        } else if (operator == Assignment.Operator.BIT_OR_ASSIGN) {
            this.scribe.printNextToken(89, this.preferences.insert_space_before_assignment_operator);
        } else {
            this.scribe.printNextToken(90, this.preferences.insert_space_before_assignment_operator);
        }
        if (this.preferences.insert_space_after_assignment_operator) {
            this.scribe.space();
        }
        Alignment2 assignmentAlignment = this.scribe.createAlignment("assignmentAlignment", this.preferences.alignment_for_assignment, 1, this.scribe.scanner.currentPosition);
        this.scribe.enterAlignment(assignmentAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(assignmentAlignment, 0);
                node.getRightHandSide().accept(this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(assignmentAlignment, true);
        return false;
    }

    public boolean visit(Block node) {
        this.formatBlock(node, this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block);
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.scribe.printNextToken(46);
        } else {
            this.scribe.printNextToken(44);
        }
        return false;
    }

    public boolean visit(BreakStatement node) {
        this.scribe.printNextToken(75);
        if (node.getLabel() != null) {
            this.scribe.printNextToken(26, true);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(CastExpression node) {
        this.scribe.printNextToken(28);
        if (this.preferences.insert_space_after_opening_paren_in_cast) {
            this.scribe.space();
        }
        node.getType().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_cast);
        if (this.preferences.insert_space_after_closing_paren_in_cast) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        this.scribe.printNextToken(51);
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        Expression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(43);
        List typeArguments = node.typeArguments();
        int length = typeArguments.size();
        if (length != 0) {
            this.scribe.printNextToken(7, this.preferences.insert_space_before_opening_angle_bracket_in_type_arguments);
            if (this.preferences.insert_space_after_opening_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
            int i = 0;
            while (i < length - 1) {
                ((Type)typeArguments.get(i)).accept(this);
                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_type_arguments);
                if (this.preferences.insert_space_after_comma_in_type_arguments) {
                    this.scribe.space();
                }
                ++i;
            }
            ((Type)typeArguments.get(length - 1)).accept(this);
            if (this.isClosingGenericToken()) {
                this.scribe.printNextToken(CLOSING_GENERICS_EXPECTEDTOKENS, this.preferences.insert_space_before_closing_angle_bracket_in_type_arguments);
            }
            if (this.preferences.insert_space_after_closing_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
        } else {
            this.scribe.space();
        }
        node.getType().accept(this);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_method_invocation);
        List arguments = node.arguments();
        int argumentsLength = arguments.size();
        if (argumentsLength != 0) {
            if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
                this.scribe.space();
            }
            Alignment2 argumentsAlignment = this.scribe.createAlignment("allocation", this.preferences.alignment_for_arguments_in_allocation_expression, argumentsLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(argumentsAlignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < argumentsLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_allocation_expression);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(argumentsAlignment, i);
                        if (i > 0 && this.preferences.insert_space_after_comma_in_allocation_expression) {
                            this.scribe.space();
                        }
                        ((Expression)arguments.get(i)).accept(this);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(argumentsAlignment, true);
            this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_method_invocation);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_method_invocation);
        }
        AnonymousClassDeclaration classDeclaration = node.getAnonymousClassDeclaration();
        if (classDeclaration != null) {
            classDeclaration.accept(this);
        }
        return false;
    }

    public boolean visit(CompilationUnit node) {
        boolean hasPackage;
        this.scribe.lastNumberOfNewLines = 1;
        PackageDeclaration packageDeclaration = node.getPackage();
        boolean bl = hasPackage = packageDeclaration != null;
        if (hasPackage) {
            List annotations;
            int blankLinesBeforePackage;
            if (this.hasComments()) {
                this.scribe.printComment();
            }
            if ((blankLinesBeforePackage = this.preferences.blank_lines_before_package) > 0) {
                this.scribe.printEmptyLines(blankLinesBeforePackage);
            }
            if ((annotations = packageDeclaration.annotations()).size() != 0) {
                this.scribe.printModifiers(annotations, this);
                this.scribe.space();
            }
            this.scribe.printNextToken(96);
            this.scribe.space();
            packageDeclaration.getName().accept(this);
            this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
            int blankLinesAfterPackage = this.preferences.blank_lines_after_package;
            if (blankLinesAfterPackage > 0) {
                this.scribe.printEmptyLines(blankLinesAfterPackage);
            } else {
                this.scribe.printNewLine();
            }
        } else {
            this.scribe.printComment();
        }
        List imports = node.imports();
        int importsLength = imports.size();
        if (importsLength != 0) {
            int blankLinesBeforeImports;
            if (hasPackage && (blankLinesBeforeImports = this.preferences.blank_lines_before_imports) > 0) {
                this.scribe.printEmptyLines(blankLinesBeforeImports);
            }
            int i = 0;
            while (i < importsLength) {
                ((ImportDeclaration)imports.get(i)).accept(this);
                ++i;
            }
            int blankLinesAfterImports = this.preferences.blank_lines_after_imports;
            if (blankLinesAfterImports > 0) {
                this.scribe.printEmptyLines(blankLinesAfterImports);
            }
        }
        this.formatEmptyTypeDeclaration(true);
        int blankLineBetweenTypeDeclarations = this.preferences.blank_lines_between_type_declarations;
        List types = node.types();
        int typesLength = types.size();
        if (typesLength != 0) {
            int i = 0;
            while (i < typesLength - 1) {
                ((AbstractTypeDeclaration)types.get(i)).accept(this);
                this.formatEmptyTypeDeclaration(false);
                if (blankLineBetweenTypeDeclarations != 0) {
                    this.scribe.printEmptyLines(blankLineBetweenTypeDeclarations);
                } else {
                    this.scribe.printNewLine();
                }
                ++i;
            }
            ((AbstractTypeDeclaration)types.get(typesLength - 1)).accept(this);
        }
        this.scribe.printEndOfCompilationUnit();
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept(this);
        Alignment2 conditionalExpressionAlignment = this.scribe.createAlignment("conditionalExpression", this.preferences.alignment_for_conditional_expression, 2, this.scribe.scanner.currentPosition);
        this.scribe.enterAlignment(conditionalExpressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(conditionalExpressionAlignment, 0);
                this.scribe.printNextToken(23, this.preferences.insert_space_before_question_in_conditional);
                if (this.preferences.insert_space_after_question_in_conditional) {
                    this.scribe.space();
                }
                node.getThenExpression().accept(this);
                this.scribe.printTrailingComment();
                this.scribe.alignFragment(conditionalExpressionAlignment, 1);
                this.scribe.printNextToken(65, this.preferences.insert_space_before_colon_in_conditional);
                if (this.preferences.insert_space_after_colon_in_conditional) {
                    this.scribe.space();
                }
                node.getElseExpression().accept(this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(conditionalExpressionAlignment, true);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        List typeArguments = node.typeArguments();
        int typeArgumentsLength = typeArguments.size();
        if (typeArgumentsLength != 0) {
            this.scribe.printNextToken(7, this.preferences.insert_space_before_opening_angle_bracket_in_type_arguments);
            if (this.preferences.insert_space_after_opening_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
            int i = 0;
            while (i < typeArgumentsLength - 1) {
                ((Type)typeArguments.get(i)).accept(this);
                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_type_arguments);
                if (this.preferences.insert_space_after_comma_in_type_arguments) {
                    this.scribe.space();
                }
                ++i;
            }
            ((Type)typeArguments.get(typeArgumentsLength - 1)).accept(this);
            if (this.isClosingGenericToken()) {
                this.scribe.printNextToken(CLOSING_GENERICS_EXPECTEDTOKENS, this.preferences.insert_space_before_closing_angle_bracket_in_type_arguments);
            }
            if (this.preferences.insert_space_after_closing_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
        }
        this.scribe.printNextToken(42);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_method_invocation);
        List arguments = node.arguments();
        int argumentsLength = arguments.size();
        if (argumentsLength != 0) {
            if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
                this.scribe.space();
            }
            Alignment2 argumentsAlignment = this.scribe.createAlignment("explicit_constructor_call", this.preferences.alignment_for_arguments_in_explicit_constructor_call, argumentsLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(argumentsAlignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < argumentsLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_explicit_constructor_call_arguments);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(argumentsAlignment, i);
                        if (i > 0 && this.preferences.insert_space_after_comma_in_explicit_constructor_call_arguments) {
                            this.scribe.space();
                        }
                        ((Expression)arguments.get(i)).accept(this);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(argumentsAlignment, true);
            this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_method_invocation);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_method_invocation);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(ContinueStatement node) {
        this.scribe.printNextToken(76);
        if (node.getLabel() != null) {
            this.scribe.printNextToken(26, true);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(DoStatement node) {
        this.scribe.printNextToken(77);
        int line = this.scribe.line;
        Statement action = node.getBody();
        if (action != null) {
            switch (action.getNodeType()) {
                case 8: {
                    this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                    action.accept(this);
                    break;
                }
                case 20: {
                    action.accept(this);
                    break;
                }
                default: {
                    this.scribe.printNewLine();
                    this.scribe.indent();
                    action.accept(this);
                    this.scribe.unIndent();
                    this.scribe.printNewLine();
                    break;
                }
            }
        } else {
            action.accept(this);
        }
        if (this.preferences.insert_new_line_before_while_in_do_statement) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(73, this.preferences.insert_space_after_closing_brace_in_block);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_while);
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_while);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(EmptyStatement node) {
        if (this.preferences.put_empty_statement_on_new_line) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        this.scribe.printNextToken(78);
        int line = this.scribe.line;
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_for);
        if (this.preferences.insert_space_after_opening_paren_in_for) {
            this.scribe.space();
        }
        node.getParameter().accept(this);
        this.scribe.printNextToken(65, this.preferences.insert_space_before_colon_in_for);
        if (this.preferences.insert_space_after_colon_in_for) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_for);
        this.formatAction(line, node.getBody(), false);
        return false;
    }

    public boolean visit(EnumConstantDeclaration node) {
        AnonymousClassDeclaration anonymousClassDeclaration;
        this.scribe.printComment();
        int line = this.scribe.line;
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        this.scribe.printNextToken(26);
        if (this.isNextToken(28)) {
            this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_enum_constant);
            List arguments = node.arguments();
            int argumentsLength = arguments.size();
            if (argumentsLength != 0) {
                Alignment2 argumentsAlignment = this.scribe.createAlignment("enumConstantArguments", this.preferences.alignment_for_arguments_in_enum_constant, argumentsLength, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(argumentsAlignment);
                boolean ok = false;
                do {
                    try {
                        if (this.preferences.insert_space_after_opening_paren_in_enum_constant) {
                            this.scribe.space();
                        }
                        int i = 0;
                        while (i < argumentsLength) {
                            if (i > 0) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_enum_constant_arguments);
                                this.scribe.printTrailingComment();
                            }
                            this.scribe.alignFragment(argumentsAlignment, i);
                            if (i > 0 && this.preferences.insert_space_after_comma_in_enum_constant_arguments) {
                                this.scribe.space();
                            }
                            ((Expression)arguments.get(i)).accept(this);
                            ++i;
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(argumentsAlignment, true);
                this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_enum_constant);
            } else {
                this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_enum_constant);
            }
        }
        if ((anonymousClassDeclaration = node.getAnonymousClassDeclaration()) != null) {
            List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
            String enum_constant_brace = this.preferences.brace_position_for_enum_constant;
            this.formatLeftCurlyBrace(line, enum_constant_brace);
            this.formatTypeOpeningBrace(enum_constant_brace, this.preferences.insert_space_before_opening_brace_in_enum_constant, bodyDeclarations.size() != 0, node);
            if (this.preferences.indent_body_declarations_compare_to_enum_constant_header) {
                this.scribe.indent();
            }
            this.formatTypeMembers(bodyDeclarations, true);
            if (this.preferences.indent_body_declarations_compare_to_enum_constant_header) {
                this.scribe.unIndent();
            }
            if (this.preferences.insert_new_line_in_empty_enum_constant) {
                this.scribe.printNewLine();
            }
            this.scribe.printNextToken(31);
            if (enum_constant_brace.equals("next_line_shifted")) {
                this.scribe.unIndent();
            }
            if (this.hasComments()) {
                this.scribe.printNewLine();
            }
        }
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        this.scribe.printNextToken(98, true);
        this.scribe.printNextToken(26, true);
        List superInterfaces = node.superInterfaceTypes();
        int superInterfacesLength = superInterfaces.size();
        if (superInterfacesLength != 0) {
            Alignment2 interfaceAlignment = this.scribe.createAlignment("superInterfaces", this.preferences.alignment_for_superinterfaces_in_enum_declaration, superInterfacesLength + 1, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(interfaceAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(interfaceAlignment, 0);
                    this.scribe.printNextToken(106, true);
                    int i = 0;
                    while (i < superInterfacesLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_superinterfaces);
                            this.scribe.printTrailingComment();
                            this.scribe.alignFragment(interfaceAlignment, i + 1);
                            if (this.preferences.insert_space_after_comma_in_superinterfaces) {
                                this.scribe.space();
                            }
                            ((Type)superInterfaces.get(i)).accept(this);
                        } else {
                            this.scribe.alignFragment(interfaceAlignment, i + 1);
                            this.scribe.space();
                            ((Type)superInterfaces.get(i)).accept(this);
                        }
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(interfaceAlignment, true);
        }
        String bracePosition = this.preferences.brace_position_for_enum_declaration;
        List enumConstants = node.enumConstants();
        int enumConstantsLength = enumConstants.size();
        this.formatLeftCurlyBrace(line, bracePosition);
        this.formatTypeOpeningBrace(bracePosition, this.preferences.insert_space_before_opening_brace_in_enum_declaration, enumConstantsLength + node.bodyDeclarations().size() != 0, node);
        boolean indent_body_declarations_compare_to_header = this.preferences.indent_body_declarations_compare_to_enum_declaration_header;
        if (indent_body_declarations_compare_to_header) {
            this.scribe.indent();
        }
        if (enumConstantsLength != 0) {
            if (enumConstantsLength > 1) {
                Alignment2 enumConstantsAlignment = this.scribe.createAlignment("enumConstants", this.preferences.alignment_for_enum_constants, enumConstantsLength, this.scribe.scanner.currentPosition, 0, false);
                this.scribe.enterAlignment(enumConstantsAlignment);
                boolean ok = false;
                do {
                    try {
                        int i = 0;
                        while (i < enumConstantsLength) {
                            this.scribe.alignFragment(enumConstantsAlignment, i);
                            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)enumConstants.get(i);
                            enumConstantDeclaration.accept(this);
                            if (this.isNextToken(30)) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_enum_declarations);
                                if (this.preferences.insert_space_after_comma_in_enum_declarations) {
                                    this.scribe.space();
                                }
                                this.scribe.printTrailingComment();
                                if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
                                    this.scribe.printNewLine();
                                }
                            }
                            ++i;
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(enumConstantsAlignment, true);
            } else {
                EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)enumConstants.get(0);
                enumConstantDeclaration.accept(this);
                if (this.isNextToken(30)) {
                    this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_enum_declarations);
                    if (this.preferences.insert_space_after_comma_in_enum_declarations) {
                        this.scribe.space();
                    }
                    this.scribe.printTrailingComment();
                    if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
                        this.scribe.printNewLine();
                    }
                }
            }
        }
        if (this.isNextToken(27)) {
            this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        if (enumConstantsLength != 0) {
            this.scribe.printNewLine();
        }
        this.formatTypeMembers(node.bodyDeclarations(), true);
        if (indent_body_declarations_compare_to_header) {
            this.scribe.unIndent();
        }
        if (this.preferences.insert_new_line_in_empty_enum_declaration) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(31);
        this.scribe.printTrailingComment();
        if (bracePosition.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        if (this.hasComments()) {
            this.scribe.printNewLine();
        }
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept(this);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(FieldAccess node) {
        node.getExpression().accept(this);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(26);
        return false;
    }

    public boolean visit(ForStatement node) {
        List initializers;
        int initializersLength;
        this.scribe.printNextToken(78);
        int line = this.scribe.line;
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_for);
        if (this.preferences.insert_space_after_opening_paren_in_for) {
            this.scribe.space();
        }
        if ((initializersLength = (initializers = node.initializers()).size()) != 0) {
            int i = 0;
            while (i < initializersLength) {
                Expression initializer = (Expression)initializers.get(i);
                switch (initializer.getNodeType()) {
                    case 58: {
                        this.formatLocalDeclaration((VariableDeclarationExpression)initializer, this.preferences.insert_space_before_comma_in_for_inits, this.preferences.insert_space_after_comma_in_for_inits);
                        break;
                    }
                    default: {
                        initializer.accept(this);
                        if (i < 0 || i >= initializersLength - 1) break;
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_for_inits);
                        if (this.preferences.insert_space_after_comma_in_for_inits) {
                            this.scribe.space();
                        }
                        this.scribe.printTrailingComment();
                    }
                }
                ++i;
            }
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon_in_for);
        Expression condition = node.getExpression();
        if (condition != null) {
            if (this.preferences.insert_space_after_semicolon_in_for) {
                this.scribe.space();
            }
            condition.accept(this);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon_in_for);
        List updaters = node.updaters();
        int updatersLength = updaters.size();
        if (updatersLength != 0) {
            if (this.preferences.insert_space_after_semicolon_in_for) {
                this.scribe.space();
            }
            int i = 0;
            while (i < updatersLength) {
                ((Expression)updaters.get(i)).accept(this);
                if (i != updatersLength - 1) {
                    this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_for_increments);
                    if (this.preferences.insert_space_after_comma_in_for_increments) {
                        this.scribe.space();
                    }
                    this.scribe.printTrailingComment();
                }
                ++i;
            }
        }
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_for);
        this.formatAction(line, node.getBody(), false);
        return false;
    }

    public boolean visit(IfStatement node) {
        this.scribe.printNextToken(79);
        int line = this.scribe.line;
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_if);
        if (this.preferences.insert_space_after_opening_paren_in_if) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_if);
        Statement thenStatement = node.getThenStatement();
        Statement elseStatement = node.getElseStatement();
        boolean thenStatementIsBlock = false;
        if (thenStatement != null) {
            if (thenStatement instanceof Block) {
                Block block = (Block)thenStatement;
                thenStatementIsBlock = true;
                List statements = block.statements();
                if (this.isGuardClause(block, statements) && elseStatement == null && this.preferences.keep_guardian_clause_on_one_line) {
                    this.scribe.printNextToken(68, this.preferences.insert_space_before_opening_brace_in_block);
                    this.scribe.space();
                    ((Statement)statements.get(0)).accept(this);
                    this.scribe.printNextToken(31, true);
                    this.scribe.printTrailingComment();
                } else {
                    this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                    thenStatement.accept(this);
                    if (elseStatement != null && this.preferences.insert_new_line_before_else_in_if_statement) {
                        this.scribe.printNewLine();
                    }
                }
            } else if (elseStatement == null && this.preferences.keep_simple_if_on_one_line) {
                Alignment2 compactIfAlignment = this.scribe.createAlignment("compactIf", this.preferences.alignment_for_compact_if, 1, 1, this.scribe.scanner.currentPosition, 1, false);
                this.scribe.enterAlignment(compactIfAlignment);
                boolean ok = false;
                do {
                    try {
                        this.scribe.alignFragment(compactIfAlignment, 0);
                        this.scribe.space();
                        thenStatement.accept(this);
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(compactIfAlignment, true);
            } else if (this.preferences.keep_then_statement_on_same_line) {
                this.scribe.space();
                thenStatement.accept(this);
                if (elseStatement != null) {
                    this.scribe.printNewLine();
                }
            } else {
                this.scribe.printTrailingComment();
                this.scribe.printNewLine();
                this.scribe.indent();
                thenStatement.accept(this);
                if (elseStatement != null) {
                    this.scribe.printNewLine();
                }
                this.scribe.unIndent();
            }
        }
        if (elseStatement != null) {
            if (thenStatementIsBlock) {
                this.scribe.printNextToken(103, this.preferences.insert_space_after_closing_brace_in_block);
            } else {
                this.scribe.printNextToken(103, true);
            }
            if (elseStatement instanceof Block) {
                elseStatement.accept(this);
            } else if (elseStatement instanceof IfStatement) {
                if (!this.preferences.compact_else_if) {
                    this.scribe.printNewLine();
                    this.scribe.indent();
                }
                this.scribe.space();
                elseStatement.accept(this);
                if (!this.preferences.compact_else_if) {
                    this.scribe.unIndent();
                }
            } else if (this.preferences.keep_else_statement_on_same_line) {
                this.scribe.space();
                elseStatement.accept(this);
            } else {
                this.scribe.printNewLine();
                this.scribe.indent();
                elseStatement.accept(this);
                this.scribe.unIndent();
            }
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        this.scribe.printNextToken(100);
        this.scribe.space();
        if (node.isStatic()) {
            this.scribe.printNextToken(54);
            this.scribe.space();
        }
        node.getName().accept(this);
        if (node.isOnDemand()) {
            this.scribe.printNextToken(3);
            this.scribe.printNextToken(4);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        this.scribe.printNewLine();
        return false;
    }

    public boolean visit(InfixExpression node) {
        InfixExpressionWrappingBuilder builder = new InfixExpressionWrappingBuilder();
        node.accept(builder);
        int fragmentsSize = builder.getFragmentsCounter();
        this.scribe.printComment();
        Alignment2 binaryExpressionAlignment = this.scribe.createAlignment("binaryExpressionAlignment", this.preferences.alignment_for_binary_expression, 1, fragmentsSize, this.scribe.scanner.currentPosition);
        this.scribe.enterAlignment(binaryExpressionAlignment);
        boolean ok = false;
        ArrayList fragments = builder.fragments;
        int[] operators = builder.getOperators();
        do {
            try {
                int i = 0;
                while (i < fragmentsSize - 1) {
                    ((Expression)fragments.get(i)).accept(this);
                    this.scribe.printTrailingComment();
                    if (this.scribe.lastNumberOfNewLines == 1 && binaryExpressionAlignment.couldBreak() && binaryExpressionAlignment.wasSplit) {
                        binaryExpressionAlignment.performFragmentEffect();
                    }
                    this.scribe.alignFragment(binaryExpressionAlignment, i);
                    this.scribe.printNextToken(operators[i], this.preferences.insert_space_before_binary_operator);
                    this.scribe.printTrailingComment();
                    if (this.scribe.lastNumberOfNewLines == 1 && binaryExpressionAlignment.couldBreak() && binaryExpressionAlignment.wasSplit) {
                        binaryExpressionAlignment.performFragmentEffect();
                    }
                    if (this.preferences.insert_space_after_binary_operator || operators[i] == 2 && this.isNextToken(2)) {
                        this.scribe.space();
                    }
                    ++i;
                }
                ((Expression)fragments.get(fragmentsSize - 1)).accept(this);
                this.scribe.printTrailingComment();
                if (this.scribe.lastNumberOfNewLines == 1 && binaryExpressionAlignment.couldBreak() && binaryExpressionAlignment.wasSplit) {
                    binaryExpressionAlignment.performFragmentEffect();
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(binaryExpressionAlignment, true);
        return false;
    }

    public boolean visit(Initializer node) {
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept(this);
        this.scribe.printNextToken(15, true);
        this.scribe.space();
        node.getRightOperand().accept(this);
        return false;
    }

    public boolean visit(LabeledStatement node) {
        this.scribe.printNextToken(26);
        this.scribe.printNextToken(65, this.preferences.insert_space_before_colon_in_labeled_statement);
        if (this.preferences.insert_space_after_colon_in_labeled_statement) {
            this.scribe.space();
        }
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        this.scribe.printNextToken(53);
        if (this.preferences.insert_space_after_at_in_annotation) {
            this.scribe.space();
        }
        node.getTypeName().accept(this);
        return false;
    }

    public boolean visit(MemberValuePair node) {
        this.scribe.printNextToken(26);
        this.scribe.printNextToken(71, this.preferences.insert_space_before_assignment_operator);
        if (this.preferences.insert_space_after_assignment_operator) {
            this.scribe.space();
        }
        node.getValue().accept(this);
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        Block body;
        List thrownExceptions;
        int thrownExceptionsLength;
        Type returnType;
        List typeParameters;
        int typeParametersLength;
        if ((node.getFlags() & 1) != 0) {
            this.scribe.printComment();
            this.scribe.printIndentationIfNecessary();
            this.scribe.scanner.resetTo(node.getStartPosition() + node.getLength(), this.scribe.scannerEndPosition);
            this.scribe.needSpace = true;
            this.scribe.printTrailingComment();
            switch (this.scribe.scanner.source[this.scribe.scanner.currentPosition]) {
                case '\n': {
                    ++this.scribe.scanner.currentPosition;
                    this.scribe.lastNumberOfNewLines = 1;
                    break;
                }
                case '\r': {
                    ++this.scribe.scanner.currentPosition;
                    if (this.scribe.scanner.source[this.scribe.scanner.currentPosition] == '\n') {
                        ++this.scribe.scanner.currentPosition;
                    }
                    this.scribe.lastNumberOfNewLines = 1;
                }
            }
            return false;
        }
        this.scribe.printComment();
        int line = this.scribe.line;
        List modifiers = node.modifiers();
        int modifiersLength = modifiers.size();
        if (modifiersLength != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        if ((typeParametersLength = (typeParameters = node.typeParameters()).size()) != 0) {
            this.scribe.printNextToken(7, this.preferences.insert_space_before_opening_angle_bracket_in_type_parameters);
            if (this.preferences.insert_space_after_opening_angle_bracket_in_type_parameters) {
                this.scribe.space();
            }
            int i = 0;
            while (i < typeParametersLength - 1) {
                ((TypeParameter)typeParameters.get(i)).accept(this);
                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_type_parameters);
                if (this.preferences.insert_space_after_comma_in_type_parameters) {
                    this.scribe.space();
                }
                ++i;
            }
            ((TypeParameter)typeParameters.get(typeParametersLength - 1)).accept(this);
            if (this.isClosingGenericToken()) {
                this.scribe.printNextToken(CLOSING_GENERICS_EXPECTEDTOKENS, this.preferences.insert_space_before_closing_angle_bracket_in_type_parameters);
            }
            if (this.preferences.insert_space_after_closing_angle_bracket_in_type_parameters) {
                this.scribe.space();
            }
        }
        if ((returnType = node.getReturnType2()) != null) {
            returnType.accept(this);
        }
        this.scribe.printNextToken(26, true);
        boolean spaceBeforeParen = this.preferences.insert_space_before_opening_paren_in_method_declaration;
        if (node.isConstructor()) {
            spaceBeforeParen = this.preferences.insert_space_before_opening_paren_in_constructor_declaration;
        }
        this.scribe.printNextToken(28, spaceBeforeParen);
        List parameters = node.parameters();
        int parametersLength = parameters.size();
        if (parametersLength != 0) {
            if (this.preferences.insert_space_after_opening_paren_in_method_declaration) {
                this.scribe.space();
            }
            Alignment2 parametersAlignment = this.scribe.createAlignment("methodParameters", this.preferences.alignment_for_parameters_in_method_declaration, parametersLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(parametersAlignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < parametersLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_method_declaration_parameters);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(parametersAlignment, i);
                        if (i > 0 && this.preferences.insert_space_after_comma_in_method_declaration_parameters) {
                            this.scribe.space();
                        }
                        ((SingleVariableDeclaration)parameters.get(i)).accept(this);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(parametersAlignment, true);
            this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_method_declaration);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_method_declaration);
        }
        int extraDimensions = node.getExtraDimensions();
        if (extraDimensions != 0) {
            int i = 0;
            while (i < extraDimensions) {
                this.scribe.printNextToken(14);
                this.scribe.printNextToken(70);
                ++i;
            }
        }
        if ((thrownExceptionsLength = (thrownExceptions = node.thrownExceptions()).size()) != 0) {
            Alignment2 throwsAlignment = this.scribe.createAlignment("throws", node.isConstructor() ? this.preferences.alignment_for_throws_clause_in_constructor_declaration : this.preferences.alignment_for_throws_clause_in_method_declaration, thrownExceptionsLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(throwsAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(throwsAlignment, 0);
                    this.scribe.printNextToken(105, true);
                    int i = 0;
                    while (i < thrownExceptionsLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_method_declaration_throws);
                            this.scribe.printTrailingComment();
                            this.scribe.alignFragment(throwsAlignment, i);
                            if (this.preferences.insert_space_after_comma_in_method_declaration_throws) {
                                this.scribe.space();
                            }
                        } else {
                            this.scribe.space();
                        }
                        ((Name)thrownExceptions.get(i)).accept(this);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(throwsAlignment, true);
        }
        if ((body = node.getBody()) != null) {
            List statements;
            int statementsLength;
            String method_declaration_brace = this.preferences.brace_position_for_method_declaration;
            this.formatLeftCurlyBrace(line, method_declaration_brace);
            this.formatOpeningBrace(method_declaration_brace, this.preferences.insert_space_before_opening_brace_in_method_declaration);
            int numberOfBlankLinesAtBeginningOfMethodBody = this.preferences.blank_lines_at_beginning_of_method_body;
            if (numberOfBlankLinesAtBeginningOfMethodBody > 0) {
                this.scribe.printEmptyLines(numberOfBlankLinesAtBeginningOfMethodBody);
            }
            if ((statementsLength = (statements = body.statements()).size()) != 0) {
                this.scribe.printNewLine();
                if (this.preferences.indent_statements_compare_to_body) {
                    this.scribe.indent();
                }
                this.formatStatements(statements, true);
                this.scribe.printComment();
                if (this.preferences.indent_statements_compare_to_body) {
                    this.scribe.unIndent();
                }
            } else if (this.preferences.insert_new_line_in_empty_method_body) {
                this.scribe.printNewLine();
                if (this.preferences.indent_statements_compare_to_body) {
                    this.scribe.indent();
                }
                this.scribe.printComment();
                if (this.preferences.indent_statements_compare_to_body) {
                    this.scribe.unIndent();
                }
            }
            this.scribe.printNextToken(31);
            this.scribe.printTrailingComment();
            if (method_declaration_brace.equals("next_line_shifted")) {
                this.scribe.unIndent();
            }
        } else {
            this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        MethodInvocationFragmentBuilder builder = new MethodInvocationFragmentBuilder();
        node.accept(builder);
        List fragments = builder.fragments();
        int fragmentsLength = fragments.size();
        if (fragmentsLength >= 3) {
            Expression firstFragment = (Expression)fragments.get(0);
            switch (firstFragment.getNodeType()) {
                case 32: {
                    this.formatSingleMethodInvocation((MethodInvocation)firstFragment);
                    break;
                }
                default: {
                    firstFragment.accept(this);
                }
            }
            Alignment2 cascadingMessageSendAlignment = this.scribe.createAlignment("cascadingMessageSendAlignment", this.preferences.alignment_for_selector_in_method_invocation, 2, fragmentsLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(cascadingMessageSendAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(cascadingMessageSendAlignment, 0);
                    this.scribe.printNextToken(3);
                    int i = 1;
                    while (i < fragmentsLength - 1) {
                        MethodInvocation currentMethodInvocation = (MethodInvocation)fragments.get(i);
                        this.formatSingleMethodInvocation(currentMethodInvocation);
                        this.scribe.alignFragment(cascadingMessageSendAlignment, i);
                        this.scribe.printNextToken(3);
                        ++i;
                    }
                    MethodInvocation currentMethodInvocation = (MethodInvocation)fragments.get(fragmentsLength - 1);
                    this.formatSingleMethodInvocation(currentMethodInvocation);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(cascadingMessageSendAlignment, true);
        } else {
            Expression expression = node.getExpression();
            if (expression != null) {
                expression.accept(this);
                this.scribe.printNextToken(3);
            }
            this.formatSingleMethodInvocation(node);
        }
        return false;
    }

    private void formatSingleMethodInvocation(MethodInvocation node) {
        List typeArguments = node.typeArguments();
        int typeArgumentsLength = typeArguments.size();
        if (typeArgumentsLength != 0) {
            this.scribe.printNextToken(7, this.preferences.insert_space_before_opening_angle_bracket_in_type_arguments);
            if (this.preferences.insert_space_after_opening_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
            int i = 0;
            while (i < typeArgumentsLength - 1) {
                ((Type)typeArguments.get(i)).accept(this);
                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_type_arguments);
                if (this.preferences.insert_space_after_comma_in_type_arguments) {
                    this.scribe.space();
                }
                ++i;
            }
            ((Type)typeArguments.get(typeArgumentsLength - 1)).accept(this);
            if (this.isClosingGenericToken()) {
                this.scribe.printNextToken(CLOSING_GENERICS_EXPECTEDTOKENS, this.preferences.insert_space_before_closing_angle_bracket_in_type_arguments);
            }
            if (this.preferences.insert_space_after_closing_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
        }
        this.scribe.printNextToken(26);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_method_invocation);
        List arguments = node.arguments();
        int argumentsLength = arguments.size();
        if (argumentsLength != 0) {
            if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
                this.scribe.space();
            }
            if (argumentsLength > 1) {
                Alignment2 argumentsAlignment = this.scribe.createAlignment("messageArguments", this.preferences.alignment_for_arguments_in_method_invocation, argumentsLength, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(argumentsAlignment);
                boolean ok = false;
                do {
                    try {
                        int i = 0;
                        while (i < argumentsLength) {
                            if (i > 0) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_method_invocation_arguments);
                                this.scribe.printTrailingComment();
                            }
                            this.scribe.alignFragment(argumentsAlignment, i);
                            if (i > 0 && this.preferences.insert_space_after_comma_in_method_invocation_arguments) {
                                this.scribe.space();
                            }
                            ((Expression)arguments.get(i)).accept(this);
                            ++i;
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(argumentsAlignment, true);
            } else {
                int i = 0;
                while (i < argumentsLength) {
                    if (i > 0) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_method_invocation_arguments);
                        this.scribe.printTrailingComment();
                    }
                    if (i > 0 && this.preferences.insert_space_after_comma_in_method_invocation_arguments) {
                        this.scribe.space();
                    }
                    ((Expression)arguments.get(i)).accept(this);
                    ++i;
                }
            }
            this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_method_invocation);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_method_invocation);
        }
    }

    public boolean visit(NormalAnnotation node) {
        this.scribe.printNextToken(53);
        if (this.preferences.insert_space_after_at_in_annotation) {
            this.scribe.space();
        }
        node.getTypeName().accept(this);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_annotation);
        if (this.preferences.insert_space_after_opening_paren_in_annotation) {
            this.scribe.space();
        }
        List memberValuePairs = node.values();
        int memberValuePairsLength = memberValuePairs.size();
        if (memberValuePairs.size() != 0) {
            int i = 0;
            while (i < memberValuePairsLength - 1) {
                ((MemberValuePair)memberValuePairs.get(i)).accept(this);
                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_annotation);
                if (this.preferences.insert_space_after_comma_in_annotation) {
                    this.scribe.space();
                }
                ++i;
            }
            ((MemberValuePair)memberValuePairs.get(memberValuePairsLength - 1)).accept(this);
        }
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_annotation);
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.scribe.printNextToken(45);
        return false;
    }

    public boolean visit(NumberLiteral node) {
        if (this.isNextToken(2)) {
            this.scribe.printNextToken(2, this.preferences.insert_space_before_unary_operator);
            if (this.preferences.insert_space_after_unary_operator) {
                this.scribe.space();
            }
        }
        this.scribe.printNextToken(NUMBER_LITERALS_EXPECTEDTOKENS);
        return false;
    }

    public boolean visit(ParameterizedType node) {
        node.getType().accept(this);
        this.scribe.printNextToken(7, this.preferences.insert_space_before_opening_angle_bracket_in_parameterized_type_reference);
        if (this.preferences.insert_space_after_opening_angle_bracket_in_parameterized_type_reference) {
            this.scribe.space();
        }
        List typeArguments = node.typeArguments();
        int typeArgumentsLength = typeArguments.size();
        int i = 0;
        while (i < typeArgumentsLength - 1) {
            ((Type)typeArguments.get(i)).accept(this);
            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_parameterized_type_reference);
            if (this.preferences.insert_space_after_comma_in_parameterized_type_reference) {
                this.scribe.space();
            }
            ++i;
        }
        ((Type)typeArguments.get(typeArgumentsLength - 1)).accept(this);
        if (this.isClosingGenericToken()) {
            this.scribe.printNextToken(CLOSING_GENERICS_EXPECTEDTOKENS, this.preferences.insert_space_before_closing_angle_bracket_in_parameterized_type_reference);
        }
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_parenthesized_expression);
        if (this.preferences.insert_space_after_opening_paren_in_parenthesized_expression) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_parenthesized_expression);
        return false;
    }

    public boolean visit(PostfixExpression node) {
        node.getOperand().accept(this);
        int operator = node.getOperator() == PostfixExpression.Operator.INCREMENT ? 9 : 10;
        this.scribe.printNextToken(operator, this.preferences.insert_space_before_postfix_operator);
        if (this.preferences.insert_space_after_postfix_operator) {
            this.scribe.space();
        }
        return false;
    }

    public boolean visit(PrefixExpression node) {
        boolean insertSpaceAfterOperator;
        boolean insertSpaceBeforeOperator;
        int operator;
        PrefixExpression.Operator operator2 = node.getOperator();
        if (operator2 == PrefixExpression.Operator.INCREMENT) {
            operator = 9;
            insertSpaceBeforeOperator = this.preferences.insert_space_before_prefix_operator;
            insertSpaceAfterOperator = this.preferences.insert_space_after_prefix_operator;
        } else if (operator2 == PrefixExpression.Operator.DECREMENT) {
            operator = 10;
            insertSpaceBeforeOperator = this.preferences.insert_space_before_prefix_operator;
            insertSpaceAfterOperator = this.preferences.insert_space_after_prefix_operator;
        } else if (operator2 == PrefixExpression.Operator.COMPLEMENT) {
            operator = 67;
            insertSpaceBeforeOperator = this.preferences.insert_space_before_unary_operator;
            insertSpaceAfterOperator = this.preferences.insert_space_after_unary_operator;
        } else if (operator2 == PrefixExpression.Operator.MINUS) {
            operator = 2;
            insertSpaceBeforeOperator = this.preferences.insert_space_before_unary_operator;
            insertSpaceAfterOperator = this.preferences.insert_space_after_unary_operator;
        } else if (operator2 == PrefixExpression.Operator.NOT) {
            operator = 66;
            insertSpaceBeforeOperator = this.preferences.insert_space_before_unary_operator;
            insertSpaceAfterOperator = this.preferences.insert_space_after_unary_operator;
        } else {
            operator = 1;
            insertSpaceBeforeOperator = this.preferences.insert_space_before_unary_operator;
            insertSpaceAfterOperator = this.preferences.insert_space_after_unary_operator;
        }
        this.scribe.printNextToken(operator, insertSpaceBeforeOperator);
        if (insertSpaceAfterOperator) {
            this.scribe.space();
        }
        node.getOperand().accept(this);
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.scribe.printNextToken(PRIMITIVE_TYPE_EXPECTEDTOKENS);
        return false;
    }

    public boolean visit(QualifiedName node) {
        node.getQualifier().accept(this);
        this.scribe.printNextToken(3);
        node.getName().accept(this);
        return false;
    }

    public boolean visit(QualifiedType node) {
        node.getQualifier().accept(this);
        this.scribe.printNextToken(3);
        node.getName().accept(this);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.scribe.printNextToken(80);
        Expression expression = node.getExpression();
        if (expression != null) {
            switch (expression.getNodeType()) {
                case 36: {
                    if (!this.preferences.insert_space_before_parenthesized_expression_in_return) break;
                    this.scribe.space();
                    break;
                }
                default: {
                    this.scribe.space();
                }
            }
            expression.accept(this);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(SimpleName node) {
        this.scribe.printNextToken(26);
        return false;
    }

    public boolean visit(SimpleType node) {
        node.getName().accept(this);
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.scribe.printNextToken(53);
        if (this.preferences.insert_space_after_at_in_annotation) {
            this.scribe.space();
        }
        node.getTypeName().accept(this);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_annotation);
        if (this.preferences.insert_space_after_opening_paren_in_annotation) {
            this.scribe.space();
        }
        node.getValue().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_annotation);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        Expression initialization;
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        node.getType().accept(this);
        if (node.isVarargs()) {
            this.scribe.printNextToken(107, this.preferences.insert_space_before_ellipsis);
            if (this.preferences.insert_space_after_ellipsis) {
                this.scribe.space();
            }
            this.scribe.printNextToken(26, false);
        } else {
            this.scribe.printNextToken(26, true);
        }
        int extraDimensions = node.getExtraDimensions();
        if (extraDimensions != 0) {
            int i = 0;
            while (i < extraDimensions) {
                this.scribe.printNextToken(14);
                this.scribe.printNextToken(70);
                ++i;
            }
        }
        if ((initialization = node.getInitializer()) != null) {
            this.scribe.printNextToken(71, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
            Alignment2 assignmentAlignment = this.scribe.createAlignment("localDeclarationAssignmentAlignment", this.preferences.alignment_for_assignment, 1, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(assignmentAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(assignmentAlignment, 0);
                    initialization.accept(this);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(assignmentAlignment, true);
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.scribe.checkNLSTag(node.getStartPosition());
        this.scribe.printNextToken(52);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        List typeArguments;
        int typeArgumentsLength;
        Expression qualification = node.getExpression();
        if (qualification != null) {
            qualification.accept(this);
            this.scribe.printNextToken(3);
        }
        if ((typeArgumentsLength = (typeArguments = node.typeArguments()).size()) != 0) {
            this.scribe.printNextToken(7, this.preferences.insert_space_before_opening_angle_bracket_in_type_arguments);
            if (this.preferences.insert_space_after_opening_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
            int i = 0;
            while (i < typeArgumentsLength - 1) {
                ((Type)typeArguments.get(i)).accept(this);
                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_type_arguments);
                if (this.preferences.insert_space_after_comma_in_type_arguments) {
                    this.scribe.space();
                }
                ++i;
            }
            ((Type)typeArguments.get(typeArgumentsLength - 1)).accept(this);
            if (this.isClosingGenericToken()) {
                this.scribe.printNextToken(CLOSING_GENERICS_EXPECTEDTOKENS, this.preferences.insert_space_before_closing_angle_bracket_in_type_arguments);
            }
            if (this.preferences.insert_space_after_closing_angle_bracket_in_type_arguments) {
                this.scribe.space();
            }
        }
        this.scribe.printNextToken(41);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_method_invocation);
        List arguments = node.arguments();
        int argumentsLength = arguments.size();
        if (argumentsLength != 0) {
            if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
                this.scribe.space();
            }
            Alignment2 argumentsAlignment = this.scribe.createAlignment("explicit_constructor_call", this.preferences.alignment_for_arguments_in_explicit_constructor_call, argumentsLength, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(argumentsAlignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < argumentsLength) {
                        if (i > 0) {
                            this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_explicit_constructor_call_arguments);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(argumentsAlignment, i);
                        if (i > 0 && this.preferences.insert_space_after_comma_in_explicit_constructor_call_arguments) {
                            this.scribe.space();
                        }
                        ((Expression)arguments.get(i)).accept(this);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(argumentsAlignment, true);
            this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_method_invocation);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_method_invocation);
        }
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(41);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(26);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(41);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(26);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_method_invocation);
        List arguments = node.arguments();
        int argumentsLength = arguments.size();
        if (argumentsLength != 0) {
            if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
                this.scribe.space();
            }
            if (argumentsLength > 1) {
                Alignment2 argumentsAlignment = this.scribe.createAlignment("messageArguments", this.preferences.alignment_for_arguments_in_method_invocation, argumentsLength, this.scribe.scanner.currentPosition);
                this.scribe.enterAlignment(argumentsAlignment);
                boolean ok = false;
                do {
                    try {
                        int i = 0;
                        while (i < argumentsLength) {
                            if (i > 0) {
                                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_method_invocation_arguments);
                                this.scribe.printTrailingComment();
                            }
                            this.scribe.alignFragment(argumentsAlignment, i);
                            if (i > 0 && this.preferences.insert_space_after_comma_in_method_invocation_arguments) {
                                this.scribe.space();
                            }
                            ((Expression)arguments.get(i)).accept(this);
                            ++i;
                        }
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(argumentsAlignment, true);
            } else {
                int i = 0;
                while (i < argumentsLength) {
                    if (i > 0) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_method_invocation_arguments);
                        this.scribe.printTrailingComment();
                    }
                    if (i > 0 && this.preferences.insert_space_after_comma_in_method_invocation_arguments) {
                        this.scribe.space();
                    }
                    ((Expression)arguments.get(i)).accept(this);
                    ++i;
                }
            }
            this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_method_invocation);
        } else {
            this.scribe.printNextToken(29, this.preferences.insert_space_between_empty_parens_in_method_invocation);
        }
        return false;
    }

    public boolean visit(SwitchCase node) {
        Expression constant = node.getExpression();
        if (constant == null) {
            this.scribe.printNextToken(97);
            this.scribe.printNextToken(65, this.preferences.insert_space_before_colon_in_default);
        } else {
            this.scribe.printNextToken(101);
            this.scribe.space();
            constant.accept(this);
            this.scribe.printNextToken(65, this.preferences.insert_space_before_colon_in_case);
        }
        return false;
    }

    public boolean visit(SwitchStatement node) {
        this.scribe.printNextToken(81);
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_switch);
        if (this.preferences.insert_space_after_opening_paren_in_switch) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_switch);
        String switch_brace = this.preferences.brace_position_for_switch;
        this.formatOpeningBrace(switch_brace, this.preferences.insert_space_before_opening_brace_in_switch);
        this.scribe.printNewLine();
        if (this.preferences.indent_switchstatements_compare_to_switch) {
            this.scribe.indent();
        }
        List statements = node.statements();
        int statementsLength = statements.size();
        boolean wasACase = false;
        boolean wasAStatement = false;
        if (statementsLength != 0) {
            int i = 0;
            while (i < statementsLength) {
                Statement statement = (Statement)statements.get(i);
                if (statement instanceof SwitchCase) {
                    if (wasACase) {
                        this.scribe.printNewLine();
                    }
                    if (wasACase && this.preferences.indent_switchstatements_compare_to_cases || wasAStatement && this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.unIndent();
                    }
                    statement.accept(this);
                    this.scribe.printTrailingComment();
                    wasACase = true;
                    wasAStatement = false;
                    if (this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.indent();
                    }
                } else if (statement instanceof BreakStatement) {
                    if (this.preferences.indent_breaks_compare_to_cases) {
                        if (wasAStatement && !this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.indent();
                        }
                    } else {
                        if (wasAStatement && this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                        if (wasACase && this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                    }
                    if (wasACase) {
                        this.scribe.printNewLine();
                    }
                    statement.accept(this);
                    if (this.preferences.indent_breaks_compare_to_cases) {
                        this.scribe.unIndent();
                    }
                    wasACase = false;
                    wasAStatement = false;
                } else if (statement instanceof Block) {
                    String bracePosition;
                    if (wasACase) {
                        if (this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                        bracePosition = this.preferences.brace_position_for_block_in_case;
                        this.formatBlock((Block)statement, bracePosition, this.preferences.insert_space_after_colon_in_case);
                        if (this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.indent();
                        }
                    } else {
                        bracePosition = this.preferences.brace_position_for_block;
                        this.formatBlock((Block)statement, bracePosition, this.preferences.insert_space_before_opening_brace_in_block);
                    }
                    wasAStatement = true;
                    wasACase = false;
                } else {
                    this.scribe.printNewLine();
                    statement.accept(this);
                    wasAStatement = true;
                    wasACase = false;
                }
                if (!wasACase) {
                    this.scribe.printNewLine();
                }
                this.scribe.printComment();
                ++i;
            }
        }
        if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_switchstatements_compare_to_switch) {
            this.scribe.unIndent();
        }
        this.scribe.printNewLine();
        this.scribe.printNextToken(31);
        this.scribe.printTrailingComment();
        if (switch_brace.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        this.scribe.printNextToken(55);
        int line = this.scribe.line;
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_synchronized);
        if (this.preferences.insert_space_after_opening_paren_in_synchronized) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_synchronized);
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(ThisExpression node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(42);
        return false;
    }

    public boolean visit(ThrowStatement node) {
        this.scribe.printNextToken(82);
        this.scribe.space();
        node.getExpression().accept(this);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(TryStatement node) {
        Block finallyBlock;
        this.scribe.printNextToken(83);
        node.getBody().accept(this);
        List catchClauses = node.catchClauses();
        int catchClausesLength = catchClauses.size();
        if (catchClausesLength != 0) {
            int i = 0;
            while (i < catchClausesLength) {
                if (this.preferences.insert_new_line_before_catch_in_try_statement) {
                    this.scribe.printNewLine();
                }
                this.scribe.printNextToken(102, this.preferences.insert_space_after_closing_brace_in_block);
                int line = this.scribe.line;
                this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_catch);
                if (this.preferences.insert_space_after_opening_paren_in_catch) {
                    this.scribe.space();
                }
                CatchClause catchClause = (CatchClause)catchClauses.get(i);
                catchClause.getException().accept(this);
                this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_catch);
                this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                catchClause.getBody().accept(this);
                ++i;
            }
        }
        if ((finallyBlock = node.getFinally()) != null) {
            if (this.preferences.insert_new_line_before_finally_in_try_statement) {
                this.scribe.printNewLine();
            }
            this.scribe.printNextToken(104, this.preferences.insert_space_after_closing_brace_in_block);
            finallyBlock.accept(this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        List superInterfaces;
        int superInterfacesLength;
        Type superclass;
        boolean isInterface;
        this.scribe.printComment();
        int line = this.scribe.line;
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        if (isInterface = node.isInterface()) {
            this.scribe.printNextToken(95, true);
        } else {
            this.scribe.printNextToken(72, true);
        }
        this.scribe.printNextToken(26, true);
        List typeParameters = node.typeParameters();
        int typeParametersLength = typeParameters.size();
        if (typeParametersLength != 0) {
            this.scribe.printNextToken(7, this.preferences.insert_space_before_opening_angle_bracket_in_type_parameters);
            if (this.preferences.insert_space_after_opening_angle_bracket_in_type_parameters) {
                this.scribe.space();
            }
            int i = 0;
            while (i < typeParametersLength - 1) {
                ((TypeParameter)typeParameters.get(i)).accept(this);
                this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_type_parameters);
                if (this.preferences.insert_space_after_comma_in_type_parameters) {
                    this.scribe.space();
                }
                ++i;
            }
            ((TypeParameter)typeParameters.get(typeParametersLength - 1)).accept(this);
            if (this.isClosingGenericToken()) {
                this.scribe.printNextToken(CLOSING_GENERICS_EXPECTEDTOKENS, this.preferences.insert_space_before_closing_angle_bracket_in_type_parameters);
            }
            if (this.preferences.insert_space_after_closing_angle_bracket_in_type_parameters) {
                this.scribe.space();
            }
        }
        if ((superclass = node.getSuperclassType()) != null) {
            Alignment2 superclassAlignment = this.scribe.createAlignment("superclass", this.preferences.alignment_for_superclass_in_type_declaration, 2, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(superclassAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(superclassAlignment, 0);
                    this.scribe.printNextToken(99, true);
                    this.scribe.alignFragment(superclassAlignment, 1);
                    this.scribe.space();
                    superclass.accept(this);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(superclassAlignment, true);
        }
        if ((superInterfacesLength = (superInterfaces = node.superInterfaceTypes()).size()) != 0) {
            Alignment2 interfaceAlignment = this.scribe.createAlignment("superInterfaces", this.preferences.alignment_for_superinterfaces_in_type_declaration, superInterfacesLength + 1, this.scribe.scanner.currentPosition);
            this.scribe.enterAlignment(interfaceAlignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(interfaceAlignment, 0);
                    if (isInterface) {
                        this.scribe.printNextToken(99, true);
                    } else {
                        this.scribe.printNextToken(106, true);
                    }
                    this.scribe.alignFragment(interfaceAlignment, 1);
                    this.scribe.space();
                    ((Type)superInterfaces.get(0)).accept(this);
                    int i = 1;
                    while (i < superInterfacesLength) {
                        this.scribe.printNextToken(30, this.preferences.insert_space_before_comma_in_superinterfaces);
                        this.scribe.printTrailingComment();
                        this.scribe.alignFragment(interfaceAlignment, i + 1);
                        if (this.preferences.insert_space_after_comma_in_superinterfaces) {
                            this.scribe.space();
                        }
                        ((Type)superInterfaces.get(i)).accept(this);
                        ++i;
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(interfaceAlignment, true);
        }
        String class_declaration_brace = this.preferences.brace_position_for_type_declaration;
        boolean space_before_opening_brace = this.preferences.insert_space_before_opening_brace_in_type_declaration;
        this.formatLeftCurlyBrace(line, class_declaration_brace);
        List bodyDeclarations = node.bodyDeclarations();
        this.formatTypeOpeningBrace(class_declaration_brace, space_before_opening_brace, bodyDeclarations.size() != 0, node);
        boolean indent_body_declarations_compare_to_header = this.preferences.indent_body_declarations_compare_to_type_header;
        if (indent_body_declarations_compare_to_header) {
            this.scribe.indent();
        }
        this.formatTypeMembers(bodyDeclarations, true);
        if (indent_body_declarations_compare_to_header) {
            this.scribe.unIndent();
        }
        if (this.preferences.insert_new_line_in_empty_type_declaration) {
            this.scribe.printNewLine();
        }
        this.scribe.printNextToken(31);
        this.scribe.printTrailingComment();
        if (class_declaration_brace.equals("next_line_shifted")) {
            this.scribe.unIndent();
        }
        if (this.hasComments()) {
            this.scribe.printNewLine();
        }
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        node.getDeclaration().accept(this);
        return false;
    }

    public boolean visit(TypeLiteral node) {
        node.getType().accept(this);
        this.scribe.printNextToken(3);
        this.scribe.printNextToken(72);
        return false;
    }

    public boolean visit(TypeParameter node) {
        node.getName().accept(this);
        List bounds = node.typeBounds();
        int boundsLength = bounds.size();
        if (boundsLength != 0) {
            this.scribe.printNextToken(99, true);
            this.scribe.space();
            ((Type)bounds.get(0)).accept(this);
            if (boundsLength > 1) {
                this.scribe.printNextToken(20, this.preferences.insert_space_before_and_in_type_parameter);
                if (this.preferences.insert_space_after_and_in_type_parameter) {
                    this.scribe.space();
                }
                int i = 1;
                while (i < boundsLength - 1) {
                    ((Type)bounds.get(i)).accept(this);
                    this.scribe.printNextToken(20, this.preferences.insert_space_before_and_in_type_parameter);
                    if (this.preferences.insert_space_after_and_in_type_parameter) {
                        this.scribe.space();
                    }
                    ++i;
                }
                ((Type)bounds.get(boundsLength - 1)).accept(this);
            }
        }
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.formatLocalDeclaration(node, this.preferences.insert_space_before_comma_in_multiple_local_declarations, this.preferences.insert_space_after_comma_in_multiple_local_declarations);
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        List modifiers = node.modifiers();
        if (modifiers.size() != 0) {
            this.scribe.printModifiers(modifiers, this);
            this.scribe.space();
        }
        node.getType().accept(this);
        this.formatVariableDeclarationFragments(node.fragments(), this.preferences.insert_space_before_comma_in_multiple_local_declarations, this.preferences.insert_space_after_comma_in_multiple_local_declarations);
        this.scribe.printNextToken(27, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.scribe.printNextToken(73);
        int line = this.scribe.line;
        this.scribe.printNextToken(28, this.preferences.insert_space_before_opening_paren_in_while);
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.scribe.space();
        }
        node.getExpression().accept(this);
        this.scribe.printNextToken(29, this.preferences.insert_space_before_closing_paren_in_while);
        this.formatAction(line, node.getBody(), false);
        return false;
    }

    public boolean visit(WildcardType node) {
        this.scribe.printNextToken(23, this.preferences.insert_space_before_question_in_wilcard);
        Type bound = node.getBound();
        if (bound != null) {
            if (node.isUpperBound()) {
                this.scribe.printNextToken(99, true);
            } else {
                this.scribe.printNextToken(41, true);
            }
            this.scribe.space();
            bound.accept(this);
        } else if (this.preferences.insert_space_after_question_in_wilcard) {
            this.scribe.space();
        }
        return false;
    }
}

