/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserText;
import org.eclipse.ui.internal.browser.BusyIndicator;
import org.eclipse.ui.internal.browser.IBrowserViewerContainer;
import org.eclipse.ui.internal.browser.ImageResource;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.ToolbarLayout;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class BrowserViewer
extends Composite {
    public static final int LOCATION_BAR = 2;
    public static final int BUTTON_BAR = 4;
    protected static final String PROPERTY_TITLE = "title";
    private static final int MAX_HISTORY = 50;
    public Clipboard clipboard;
    public Combo combo;
    protected boolean showToolbar;
    protected boolean showURLbar;
    protected ToolItem back;
    protected ToolItem forward;
    protected BusyIndicator busy;
    protected boolean loading;
    protected static List history;
    protected Browser browser;
    protected BrowserText text;
    protected boolean newWindow;
    protected IBrowserViewerContainer container;
    protected String title;
    protected int progressWorked = 0;
    protected List propertyListeners;
    public ILocationListener locationListener;
    public IBackNextListener backNextListener;
    protected File file;
    protected long timestamp;
    protected Thread fileListenerThread;
    protected LocationListener locationListener2;
    protected Object syncObject = new Object();

    public BrowserViewer(Composite parent, int style) {
        super(parent, 0);
        if ((style & 2) != 0) {
            this.showURLbar = true;
        }
        if ((style & 4) != 0) {
            this.showToolbar = true;
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.clipboard = new Clipboard(parent.getDisplay());
        if (this.showToolbar || this.showURLbar) {
            Composite toolbarComp = new Composite((Composite)this, 0);
            toolbarComp.setLayout((Layout)new ToolbarLayout());
            toolbarComp.setLayoutData((Object)new GridData(770));
            if (this.showToolbar) {
                this.createToolbar(toolbarComp);
            }
            if (this.showURLbar) {
                this.createLocationBar(toolbarComp);
            }
            if (this.showToolbar | this.showURLbar) {
                this.busy = new BusyIndicator(toolbarComp, 0);
                this.busy.setLayoutData(new GridData(128));
                this.busy.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        BrowserViewer.this.setURL("http://www.eclipse.org");
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.ui.browser.browser_context");
        }
        try {
            this.browser = new Browser((Composite)this, 0);
        }
        catch (SWTError e) {
            if (e.code != 2) {
                WebBrowserUtil.openError(Messages.errorCouldNotLaunchInternalWebBrowser);
                return;
            }
            this.text = new BrowserText(this, this, e);
        }
        if (this.showURLbar) {
            this.updateHistory();
        }
        if (this.showToolbar) {
            this.updateBackNextBusy();
        }
        if (this.browser != null) {
            this.browser.setLayoutData((Object)new GridData(1808));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.browser, "org.eclipse.ui.browser.browser_context");
        } else {
            this.text.getControl().setLayoutData((Object)new GridData(1808));
        }
        this.addBrowserListeners();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void home() {
        this.browser.setText("");
    }

    public void setURL(String url) {
        this.setURL(url, true);
    }

    protected void updateBackNextBusy() {
        this.back.setEnabled(this.isBackEnabled());
        this.forward.setEnabled(this.isForwardEnabled());
        this.busy.setBusy(this.loading);
        if (this.backNextListener != null) {
            this.backNextListener.updateBackNextBusy();
        }
    }

    protected void updateLocation() {
        if (this.locationListener != null) {
            this.locationListener.historyChanged(null);
        }
        if (this.locationListener != null) {
            this.locationListener.locationChanged(null);
        }
    }

    private void addBrowserListeners() {
        if (this.browser == null) {
            return;
        }
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                if (BrowserViewer.this.container != null) {
                    IStatusLineManager status = BrowserViewer.this.container.getActionBars().getStatusLineManager();
                    status.setMessage(event.text);
                }
            }
        });
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell2 = new Shell(BrowserViewer.this.getShell());
                shell2.setLayout((Layout)new FillLayout());
                shell2.setText(Messages.viewWebBrowserTitle);
                shell2.setImage(BrowserViewer.this.getShell().getImage());
                if (event.location != null) {
                    shell2.setLocation(event.location);
                }
                if (event.size != null) {
                    shell2.setSize(event.size);
                }
                int style = 0;
                if (event.addressBar) {
                    style += 2;
                }
                if (event.toolBar) {
                    style += 4;
                }
                BrowserViewer browser2 = new BrowserViewer((Composite)shell2, 0);
                browser2.newWindow = true;
                event.browser = browser2.browser;
            }
        });
        this.browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent e) {
            }

            public void show(WindowEvent e) {
                Browser browser2 = (Browser)e.widget;
                if (browser2.getParent().getParent() instanceof Shell) {
                    Shell shell = (Shell)browser2.getParent().getParent();
                    if (e.location != null) {
                        shell.setLocation(e.location);
                    }
                    if (e.size != null) {
                        shell.setSize(shell.computeSize(e.size.x, e.size.y));
                    }
                    shell.open();
                }
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                if (BrowserViewer.this.newWindow) {
                    BrowserViewer.this.getShell().dispose();
                } else {
                    BrowserViewer.this.container.close();
                }
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                boolean done = event.current == event.total;
                int percentProgress = event.current * 100 / event.total;
                if (BrowserViewer.this.container != null) {
                    IProgressMonitor monitor = BrowserViewer.this.container.getActionBars().getStatusLineManager().getProgressMonitor();
                    if (done) {
                        monitor.done();
                        BrowserViewer.this.progressWorked = 0;
                    } else if (BrowserViewer.this.progressWorked == 0) {
                        monitor.beginTask("", event.total);
                        BrowserViewer.this.progressWorked = percentProgress;
                    } else {
                        monitor.worked(event.current - BrowserViewer.this.progressWorked);
                        BrowserViewer.this.progressWorked = event.current;
                    }
                }
                if (BrowserViewer.this.showToolbar) {
                    if (!BrowserViewer.this.busy.isBusy() && !done) {
                        BrowserViewer.this.loading = true;
                    } else if (BrowserViewer.this.busy.isBusy() && done) {
                        BrowserViewer.this.loading = false;
                    }
                    BrowserViewer.this.updateBackNextBusy();
                    BrowserViewer.this.updateHistory();
                }
            }

            public void completed(ProgressEvent event) {
                if (BrowserViewer.this.container != null) {
                    IProgressMonitor monitor = BrowserViewer.this.container.getActionBars().getStatusLineManager().getProgressMonitor();
                    monitor.done();
                }
                if (BrowserViewer.this.showToolbar) {
                    BrowserViewer.this.loading = false;
                    BrowserViewer.this.updateBackNextBusy();
                    BrowserViewer.this.updateHistory();
                }
            }
        });
        if (this.showToolbar) {
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    if (!event.top) {
                        return;
                    }
                    if (BrowserViewer.this.combo != null && !"about:blank".equals(event.location)) {
                        BrowserViewer.this.combo.setText(event.location);
                        BrowserViewer.this.addToHistory(event.location);
                        BrowserViewer.this.updateHistory();
                    }
                }

                public void changing(LocationEvent event) {
                }
            });
        }
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                String oldTitle = BrowserViewer.this.title;
                BrowserViewer.this.title = event.title;
                BrowserViewer.this.firePropertyChangeEvent(BrowserViewer.PROPERTY_TITLE, oldTitle, BrowserViewer.this.title);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
        try {
            int size = this.propertyListeners.size();
            PropertyChangeListener[] pcl = new PropertyChangeListener[size];
            this.propertyListeners.toArray(pcl);
            int i = 0;
            while (i < size) {
                try {
                    pcl[i].propertyChange(event);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public boolean forward() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.forward();
    }

    public boolean back() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.back();
    }

    public boolean isBackEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isBackEnabled();
    }

    public boolean isForwardEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isForwardEnabled();
    }

    public void stop() {
        if (this.browser != null) {
            this.browser.stop();
        }
    }

    private boolean navigate(String url) {
        Trace.trace(Trace.FINER, "Navigate: " + url);
        if (url != null && url.equals(this.getURL())) {
            this.refresh();
            return true;
        }
        if (this.browser != null) {
            return this.browser.setUrl(url);
        }
        return this.text.setUrl(url);
    }

    public void refresh() {
        if (this.browser != null) {
            this.browser.refresh();
        } else {
            this.text.refresh();
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {}
    }

    private void setURL(String url, boolean browse) {
        Trace.trace(Trace.FINEST, "setURL: " + url + " " + browse);
        if (url == null) {
            this.home();
            return;
        }
        if ("eclipse".equalsIgnoreCase(url)) {
            url = "http://www.eclipse.org";
        } else if ("wtp".equalsIgnoreCase(url)) {
            url = "http://www.eclipse.org/webtools/";
        }
        if (browse) {
            this.navigate(url);
        }
        this.addToHistory(url);
        this.updateHistory();
    }

    protected void addToHistory(String url) {
        if (history == null) {
            history = WebBrowserPreference.getInternalWebBrowserHistory();
        }
        int found = -1;
        int size = history.size();
        int i = 0;
        while (i < size) {
            String s = (String)history.get(i);
            if (s.equals(url)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found == -1) {
            if (size >= 50) {
                history.remove(size - 1);
            }
            history.add(0, url);
            WebBrowserPreference.setInternalWebBrowserHistory(history);
        } else if (found != 0) {
            history.remove(found);
            history.add(0, url);
            WebBrowserPreference.setInternalWebBrowserHistory(history);
        }
    }

    public void dispose() {
        super.dispose();
        this.showToolbar = false;
        if (this.busy != null) {
            this.busy.dispose();
        }
        this.busy = null;
        this.browser = null;
        this.text = null;
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = null;
        this.removeSynchronizationListener();
    }

    private ToolBar createLocationBar(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.updateHistory();
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent we) {
                try {
                    if (BrowserViewer.this.combo.getSelectionIndex() != -1) {
                        BrowserViewer.this.setURL(BrowserViewer.this.combo.getItem(BrowserViewer.this.combo.getSelectionIndex()));
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.combo.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                BrowserViewer.this.setURL(BrowserViewer.this.combo.getText());
            }
        });
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        ToolItem go = new ToolItem(toolbar, 0);
        go.setImage(ImageResource.getImage("IMG_ELCL_NAV_GO"));
        go.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_GO"));
        go.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_GO"));
        go.setToolTipText(Messages.actionWebBrowserGo);
        go.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserViewer.this.setURL(BrowserViewer.this.combo.getText());
            }
        });
        return toolbar;
    }

    private ToolBar createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        this.back = new ToolItem(toolbar, 0);
        this.back.setImage(ImageResource.getImage("IMG_ELCL_NAV_BACKWARD"));
        this.back.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_BACKWARD"));
        this.back.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_BACKWARD"));
        this.back.setToolTipText(Messages.actionWebBrowserBack);
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserViewer.this.back();
            }
        });
        this.forward = new ToolItem(toolbar, 0);
        this.forward.setImage(ImageResource.getImage("IMG_ELCL_NAV_FORWARD"));
        this.forward.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_FORWARD"));
        this.forward.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_FORWARD"));
        this.forward.setToolTipText(Messages.actionWebBrowserForward);
        this.forward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserViewer.this.forward();
            }
        });
        ToolItem stop = new ToolItem(toolbar, 0);
        stop.setImage(ImageResource.getImage("IMG_ELCL_NAV_STOP"));
        stop.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_STOP"));
        stop.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_STOP"));
        stop.setToolTipText(Messages.actionWebBrowserStop);
        stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserViewer.this.stop();
            }
        });
        ToolItem refresh = new ToolItem(toolbar, 0);
        refresh.setImage(ImageResource.getImage("IMG_ELCL_NAV_REFRESH"));
        refresh.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_REFRESH"));
        refresh.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_REFRESH"));
        refresh.setToolTipText(Messages.actionWebBrowserRefresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserViewer.this.refresh();
            }
        });
        return toolbar;
    }

    public String getURL() {
        if (this.browser != null) {
            return this.browser.getUrl();
        }
        return this.text.getUrl();
    }

    public boolean setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
            this.updateHistory();
            return true;
        }
        return super.setFocus();
    }

    protected void updateHistory() {
        if (this.combo == null) {
            return;
        }
        String temp = this.combo.getText();
        if (history == null) {
            history = WebBrowserPreference.getInternalWebBrowserHistory();
        }
        String[] historyList = new String[history.size()];
        history.toArray(historyList);
        this.combo.setItems(historyList);
        this.combo.setText(temp);
    }

    public IBrowserViewerContainer getContainer() {
        return this.container;
    }

    public void setContainer(IBrowserViewerContainer container) {
        IStatusLineManager manager;
        if (container == null && this.container != null && (manager = this.container.getActionBars().getStatusLineManager()) != null) {
            manager.getProgressMonitor().done();
        }
        this.container = container;
    }

    protected void addSynchronizationListener() {
        if (this.fileListenerThread != null) {
            return;
        }
        this.fileListenerThread = new Thread("Browser file synchronization"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (BrowserViewer.this.fileListenerThread != null) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                    Object object = BrowserViewer.this.syncObject;
                    synchronized (object) {
                        if (BrowserViewer.this.file != null && BrowserViewer.this.file.lastModified() != BrowserViewer.this.timestamp) {
                            BrowserViewer.this.timestamp = BrowserViewer.this.file.lastModified();
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    BrowserViewer.this.refresh();
                                }
                            });
                        }
                    }
                }
            }
        };
        this.fileListenerThread.setDaemon(true);
        this.fileListenerThread.setPriority(1);
        this.locationListener2 = new LocationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(LocationEvent event) {
                File temp = BrowserViewer.getFile(event.location);
                if (temp != null && temp.exists()) {
                    Object object = BrowserViewer.this.syncObject;
                    synchronized (object) {
                        BrowserViewer.this.file = temp;
                        BrowserViewer.this.timestamp = BrowserViewer.this.file.lastModified();
                    }
                } else {
                    BrowserViewer.this.file = null;
                }
            }

            public void changing(LocationEvent event) {
            }
        };
        this.browser.addLocationListener(this.locationListener2);
        File temp = BrowserViewer.getFile(this.browser.getUrl());
        if (temp != null && temp.exists()) {
            this.file = temp;
            this.timestamp = this.file.lastModified();
        }
        this.fileListenerThread.start();
    }

    protected static File getFile(String location) {
        if (location == null) {
            return null;
        }
        if (location.startsWith("file:/")) {
            location = location.substring(6);
        }
        return new File(location);
    }

    protected void removeSynchronizationListener() {
        if (this.fileListenerThread == null) {
            return;
        }
        this.fileListenerThread = null;
        this.browser.removeLocationListener(this.locationListener2);
        this.locationListener2 = null;
    }

    public static interface ILocationListener {
        public void locationChanged(String var1);

        public void historyChanged(String[] var1);
    }

    public static interface IBackNextListener {
        public void updateBackNextBusy();
    }
}

